/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.api.computer.IAbstractLaser;
import cr0s.warpdrive.block.TileEntityAbstractInterfaced;
import cr0s.warpdrive.block.TileEntityLaserMedium;
import cr0s.warpdrive.config.WarpDriveConfig;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.LinkedList;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityAbstractLaser
extends TileEntityAbstractInterfaced
implements IAbstractLaser {
    protected ForgeDirection[] laserMedium_directionsValid = ForgeDirection.VALID_DIRECTIONS;
    protected int laserMedium_maxCount = 0;
    protected ForgeDirection laserMedium_direction = ForgeDirection.UNKNOWN;
    protected int cache_laserMedium_count = 0;
    protected int cache_laserMedium_energyStored = 0;
    protected int cache_laserMedium_maxStorage = 0;
    private final int updateInterval_slow_ticks;
    protected int updateInterval_ticks;
    private int updateTicks = this.updateInterval_ticks = (this.updateInterval_slow_ticks = 20 * WarpDriveConfig.SHIP_CONTROLLER_UPDATE_INTERVAL_SECONDS);
    private int bootTicks = 20;

    public TileEntityAbstractLaser() {
        this.addMethods(new String[]{"energy", "laserMediumDirection", "laserMediumCount"});
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        this.updateLaserMediumDirection();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.bootTicks > 0) {
            --this.bootTicks;
            if (this.laserMedium_direction == ForgeDirection.UNKNOWN) {
                this.updateTicks = 1;
            }
        }
        --this.updateTicks;
        if (this.updateTicks <= 0) {
            this.updateTicks = this.updateInterval_ticks;
            this.updateLaserMediumDirection();
        }
    }

    private void updateLaserMediumDirection() {
        assert (this.laserMedium_maxCount != 0);
        for (ForgeDirection direction : this.laserMedium_directionsValid) {
            TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            if (!(tileEntity instanceof TileEntityLaserMedium)) continue;
            int energyStored = 0;
            int maxStorage = 0;
            int count = 0;
            while (tileEntity instanceof TileEntityLaserMedium && count <= this.laserMedium_maxCount) {
                energyStored += ((TileEntityLaserMedium)tileEntity).energy_getEnergyStored();
                maxStorage += ((TileEntityLaserMedium)tileEntity).energy_getMaxStorage();
                tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + (++count + 1) * direction.offsetX, this.field_145848_d + (count + 1) * direction.offsetY, this.field_145849_e + (count + 1) * direction.offsetZ);
            }
            this.laserMedium_direction = direction;
            this.cache_laserMedium_count = count;
            this.cache_laserMedium_energyStored = energyStored;
            this.cache_laserMedium_maxStorage = maxStorage;
            return;
        }
        this.laserMedium_direction = ForgeDirection.UNKNOWN;
        this.cache_laserMedium_count = 0;
        this.cache_laserMedium_energyStored = 0;
        this.cache_laserMedium_maxStorage = 0;
    }

    protected int laserMedium_getEnergyStored() {
        return this.laserMedium_consumeUpTo(Integer.MAX_VALUE, true);
    }

    protected boolean laserMedium_consumeExactly(int amountRequested, boolean simulate) {
        int amountSimulated = this.laserMedium_consumeUpTo(amountRequested, true);
        if (simulate) {
            return amountRequested <= amountSimulated;
        }
        if (amountRequested > amountSimulated) {
            return false;
        }
        return amountRequested <= this.laserMedium_consumeUpTo(amountRequested, false);
    }

    protected int laserMedium_consumeUpTo(int amount, boolean simulate) {
        TileEntity tileEntity;
        int count;
        if (this.laserMedium_direction == ForgeDirection.UNKNOWN) {
            return 0;
        }
        int totalEnergy = 0;
        LinkedList<TileEntityLaserMedium> laserMediums = new LinkedList<TileEntityLaserMedium>();
        for (count = 1; count <= this.laserMedium_maxCount && (tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + count * this.laserMedium_direction.offsetX, this.field_145848_d + count * this.laserMedium_direction.offsetY, this.field_145849_e + count * this.laserMedium_direction.offsetZ)) instanceof TileEntityLaserMedium; ++count) {
            laserMediums.add((TileEntityLaserMedium)tileEntity);
            totalEnergy += ((TileEntityLaserMedium)tileEntity).energy_getEnergyStored();
        }
        if (--count == 0) {
            return 0;
        }
        if (simulate) {
            return totalEnergy;
        }
        int energyAverage = amount / count;
        int energyLeftOver = amount - energyAverage * count;
        if (energyAverage >= WarpDriveConfig.LASER_MEDIUM_MAX_ENERGY_STORED) {
            energyAverage = WarpDriveConfig.LASER_MEDIUM_MAX_ENERGY_STORED;
            energyLeftOver = 0;
        }
        for (TileEntityLaserMedium laserMedium : laserMediums) {
            int energyStored = laserMedium.energy_getEnergyStored();
            if (energyStored >= energyAverage) continue;
            energyLeftOver += energyAverage - energyStored;
        }
        int energyTotalConsumed = 0;
        for (TileEntityLaserMedium laserMedium : laserMediums) {
            int energyStored = laserMedium.energy_getEnergyStored();
            int energyToConsume = Math.min(energyStored, energyAverage + energyLeftOver);
            energyLeftOver -= Math.max(0, energyToConsume - energyAverage);
            laserMedium.energy_consume(energyToConsume, false);
            energyTotalConsumed += energyToConsume;
        }
        return energyTotalConsumed;
    }

    @Override
    public Object[] energy() {
        return new Object[]{this.cache_laserMedium_energyStored, this.cache_laserMedium_maxStorage};
    }

    @Override
    public Object[] laserMediumDirection() {
        return new Object[]{this.laserMedium_direction.name(), this.laserMedium_direction.offsetX, this.laserMedium_direction.offsetY, this.laserMedium_direction.offsetZ};
    }

    @Override
    public Object[] laserMediumCount() {
        return new Object[]{this.cache_laserMedium_count};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] energy(Context context, Arguments arguments) {
        return this.energy();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] laserMediumDirection(Context context, Arguments arguments) {
        return this.laserMediumDirection();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] laserMediumCount(Context context, Arguments arguments) {
        return this.laserMediumCount();
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName;
        switch (methodName = this.getMethodName(method)) {
            case "energy": {
                return this.energy();
            }
            case "laserMediumDirection": {
                return this.laserMediumDirection();
            }
            case "laserMediumCount": {
                return this.laserMediumCount();
            }
        }
        return super.callMethod(computer, context, method, arguments);
    }
}

