/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.block.TileEntityAbstractChunkLoading;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumComponentType;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityChunkLoader
extends TileEntityAbstractChunkLoading {
    private boolean isEnabled = false;
    private int radiusXneg = 0;
    private int radiusXpos = 0;
    private int radiusZneg = 0;
    private int radiusZpos = 0;
    private boolean isPowered = false;

    public TileEntityChunkLoader() {
        this.IC2_sinkTier = 2;
        this.IC2_sourceTier = 2;
        this.peripheralName = "warpdriveChunkLoader";
        this.addMethods(new String[]{"enable", "bounds", "radius", "upgrades", "getEnergyRequired"});
        this.setUpgradeMaxCount(EnumComponentType.SUPERCONDUCTOR, 5);
        this.setUpgradeMaxCount(EnumComponentType.EMERALD_CRYSTAL, WarpDriveConfig.CHUNK_LOADER_MAX_RADIUS);
    }

    @Override
    public int energy_getMaxStorage() {
        return WarpDriveConfig.CHUNK_LOADER_MAX_ENERGY_STORED;
    }

    @Override
    public boolean energy_canInput(ForgeDirection from) {
        return true;
    }

    @Override
    public boolean dismountUpgrade(Object upgrade) {
        boolean isSuccess = super.dismountUpgrade(upgrade);
        if (isSuccess) {
            int maxRange = this.getMaxRange();
            this.setBounds(maxRange, maxRange, maxRange, maxRange);
        }
        return isSuccess;
    }

    @Override
    public boolean mountUpgrade(Object upgrade) {
        boolean isSuccess = super.mountUpgrade(upgrade);
        if (isSuccess) {
            int maxRange = this.getMaxRange();
            this.setBounds(maxRange, maxRange, maxRange, maxRange);
        }
        return isSuccess;
    }

    private int getMaxRange() {
        return this.getValidUpgradeCount(EnumComponentType.EMERALD_CRYSTAL);
    }

    private double getEnergyFactor() {
        int upgradeCount = this.getValidUpgradeCount(EnumComponentType.SUPERCONDUCTOR);
        return 1.0 - 0.1 * (double)upgradeCount;
    }

    public long chunkloading_getEnergyRequired() {
        return (long)Math.ceil(this.getEnergyFactor() * (double)this.chunkloading_getArea() * (double)WarpDriveConfig.CHUNK_LOADER_ENERGY_PER_CHUNK);
    }

    @Override
    public boolean shouldChunkLoad() {
        return this.isEnabled && this.isPowered;
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.refreshChunkRange();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.isPowered = this.energy_consume(this.chunkloading_getEnergyRequired(), !this.isEnabled);
        this.updateMetadata(this.isEnabled ? (this.isPowered ? 2 : 1) : 0);
    }

    private void setBounds(int negX, int posX, int negZ, int posZ) {
        int maxArea;
        int radiusZpos_new;
        int radiusZneg_new;
        int radiusXpos_new;
        int maxRange = this.getMaxRange();
        int radiusXneg_new = -Commons.clamp(0, 1000, Math.abs(negX));
        int newArea = (-radiusXneg_new + 1 + (radiusXpos_new = Commons.clamp(0, 1000, Math.abs(posX)))) * (-(radiusZneg_new = -Commons.clamp(0, 1000, Math.abs(negZ))) + 1 + (radiusZpos_new = Commons.clamp(0, 1000, Math.abs(posZ))));
        if (newArea <= (maxArea = (1 + 2 * maxRange) * (1 + 2 * maxRange))) {
            this.radiusXneg = radiusXneg_new;
            this.radiusXpos = radiusXpos_new;
            this.radiusZneg = radiusZneg_new;
            this.radiusZpos = radiusZpos_new;
            this.refreshChunkRange();
        }
    }

    private void refreshChunkRange() {
        if (this.field_145850_b == null) {
            return;
        }
        ChunkCoordIntPair chunkSelf = this.field_145850_b.func_72938_d(this.field_145851_c, this.field_145849_e).func_76632_l();
        this.chunkMin = new ChunkCoordIntPair(chunkSelf.field_77276_a + this.radiusXneg, chunkSelf.field_77275_b + this.radiusZneg);
        this.chunkMax = new ChunkCoordIntPair(chunkSelf.field_77276_a + this.radiusXpos, chunkSelf.field_77275_b + this.radiusZpos);
        this.refreshChunkLoading();
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.isEnabled = !tagCompound.func_74764_b("isEnabled") || tagCompound.func_74767_n("isEnabled");
        this.setBounds(tagCompound.func_74762_e("radiusXneg"), tagCompound.func_74762_e("radiusXpos"), tagCompound.func_74762_e("radiusZneg"), tagCompound.func_74762_e("radiusZpos"));
        this.isPowered = tagCompound.func_74767_n("isPowered");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74757_a("isEnabled", this.isEnabled);
        tagCompound.func_74768_a("radiusXneg", this.radiusXneg);
        tagCompound.func_74768_a("radiusZneg", this.radiusZneg);
        tagCompound.func_74768_a("radiusXpos", this.radiusXpos);
        tagCompound.func_74768_a("radiusZpos", this.radiusZpos);
        tagCompound.func_74757_a("isPowered", this.isPowered);
    }

    public Object[] enable(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            this.isEnabled = Commons.toBool(arguments[0]);
        }
        return new Object[]{this.isEnabled};
    }

    public Object[] bounds(Object[] arguments) {
        if (arguments.length == 4) {
            this.setBounds(Commons.toInt(arguments[0]), Commons.toInt(arguments[1]), Commons.toInt(arguments[2]), Commons.toInt(arguments[3]));
        }
        return new Object[]{this.radiusXneg, this.radiusXpos, this.radiusZneg, this.radiusZpos};
    }

    public Object[] radius(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            int radius = Commons.toInt(arguments[0]);
            this.setBounds(radius, radius, radius, radius);
        }
        return new Object[]{this.radiusXneg, this.radiusXpos, this.radiusZneg, this.radiusZpos};
    }

    public Object[] upgrades() {
        return new Object[]{this.getUpgradesAsString()};
    }

    public Object[] getEnergyRequired() {
        return new Object[]{this.chunkloading_getEnergyRequired()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] enable(Context context, Arguments arguments) {
        return this.enable(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] bounds(Context context, Arguments arguments) {
        return this.bounds(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] radius(Context context, Arguments arguments) {
        return this.radius(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] upgrades(Context context, Arguments arguments) {
        return this.upgrades();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getEnergyRequired(Context context, Arguments arguments) {
        return this.getEnergyRequired();
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName;
        switch (methodName = this.getMethodName(method)) {
            case "radius": {
                return this.radius(arguments);
            }
            case "bounds": {
                return this.bounds(arguments);
            }
            case "enable": {
                return this.enable(arguments);
            }
            case "upgrades": {
                return this.upgrades();
            }
            case "getEnergyRequired": {
                return this.getEnergyRequired();
            }
        }
        return super.callMethod(computer, context, method, arguments);
    }

    @Override
    public String toString() {
        return String.format("%s @ %s (%d %d %d)", this.getClass().getSimpleName(), this.field_145850_b == null ? "~NULL~" : this.field_145850_b.field_73011_w.func_80007_l(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

