/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBeamFrequency;
import cr0s.warpdrive.api.IDamageReceiver;
import cr0s.warpdrive.block.TileEntityAbstractLaser;
import cr0s.warpdrive.block.forcefield.BlockForceField;
import cr0s.warpdrive.block.forcefield.TileEntityForceField;
import cr0s.warpdrive.block.weapon.BlockLaserCamera;
import cr0s.warpdrive.block.weapon.TileEntityLaserCamera;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.ForceFieldSetup;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.network.PacketHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TileEntityLaser
extends TileEntityAbstractLaser
implements IBeamFrequency {
    private int legacyVideoChannel = -1;
    private boolean legacyCheck = !(this instanceof TileEntityLaserCamera);
    private float yaw;
    private float pitch;
    protected int beamFrequency = -1;
    private float r;
    private float g;
    private float b;
    private boolean isEmitting = false;
    private int delayTicks = 0;
    private int energyFromOtherBeams = 0;
    private ScanResultType scanResult_type = ScanResultType.IDLE;
    private VectorI scanResult_position = null;
    private String scanResult_blockUnlocalizedName;
    private int scanResult_blockMetadata = 0;
    private float scanResult_blockResistance = -2.0f;

    public TileEntityLaser() {
        this.peripheralName = "warpdriveLaser";
        this.addMethods(new String[]{"emitBeam", "beamFrequency", "getScanResult"});
        this.laserMedium_maxCount = WarpDriveConfig.LASER_CANNON_MAX_MEDIUMS_COUNT;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.legacyCheck) {
            if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) instanceof BlockLaserCamera) {
                try {
                    WarpDrive.logger.info("Self-upgrading legacy tile entity " + this);
                    NBTTagCompound nbtOld = new NBTTagCompound();
                    this.func_145841_b(nbtOld);
                    TileEntityLaserCamera newTileEntity = new TileEntityLaserCamera();
                    newTileEntity.func_145839_a(nbtOld);
                    newTileEntity.func_145834_a(this.field_145850_b);
                    newTileEntity.func_145829_t();
                    this.func_145843_s();
                    this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.field_145850_b.func_147455_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)newTileEntity);
                    newTileEntity.setVideoChannel(this.legacyVideoChannel);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.legacyCheck = false;
        }
        if (this.beamFrequency <= 0 || this.beamFrequency > 65000) {
            return;
        }
        ++this.delayTicks;
        if (this.isEmitting && (this.beamFrequency != 1420 && this.delayTicks > WarpDriveConfig.LASER_CANNON_EMIT_FIRE_DELAY_TICKS || this.beamFrequency == 1420 && this.delayTicks > WarpDriveConfig.LASER_CANNON_EMIT_SCAN_DELAY_TICKS)) {
            this.delayTicks = 0;
            this.isEmitting = false;
            int beamEnergy = Math.min(this.laserMedium_consumeUpTo(Integer.MAX_VALUE, false) + MathHelper.func_76128_c((double)((double)this.energyFromOtherBeams * WarpDriveConfig.LASER_CANNON_BOOSTER_BEAM_ENERGY_EFFICIENCY)), WarpDriveConfig.LASER_CANNON_MAX_LASER_ENERGY);
            this.emitBeam(beamEnergy);
            this.energyFromOtherBeams = 0;
            this.sendEvent("laserSend", this.beamFrequency, beamEnergy);
        }
    }

    public void initiateBeamEmission(float parYaw, float parPitch) {
        this.yaw = parYaw;
        this.pitch = parPitch;
        this.delayTicks = 0;
        this.isEmitting = true;
    }

    private void addBeamEnergy(int amount) {
        if (this.isEmitting) {
            this.energyFromOtherBeams += amount;
            if (WarpDriveConfig.LOGGING_WEAPON) {
                WarpDrive.logger.info(String.format("%s Added boosting energy %d for a total accumulation of %d", this, amount, this.energyFromOtherBeams));
            }
        } else if (WarpDriveConfig.LOGGING_WEAPON) {
            WarpDrive.logger.warn(String.format("%s Ignored boosting energy %d", this, amount));
        }
    }

    public static MovingObjectPosition rayTraceBlocks(World world, Vec3 vSource, Vec3 vTarget, int beamFrequency, boolean checkLiquids, boolean checkAir, boolean doReturnMissed) {
        MovingObjectPosition movingObjectPosition;
        if (Double.isNaN(vSource.field_72450_a) || Double.isNaN(vSource.field_72448_b) || Double.isNaN(vSource.field_72449_c)) {
            return null;
        }
        if (Double.isNaN(vTarget.field_72450_a) || Double.isNaN(vTarget.field_72448_b) || Double.isNaN(vTarget.field_72449_c)) {
            return null;
        }
        int xSource = MathHelper.func_76128_c((double)vSource.field_72450_a);
        int ySource = MathHelper.func_76128_c((double)vSource.field_72448_b);
        int zSource = MathHelper.func_76128_c((double)vSource.field_72449_c);
        Block blockSource = world.func_147439_a(xSource, ySource, zSource);
        int metadataSource = world.func_72805_g(xSource, ySource, zSource);
        if ((checkAir || blockSource.func_149668_a(world, xSource, ySource, zSource) != null) && blockSource.func_149678_a(metadataSource, checkLiquids) && (movingObjectPosition = blockSource.func_149731_a(world, xSource, ySource, zSource, vSource, vTarget)) != null) {
            return movingObjectPosition;
        }
        int xTarget = MathHelper.func_76128_c((double)vTarget.field_72450_a);
        int yTarget = MathHelper.func_76128_c((double)vTarget.field_72448_b);
        int zTarget = MathHelper.func_76128_c((double)vTarget.field_72449_c);
        Vec3 vCurrent = Vec3.func_72443_a((double)vSource.field_72450_a, (double)vSource.field_72448_b, (double)vSource.field_72449_c);
        int xCurrent = xSource;
        int yCurrent = ySource;
        int zCurrent = zSource;
        MovingObjectPosition movingObjectPositionMissed = null;
        int countLoop = WarpDriveConfig.LASER_CANNON_RANGE_MAX * 2;
        while (countLoop-- >= 0) {
            TileEntity tileEntity;
            EnumFacing facing;
            if (Double.isNaN(vCurrent.field_72450_a) || Double.isNaN(vCurrent.field_72448_b) || Double.isNaN(vCurrent.field_72449_c)) {
                WarpDrive.logger.error(String.format("Critical error while raytracing blocks from %s to %s in %s", vSource, vTarget, world.field_73011_w.func_80007_l()));
                return null;
            }
            if (xCurrent == xTarget && yCurrent == yTarget && zCurrent == zTarget) {
                return doReturnMissed ? movingObjectPositionMissed : null;
            }
            boolean hasOffsetX = true;
            boolean hasOffsetY = true;
            boolean hasOffsetZ = true;
            double xProposed = 999.0;
            double yProposed = 999.0;
            double zProposed = 999.0;
            if (xTarget > xCurrent) {
                xProposed = (double)xCurrent + 1.0;
            } else if (xTarget < xCurrent) {
                xProposed = (double)xCurrent + 0.0;
            } else {
                hasOffsetX = false;
            }
            if (yTarget > yCurrent) {
                yProposed = (double)yCurrent + 1.0;
            } else if (yTarget < yCurrent) {
                yProposed = (double)yCurrent + 0.0;
            } else {
                hasOffsetY = false;
            }
            if (zTarget > zCurrent) {
                zProposed = (double)zCurrent + 1.0;
            } else if (zTarget < zCurrent) {
                zProposed = (double)zCurrent + 0.0;
            } else {
                hasOffsetZ = false;
            }
            double xDeltaNormalized = 999.0;
            double yDeltaNormalized = 999.0;
            double zDeltaNormalized = 999.0;
            double xDeltaToTarget = vTarget.field_72450_a - vCurrent.field_72450_a;
            double yDeltaToTarget = vTarget.field_72448_b - vCurrent.field_72448_b;
            double zDeltaToTarget = vTarget.field_72449_c - vCurrent.field_72449_c;
            if (hasOffsetX) {
                xDeltaNormalized = (xProposed - vCurrent.field_72450_a) / xDeltaToTarget;
            }
            if (hasOffsetY) {
                yDeltaNormalized = (yProposed - vCurrent.field_72448_b) / yDeltaToTarget;
            }
            if (hasOffsetZ) {
                zDeltaNormalized = (zProposed - vCurrent.field_72449_c) / zDeltaToTarget;
            }
            if (xDeltaNormalized < yDeltaNormalized && xDeltaNormalized < zDeltaNormalized) {
                facing = xTarget > xCurrent ? EnumFacing.WEST : EnumFacing.EAST;
                vCurrent.field_72450_a = xProposed;
                vCurrent.field_72448_b += yDeltaToTarget * xDeltaNormalized;
                vCurrent.field_72449_c += zDeltaToTarget * xDeltaNormalized;
            } else if (yDeltaNormalized < zDeltaNormalized) {
                facing = yTarget > yCurrent ? EnumFacing.UP : EnumFacing.DOWN;
                vCurrent.field_72450_a += xDeltaToTarget * yDeltaNormalized;
                vCurrent.field_72448_b = yProposed;
                vCurrent.field_72449_c += zDeltaToTarget * yDeltaNormalized;
            } else {
                facing = zTarget > zCurrent ? EnumFacing.SOUTH : EnumFacing.NORTH;
                vCurrent.field_72450_a += xDeltaToTarget * zDeltaNormalized;
                vCurrent.field_72448_b += yDeltaToTarget * zDeltaNormalized;
                vCurrent.field_72449_c = zProposed;
            }
            xCurrent = MathHelper.func_76128_c((double)vCurrent.field_72450_a);
            if (facing == EnumFacing.EAST) {
                --xCurrent;
            }
            yCurrent = MathHelper.func_76128_c((double)vCurrent.field_72448_b);
            if (facing == EnumFacing.DOWN) {
                --yCurrent;
            }
            zCurrent = MathHelper.func_76128_c((double)vCurrent.field_72449_c);
            if (facing == EnumFacing.NORTH) {
                --zCurrent;
            }
            Block blockCurrent = world.func_147439_a(xCurrent, yCurrent, zCurrent);
            int metadataCurrent = world.func_72805_g(xCurrent, yCurrent, zCurrent);
            if (blockCurrent instanceof BlockForceField && (tileEntity = world.func_147438_o(xCurrent, yCurrent, zCurrent)) instanceof TileEntityForceField) {
                ForceFieldSetup forceFieldSetup = ((TileEntityForceField)tileEntity).getForceFieldSetup();
                if (forceFieldSetup == null) {
                    WarpDrive.logger.warn(String.format("Laser beam stopped by non-loaded force field projector at %s", tileEntity));
                } else if (forceFieldSetup.beamFrequency == beamFrequency) {
                    if (!WarpDriveConfig.LOGGING_WEAPON) continue;
                    WarpDrive.logger.info(String.format("Laser beam passing through force field %s", tileEntity));
                    continue;
                }
            }
            if (!checkAir && blockCurrent.func_149668_a(world, xCurrent, yCurrent, zCurrent) == null) continue;
            if (blockCurrent.func_149678_a(metadataCurrent, checkLiquids)) {
                MovingObjectPosition movingObjectPosition2 = blockCurrent.func_149731_a(world, xCurrent, yCurrent, zCurrent, vCurrent, vTarget);
                if (movingObjectPosition2 == null) continue;
                return movingObjectPosition2;
            }
            movingObjectPositionMissed = new MovingObjectPosition(xCurrent, yCurrent, zCurrent, facing.ordinal(), vCurrent, false);
        }
        return doReturnMissed ? movingObjectPositionMissed : null;
    }

    private void emitBeam(int beamEnergy) {
        int energy = beamEnergy;
        int beamLengthBlocks = Commons.clamp(0, WarpDriveConfig.LASER_CANNON_RANGE_MAX, energy / 200);
        if (energy == 0 || this.beamFrequency > 65000 || this.beamFrequency <= 0) {
            if (WarpDriveConfig.LOGGING_WEAPON) {
                WarpDrive.logger.info(this + " Beam canceled (energy " + energy + " over " + beamLengthBlocks + " blocks, beamFrequency " + this.beamFrequency + ")");
            }
            return;
        }
        float yawZ = MathHelper.func_76134_b((float)(-this.yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float yawX = MathHelper.func_76126_a((float)(-this.yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float pitchHorizontal = -MathHelper.func_76134_b((float)(-this.pitch * ((float)Math.PI / 180)));
        float pitchVertical = MathHelper.func_76126_a((float)(-this.pitch * ((float)Math.PI / 180)));
        float directionX = yawX * pitchHorizontal;
        float directionZ = yawZ * pitchHorizontal;
        Vector3 vDirection = new Vector3(directionX, pitchVertical, directionZ);
        Vector3 vSource = new Vector3(this).translate(0.5).translate(vDirection);
        Vector3 vReachPoint = vSource.clone().translateFactor(vDirection, beamLengthBlocks);
        if (WarpDriveConfig.LOGGING_WEAPON) {
            WarpDrive.logger.info(this + " Energy " + energy + " over " + beamLengthBlocks + " blocks, Orientation " + this.yaw + " " + this.pitch + ", Direction " + vDirection + ", From " + vSource + " to " + vReachPoint);
        }
        this.playSoundCorrespondsEnergy(energy);
        if (this.beamFrequency == 1420) {
            MovingObjectPosition mopResult = TileEntityLaser.rayTraceBlocks(this.field_145850_b, vSource.toVec3(), vReachPoint.toVec3(), this.beamFrequency, false, true, false);
            this.scanResult_blockUnlocalizedName = null;
            this.scanResult_blockMetadata = 0;
            this.scanResult_blockResistance = -2.0f;
            if (mopResult != null) {
                this.scanResult_type = ScanResultType.BLOCK;
                this.scanResult_position = new VectorI(mopResult.field_72311_b, mopResult.field_72312_c, mopResult.field_72309_d);
                Block block = this.field_145850_b.func_147439_a(this.scanResult_position.x, this.scanResult_position.y, this.scanResult_position.z);
                if (block != null) {
                    this.scanResult_blockUnlocalizedName = block.func_149739_a();
                    this.scanResult_blockMetadata = this.field_145850_b.func_72805_g(this.scanResult_position.x, this.scanResult_position.y, this.scanResult_position.z);
                    this.scanResult_blockResistance = block.func_149638_a(null);
                }
                PacketHandler.sendBeamPacket(this.field_145850_b, vSource, new Vector3(mopResult.field_72307_f), this.r, this.g, this.b, 50, energy, 200);
            } else {
                this.scanResult_type = ScanResultType.NONE;
                this.scanResult_position = new VectorI(vReachPoint.intX(), vReachPoint.intY(), vReachPoint.intZ());
                PacketHandler.sendBeamPacket(this.field_145850_b, vSource, vReachPoint, this.r, this.g, this.b, 50, energy, 200);
            }
            if (WarpDriveConfig.LOGGING_WEAPON) {
                WarpDrive.logger.info("Scan result type " + this.scanResult_type.name + " at " + this.scanResult_position.x + " " + this.scanResult_position.y + " " + this.scanResult_position.z + " block " + this.scanResult_blockUnlocalizedName + " " + this.scanResult_blockMetadata + " resistance " + this.scanResult_blockResistance);
            }
            this.sendEvent("laserScanning", this.scanResult_type.name, this.scanResult_position.x, this.scanResult_position.y, this.scanResult_position.z, this.scanResult_blockUnlocalizedName, this.scanResult_blockMetadata, Float.valueOf(this.scanResult_blockResistance));
            return;
        }
        TreeMap<Double, MovingObjectPosition> entityHits = this.raytraceEntities(vSource.clone(), vDirection.clone(), beamLengthBlocks);
        if (WarpDriveConfig.LOGGING_WEAPON) {
            WarpDrive.logger.info("Entity hits are (" + (entityHits == null ? 0 : entityHits.size()) + ") " + entityHits);
        }
        Vector3 vHitPoint = vReachPoint.clone();
        double distanceTravelled = 0.0;
        for (int passedBlocks = 0; passedBlocks < beamLengthBlocks; ++passedBlocks) {
            TileEntityLaser tileEntityLaser;
            MovingObjectPosition blockHit = TileEntityLaser.rayTraceBlocks(this.field_145850_b, vSource.toVec3(), vReachPoint.toVec3(), this.beamFrequency, false, true, false);
            double blockHitDistance = (double)beamLengthBlocks + 0.1;
            if (blockHit != null) {
                blockHitDistance = blockHit.field_72307_f.func_72438_d(vSource.toVec3());
            }
            if (entityHits != null) {
                Map.Entry<Double, MovingObjectPosition> entityHitEntry;
                double entityHitDistance;
                Iterator<Map.Entry<Double, MovingObjectPosition>> iterator = entityHits.entrySet().iterator();
                while (iterator.hasNext() && !((entityHitDistance = (entityHitEntry = iterator.next()).getKey().doubleValue()) >= blockHitDistance)) {
                    MovingObjectPosition mopEntity = entityHitEntry.getValue();
                    if (mopEntity == null) continue;
                    EntityLivingBase entity = null;
                    if (mopEntity.field_72308_g instanceof EntityLivingBase) {
                        entity = (EntityLivingBase)mopEntity.field_72308_g;
                        if (WarpDriveConfig.LOGGING_WEAPON) {
                            WarpDrive.logger.info("Entity is a valid target (living) " + entity);
                        }
                    } else {
                        String entityId = EntityList.func_75621_b((Entity)mopEntity.field_72308_g);
                        if (!Dictionary.ENTITIES_NONLIVINGTARGET.contains(entityId)) {
                            if (WarpDriveConfig.LOGGING_WEAPON) {
                                WarpDrive.logger.info("Entity is an invalid target (non-living " + entityId + ") " + mopEntity.field_72308_g);
                            }
                            entityHits.put(entityHitDistance, null);
                            continue;
                        }
                        if (WarpDriveConfig.LOGGING_WEAPON) {
                            WarpDrive.logger.info("Entity is a valid target (non-living " + entityId + ") " + mopEntity.field_72308_g);
                        }
                    }
                    energy = (int)((double)energy * this.getTransmittance(entityHitDistance - distanceTravelled));
                    distanceTravelled = entityHitDistance;
                    vHitPoint = new Vector3(mopEntity.field_72307_f);
                    if ((energy -= WarpDriveConfig.LASER_CANNON_ENTITY_HIT_ENERGY) <= 0) break;
                    mopEntity.field_72308_g.func_70015_d(WarpDriveConfig.LASER_CANNON_ENTITY_HIT_SET_ON_FIRE_SECONDS);
                    if (entity != null) {
                        float damage = (float)Commons.clamp(0.0, (double)WarpDriveConfig.LASER_CANNON_ENTITY_HIT_MAX_DAMAGE, (double)(WarpDriveConfig.LASER_CANNON_ENTITY_HIT_BASE_DAMAGE + energy / WarpDriveConfig.LASER_CANNON_ENTITY_HIT_ENERGY_PER_DAMAGE));
                        entity.func_70097_a(DamageSource.field_76372_a, damage);
                    } else {
                        mopEntity.field_72308_g.func_70106_y();
                    }
                    if (energy > WarpDriveConfig.LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_THRESHOLD) {
                        float strength = (float)Commons.clamp(0.0, (double)WarpDriveConfig.LASER_CANNON_ENTITY_HIT_EXPLOSION_MAX_STRENGTH, (double)(WarpDriveConfig.LASER_CANNON_ENTITY_HIT_EXPLOSION_BASE_STRENGTH + (float)(energy / WarpDriveConfig.LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_PER_STRENGTH)));
                        this.field_145850_b.func_72885_a(null, mopEntity.field_72308_g.field_70165_t, mopEntity.field_72308_g.field_70163_u, mopEntity.field_72308_g.field_70161_v, strength, true, true);
                    }
                    entityHits.put(entityHitDistance, null);
                }
                if (energy <= 0) break;
            }
            if (blockHitDistance >= (double)beamLengthBlocks || blockHit == null) {
                if (WarpDriveConfig.LOGGING_WEAPON) {
                    WarpDrive.logger.info("No more blocks to hit or too far: blockHitDistance is " + blockHitDistance + ", blockHit is " + blockHit);
                }
                vHitPoint = vReachPoint;
                break;
            }
            Block block = this.field_145850_b.func_147439_a(blockHit.field_72311_b, blockHit.field_72312_c, blockHit.field_72309_d);
            float hardness = -2.0f;
            if (WarpDrive.fieldBlockHardness != null) {
                try {
                    hardness = ((Float)WarpDrive.fieldBlockHardness.get(block)).floatValue();
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    exception.printStackTrace();
                    WarpDrive.logger.error("Unable to access block hardness value of " + block);
                }
            }
            if (block instanceof IDamageReceiver) {
                hardness = ((IDamageReceiver)block).getBlockHardness(this.field_145850_b, blockHit.field_72311_b, blockHit.field_72312_c, blockHit.field_72309_d, WarpDrive.damageLaser, this.beamFrequency, vDirection, energy);
            }
            if (WarpDriveConfig.LOGGING_WEAPON) {
                WarpDrive.logger.info(String.format("Block collision found at (%d %d %d) with block %s of hardness %.2f", blockHit.field_72311_b, blockHit.field_72312_c, blockHit.field_72309_d, block.func_149739_a(), Float.valueOf(hardness)));
            }
            if (this.isBlockBreakCanceled(null, this.field_145850_b, blockHit.field_72311_b, blockHit.field_72312_c, blockHit.field_72309_d)) {
                if (WarpDriveConfig.LOGGING_WEAPON) {
                    WarpDrive.logger.info("Laser weapon cancelled at (" + blockHit.field_72311_b + " " + blockHit.field_72312_c + " " + blockHit.field_72309_d + ")");
                }
                vHitPoint = new Vector3(blockHit.field_72307_f);
                break;
            }
            if ((block.func_149667_c(WarpDrive.blockLaser) || block.func_149667_c(WarpDrive.blockLaserCamera)) && (tileEntityLaser = (TileEntityLaser)this.field_145850_b.func_147438_o(blockHit.field_72311_b, blockHit.field_72312_c, blockHit.field_72309_d)) != null && tileEntityLaser.getBeamFrequency() == this.beamFrequency) {
                tileEntityLaser.addBeamEnergy(energy);
                vHitPoint = new Vector3(blockHit.field_72307_f);
                break;
            }
            if (hardness < 0.0f) {
                float strength = (float)Commons.clamp(0.0, (double)WarpDriveConfig.LASER_CANNON_BLOCK_HIT_EXPLOSION_MAX_STRENGTH, (double)(WarpDriveConfig.LASER_CANNON_BLOCK_HIT_EXPLOSION_BASE_STRENGTH + (float)(energy / WarpDriveConfig.LASER_CANNON_BLOCK_HIT_EXPLOSION_ENERGY_PER_STRENGTH)));
                if (WarpDriveConfig.LOGGING_WEAPON) {
                    WarpDrive.logger.info("Explosion triggered with strength " + strength);
                }
                this.field_145850_b.func_72885_a(null, (double)blockHit.field_72311_b, (double)blockHit.field_72312_c, (double)blockHit.field_72309_d, strength, true, true);
                vHitPoint = new Vector3(blockHit.field_72307_f);
                break;
            }
            int energyCost = Commons.clamp(WarpDriveConfig.LASER_CANNON_BLOCK_HIT_ENERGY_MIN, WarpDriveConfig.LASER_CANNON_BLOCK_HIT_ENERGY_MAX, Math.round(hardness * (float)WarpDriveConfig.LASER_CANNON_BLOCK_HIT_ENERGY_PER_BLOCK_HARDNESS));
            double absorptionChance = Commons.clamp(0.0, WarpDriveConfig.LASER_CANNON_BLOCK_HIT_ABSORPTION_MAX, (double)hardness * WarpDriveConfig.LASER_CANNON_BLOCK_HIT_ABSORPTION_PER_BLOCK_HARDNESS);
            if (WarpDriveConfig.LOGGING_WEAPON) {
                WarpDrive.logger.info(String.format("Block energy cost is %d with %.1f %% of absorption", energyCost, absorptionChance * 100.0));
            }
            energy = (int)((double)energy * this.getTransmittance(blockHitDistance - distanceTravelled));
            do {
                distanceTravelled = blockHitDistance;
                vHitPoint = new Vector3(blockHit.field_72307_f);
                if ((energy -= energyCost) <= 0) {
                    if (!WarpDriveConfig.LOGGING_WEAPON) break;
                    WarpDrive.logger.info("Beam died out of energy");
                    break;
                }
                if (!WarpDriveConfig.LOGGING_WEAPON) continue;
                WarpDrive.logger.info(String.format("Beam energy down to %d", energy));
            } while (!(this.field_145850_b.field_73012_v.nextDouble() > absorptionChance));
            if (energy <= 0) break;
            Vector3 origin = new Vector3((double)blockHit.field_72311_b - 0.3 * vDirection.x + (double)this.field_145850_b.field_73012_v.nextFloat() - (double)this.field_145850_b.field_73012_v.nextFloat(), (double)blockHit.field_72312_c - 0.3 * vDirection.y + (double)this.field_145850_b.field_73012_v.nextFloat() - (double)this.field_145850_b.field_73012_v.nextFloat(), (double)blockHit.field_72309_d - 0.3 * vDirection.z + (double)this.field_145850_b.field_73012_v.nextFloat() - (double)this.field_145850_b.field_73012_v.nextFloat());
            Vector3 direction = new Vector3(-0.2 * vDirection.x + 0.05 * (double)(this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()), -0.2 * vDirection.y + 0.05 * (double)(this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()), -0.2 * vDirection.z + 0.05 * (double)(this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()));
            PacketHandler.sendSpawnParticlePacket(this.field_145850_b, "explode", (byte)5, origin, direction, this.r, this.g, this.b, this.r, this.g, this.b, 96);
            if (block instanceof IDamageReceiver) {
                energy = ((IDamageReceiver)block).applyDamage(this.field_145850_b, blockHit.field_72311_b, blockHit.field_72312_c, blockHit.field_72309_d, WarpDrive.damageLaser, this.beamFrequency, vDirection, energy);
                if (WarpDriveConfig.LOGGING_WEAPON) {
                    WarpDrive.logger.info("IDamageReceiver damage applied, remaining energy is " + energy);
                }
                if (energy <= 0) break;
            }
            if (hardness >= WarpDriveConfig.LASER_CANNON_BLOCK_HIT_EXPLOSION_HARDNESS_THRESHOLD) {
                float strength = (float)Commons.clamp(0.0, (double)WarpDriveConfig.LASER_CANNON_BLOCK_HIT_EXPLOSION_MAX_STRENGTH, (double)(WarpDriveConfig.LASER_CANNON_BLOCK_HIT_EXPLOSION_BASE_STRENGTH + (float)(energy / WarpDriveConfig.LASER_CANNON_BLOCK_HIT_EXPLOSION_ENERGY_PER_STRENGTH)));
                if (WarpDriveConfig.LOGGING_WEAPON) {
                    WarpDrive.logger.info("Explosion triggered with strength " + strength);
                }
                this.field_145850_b.func_72885_a(null, (double)blockHit.field_72311_b, (double)blockHit.field_72312_c, (double)blockHit.field_72309_d, strength, true, true);
                this.field_145850_b.func_147449_b(blockHit.field_72311_b, blockHit.field_72312_c, blockHit.field_72309_d, (Block)(this.field_145850_b.field_73012_v.nextBoolean() ? Blocks.field_150480_ab : Blocks.field_150350_a));
                continue;
            }
            this.field_145850_b.func_147468_f(blockHit.field_72311_b, blockHit.field_72312_c, blockHit.field_72309_d);
        }
        PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(this).translate(0.5).translate(vDirection.scale(0.5)), vHitPoint, this.r, this.g, this.b, 50, energy, beamLengthBlocks);
    }

    private double getTransmittance(double distance) {
        if (distance <= 0.0) {
            return 1.0;
        }
        double attenuation = CelestialObjectManager.hasAtmosphere(this.field_145850_b, this.field_145851_c, this.field_145849_e) ? WarpDriveConfig.LASER_CANNON_ENERGY_ATTENUATION_PER_AIR_BLOCK : WarpDriveConfig.LASER_CANNON_ENERGY_ATTENUATION_PER_VOID_BLOCK;
        double transmittance = Math.exp(-attenuation * distance);
        if (WarpDriveConfig.LOGGING_WEAPON) {
            WarpDrive.logger.info("Transmittance over " + distance + " blocks is " + transmittance);
        }
        return transmittance;
    }

    private TreeMap<Double, MovingObjectPosition> raytraceEntities(Vector3 vSource, Vector3 vDirection, double reachDistance) {
        double raytraceTolerance = 2.0;
        Vec3 vec3Source = vSource.toVec3();
        Vec3 vec3Target = Vec3.func_72443_a((double)(vec3Source.field_72450_a + vDirection.x * reachDistance), (double)(vec3Source.field_72448_b + vDirection.y * reachDistance), (double)(vec3Source.field_72449_c + vDirection.z * reachDistance));
        AxisAlignedBB boxToScan = AxisAlignedBB.func_72330_a((double)Math.min((double)this.field_145851_c - 2.0, vec3Target.field_72450_a - 2.0), (double)Math.min((double)this.field_145848_d - 2.0, vec3Target.field_72448_b - 2.0), (double)Math.min((double)this.field_145849_e - 2.0, vec3Target.field_72449_c - 2.0), (double)Math.max((double)this.field_145851_c + 2.0, vec3Target.field_72450_a + 2.0), (double)Math.max((double)this.field_145848_d + 2.0, vec3Target.field_72448_b + 2.0), (double)Math.max((double)this.field_145849_e + 2.0, vec3Target.field_72449_c + 2.0));
        List entities = this.field_145850_b.func_72839_b(null, boxToScan);
        if (entities == null || entities.isEmpty()) {
            if (WarpDriveConfig.LOGGING_WEAPON) {
                WarpDrive.logger.info("No entity on trajectory (box)");
            }
            return null;
        }
        HashMap<Double, MovingObjectPosition> entityHits = new HashMap<Double, MovingObjectPosition>(entities.size());
        for (Entity entity : entities) {
            if (entity == null || !entity.func_70067_L() || entity.field_70121_D == null) continue;
            double border = entity.func_70111_Y();
            AxisAlignedBB aabbEntity = entity.field_70121_D.func_72314_b(border, border, border);
            MovingObjectPosition hitMOP = aabbEntity.func_72327_a(vec3Source, vec3Target);
            if (WarpDriveConfig.LOGGING_WEAPON) {
                WarpDrive.logger.info("Checking " + entity + " boundingBox " + entity.field_70121_D + " border " + border + " aabbEntity " + aabbEntity + " hitMOP " + hitMOP);
            }
            if (hitMOP == null) continue;
            MovingObjectPosition mopEntity = new MovingObjectPosition(entity);
            mopEntity.field_72307_f = hitMOP.field_72307_f;
            double distance = vec3Source.func_72438_d(hitMOP.field_72307_f);
            if (entityHits.containsKey(distance)) {
                distance += this.field_145850_b.field_73012_v.nextDouble() / 10.0;
            }
            entityHits.put(distance, mopEntity);
        }
        if (entityHits.isEmpty()) {
            return null;
        }
        return new TreeMap<Double, MovingObjectPosition>(entityHits);
    }

    @Override
    public int getBeamFrequency() {
        return this.beamFrequency;
    }

    @Override
    public void setBeamFrequency(int parBeamFrequency) {
        if (this.beamFrequency != parBeamFrequency && parBeamFrequency <= 65000 && parBeamFrequency > 0) {
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info(this + " Beam frequency set from " + this.beamFrequency + " to " + parBeamFrequency);
            }
            this.beamFrequency = parBeamFrequency;
        }
        Vector3 vRGB = IBeamFrequency.getBeamColor(this.beamFrequency);
        this.r = (float)vRGB.x;
        this.g = (float)vRGB.y;
        this.b = (float)vRGB.z;
    }

    private void playSoundCorrespondsEnergy(int energy) {
        if (energy <= 500000) {
            this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d - 0.5f), (double)((float)this.field_145849_e + 0.5f), "warpdrive:lowlaser", 4.0f, 1.0f);
        } else if (energy > 500000 && energy <= 1000000) {
            this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d - 0.5f), (double)((float)this.field_145849_e + 0.5f), "warpdrive:midlaser", 4.0f, 1.0f);
        } else if (energy > 1000000) {
            this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d - 0.5f), (double)((float)this.field_145849_e + 0.5f), "warpdrive:hilaser", 4.0f, 1.0f);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.setBeamFrequency(tagCompound.func_74762_e("beamFrequency"));
        this.legacyVideoChannel = tagCompound.func_74762_e("cameraFrequency") + tagCompound.func_74762_e("videoChannel");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("beamFrequency", this.beamFrequency);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] emitBeam(Context context, Arguments arguments) {
        return this.emitBeam(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] beamFrequency(Context context, Arguments arguments) {
        if (arguments.count() == 1) {
            this.setBeamFrequency(arguments.checkInteger(0));
        }
        return new Integer[]{this.beamFrequency};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getScanResult(Context context, Arguments arguments) {
        return this.getScanResult();
    }

    private Object[] emitBeam(Object[] arguments) {
        try {
            if (arguments.length == 2) {
                float newYaw = Commons.toFloat(arguments[0]);
                float newPitch = Commons.toFloat(arguments[1]);
                this.initiateBeamEmission(newYaw, newPitch);
            } else if (arguments.length == 3) {
                float deltaX = -Commons.toFloat(arguments[0]);
                float deltaY = -Commons.toFloat(arguments[1]);
                float deltaZ = Commons.toFloat(arguments[2]);
                double horizontalDistance = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
                float newYaw = (float)(Math.atan2(deltaX, deltaZ) * 180.0 / Math.PI);
                float newPitch = (float)(Math.atan2(deltaY, horizontalDistance) * 180.0 / Math.PI);
                this.initiateBeamEmission(newYaw, newPitch);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Object[]{false};
        }
        return new Object[]{true};
    }

    private Object[] getScanResult() {
        if (this.scanResult_type != ScanResultType.IDLE) {
            try {
                Object[] info = new Object[]{this.scanResult_type.name, this.scanResult_position.x, this.scanResult_position.y, this.scanResult_position.z, this.scanResult_blockUnlocalizedName, this.scanResult_blockMetadata, Float.valueOf(this.scanResult_blockResistance)};
                this.scanResult_type = ScanResultType.IDLE;
                this.scanResult_position = null;
                this.scanResult_blockUnlocalizedName = null;
                this.scanResult_blockMetadata = 0;
                this.scanResult_blockResistance = -2.0f;
                return info;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return new Object[]{"!ERROR!", 0, 0, 0, null, 0, -3};
            }
        }
        return new Object[]{this.scanResult_type.name, 0, 0, 0, null, 0, -1};
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName;
        switch (methodName = this.getMethodName(method)) {
            case "emitBeam": {
                return this.emitBeam(arguments);
            }
            case "position": {
                return new Integer[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
            }
            case "beamFrequency": {
                if (arguments.length == 1 && arguments[0] != null) {
                    this.setBeamFrequency(Commons.toInt(arguments[0]));
                }
                return new Integer[]{this.beamFrequency};
            }
            case "getScanResult": {
                return this.getScanResult();
            }
        }
        return super.callMethod(computer, context, method, arguments);
    }

    @Override
    public String toString() {
        return String.format("%s Beam '%d' @ %s (%d %d %d)", this.getClass().getSimpleName(), this.beamFrequency, this.field_145850_b == null ? "~NULL~" : this.field_145850_b.field_73011_w.func_80007_l(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private static enum ScanResultType {
        IDLE("IDLE"),
        BLOCK("BLOCK"),
        NONE("NONE");

        public final String name;

        private ScanResultType(String name) {
            this.name = name;
        }
    }
}

