/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.breathing;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObjectManager;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityAirGenerator
extends TileEntityAbstractEnergy {
    private int cooldownTicks = 0;
    private boolean isEnabled = true;
    private static final int START_CONCENTRATION_VALUE = 15;

    public TileEntityAirGenerator() {
        this.peripheralName = "warpdriveAirGenerator";
        this.addMethods(new String[]{"enable"});
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.func_145837_r()) {
            return;
        }
        if (CelestialObjectManager.hasAtmosphere(this.field_145850_b, this.field_145851_c, this.field_145849_e)) {
            if (this.func_145832_p() != 0) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
            }
            return;
        }
        ++this.cooldownTicks;
        if (this.cooldownTicks > WarpDriveConfig.BREATHING_AIR_GENERATION_TICKS) {
            if (this.isEnabled && this.energy_consume(WarpDriveConfig.BREATHING_ENERGY_PER_NEW_AIR_BLOCK[0], true)) {
                if (this.func_145832_p() != 1) {
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 2);
                }
            } else if (this.func_145832_p() != 0) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
            }
            this.releaseAir(1, 0, 0);
            this.releaseAir(-1, 0, 0);
            this.releaseAir(0, 1, 0);
            this.releaseAir(0, -1, 0);
            this.releaseAir(0, 0, 1);
            this.releaseAir(0, 0, -1);
            this.cooldownTicks = 0;
        }
    }

    private void releaseAir(int xOffset, int yOffset, int zOffset) {
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c + xOffset, this.field_145848_d + yOffset, this.field_145849_e + zOffset);
        if (block.isAir((IBlockAccess)this.field_145850_b, this.field_145851_c + xOffset, this.field_145848_d + yOffset, this.field_145849_e + zOffset)) {
            int energy_cost;
            int n = energy_cost = !block.func_149667_c(WarpDrive.blockAir) ? WarpDriveConfig.BREATHING_ENERGY_PER_NEW_AIR_BLOCK[0] : WarpDriveConfig.BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK[0];
            if (this.isEnabled && this.energy_consume(energy_cost, true)) {
                if (this.field_145850_b.func_147465_d(this.field_145851_c + xOffset, this.field_145848_d + yOffset, this.field_145849_e + zOffset, WarpDrive.blockAir, 15, 2)) {
                    this.energy_consume(WarpDriveConfig.BREATHING_ENERGY_PER_NEW_AIR_BLOCK[0], false);
                } else {
                    this.energy_consume(WarpDriveConfig.BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK[0], false);
                }
            } else if (block.func_149667_c(WarpDrive.blockAir)) {
                int metadata = this.field_145850_b.func_72805_g(this.field_145851_c + xOffset, this.field_145848_d + yOffset, this.field_145849_e + zOffset);
                if (metadata > 4) {
                    this.field_145850_b.func_72921_c(this.field_145851_c + xOffset, this.field_145848_d + yOffset, this.field_145849_e + zOffset, metadata - 4, 2);
                } else if (metadata > 1) {
                    this.field_145850_b.func_72921_c(this.field_145851_c + xOffset, this.field_145848_d + yOffset, this.field_145849_e + zOffset, 1, 2);
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.isEnabled = !tagCompound.func_74764_b("isEnabled") || tagCompound.func_74767_n("isEnabled");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74757_a("isEnabled", this.isEnabled);
    }

    @Override
    public int energy_getMaxStorage() {
        return WarpDriveConfig.BREATHING_MAX_ENERGY_STORED[0];
    }

    @Override
    public boolean energy_canInput(ForgeDirection from) {
        return true;
    }

    @Override
    public String toString() {
        return String.format("%s @ %s (%d %d %d)", this.getClass().getSimpleName(), this.field_145850_b == null ? "~NULL~" : this.field_145850_b.field_73011_w.func_80007_l(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Object[] enable(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            this.isEnabled = Commons.toBool(arguments[0]);
        }
        return new Object[]{this.isEnabled};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] enable(Context context, Arguments arguments) {
        return this.enable(this.argumentsOCtoCC(arguments));
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName;
        switch (methodName = this.getMethodName(method)) {
            case "enable": {
                return this.enable(arguments);
            }
        }
        return super.callMethod(computer, context, method, arguments);
    }
}

