/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.breathing;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.block.breathing.BlockAirGeneratorTiered;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.StateAir;
import cr0s.warpdrive.event.ChunkHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityAirGeneratorTiered
extends TileEntityAbstractEnergy {
    protected byte tier = (byte)-1;
    private boolean isEnabled = true;
    private int maxEnergyStored = 0;
    private int cooldownTicks = 0;

    public TileEntityAirGeneratorTiered() {
        this.peripheralName = "warpdriveAirGenerator";
        this.addMethods(new String[]{"enable"});
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        Block block = this.func_145838_q();
        if (block instanceof BlockAirGeneratorTiered) {
            this.tier = ((BlockAirGeneratorTiered)block).tier;
            this.maxEnergyStored = WarpDriveConfig.BREATHING_MAX_ENERGY_STORED[this.tier - 1];
        } else {
            WarpDrive.logger.error("Missing block for " + this + " at " + this.field_145850_b + " " + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.func_145837_r()) {
            return;
        }
        int metadata = this.func_145832_p();
        if (CelestialObjectManager.hasAtmosphere(this.field_145850_b, this.field_145851_c, this.field_145849_e)) {
            if ((metadata & 8) != 0) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata & 7, 2);
            }
            return;
        }
        ++this.cooldownTicks;
        if (this.cooldownTicks > WarpDriveConfig.BREATHING_AIR_GENERATION_TICKS) {
            ForgeDirection direction = ForgeDirection.getOrientation((int)(metadata & 7));
            boolean isActive = this.releaseAir(direction);
            if (isActive) {
                if ((metadata & 8) == 0) {
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata | 8, 2);
                }
            } else if ((metadata & 8) != 0) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata & 7, 2);
            }
            this.cooldownTicks = 0;
        }
    }

    private boolean releaseAir(ForgeDirection direction) {
        int x = this.field_145851_c + direction.offsetX;
        int y = this.field_145848_d + direction.offsetY;
        int z = this.field_145849_e + direction.offsetZ;
        if (!this.field_145850_b.func_147437_c(x, y, z)) {
            return false;
        }
        StateAir stateAir = ChunkHandler.getStateAir(this.field_145850_b, x, y, z);
        if (stateAir == null) {
            return true;
        }
        stateAir.updateBlockCache(this.field_145850_b);
        if (!stateAir.isAir()) {
            return false;
        }
        if (this.isEnabled) {
            int energy_cost;
            int n = energy_cost = !stateAir.isAirSource() ? WarpDriveConfig.BREATHING_ENERGY_PER_NEW_AIR_BLOCK[this.tier - 1] : WarpDriveConfig.BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK[this.tier - 1];
            if (this.energy_consume(energy_cost, true)) {
                short range = (short)(WarpDriveConfig.BREATHING_AIR_GENERATION_RANGE_BLOCKS[this.tier - 1] - 1);
                stateAir.setAirSource(this.field_145850_b, direction, range);
                this.energy_consume(energy_cost, false);
                return true;
            }
        }
        if (stateAir.concentration > 4) {
            stateAir.setConcentration(this.field_145850_b, (byte)(stateAir.concentration / 2));
        } else if (stateAir.concentration > 0) {
            stateAir.removeAirSource(this.field_145850_b);
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.isEnabled = !tagCompound.func_74764_b("isEnabled") || tagCompound.func_74767_n("isEnabled");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74757_a("isEnabled", this.isEnabled);
    }

    @Override
    public int energy_getMaxStorage() {
        return this.maxEnergyStored;
    }

    @Override
    public boolean energy_canInput(ForgeDirection from) {
        return true;
    }

    @Override
    public String toString() {
        return String.format("%s @ %s (%d %d %d)", this.getClass().getSimpleName(), this.field_145850_b == null ? "~NULL~" : this.field_145850_b.field_73011_w.func_80007_l(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Object[] enable(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            this.isEnabled = Commons.toBool(arguments[0]);
        }
        return new Object[]{this.isEnabled};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] enable(Context context, Arguments arguments) {
        return this.enable(this.argumentsOCtoCC(arguments));
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName;
        switch (methodName = this.getMethodName(method)) {
            case "enable": {
                return this.enable(arguments);
            }
        }
        return super.callMethod(computer, context, method, arguments);
    }
}

