/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.building;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.block.BlockAbstractContainer;
import cr0s.warpdrive.block.building.TileEntityShipScanner;
import cr0s.warpdrive.render.RenderBlockShipScanner;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockShipScanner
extends BlockAbstractContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconBuffer;
    private static final int ICON_BOTTOM = 0;
    private static final int ICON_TOP = 1;
    private static final int ICON_SIDE = 2;
    private static final int ICON_BORDER = 3;
    public static int passCurrent;

    public BlockShipScanner() {
        super(Material.field_151573_f);
        this.func_149663_c("warpdrive.building.ship_scanner");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconBuffer = new IIcon[16];
        this.iconBuffer[0] = iconRegister.func_94245_a("warpdrive:building/ship_scanner-bottom");
        this.iconBuffer[1] = iconRegister.func_94245_a("warpdrive:building/ship_scanner-top");
        this.iconBuffer[2] = iconRegister.func_94245_a("warpdrive:building/ship_scanner-side");
        this.iconBuffer[3] = iconRegister.func_94245_a("warpdrive:building/ship_scanner-border");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (side == 0) {
            return this.iconBuffer[0];
        }
        if (side == 1) {
            return this.iconBuffer[1];
        }
        return this.iconBuffer[2];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getBorderIcon() {
        return this.iconBuffer[3];
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return RenderBlockShipScanner.renderId;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        passCurrent = pass;
        return pass == 0 || pass == 1;
    }

    public int func_149720_d(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity tileEntity = blockAccess.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityShipScanner && ((TileEntityShipScanner)tileEntity).blockCamouflage != null) {
            return ((TileEntityShipScanner)tileEntity).colorMultiplierCamouflage;
        }
        return super.func_149720_d(blockAccess, x, y, z);
    }

    public int getLightValue(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity tileEntity = blockAccess.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityShipScanner) {
            return ((TileEntityShipScanner)tileEntity).lightCamouflage;
        }
        return 0;
    }

    public boolean func_149662_c() {
        return false;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityShipScanner();
    }

    @Override
    public byte getTier(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77973_b() != Item.func_150898_a((Block)this)) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (world.field_72995_K) {
            return false;
        }
        if (entityPlayer.func_70694_bm() == null && (tileEntity = world.func_147438_o(x, y, z)) instanceof TileEntityShipScanner) {
            Block blockAbove = world.func_147439_a(x, y + 2, z);
            if (blockAbove.isAir((IBlockAccess)world, x, y + 2, z) || !entityPlayer.func_70093_af()) {
                Commons.addChatMessage((ICommandSender)entityPlayer, ((TileEntityShipScanner)tileEntity).getStatus());
                return true;
            }
            if (blockAbove != this) {
                ((TileEntityShipScanner)tileEntity).blockCamouflage = blockAbove;
                ((TileEntityShipScanner)tileEntity).metadataCamouflage = world.func_72805_g(x, y + 2, z);
                ((TileEntityShipScanner)tileEntity).colorMultiplierCamouflage = 0x808080;
                ((TileEntityShipScanner)tileEntity).lightCamouflage = blockAbove.getLightValue((IBlockAccess)world, x, y + 2, z);
                tileEntity.func_70296_d();
                world.func_72921_c(x, y, z, ((TileEntityShipScanner)tileEntity).metadataCamouflage, 2);
            } else {
                ((TileEntityShipScanner)tileEntity).blockCamouflage = null;
                ((TileEntityShipScanner)tileEntity).metadataCamouflage = 0;
                ((TileEntityShipScanner)tileEntity).colorMultiplierCamouflage = 0;
                ((TileEntityShipScanner)tileEntity).lightCamouflage = 0;
                tileEntity.func_70296_d();
                world.func_72921_c(x, y, z, ((TileEntityShipScanner)tileEntity).metadataCamouflage, 2);
            }
        }
        return false;
    }
}

