/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.building;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.ISequencerCallbacks;
import cr0s.warpdrive.block.TileEntityAbstractInterfaced;
import cr0s.warpdrive.block.movement.BlockShipCore;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumShipScannerState;
import cr0s.warpdrive.data.JumpBlock;
import cr0s.warpdrive.data.JumpShip;
import cr0s.warpdrive.data.Transformation;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.event.DeploySequencer;
import cr0s.warpdrive.item.ItemShipToken;
import cr0s.warpdrive.network.PacketHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityShipScanner
extends TileEntityAbstractInterfaced
implements ISequencerCallbacks {
    private String schematicFileName = "";
    private int targetX;
    private int targetY;
    private int targetZ;
    private byte rotationSteps;
    public Block blockCamouflage;
    public int metadataCamouflage;
    protected int colorMultiplierCamouflage;
    protected int lightCamouflage;
    private boolean isShipToken;
    private EnumShipScannerState enumShipScannerState = EnumShipScannerState.IDLE;
    private TileEntityShipCore shipCore = null;
    private int laserTicks = 0;
    private int scanTicks = 0;
    private int deployTicks = 0;
    private int searchTicks = 0;
    private String playerName = "";
    private JumpShip jumpShip;
    private int blocksToDeployCount;
    private static final int SHIP_TOKEN_UPDATE_PERIOD_TICKS = 20;
    private static final int SHIP_TOKEN_UPDATE_DELAY_FAILED_PRECONDITION_TICKS = 60;
    private static final int SHIP_TOKEN_UPDATE_DELAY_FAILED_DEPLOY_TICKS = 100;
    private int shipToken_nextUpdate_ticks = 5;
    private static final int SHIP_TOKEN_PLAYER_WARMUP_PERIODS = 5;
    private UUID shipToken_idPlayer = null;
    private int shipToken_countWarmup = 5;
    private String shipToken_nameSchematic = "";

    public TileEntityShipScanner() {
        this.peripheralName = "warpdriveShipScanner";
        this.addMethods(new String[]{"scan", "fileName", "deploy", "state"});
    }

    @Override
    public void func_145845_h() {
        boolean isSetupDone;
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.searchTicks;
        if (this.searchTicks > WarpDriveConfig.SS_SEARCH_INTERVAL_TICKS) {
            this.searchTicks = 0;
            this.shipCore = this.searchShipCore();
        }
        boolean bl = isSetupDone = this.targetX != 0 || this.targetY != 0 || this.targetZ != 0;
        if (isSetupDone) {
            if (this.enumShipScannerState == EnumShipScannerState.IDLE) {
                this.checkPlayerForShipToken();
            }
            if (this.enumShipScannerState != EnumShipScannerState.DEPLOYING) {
                this.setState(EnumShipScannerState.IDLE);
                return;
            }
        } else if (this.enumShipScannerState != EnumShipScannerState.DEPLOYING && this.shipCore == null) {
            ++this.laserTicks;
            if (this.laserTicks > 20) {
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(this).translate(0.5), new Vector3(this.field_145851_c, this.field_145848_d + 5, this.field_145849_e).translate(0.5), 1.0f, 0.2f, 0.0f, 40, 0, 100);
                this.laserTicks = 0;
            }
            return;
        }
        switch (this.enumShipScannerState) {
            case IDLE: {
                if (this.shipCore == null) break;
                ++this.laserTicks;
                if (this.laserTicks <= 20) break;
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(this).translate(0.5), new Vector3(this.shipCore.field_145851_c, this.shipCore.field_145848_d, this.shipCore.field_145849_e).translate(0.5), 0.0f, 1.0f, 0.2f, 40, 0, 100);
                this.laserTicks = 0;
                break;
            }
            case SCANNING: {
                ++this.laserTicks;
                if (this.laserTicks > 5) {
                    this.laserTicks = 0;
                    for (int index = 0; index < 10; ++index) {
                        int randomX = this.shipCore.minX + this.field_145850_b.field_73012_v.nextInt(this.shipCore.maxX - this.shipCore.minX + 1);
                        int randomY = this.shipCore.minY + this.field_145850_b.field_73012_v.nextInt(this.shipCore.maxY - this.shipCore.minY + 1);
                        int randomZ = this.shipCore.minZ + this.field_145850_b.field_73012_v.nextInt(this.shipCore.maxZ - this.shipCore.minZ + 1);
                        this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d, (double)((float)this.field_145849_e + 0.5f), "warpdrive:lowlaser", 4.0f, 1.0f);
                        float r = this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat();
                        float g = this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat();
                        float b = this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat();
                        PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(this).translate(0.5), new Vector3(randomX, randomY, randomZ).translate(0.5), r, g, b, 15, 0, 100);
                    }
                }
                ++this.scanTicks;
                if (this.scanTicks <= 20 * (1 + this.shipCore.shipMass / WarpDriveConfig.SS_SCAN_BLOCKS_PER_SECOND)) break;
                this.setState(EnumShipScannerState.IDLE);
                break;
            }
            case DEPLOYING: {
                if (this.deployTicks == 0) {
                    DeploySequencer sequencer = new DeploySequencer(this.jumpShip, this.func_145831_w(), this.isShipToken, this.targetX, this.targetY, this.targetZ, this.rotationSteps);
                    int optimumSpeed = Math.round((float)(this.blocksToDeployCount * WarpDriveConfig.SS_DEPLOY_INTERVAL_TICKS) / 200.0f);
                    int blockToDeployPerTick = Math.max(WarpDriveConfig.SS_DEPLOY_BLOCKS_PER_INTERVAL, Math.min(WarpDriveConfig.G_BLOCKS_PER_TICK / 4, optimumSpeed));
                    if (WarpDrive.isDev && WarpDriveConfig.LOGGING_BUILDING) {
                        WarpDrive.logger.info("optimumSpeed " + optimumSpeed + " blockToDeployPerTick " + blockToDeployPerTick);
                    }
                    sequencer.setBlocksPerTick(blockToDeployPerTick);
                    sequencer.setCaptain(this.playerName);
                    sequencer.setEffectSource(new Vector3(this).translate(0.5));
                    sequencer.setCallback(this);
                    sequencer.enable();
                }
                ++this.deployTicks;
                if (!((float)this.deployTicks > 1200.0f)) break;
                WarpDrive.logger.info(this + " Deployment timeout?");
                this.deployTicks = 0;
                this.setState(EnumShipScannerState.IDLE);
                this.shipToken_nextUpdate_ticks = 60;
                break;
            }
            default: {
                WarpDrive.logger.error("Invalid ship scanner state, forcing to IDLE...");
                this.setState(EnumShipScannerState.IDLE);
            }
        }
    }

    private void setState(EnumShipScannerState newState) {
        if (this.enumShipScannerState == newState) {
            return;
        }
        this.enumShipScannerState = newState;
        if (this.blockCamouflage == null) {
            if (this.func_145832_p() == newState.getMetadata()) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, newState.getMetadata(), 2);
            }
        } else if (this.func_145832_p() != this.metadataCamouflage) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.metadataCamouflage, 2);
        }
    }

    @Override
    public void sequencer_finished() {
        switch (this.enumShipScannerState) {
            case DEPLOYING: {
                this.setState(EnumShipScannerState.IDLE);
                if (WarpDriveConfig.LOGGING_BUILDING) {
                    WarpDrive.logger.info(this + " Deployment done");
                }
                this.shipToken_nextUpdate_ticks = 60;
                break;
            }
            default: {
                WarpDrive.logger.error(this + " Invalid ship scanner state, forcing to IDLE...");
                this.setState(EnumShipScannerState.IDLE);
            }
        }
    }

    private TileEntityShipCore searchShipCore() {
        StringBuilder reason = new StringBuilder();
        TileEntityShipCore tileEntityShipCore = null;
        for (int newY = this.field_145848_d + 1; newY <= 255; ++newY) {
            if (!this.field_145850_b.func_147439_a(this.field_145851_c, newY, this.field_145849_e).func_149667_c(WarpDrive.blockShipCore)) continue;
            tileEntityShipCore = (TileEntityShipCore)this.field_145850_b.func_147438_o(this.field_145851_c, newY, this.field_145849_e);
            if (tileEntityShipCore == null || tileEntityShipCore.validateShipSpatialParameters(reason)) break;
            tileEntityShipCore = null;
            break;
        }
        return tileEntityShipCore;
    }

    private boolean saveShipToSchematic(String fileName, StringBuilder reason) {
        if (!this.shipCore.validateShipSpatialParameters(reason)) {
            return false;
        }
        int width = this.shipCore.maxX - this.shipCore.minX + 1;
        int length = this.shipCore.maxZ - this.shipCore.minZ + 1;
        int height = this.shipCore.maxY - this.shipCore.minY + 1;
        int size = width * length * height;
        if (width <= 0 || length <= 0 || height <= 0) {
            reason.append("Invalid ship dimensions, nothing to scan");
            return false;
        }
        NBTTagCompound schematic = new NBTTagCompound();
        schematic.func_74777_a("Width", (short)width);
        schematic.func_74777_a("Length", (short)length);
        schematic.func_74777_a("Height", (short)height);
        schematic.func_74768_a("shipMass", this.shipCore.shipMass);
        schematic.func_74778_a("shipName", this.shipCore.shipName);
        schematic.func_74768_a("shipVolume", this.shipCore.shipVolume);
        JumpShip ship = new JumpShip();
        ship.worldObj = this.shipCore.func_145831_w();
        ship.coreX = this.shipCore.field_145851_c;
        ship.coreY = this.shipCore.field_145848_d;
        ship.coreZ = this.shipCore.field_145849_e;
        ship.dx = this.shipCore.facing.offsetX;
        ship.dz = this.shipCore.facing.offsetZ;
        ship.minX = this.shipCore.minX;
        ship.maxX = this.shipCore.maxX;
        ship.minY = this.shipCore.minY;
        ship.maxY = this.shipCore.maxY;
        ship.minZ = this.shipCore.minZ;
        ship.maxZ = this.shipCore.maxZ;
        ship.shipCore = this.shipCore;
        if (!ship.save(reason)) {
            return false;
        }
        NBTTagCompound tagCompoundShip = new NBTTagCompound();
        ship.writeToNBT(tagCompoundShip);
        schematic.func_74782_a("ship", (NBTBase)tagCompoundShip);
        String[] stringBlockRegistryNames = new String[size];
        byte[] byteMetadatas = new byte[size];
        NBTTagList tileEntitiesList = new NBTTagList();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    TileEntity tileEntity;
                    Block block = this.field_145850_b.func_147439_a(this.shipCore.minX + x, this.shipCore.minY + y, this.shipCore.minZ + z);
                    if (Dictionary.BLOCKS_LEFTBEHIND.contains(block) || Dictionary.BLOCKS_ANCHOR.contains(block)) {
                        block = Blocks.field_150350_a;
                    }
                    int index = x + (y * length + z) * width;
                    stringBlockRegistryNames[index] = Block.field_149771_c.func_148750_c((Object)block);
                    byteMetadatas[index] = (byte)this.field_145850_b.func_72805_g(this.shipCore.minX + x, this.shipCore.minY + y, this.shipCore.minZ + z);
                    if (block.func_149667_c(Blocks.field_150350_a) || (tileEntity = this.field_145850_b.func_147438_o(this.shipCore.minX + x, this.shipCore.minY + y, this.shipCore.minZ + z)) == null) continue;
                    try {
                        NBTTagCompound tagTileEntity = new NBTTagCompound();
                        tileEntity.func_145841_b(tagTileEntity);
                        JumpBlock.removeUniqueIDs(tagTileEntity);
                        tagTileEntity.func_74768_a("x", tileEntity.field_145851_c - this.shipCore.minX);
                        tagTileEntity.func_74768_a("y", tileEntity.field_145848_d - this.shipCore.minY);
                        tagTileEntity.func_74768_a("z", tileEntity.field_145849_e - this.shipCore.minZ);
                        tileEntitiesList.func_74742_a((NBTBase)tagTileEntity);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        schematic.func_74778_a("Materials", "Alpha");
        NBTTagList tagListBlocks = new NBTTagList();
        for (String stringRegistryName : stringBlockRegistryNames) {
            tagListBlocks.func_74742_a((NBTBase)new NBTTagString(stringRegistryName));
        }
        schematic.func_74782_a("Blocks", (NBTBase)tagListBlocks);
        schematic.func_74773_a("Data", byteMetadatas);
        schematic.func_74782_a("Entities", (NBTBase)new NBTTagList());
        schematic.func_74782_a("TileEntities", (NBTBase)tileEntitiesList);
        Commons.writeNBTToFile(fileName, schematic);
        return true;
    }

    private boolean scanShip(StringBuilder reason) {
        this.setState(EnumShipScannerState.SCANNING);
        File file = new File(WarpDriveConfig.G_SCHEMALOCATION);
        if (!(file.exists() && file.isDirectory() || file.mkdirs())) {
            return false;
        }
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd_HH'h'mm'm'ss's'SSS");
        String shipName = this.shipCore.shipName.replaceAll("[^ -~]", "").replaceAll("[:/\\\\]", "");
        do {
            Date now = new Date();
            this.schematicFileName = shipName + "_" + sdfDate.format(now);
        } while (new File(WarpDriveConfig.G_SCHEMALOCATION + "/" + this.schematicFileName + ".schematic").exists());
        if (!this.saveShipToSchematic(WarpDriveConfig.G_SCHEMALOCATION + "/" + this.schematicFileName + ".schematic", reason)) {
            return false;
        }
        reason.append(this.schematicFileName);
        return true;
    }

    private int deployShip(String fileName, int offsetX, int offsetY, int offsetZ, byte rotationSteps, boolean isForced, StringBuilder reason) {
        double dZ;
        double dY;
        double dX;
        double distance;
        this.targetX = this.field_145851_c + offsetX;
        this.targetY = this.field_145848_d + offsetY;
        this.targetZ = this.field_145849_e + offsetZ;
        this.rotationSteps = rotationSteps;
        this.jumpShip = JumpShip.createFromFile(fileName, reason);
        if (this.jumpShip == null) {
            return -1;
        }
        this.blocksToDeployCount = this.jumpShip.jumpBlocks.length;
        if (WarpDriveConfig.LOGGING_BUILDING) {
            WarpDrive.logger.info(String.format("[ShipScanner] Loaded %d blocks to deploy", this.blocksToDeployCount));
        }
        if ((distance = (double)MathHelper.func_76133_a((double)((dX = (double)(this.field_145851_c - this.targetX)) * dX + (dY = (double)(this.field_145848_d - this.targetY)) * dY + (dZ = (double)(this.field_145849_e - this.targetZ)) * dZ))) > (double)WarpDriveConfig.SS_MAX_DEPLOY_RADIUS_BLOCKS) {
            reason.append(String.format("\u00c2\u00a7cCannot deploy ship more than %d blocks away from scanner.", WarpDriveConfig.SS_MAX_DEPLOY_RADIUS_BLOCKS));
            return 5;
        }
        Transformation transformation = new Transformation(this.jumpShip, this.field_145850_b, this.targetX - this.jumpShip.coreX, this.targetY - this.jumpShip.coreY, this.targetZ - this.jumpShip.coreZ, rotationSteps);
        ChunkCoordinates targetLocation1 = transformation.apply(this.jumpShip.minX, this.jumpShip.minY, this.jumpShip.minZ);
        ChunkCoordinates targetLocation2 = transformation.apply(this.jumpShip.maxX, this.jumpShip.maxY, this.jumpShip.maxZ);
        ChunkCoordinates targetLocationMin = new ChunkCoordinates(Math.min(targetLocation1.field_71574_a, targetLocation2.field_71574_a) - 1, Math.max(0, Math.min(targetLocation1.field_71572_b, targetLocation2.field_71572_b) - 1), Math.min(targetLocation1.field_71573_c, targetLocation2.field_71573_c) - 1);
        ChunkCoordinates targetLocationMax = new ChunkCoordinates(Math.max(targetLocation1.field_71574_a, targetLocation2.field_71574_a) + 1, Math.min(255, Math.max(targetLocation1.field_71572_b, targetLocation2.field_71572_b) + 1), Math.max(targetLocation1.field_71573_c, targetLocation2.field_71573_c) + 1);
        if (isForced) {
            if (!TileEntityShipScanner.isShipCoreClear(this.field_145850_b, this.targetX, this.targetY, this.targetZ, this.playerName, reason)) {
                if (WarpDriveConfig.LOGGING_BUILDING) {
                    WarpDrive.logger.info(String.format("Deployment collision detected at (%d %d %d)", this.targetX, this.targetY, this.targetZ));
                }
                return 2;
            }
            for (int x = targetLocationMin.field_71574_a; x <= targetLocationMax.field_71574_a; ++x) {
                for (int y = targetLocationMin.field_71572_b; y <= targetLocationMax.field_71572_b; ++y) {
                    for (int z = targetLocationMin.field_71573_c; z <= targetLocationMax.field_71573_c; ++z) {
                        this.field_145850_b.func_147468_f(x, y, z);
                    }
                }
            }
        } else {
            int occupiedBlockCount = 0;
            for (int x = targetLocationMin.field_71574_a; x <= targetLocationMax.field_71574_a; ++x) {
                for (int y = targetLocationMin.field_71572_b; y <= targetLocationMax.field_71572_b; ++y) {
                    for (int z = targetLocationMin.field_71573_c; z <= targetLocationMax.field_71573_c; ++z) {
                        if (this.field_145850_b.func_147437_c(x, y, z)) continue;
                        if (++occupiedBlockCount == 1 || occupiedBlockCount <= 100 && this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                            this.field_145850_b.func_72885_a(null, (double)x, (double)y, (double)z, 1.0f, false, false);
                        }
                        if (!WarpDriveConfig.LOGGING_BUILDING) continue;
                        WarpDrive.logger.info("Deployment collision detected at " + x + " " + y + " " + z);
                    }
                }
            }
            if (occupiedBlockCount > 0) {
                reason.append(String.format("\u00c2\u00a7cDeployment area occupied with %d blocks. Can't deploy ship.", occupiedBlockCount));
                return 2;
            }
        }
        this.deployTicks = 0;
        this.isShipToken = isForced;
        this.setState(EnumShipScannerState.DEPLOYING);
        reason.append(String.format("Deploying ship '%s'...", fileName));
        return 3;
    }

    private static boolean isShipCoreClear(World world, int x, int y, int z, String nameRequestingPlayer, StringBuilder reason) {
        Block block = world.func_147439_a(x, y, z);
        if (block.isAir((IBlockAccess)world, x, y, z)) {
            return true;
        }
        if (!(block instanceof BlockShipCore)) {
            world.func_72885_a(null, (double)x, (double)y, (double)z, 1.0f, false, false);
            reason.append(String.format("\u00c2\u00a7cDeployment area occupied by %s.\nCan't deploy new ship at (%d %d %d)", block.func_149732_F(), x, y, z));
            return false;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TileEntityShipCore)) {
            reason.append(String.format("\u00c2\u00a7cDeployment area occupied with invalid tile entity %s for ship core.\nContact an admin for help at (%d %d %d)", tileEntity, x, y, z));
            WarpDrive.logger.error(reason.toString());
            world.func_72885_a(null, (double)x, (double)y, (double)z, 1.0f, false, false);
            return false;
        }
        TileEntityShipCore tileEntityShipCore = (TileEntityShipCore)tileEntity;
        String namePlayersAboard = tileEntityShipCore.getAllPlayersOnShip();
        if (!namePlayersAboard.isEmpty()) {
            reason.append(String.format("\u00c2\u00a7cDeployment area occupied by active crew %s.\n\u00c2\u00a76Please wait or use another deployment spot", namePlayersAboard));
            return false;
        }
        if (tileEntityShipCore.isBooting()) {
            reason.append("\u00c2\u00a7cDeployment area is busy.\n\u00c2\u00a76Please try again in a few seconds.");
            return false;
        }
        String nameOnlineCrew = tileEntityShipCore.getFirstOnlineCrew();
        if (nameOnlineCrew == null || nameOnlineCrew.isEmpty()) {
            return true;
        }
        if (nameOnlineCrew.equals(nameRequestingPlayer)) {
            reason.append(String.format("\u00c2\u00a7cDeployment area occupied by your ship, captain %s!\n\u00c2\u00a72Come back inside and use the computer to jump away!", nameOnlineCrew));
            return false;
        }
        reason.append(String.format("\u00c2\u00a7cDeployment area occupied with ship owned by %s.\n\u00c2\u00a76Contact that player or use another deployment spot", nameOnlineCrew));
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.schematicFileName = tagCompound.func_74779_i("schematic");
        this.targetX = tagCompound.func_74762_e("targetX");
        this.targetY = tagCompound.func_74762_e("targetY");
        this.targetZ = tagCompound.func_74762_e("targetZ");
        this.rotationSteps = tagCompound.func_74771_c("rotationSteps");
        if (tagCompound.func_74764_b("camouflageBlock")) {
            try {
                this.blockCamouflage = Block.func_149684_b((String)tagCompound.func_74779_i("camouflageBlock"));
                this.metadataCamouflage = tagCompound.func_74771_c("camouflageMeta");
                this.colorMultiplierCamouflage = tagCompound.func_74762_e("camouflageColorMultiplier");
                this.lightCamouflage = tagCompound.func_74771_c("camouflageLight");
                if (Dictionary.BLOCKS_NOCAMOUFLAGE.contains(this.blockCamouflage)) {
                    this.blockCamouflage = null;
                    this.metadataCamouflage = 0;
                    this.colorMultiplierCamouflage = 0;
                    this.lightCamouflage = 0;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.blockCamouflage = null;
            this.metadataCamouflage = 0;
            this.colorMultiplierCamouflage = 0;
            this.lightCamouflage = 0;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74778_a("schematic", this.schematicFileName);
        tagCompound.func_74768_a("targetX", this.targetX);
        tagCompound.func_74768_a("targetY", this.targetY);
        tagCompound.func_74768_a("targetZ", this.targetZ);
        tagCompound.func_74774_a("rotationSteps", this.rotationSteps);
        if (this.blockCamouflage != null) {
            tagCompound.func_74778_a("camouflageBlock", Block.field_149771_c.func_148750_c((Object)this.blockCamouflage));
            tagCompound.func_74774_a("camouflageMeta", (byte)this.metadataCamouflage);
            tagCompound.func_74768_a("camouflageColorMultiplier", this.colorMultiplierCamouflage);
            tagCompound.func_74774_a("camouflageLight", (byte)this.lightCamouflage);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -1, tagCompound);
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tagCompound = packet.func_148857_g();
        this.func_145839_a(tagCompound);
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] scan(Context context, Arguments arguments) {
        return this.scan();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] filename(Context context, Arguments arguments) {
        return this.filename();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] deploy(Context context, Arguments arguments) {
        return this.deploy(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] state(Context context, Arguments arguments) {
        return this.state();
    }

    private Object[] scan() {
        if (this.enumShipScannerState != EnumShipScannerState.IDLE) {
            return new Object[]{false, 0, "Already active"};
        }
        if (this.shipCore == null) {
            return new Object[]{false, 1, "Ship-Core not found"};
        }
        StringBuilder reason = new StringBuilder();
        boolean success = this.scanShip(reason);
        return new Object[]{success, 3, reason.toString()};
    }

    private Object[] filename() {
        if (this.enumShipScannerState != EnumShipScannerState.IDLE && !this.schematicFileName.isEmpty()) {
            if (this.enumShipScannerState == EnumShipScannerState.DEPLOYING) {
                return new Object[]{false, "Deployment in progress. Please wait..."};
            }
            return new Object[]{false, "Scan in progress. Please wait..."};
        }
        return new Object[]{true, this.schematicFileName};
    }

    private Object[] deploy(Object[] arguments) {
        if (arguments.length != 5) {
            return new Object[]{4, "Invalid arguments count, you need <.schematic file name>, <offsetX>, <offsetY>, <offsetZ>, <rotationSteps>!"};
        }
        String fileName = (String)arguments[0];
        int x = Commons.toInt(arguments[1]);
        int y = Commons.toInt(arguments[2]);
        int z = Commons.toInt(arguments[3]);
        byte rotationSteps = (byte)Commons.toInt(arguments[4]);
        if (!new File(WarpDriveConfig.G_SCHEMALOCATION + "/" + fileName + ".schematic").exists()) {
            return new Object[]{0, "Specified schematic file was not found!"};
        }
        StringBuilder reason = new StringBuilder();
        int result = this.deployShip(fileName, x, y, z, rotationSteps, false, reason);
        this.playerName = null;
        return new Object[]{result, reason.toString()};
    }

    private Object[] state() {
        switch (this.enumShipScannerState) {
            default: {
                return new Object[]{false, "IDLE", 0, 0};
            }
            case SCANNING: {
                return new Object[]{true, "Scanning", 0, 0};
            }
            case DEPLOYING: 
        }
        return new Object[]{true, "Deploying", 0, this.blocksToDeployCount};
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName;
        switch (methodName = this.getMethodName(method)) {
            case "scan": {
                return this.scan();
            }
            case "fileName": {
                return this.filename();
            }
            case "deploy": {
                return this.deploy(arguments);
            }
            case "state": {
                return this.state();
            }
        }
        return super.callMethod(computer, context, method, arguments);
    }

    private void checkPlayerForShipToken() {
        int slotIndex;
        --this.shipToken_nextUpdate_ticks;
        if (this.shipToken_nextUpdate_ticks > 0) {
            return;
        }
        this.shipToken_nextUpdate_ticks = 20;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 1.0), (double)((double)this.field_145848_d + 1.0), (double)((double)this.field_145849_e - 1.0), (double)((double)this.field_145851_c + 1.99), (double)((double)this.field_145848_d + 5.0), (double)((double)this.field_145849_e + 1.99));
        List list = this.field_145850_b.func_72839_b(null, axisalignedbb);
        ArrayList<EntityPlayer> entityPlayers = new ArrayList<EntityPlayer>(10);
        for (Object object : list) {
            if (!(object instanceof EntityPlayer)) continue;
            entityPlayers.add((EntityPlayer)object);
        }
        if (entityPlayers.isEmpty()) {
            this.shipToken_idPlayer = null;
            return;
        }
        if (entityPlayers.size() > 1) {
            for (EntityPlayer entityPlayer : entityPlayers) {
                Commons.addChatMessage((ICommandSender)entityPlayer, "\u00c2\u00a7cToo many players detected: please stand in the beam one at a time.");
                this.shipToken_nextUpdate_ticks = 60;
            }
            this.shipToken_idPlayer = null;
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)entityPlayers.get(0);
        ItemStack itemStack = null;
        for (slotIndex = 0; slotIndex < entityPlayer.field_71071_by.func_70302_i_() && ((itemStack = entityPlayer.field_71071_by.func_70301_a(slotIndex)) == null || itemStack.func_77973_b() != WarpDrive.itemShipToken || itemStack.field_77994_a < 1); ++slotIndex) {
        }
        if (itemStack == null || slotIndex >= entityPlayer.field_71071_by.func_70302_i_()) {
            Commons.addChatMessage((ICommandSender)entityPlayer, "Please come back once you've a Ship token.");
            this.shipToken_nextUpdate_ticks = 60;
            this.shipToken_idPlayer = null;
            return;
        }
        if (entityPlayer.func_110124_au() != this.shipToken_idPlayer || !this.shipToken_nameSchematic.equals(ItemShipToken.getSchematicName(itemStack))) {
            this.shipToken_idPlayer = entityPlayer.func_110124_au();
            this.shipToken_countWarmup = 6;
            this.shipToken_nameSchematic = ItemShipToken.getSchematicName(itemStack);
            Commons.addChatMessage((ICommandSender)entityPlayer, "\u00c2\u00a76" + String.format("Ship token '%1$s' detected!", this.shipToken_nameSchematic));
        }
        --this.shipToken_countWarmup;
        if (this.shipToken_countWarmup > 0) {
            Commons.addChatMessage((ICommandSender)entityPlayer, String.format("Stand by for ship materialization in %2$d...", this.shipToken_nameSchematic, this.shipToken_countWarmup));
            return;
        }
        this.shipToken_idPlayer = null;
        this.playerName = entityPlayer.func_70005_c_();
        StringBuilder reason = new StringBuilder();
        this.deployShip(ItemShipToken.getSchematicName(itemStack), this.targetX - this.field_145851_c, this.targetY - this.field_145848_d, this.targetZ - this.field_145849_e, this.rotationSteps, true, reason);
        if (this.enumShipScannerState == EnumShipScannerState.IDLE) {
            Commons.addChatMessage((ICommandSender)entityPlayer, "\u00c2\u00a7c" + reason.toString());
            this.shipToken_nextUpdate_ticks = 100;
            return;
        }
        Commons.addChatMessage((ICommandSender)entityPlayer, "\u00c2\u00a76" + reason.toString());
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            --itemStack.field_77994_a;
            if (itemStack.field_77994_a > 0) {
                entityPlayer.field_71071_by.func_70299_a(slotIndex, itemStack);
            } else {
                entityPlayer.field_71071_by.func_70299_a(slotIndex, null);
            }
            entityPlayer.field_71071_by.func_70296_d();
        }
    }

    @Override
    public String toString() {
        return String.format("%s @ %s (%d %d %d)", this.getClass().getSimpleName(), this.field_145850_b == null ? "~NULL~" : this.field_145850_b.field_73011_w.func_80007_l(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

