/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.collection;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.collection.TileEntityAbstractMiner;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.network.PacketHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLaserTreeFarm
extends TileEntityAbstractMiner {
    private static final int TREE_FARM_WARMUP_DELAY_TICKS = 40;
    private static final int TREE_FARM_SCAN_DELAY_TICKS = 40;
    private static final int TREE_FARM_HARVEST_LOG_DELAY_TICKS = 4;
    private static final int TREE_FARM_BREAK_LEAF_DELAY_TICKS = 4;
    private static final int TREE_FARM_SILKTOUCH_LEAF_DELAY_TICKS = 4;
    private static final int TREE_FARM_TAP_TREE_WET_DELAY_TICKS = 4;
    private static final int TREE_FARM_TAP_TREE_DRY_DELAY_TICKS = 1;
    private static final int TREE_FARM_PLANT_DELAY_TICKS = 1;
    private static final int TREE_FARM_LOW_POWER_DELAY_TICKS = 40;
    private static final int TREE_FARM_ENERGY_PER_SURFACE = 1;
    private static final int TREE_FARM_ENERGY_PER_WET_SPOT = 1;
    private static final double TREE_FARM_ENERGY_PER_LOG = 1.0;
    private static final double TREE_FARM_ENERGY_PER_LEAF = 1.0;
    private static final double TREE_FARM_SILKTOUCH_ENERGY_FACTOR = 2.0;
    private static final int TREE_FARM_ENERGY_PER_SAPLING = 1;
    private int radiusX_requested = WarpDriveConfig.TREE_FARM_totalMaxRadius;
    private int radiusZ_requested = WarpDriveConfig.TREE_FARM_totalMaxRadius;
    private boolean breakLeaves = false;
    private boolean tapTrees = false;
    private static final int STATE_IDLE = 0;
    private static final int STATE_WARMUP = 1;
    private static final int STATE_SCAN = 2;
    private static final int STATE_HARVEST = 3;
    private static final int STATE_TAP = 4;
    private static final int STATE_PLANT = 5;
    private int currentState = 0;
    private int radiusX_actual = this.radiusX_requested;
    private int radiusZ_actual = this.radiusZ_requested;
    private boolean isPowered = false;
    private int delayTargetTicks = 0;
    private int totalHarvested = 0;
    private int delayTicks = 0;
    private LinkedList<VectorI> soils;
    private int soilIndex = 0;
    private ArrayList<VectorI> valuables;
    private int valuableIndex = 0;

    private boolean isFarming() {
        return this.currentState != 0;
    }

    public TileEntityLaserTreeFarm() {
        this.laserOutputSide = ForgeDirection.UP;
        this.peripheralName = "warpdriveLaserTreeFarm";
        this.addMethods(new String[]{"start", "stop", "radius", "state", "breakLeaves", "silktouch", "tapTrees"});
        this.laserMedium_maxCount = WarpDriveConfig.TREE_FARM_MAX_MEDIUMS_COUNT;
        this.CC_scripts = Arrays.asList("farm", "stop");
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        if (this.currentState == 3 || this.currentState == 4 || this.currentState == 5) {
            this.updateParameters();
            this.soils = this.scanSoils();
            this.valuables = new ArrayList<VectorI>(this.scanTrees());
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.currentState == 0) {
            this.delayTicks = 0;
            this.delayTargetTicks = 40;
            this.updateMetadata(0);
            if (!WarpDriveConfig.isComputerCraftLoaded && !WarpDriveConfig.isOpenComputersLoaded) {
                this.breakLeaves = true;
                this.enableSilktouch = false;
                this.tapTrees = true;
                this.start();
            }
            return;
        }
        ++this.delayTicks;
        this.updateParameters();
        if (this.currentState == 1) {
            this.updateMetadata(3);
            if (this.delayTicks >= this.delayTargetTicks) {
                this.delayTicks = 0;
                this.delayTargetTicks = 40;
                this.currentState = 2;
                this.updateMetadata(3);
                return;
            }
        } else if (this.currentState == 2) {
            int energyCost = 1 * (1 + 2 * this.radiusX_actual) * (1 + 2 * this.radiusZ_actual);
            if (this.delayTicks == 1) {
                Block blockAbove;
                if (WarpDriveConfig.LOGGING_COLLECTION) {
                    WarpDrive.logger.debug("Scan pre-tick");
                }
                if (!(TileEntityLaserTreeFarm.isLog(blockAbove = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) || TileEntityLaserTreeFarm.isLeaf(blockAbove) || blockAbove.isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e))) {
                    PacketHandler.sendSpawnParticlePacket(this.field_145850_b, "jammed", (byte)5, new Vector3(this).translate(0.5), new Vector3(0.0, 0.0, 0.0), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 32);
                    this.currentState = 1;
                    this.delayTicks = 0;
                    this.delayTargetTicks = 40;
                    this.updateMetadata(3);
                    return;
                }
                this.isPowered = this.laserMedium_consumeExactly(energyCost, true);
                if (!this.isPowered) {
                    this.currentState = 1;
                    this.delayTicks = 0;
                    this.delayTargetTicks = 40;
                    this.updateMetadata(3);
                    return;
                }
                this.updateMetadata(4);
                int age = Math.max(40, 80);
                double xMax = (double)(this.field_145851_c + this.radiusX_actual) + 1.0;
                double xMin = (double)(this.field_145851_c - this.radiusX_actual) + 0.0;
                double zMax = (double)(this.field_145849_e + this.radiusZ_actual) + 1.0;
                double zMin = (double)(this.field_145849_e - this.radiusZ_actual) + 0.0;
                double y = this.field_145848_d + this.field_145850_b.field_73012_v.nextInt(9);
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(xMin, y, zMin), new Vector3(xMax, y, zMin), 0.3f, 0.0f, 1.0f, age, 0, 50);
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(xMax, y, zMin), new Vector3(xMax, y, zMax), 0.3f, 0.0f, 1.0f, age, 0, 50);
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(xMax, y, zMax), new Vector3(xMin, y, zMax), 0.3f, 0.0f, 1.0f, age, 0, 50);
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(xMin, y, zMax), new Vector3(xMin, y, zMin), 0.3f, 0.0f, 1.0f, age, 0, 50);
            } else if (this.delayTicks >= this.delayTargetTicks) {
                if (WarpDriveConfig.LOGGING_COLLECTION) {
                    WarpDrive.logger.debug("Scan tick");
                }
                this.delayTicks = 0;
                this.isPowered = this.laserMedium_consumeExactly(energyCost, false);
                if (!this.isPowered) {
                    this.delayTargetTicks = 40;
                    this.updateMetadata(3);
                    return;
                }
                this.delayTargetTicks = 40;
                this.updateMetadata(4);
                this.soils = this.scanSoils();
                this.soilIndex = 0;
                this.valuables = new ArrayList<VectorI>(this.scanTrees());
                this.valuableIndex = 0;
                if (!this.valuables.isEmpty()) {
                    this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d, (double)((float)this.field_145849_e + 0.5f), "warpdrive:hilaser", 4.0f, 1.0f);
                    this.currentState = this.tapTrees ? 4 : 3;
                    this.delayTargetTicks = 4;
                    this.updateMetadata(2);
                    return;
                }
                if (this.soils != null && !this.soils.isEmpty()) {
                    this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d, (double)((float)this.field_145849_e + 0.5f), "warpdrive:hilaser", 4.0f, 1.0f);
                    this.currentState = 5;
                    this.delayTargetTicks = 1;
                    this.updateMetadata(6);
                    return;
                }
                this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d, (double)((float)this.field_145849_e + 0.5f), "warpdrive:lowlaser", 4.0f, 1.0f);
                this.currentState = 1;
                this.delayTargetTicks = 40;
                this.updateMetadata(3);
            }
        } else if (this.currentState == 3 || this.currentState == 4) {
            if (this.delayTicks >= this.delayTargetTicks) {
                if (WarpDriveConfig.LOGGING_COLLECTION) {
                    WarpDrive.logger.debug("Harvest/tap tick");
                }
                this.delayTicks = 0;
                if (this.valuables == null || this.valuableIndex >= this.valuables.size()) {
                    this.valuableIndex = 0;
                    this.currentState = 5;
                    this.delayTargetTicks = 1;
                    this.updateMetadata(6);
                    return;
                }
                VectorI valuable = this.valuables.get(this.valuableIndex);
                Block block = this.field_145850_b.func_147439_a(valuable.x, valuable.y, valuable.z);
                ++this.valuableIndex;
                boolean isLog = TileEntityLaserTreeFarm.isLog(block);
                boolean isLeaf = TileEntityLaserTreeFarm.isLeaf(block);
                if (this.isBlockBreakCanceled(null, this.field_145850_b, valuable.x, valuable.y, valuable.z)) {
                    if (WarpDriveConfig.LOGGING_COLLECTION) {
                        WarpDrive.logger.info(this + " Harvesting cancelled at (" + valuable.x + " " + valuable.y + " " + valuable.z + ")");
                    }
                    return;
                }
                if (this.currentState == 4 && block.func_149667_c(WarpDriveConfig.IC2_rubberWood)) {
                    int metadata = this.field_145850_b.func_72805_g(valuable.x, valuable.y, valuable.z);
                    if (metadata >= 2 && metadata <= 5) {
                        if (WarpDriveConfig.LOGGING_COLLECTION) {
                            WarpDrive.logger.info("Tap found rubber wood wet-spot at " + valuable + " with metadata " + metadata);
                        }
                        boolean energyCost = true;
                        this.isPowered = this.laserMedium_consumeExactly(1, false);
                        if (!this.isPowered) {
                            this.delayTargetTicks = 40;
                            this.updateMetadata(1);
                            return;
                        }
                        this.delayTargetTicks = 4;
                        this.updateMetadata(2);
                        ItemStack resin = WarpDriveConfig.IC2_Resin.func_77946_l();
                        resin.field_77994_a = (int)Math.round(Math.random() * 4.0);
                        if (this.addToConnectedInventories(resin)) {
                            this.stop();
                        }
                        this.totalHarvested += resin.field_77994_a;
                        int age = Math.max(10, Math.round((4.0f + this.field_145850_b.field_73012_v.nextFloat()) * 4.0f));
                        PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(valuable.x, valuable.y, valuable.z).translate(0.5), 0.8f, 0.8f, 0.2f, age, 0, 50);
                        this.field_145850_b.func_72921_c(valuable.x, valuable.y, valuable.z, metadata + 6, 3);
                        return;
                    }
                    if (metadata != 0 && metadata != 1) {
                        this.delayTargetTicks = 1;
                        return;
                    }
                }
                if (isLog || this.breakLeaves && isLeaf) {
                    double energyCost;
                    double d = energyCost = isLog ? 1.0 : 1.0;
                    if (this.enableSilktouch) {
                        energyCost *= 2.0;
                    }
                    this.isPowered = this.laserMedium_consumeExactly((int)Math.round(energyCost), false);
                    if (!this.isPowered) {
                        this.delayTargetTicks = 40;
                        this.updateMetadata(1);
                        return;
                    }
                    this.delayTargetTicks = isLog ? 4 : (this.enableSilktouch ? 4 : 4);
                    this.updateMetadata(2);
                    ++this.totalHarvested;
                    int age = Math.max(10, Math.round((4.0f + this.field_145850_b.field_73012_v.nextFloat()) * (float)WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS));
                    PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(valuable.x, valuable.y, valuable.z).translate(0.5), 0.2f, 0.7f, 0.4f, age, 0, 50);
                    this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d, (double)((float)this.field_145849_e + 0.5f), "warpdrive:lowlaser", 4.0f, 1.0f);
                    this.harvestBlock(valuable);
                }
            }
        } else if (this.currentState == 5 && this.delayTicks >= this.delayTargetTicks) {
            if (WarpDriveConfig.LOGGING_COLLECTION) {
                WarpDrive.logger.debug("Plant final tick");
            }
            this.delayTicks = 0;
            if (this.soils == null || this.soilIndex >= this.soils.size()) {
                this.soilIndex = 0;
                this.currentState = 2;
                this.delayTargetTicks = 40;
                this.updateMetadata(4);
                return;
            }
            VectorI soil = this.soils.get(this.soilIndex);
            Block block = this.field_145850_b.func_147439_a(soil.x, soil.y, soil.z);
            ++this.soilIndex;
            Collection<IInventory> inventories = Commons.getConnectedInventories(this);
            if (inventories == null || inventories.isEmpty()) {
                this.currentState = 1;
                this.delayTargetTicks = 40;
                this.updateMetadata(3);
                return;
            }
            int slotIndex = 0;
            boolean found = false;
            int plantableCount = 0;
            ItemStack itemStack = null;
            Block plant = null;
            int plantMetadata = -1;
            IInventory inventory = null;
            for (IInventory inventoryLoop : inventories) {
                if (!found) {
                    slotIndex = 0;
                }
                while (slotIndex < inventoryLoop.func_70302_i_() && !found) {
                    itemStack = inventoryLoop.func_70301_a(slotIndex);
                    if (itemStack == null || itemStack.field_77994_a <= 0) {
                        ++slotIndex;
                        continue;
                    }
                    Block blockFromItem = Block.func_149634_a((Item)itemStack.func_77973_b());
                    if (!(itemStack.func_77973_b() instanceof IPlantable) && !(blockFromItem instanceof IPlantable)) {
                        ++slotIndex;
                        continue;
                    }
                    ++plantableCount;
                    IPlantable plantable = (IPlantable)(itemStack.func_77973_b() instanceof IPlantable ? itemStack.func_77973_b() : blockFromItem);
                    plant = plantable.getPlant((IBlockAccess)this.field_145850_b, soil.x, soil.y + 1, soil.z);
                    plantMetadata = plantable.getPlantMetadata((IBlockAccess)this.field_145850_b, soil.x, soil.y + 1, soil.z);
                    if (plantMetadata == 0 && itemStack.func_77960_j() != 0) {
                        plantMetadata = itemStack.func_77960_j();
                    }
                    if (WarpDriveConfig.LOGGING_COLLECTION) {
                        WarpDrive.logger.info("Slot " + slotIndex + " as " + itemStack + " which plantable " + plantable + " as block " + plant + ":" + plantMetadata);
                    }
                    if (!block.canSustainPlant((IBlockAccess)this.field_145850_b, soil.x, soil.y, soil.z, ForgeDirection.UP, plantable)) {
                        ++slotIndex;
                        continue;
                    }
                    if (!plant.func_149742_c(this.field_145850_b, soil.x, soil.y + 1, soil.z)) {
                        ++slotIndex;
                        continue;
                    }
                    found = true;
                    inventory = inventoryLoop;
                }
            }
            if (plantableCount <= 0) {
                this.currentState = 2;
                this.delayTargetTicks = 40;
                this.updateMetadata(4);
                return;
            }
            if (inventory == null) {
                if (WarpDriveConfig.LOGGING_COLLECTION) {
                    WarpDrive.logger.debug("No sapling found");
                }
                return;
            }
            assert (found);
            if (this.isBlockPlaceCanceled(null, this.field_145850_b, soil.x, soil.y + 1, soil.z, plant, plantMetadata)) {
                if (WarpDriveConfig.LOGGING_COLLECTION) {
                    WarpDrive.logger.info(this + " Planting cancelled at (" + soil.x + " " + (soil.y + 1) + " " + soil.z + ")");
                }
                return;
            }
            boolean energyCost = true;
            this.isPowered = this.laserMedium_consumeExactly(1, false);
            if (!this.isPowered) {
                this.delayTargetTicks = 40;
                this.updateMetadata(5);
                return;
            }
            this.delayTargetTicks = 1;
            this.updateMetadata(6);
            --itemStack.field_77994_a;
            if (itemStack.field_77994_a <= 0) {
                itemStack = null;
            }
            inventory.func_70299_a(slotIndex, itemStack);
            int age = Math.max(10, Math.round((4.0f + this.field_145850_b.field_73012_v.nextFloat()) * (float)WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS));
            PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(soil.x, soil.y + 1, soil.z).translate(0.5), 0.2f, 0.7f, 0.4f, age, 0, 50);
            this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d, (double)((float)this.field_145849_e + 0.5f), "warpdrive:lowlaser", 4.0f, 1.0f);
            this.field_145850_b.func_147465_d(soil.x, soil.y + 1, soil.z, plant, plantMetadata, 3);
        }
    }

    @Override
    protected void stop() {
        super.stop();
        this.currentState = 0;
        this.updateMetadata(0);
    }

    private void updateParameters() {
        int maxScanRadius = WarpDriveConfig.TREE_FARM_MAX_SCAN_RADIUS_NO_LASER_MEDIUM + this.cache_laserMedium_count * WarpDriveConfig.TREE_FARM_MAX_SCAN_RADIUS_PER_LASER_MEDIUM;
        this.radiusX_actual = Math.min(this.radiusX_requested, maxScanRadius);
        this.radiusZ_actual = Math.min(this.radiusZ_requested, maxScanRadius);
    }

    private static boolean isSoil(Block block) {
        return Dictionary.BLOCKS_SOILS.contains(block);
    }

    private static boolean isLog(Block block) {
        return Dictionary.BLOCKS_LOGS.contains(block);
    }

    private static boolean isLeaf(Block block) {
        return Dictionary.BLOCKS_LEAVES.contains(block);
    }

    private LinkedList<VectorI> scanSoils() {
        int xMin = this.field_145851_c - this.radiusX_actual;
        int xMax = this.field_145851_c + this.radiusX_actual;
        int yMin = this.field_145848_d;
        int yMax = this.field_145848_d + 8;
        int zMin = this.field_145849_e - this.radiusZ_actual;
        int zMax = this.field_145849_e + this.radiusZ_actual;
        LinkedList<VectorI> soilPositions = new LinkedList<VectorI>();
        for (int y = yMin; y <= yMax; ++y) {
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    Block block;
                    if (!this.field_145850_b.func_147437_c(x, y + 1, z) || !TileEntityLaserTreeFarm.isSoil(block = this.field_145850_b.func_147439_a(x, y, z))) continue;
                    VectorI pos = new VectorI(x, y, z);
                    if (WarpDriveConfig.LOGGING_COLLECTION) {
                        WarpDrive.logger.info("Found soil at " + x + " " + y + " " + z);
                    }
                    soilPositions.add(pos);
                }
            }
        }
        if (WarpDriveConfig.LOGGING_COLLECTION) {
            WarpDrive.logger.info("Found " + soilPositions.size() + " soils");
        }
        return soilPositions;
    }

    private Collection<VectorI> scanTrees() {
        int xMin = this.field_145851_c - this.radiusX_actual;
        int xMax = this.field_145851_c + this.radiusX_actual;
        int yMin = this.field_145848_d + 1;
        int yMax = this.field_145848_d + 1 + (this.tapTrees ? 8 : 0);
        int zMin = this.field_145849_e - this.radiusZ_actual;
        int zMax = this.field_145849_e + this.radiusZ_actual;
        Set<VectorI> logPositions = new HashSet<VectorI>();
        for (int y = yMin; y <= yMax; ++y) {
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    VectorI pos;
                    Block block = this.field_145850_b.func_147439_a(x, y, z);
                    if (!TileEntityLaserTreeFarm.isLog(block) || logPositions.contains(pos = new VectorI(x, y, z))) continue;
                    if (WarpDriveConfig.LOGGING_COLLECTION) {
                        WarpDrive.logger.info("Found tree base at " + x + "," + y + "," + z);
                    }
                    logPositions.add(pos);
                }
            }
        }
        if (!logPositions.isEmpty()) {
            HashSet whitelist = (HashSet)Dictionary.BLOCKS_LOGS.clone();
            if (this.breakLeaves) {
                whitelist.addAll(Dictionary.BLOCKS_LEAVES);
            }
            int maxLogDistance = WarpDriveConfig.TREE_FARM_MAX_LOG_DISTANCE + this.cache_laserMedium_count * WarpDriveConfig.TREE_FARM_MAX_LOG_DISTANCE_PER_MEDIUM;
            logPositions = Commons.getConnectedBlocks(this.field_145850_b, logPositions, Commons.UP_DIRECTIONS, (Set<Block>)whitelist, maxLogDistance, new VectorI[0]);
        }
        if (WarpDriveConfig.LOGGING_COLLECTION) {
            WarpDrive.logger.info("Found " + logPositions.size() + " valuables");
        }
        return logPositions;
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("radiusX", this.radiusX_requested);
        tagCompound.func_74768_a("radiusZ", this.radiusZ_requested);
        tagCompound.func_74757_a("breakLeaves", this.breakLeaves);
        tagCompound.func_74757_a("tapTrees", this.tapTrees);
        tagCompound.func_74768_a("currentState", this.currentState);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.radiusX_requested = tagCompound.func_74762_e("radiusX");
        this.radiusX_requested = Commons.clamp(1, WarpDriveConfig.TREE_FARM_totalMaxRadius, this.radiusX_requested);
        this.radiusZ_requested = tagCompound.func_74762_e("radiusZ");
        this.radiusZ_requested = Commons.clamp(1, WarpDriveConfig.TREE_FARM_totalMaxRadius, this.radiusZ_requested);
        this.breakLeaves = tagCompound.func_74767_n("breakLeaves");
        this.tapTrees = tagCompound.func_74767_n("tapTrees");
        this.currentState = tagCompound.func_74762_e("currentState");
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] start(Context context, Arguments arguments) {
        return this.start();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] stop(Context context, Arguments arguments) {
        this.stop();
        return null;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] state(Context context, Arguments arguments) {
        return this.state();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] radius(Context context, Arguments arguments) {
        return this.radius(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] breakLeaves(Context context, Arguments arguments) {
        return this.breakLeaves(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] silktouch(Context context, Arguments arguments) {
        return this.silktouch(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] tapTrees(Context context, Arguments arguments) {
        return this.tapTrees(this.argumentsOCtoCC(arguments));
    }

    private Object[] start() {
        if (this.isFarming()) {
            return new Object[]{false, "Already started"};
        }
        this.totalHarvested = 0;
        this.delayTicks = 0;
        this.currentState = 1;
        return new Boolean[]{true};
    }

    private Object[] state() {
        int energy = this.laserMedium_getEnergyStored();
        String status = this.getStatusHeaderInPureText();
        if (this.isFarming() && this.valuables != null) {
            Integer retValuables = this.valuables.size();
            Integer retValuablesIndex = this.valuableIndex;
            return new Object[]{status, this.isFarming(), energy, this.totalHarvested, retValuablesIndex, retValuables};
        }
        return new Object[]{status, this.isFarming(), energy, this.totalHarvested, 0, 0};
    }

    private Object[] radius(Object[] arguments) {
        try {
            if (arguments.length == 1 && arguments[0] != null) {
                this.radiusZ_requested = this.radiusX_requested = Commons.clamp(1, WarpDriveConfig.TREE_FARM_totalMaxRadius, Commons.toInt(arguments[0]));
                this.func_70296_d();
            } else if (arguments.length == 2) {
                this.radiusX_requested = Commons.clamp(1, WarpDriveConfig.TREE_FARM_totalMaxRadius, Commons.toInt(arguments[0]));
                this.radiusZ_requested = Commons.clamp(1, WarpDriveConfig.TREE_FARM_totalMaxRadius, Commons.toInt(arguments[1]));
                this.func_70296_d();
            }
        }
        catch (NumberFormatException exception) {
            this.radiusX_requested = WarpDriveConfig.TREE_FARM_MAX_SCAN_RADIUS_NO_LASER_MEDIUM;
            this.radiusZ_requested = WarpDriveConfig.TREE_FARM_MAX_SCAN_RADIUS_NO_LASER_MEDIUM;
        }
        return new Integer[]{this.radiusX_requested, this.radiusZ_requested};
    }

    private Object[] breakLeaves(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            try {
                this.breakLeaves = Commons.toBool(arguments[0]);
                this.func_70296_d();
            }
            catch (Exception exception) {
                return new Object[]{this.breakLeaves};
            }
        }
        return new Object[]{this.breakLeaves};
    }

    private Object[] silktouch(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            try {
                this.enableSilktouch = Commons.toBool(arguments[0]);
                this.func_70296_d();
            }
            catch (Exception exception) {
                return new Object[]{this.enableSilktouch};
            }
        }
        return new Object[]{this.enableSilktouch};
    }

    private Object[] tapTrees(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            try {
                this.tapTrees = Commons.toBool(arguments[0]);
                this.func_70296_d();
            }
            catch (Exception exception) {
                return new Object[]{this.tapTrees};
            }
        }
        return new Object[]{this.tapTrees};
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName;
        switch (methodName = this.getMethodName(method)) {
            case "start": {
                return this.start();
            }
            case "stop": {
                this.stop();
                return null;
            }
            case "state": {
                return this.state();
            }
            case "radius": {
                return this.radius(arguments);
            }
            case "breakLeaves": {
                return this.breakLeaves(arguments);
            }
            case "silktouch": {
                return this.silktouch(arguments);
            }
            case "tapTrees": {
                return this.tapTrees(arguments);
            }
        }
        return super.callMethod(computer, context, method, arguments);
    }

    @Override
    public String getStatusHeader() {
        int energy = this.laserMedium_getEnergyStored();
        String state = "IDLE (not farming)";
        if (this.currentState == 0) {
            state = "IDLE (not farming)";
        } else if (this.currentState == 1) {
            state = "Warming up...";
        } else if (this.currentState == 2) {
            state = this.breakLeaves ? "Scanning all" : "Scanning logs";
        } else if (this.currentState == 3) {
            state = this.breakLeaves ? "Harvesting all" : "Harvesting logs";
            if (this.enableSilktouch) {
                state = state + " with silktouch";
            }
        } else if (this.currentState == 4) {
            state = this.breakLeaves ? "Tapping trees, harvesting all" : "Tapping trees, harvesting logs";
            if (this.enableSilktouch) {
                state = state + " with silktouch";
            }
        } else if (this.currentState == 5) {
            state = "Planting trees";
        }
        if (energy <= 0) {
            state = state + " - Out of energy";
        } else if (!(this.currentState != 2 && this.currentState != 3 && this.currentState != 4 || this.isPowered)) {
            state = state + " - Not enough power";
        }
        return state;
    }
}

