/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.collection;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.collection.TileEntityAbstractMiner;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.network.PacketHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import java.util.Arrays;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityMiningLaser
extends TileEntityAbstractMiner {
    private final boolean canSilktouch = WarpDriveConfig.MINING_LASER_SILKTOUCH_DEUTERIUM_L <= 0.0 || FluidRegistry.isFluidRegistered((String)"deuterium");
    private int layerOffset = 1;
    private boolean mineAllBlocks = true;
    private int delayTicks = 0;
    private static final int STATE_IDLE = 0;
    private static final int STATE_WARMUP = 1;
    private static final int STATE_SCANNING = 2;
    private static final int STATE_MINING = 3;
    private int currentState = 0;
    private boolean enoughPower = false;
    private int currentLayer;
    private int radiusCapacity = WarpDriveConfig.MINING_LASER_RADIUS_NO_LASER_MEDIUM;
    private final ArrayList<VectorI> valuablesInLayer = new ArrayList();
    private int valuableIndex = 0;

    private boolean isActive() {
        return this.currentState != 0;
    }

    public TileEntityMiningLaser() {
        this.laserOutputSide = ForgeDirection.DOWN;
        this.peripheralName = "warpdriveMiningLaser";
        this.addMethods(new String[]{"start", "stop", "state", "offset", "onlyOres", "silktouch"});
        this.CC_scripts = Arrays.asList("mine", "stop");
        this.laserMedium_maxCount = WarpDriveConfig.MINING_LASER_MAX_MEDIUMS_COUNT;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.currentState == 0) {
            this.delayTicks = WarpDriveConfig.MINING_LASER_WARMUP_DELAY_TICKS;
            this.updateMetadata(0);
            if (!WarpDriveConfig.isComputerCraftLoaded && !WarpDriveConfig.isOpenComputersLoaded) {
                this.enableSilktouch = false;
                this.layerOffset = 1;
                this.mineAllBlocks = true;
                this.start();
            }
            return;
        }
        boolean isOnPlanet = CelestialObjectManager.hasAtmosphere(this.field_145850_b, this.field_145851_c, this.field_145849_e);
        this.radiusCapacity = WarpDriveConfig.MINING_LASER_RADIUS_NO_LASER_MEDIUM + this.cache_laserMedium_count * WarpDriveConfig.MINING_LASER_RADIUS_PER_LASER_MEDIUM;
        --this.delayTicks;
        if (this.currentState == 1) {
            this.updateMetadata(3);
            if (this.delayTicks < 0) {
                this.delayTicks = WarpDriveConfig.MINING_LASER_SCAN_DELAY_TICKS;
                this.currentState = 2;
                this.updateMetadata(3);
                return;
            }
        } else if (this.currentState == 2) {
            if (this.delayTicks == WarpDriveConfig.MINING_LASER_SCAN_DELAY_TICKS - 1) {
                this.enoughPower = this.laserMedium_consumeExactly(isOnPlanet ? WarpDriveConfig.MINING_LASER_PLANET_ENERGY_PER_LAYER : WarpDriveConfig.MINING_LASER_SPACE_ENERGY_PER_LAYER, true);
                if (!this.enoughPower) {
                    this.updateMetadata(3);
                    this.delayTicks = WarpDriveConfig.MINING_LASER_WARMUP_DELAY_TICKS;
                    return;
                }
                this.updateMetadata(4);
                int age = Math.max(40, 5 * WarpDriveConfig.MINING_LASER_SCAN_DELAY_TICKS);
                double xMax = (double)(this.field_145851_c + this.radiusCapacity) + 1.0;
                double xMin = (double)(this.field_145851_c - this.radiusCapacity) + 0.0;
                double zMax = (double)(this.field_145849_e + this.radiusCapacity) + 1.0;
                double zMin = (double)(this.field_145849_e - this.radiusCapacity) + 0.0;
                double y = (double)this.currentLayer + 1.0;
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(xMin, y, zMin), new Vector3(xMax, y, zMin), 0.3f, 0.0f, 1.0f, age, 0, 50);
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(xMax, y, zMin), new Vector3(xMax, y, zMax), 0.3f, 0.0f, 1.0f, age, 0, 50);
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(xMax, y, zMax), new Vector3(xMin, y, zMax), 0.3f, 0.0f, 1.0f, age, 0, 50);
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(xMin, y, zMax), new Vector3(xMin, y, zMin), 0.3f, 0.0f, 1.0f, age, 0, 50);
            } else if (this.delayTicks < 0) {
                this.delayTicks = WarpDriveConfig.MINING_LASER_SCAN_DELAY_TICKS;
                if (this.currentLayer <= 0) {
                    this.stop();
                    return;
                }
                this.enoughPower = this.laserMedium_consumeExactly(isOnPlanet ? WarpDriveConfig.MINING_LASER_PLANET_ENERGY_PER_LAYER : WarpDriveConfig.MINING_LASER_SPACE_ENERGY_PER_LAYER, false);
                if (!this.enoughPower) {
                    this.updateMetadata(3);
                    this.delayTicks = WarpDriveConfig.MINING_LASER_WARMUP_DELAY_TICKS;
                    return;
                }
                this.updateMetadata(4);
                this.scanLayer();
                if (!this.valuablesInLayer.isEmpty()) {
                    int r = (int)Math.ceil((double)this.radiusCapacity / 2.0);
                    int offset = (this.field_145848_d - this.currentLayer) % (2 * r);
                    int age = Math.max(20, Math.round(2.5f * (float)WarpDriveConfig.MINING_LASER_SCAN_DELAY_TICKS));
                    double y = (double)this.currentLayer + 1.0;
                    PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(this.field_145851_c - r + offset, y, this.field_145849_e + r).translate(0.3), 0.0f, 0.0f, 1.0f, age, 0, 50);
                    PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(this.field_145851_c + r, y, this.field_145849_e + r - offset).translate(0.3), 0.0f, 0.0f, 1.0f, age, 0, 50);
                    PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(this.field_145851_c + r - offset, y, this.field_145849_e - r).translate(0.3), 0.0f, 0.0f, 1.0f, age, 0, 50);
                    PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(this.field_145851_c - r, y, this.field_145849_e - r + offset).translate(0.3), 0.0f, 0.0f, 1.0f, age, 0, 50);
                    this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d, (double)((float)this.field_145849_e + 0.5f), "warpdrive:hilaser", 4.0f, 1.0f);
                    this.delayTicks = WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS;
                    this.currentState = 3;
                    this.updateMetadata(2);
                    return;
                }
                this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d, (double)((float)this.field_145849_e + 0.5f), "warpdrive:lowlaser", 4.0f, 1.0f);
                --this.currentLayer;
            }
        } else if (this.currentState == 3 && this.delayTicks < 0) {
            int requiredPower;
            this.delayTicks = WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS;
            if (this.valuableIndex < 0 || this.valuableIndex >= this.valuablesInLayer.size()) {
                this.delayTicks = WarpDriveConfig.MINING_LASER_SCAN_DELAY_TICKS;
                this.currentState = 2;
                this.updateMetadata(4);
                this.scanLayer();
                if (this.valuablesInLayer.size() <= 0) {
                    --this.currentLayer;
                }
                return;
            }
            int n = requiredPower = isOnPlanet ? WarpDriveConfig.MINING_LASER_PLANET_ENERGY_PER_BLOCK : WarpDriveConfig.MINING_LASER_SPACE_ENERGY_PER_BLOCK;
            if (!this.mineAllBlocks) {
                requiredPower = (int)((double)requiredPower * WarpDriveConfig.MINING_LASER_ORESONLY_ENERGY_FACTOR);
            }
            if (this.enableSilktouch) {
                requiredPower = (int)((double)requiredPower * WarpDriveConfig.MINING_LASER_SILKTOUCH_ENERGY_FACTOR);
            }
            this.enoughPower = this.laserMedium_consumeExactly(requiredPower, false);
            if (!this.enoughPower) {
                this.updateMetadata(1);
                return;
            }
            this.updateMetadata(2);
            VectorI valuable = this.valuablesInLayer.get(this.valuableIndex);
            ++this.valuableIndex;
            Block block = this.field_145850_b.func_147439_a(valuable.x, valuable.y, valuable.z);
            if (!this.canDig(block, valuable.x, valuable.y, valuable.z)) {
                this.delayTicks = Math.round((float)WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS * 0.2f);
                return;
            }
            int age = Math.max(10, Math.round((4.0f + this.field_145850_b.field_73012_v.nextFloat()) * (float)WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS));
            PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(valuable.x, valuable.y, valuable.z).translate(0.5), 1.0f, 1.0f, 0.0f, age, 0, 50);
            this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d, (double)((float)this.field_145849_e + 0.5f), "warpdrive:lowlaser", 4.0f, 1.0f);
            this.harvestBlock(valuable);
        }
    }

    @Override
    protected void stop() {
        super.stop();
        this.currentState = 0;
        this.updateMetadata(0);
    }

    private boolean canDig(Block block, int x, int y, int z) {
        if (this.field_145850_b.func_147437_c(x, y, z)) {
            return false;
        }
        if (Dictionary.BLOCKS_SKIPMINING.contains(block)) {
            return false;
        }
        if (Dictionary.BLOCKS_STOPMINING.contains(block)) {
            this.stop();
            if (WarpDriveConfig.LOGGING_COLLECTION) {
                WarpDrive.logger.info(this + " Mining stopped by " + block + " at (" + x + " " + y + " " + z + ")");
            }
            return false;
        }
        if (Dictionary.BLOCKS_MINING.contains(block) || Dictionary.BLOCKS_ORES.contains(block)) {
            return true;
        }
        if (this.isBlockBreakCanceled(null, this.field_145850_b, x, y, z)) {
            this.stop();
            if (WarpDriveConfig.LOGGING_COLLECTION) {
                WarpDrive.logger.info(this + " Mining stopped by cancelled event at (" + x + " " + y + " " + z + ")");
            }
            return false;
        }
        if (block.func_149638_a(null) <= Blocks.field_150343_Z.func_149638_a(null)) {
            return true;
        }
        if (WarpDriveConfig.LOGGING_COLLECTION) {
            WarpDrive.logger.info(this + " Rejecting " + block + " at (" + x + " " + y + " " + z + ")");
        }
        return false;
    }

    private void scanLayer() {
        Block block;
        for (int y = this.field_145848_d - 1; y > this.currentLayer; --y) {
            block = this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e);
            if (!Dictionary.BLOCKS_STOPMINING.contains(block)) continue;
            this.stop();
            if (WarpDriveConfig.LOGGING_COLLECTION) {
                WarpDrive.logger.info(this + " Mining stopped by " + block + " at (" + this.field_145851_c + " " + y + " " + this.field_145849_e + ")");
            }
            return;
        }
        this.valuablesInLayer.clear();
        this.valuableIndex = 0;
        int x = this.field_145851_c;
        int z = this.field_145849_e;
        block = this.field_145850_b.func_147439_a(x, this.currentLayer, z);
        if (this.canDig(block, x, this.currentLayer, z) && (this.mineAllBlocks || Dictionary.BLOCKS_ORES.contains(block))) {
            this.valuablesInLayer.add(new VectorI(x, this.currentLayer, z));
        }
        for (int radius = 1; radius <= this.radiusCapacity; ++radius) {
            int xMax = this.field_145851_c + radius;
            int xMin = this.field_145851_c - radius;
            int zMax = this.field_145849_e + radius;
            int zMin = this.field_145849_e - radius;
            z = zMin;
            for (x = this.field_145851_c; x <= xMax; ++x) {
                block = this.field_145850_b.func_147439_a(x, this.currentLayer, z);
                if (!this.canDig(block, x, this.currentLayer, z) || !this.mineAllBlocks && !Dictionary.BLOCKS_ORES.contains(block)) continue;
                this.valuablesInLayer.add(new VectorI(x, this.currentLayer, z));
            }
            x = xMax;
            ++z;
            while (z <= zMax) {
                block = this.field_145850_b.func_147439_a(x, this.currentLayer, z);
                if (this.canDig(block, x, this.currentLayer, z) && (this.mineAllBlocks || Dictionary.BLOCKS_ORES.contains(block))) {
                    this.valuablesInLayer.add(new VectorI(x, this.currentLayer, z));
                }
                ++z;
            }
            --x;
            z = zMax;
            while (x >= xMin) {
                block = this.field_145850_b.func_147439_a(x, this.currentLayer, z);
                if (this.canDig(block, x, this.currentLayer, z) && (this.mineAllBlocks || Dictionary.BLOCKS_ORES.contains(block))) {
                    this.valuablesInLayer.add(new VectorI(x, this.currentLayer, z));
                }
                --x;
            }
            x = xMin;
            --z;
            while (z > zMin) {
                block = this.field_145850_b.func_147439_a(x, this.currentLayer, z);
                if (this.canDig(block, x, this.currentLayer, z) && (this.mineAllBlocks || Dictionary.BLOCKS_ORES.contains(block))) {
                    this.valuablesInLayer.add(new VectorI(x, this.currentLayer, z));
                }
                --z;
            }
            z = zMin;
            for (x = xMin; x < this.field_145851_c; ++x) {
                block = this.field_145850_b.func_147439_a(x, this.currentLayer, z);
                if (!this.canDig(block, x, this.currentLayer, z) || !this.mineAllBlocks && !Dictionary.BLOCKS_ORES.contains(block)) continue;
                this.valuablesInLayer.add(new VectorI(x, this.currentLayer, z));
            }
        }
        if (WarpDriveConfig.LOGGING_COLLECTION) {
            WarpDrive.logger.info(this + " Found " + this.valuablesInLayer.size() + " valuables");
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.layerOffset = tagCompound.func_74762_e("layerOffset");
        this.mineAllBlocks = tagCompound.func_74767_n("mineAllBlocks");
        this.currentState = tagCompound.func_74762_e("currentState");
        this.currentLayer = tagCompound.func_74762_e("currentLayer");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("layerOffset", this.layerOffset);
        tagCompound.func_74757_a("mineAllBlocks", this.mineAllBlocks);
        tagCompound.func_74768_a("currentState", this.currentState);
        tagCompound.func_74768_a("currentLayer", this.currentLayer);
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] start(Context context, Arguments arguments) {
        return this.start();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] stop(Context context, Arguments arguments) {
        this.stop();
        return null;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] state(Context context, Arguments arguments) {
        return this.state();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] offset(Context context, Arguments arguments) {
        return this.offset(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] onlyOres(Context context, Arguments arguments) {
        return this.onlyOres(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] silktouch(Context context, Arguments arguments) {
        return this.silktouch(this.argumentsOCtoCC(arguments));
    }

    private Object[] start() {
        if (this.isActive()) {
            return new Object[]{false, "Already started"};
        }
        this.enableSilktouch &= this.canSilktouch;
        this.delayTicks = WarpDriveConfig.MINING_LASER_WARMUP_DELAY_TICKS;
        this.currentState = 1;
        this.currentLayer = this.field_145848_d - this.layerOffset - 1;
        if (WarpDriveConfig.LOGGING_LUA) {
            WarpDrive.logger.info(this + " Starting from Y " + this.currentLayer + " with silktouch " + this.enableSilktouch);
        }
        return new Boolean[]{true};
    }

    private Object[] state() {
        int energy = this.laserMedium_getEnergyStored();
        String status = this.getStatusHeaderInPureText();
        if (this.isActive()) {
            Integer retValuablesInLayer = this.valuablesInLayer.size();
            Integer retValuablesMined = this.valuableIndex;
            return new Object[]{status, this.isActive(), energy, this.currentLayer, retValuablesMined, retValuablesInLayer};
        }
        return new Object[]{status, this.isActive(), energy, this.currentLayer, 0, 0};
    }

    private Object[] onlyOres(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            try {
                this.mineAllBlocks = !Commons.toBool(arguments[0]);
                this.func_70296_d();
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.info(this + " onlyOres set to " + !this.mineAllBlocks);
                }
            }
            catch (Exception exception) {
                return new Object[]{!this.mineAllBlocks};
            }
        }
        return new Object[]{!this.mineAllBlocks};
    }

    private Object[] offset(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            try {
                this.layerOffset = Math.min(256, Math.abs(Commons.toInt(arguments[0])));
                this.func_70296_d();
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.info(this + " offset set to " + this.layerOffset);
                }
            }
            catch (Exception exception) {
                return new Integer[]{this.layerOffset};
            }
        }
        return new Integer[]{this.layerOffset};
    }

    private Object[] silktouch(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            try {
                this.enableSilktouch = Commons.toBool(arguments[0]);
                this.func_70296_d();
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.info(this + " silktouch set to " + this.enableSilktouch);
                }
            }
            catch (Exception exception) {
                return new Object[]{this.enableSilktouch};
            }
        }
        return new Object[]{this.enableSilktouch};
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName;
        switch (methodName = this.getMethodName(method)) {
            case "start": {
                return this.start();
            }
            case "stop": {
                this.stop();
                return null;
            }
            case "state": {
                return this.state();
            }
            case "offset": {
                return this.offset(arguments);
            }
            case "onlyOres": {
                return this.onlyOres(arguments);
            }
            case "silktouch": {
                return this.silktouch(arguments);
            }
        }
        return super.callMethod(computer, context, method, arguments);
    }

    @Override
    public String getStatusHeader() {
        int energy = this.laserMedium_getEnergyStored();
        String state = "IDLE (not mining)";
        if (this.currentState == 0) {
            state = "IDLE (not mining)";
        } else if (this.currentState == 1) {
            state = "Warming up...";
        } else if (this.currentState == 2) {
            state = this.mineAllBlocks ? "Scanning all" : "Scanning ores";
        } else if (this.currentState == 3) {
            state = this.mineAllBlocks ? "Mining all" : "Mining ores";
            if (this.enableSilktouch) {
                state = state + " with silktouch";
            }
        }
        if (energy <= 0) {
            state = state + " - Out of energy";
        } else if (!(this.currentState != 2 && this.currentState != 3 || this.enoughPower)) {
            state = state + " - Not enough power";
        }
        return state;
    }

    @Override
    public String toString() {
        return String.format("%s @ '%s' %d, %d, %d", this.getClass().getSimpleName(), this.field_145850_b == null ? "~NULL~" : this.field_145850_b.field_73011_w.func_80007_l(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

