/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.BlockAbstractContainer;
import cr0s.warpdrive.block.detection.TileEntitySiren;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockSiren
extends BlockAbstractContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconBuffer;
    public static final int METADATA_TYPE_INDUSTRIAL = 0;
    public static final int METADATA_TYPE_RAID = 4;
    public static final int METADATA_RANGE_BASIC = 0;
    public static final int METADATA_RANGE_ADVANCED = 1;
    public static final int METADATA_RANGE_SUPERIOR = 2;
    private static final int ICON_INDUSTRIAL = 0;
    private static final int ICON_RAID_BASIC = 1;
    private static final int ICON_RAID_ADVANCED = 2;
    private static final int ICON_RAID_SUPERIOR = 3;

    public BlockSiren() {
        super(Material.field_151573_f);
        this.hasSubBlocks = true;
        this.func_149647_a(WarpDrive.creativeTabWarpDrive);
        this.func_149663_c("warpdrive.detection.siren");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconBuffer = new IIcon[4];
        this.iconBuffer[0] = iconRegister.func_94245_a("warpdrive:detection/siren_industrial");
        this.iconBuffer[1] = iconRegister.func_94245_a("warpdrive:detection/siren_raid_basic");
        this.iconBuffer[2] = iconRegister.func_94245_a("warpdrive:detection/siren_raid_advanced");
        this.iconBuffer[3] = iconRegister.func_94245_a("warpdrive:detection/siren_raid_superior");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (!BlockSiren.getIsRaid(metadata)) {
            return this.iconBuffer[0];
        }
        switch (metadata & 3) {
            case 0: {
                return this.iconBuffer[1];
            }
            case 1: {
                return this.iconBuffer[2];
            }
            case 2: {
                return this.iconBuffer[3];
            }
        }
        return this.iconBuffer[1];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 4));
        list.add(new ItemStack(item, 1, 5));
        list.add(new ItemStack(item, 1, 6));
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntitySiren();
    }

    static boolean getIsRaid(int metadata) {
        switch (metadata & 4) {
            case 0: {
                return false;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    static float getRange(int metadata) {
        switch (metadata & 3) {
            case 0: {
                return 32.0f;
            }
            case 1: {
                return 64.0f;
            }
            case 2: {
                return 128.0f;
            }
        }
        return 0.0f;
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public void func_149725_f(World world, int x, int y, int z, int meta) {
        TileEntitySiren tileEntitySiren;
        if (!world.field_72995_K) {
            super.func_149725_f(world, x, y, z, meta);
            return;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntitySiren && (tileEntitySiren = (TileEntitySiren)tileEntity).isPlaying()) {
            tileEntitySiren.stopSound();
        }
    }
}

