/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IVideoChannel;
import cr0s.warpdrive.block.TileEntityAbstractInterfaced;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumCameraType;
import cr0s.warpdrive.network.PacketHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.world.ChunkPosition;

public class TileEntityCamera
extends TileEntityAbstractInterfaced
implements IVideoChannel {
    private int videoChannel = -1;
    private static final int REGISTRY_UPDATE_INTERVAL_TICKS = 300;
    private static final int PACKET_SEND_INTERVAL_TICKS = 1200;
    private int packetSendTicks = 10;
    private int registryUpdateTicks = 20;

    public TileEntityCamera() {
        this.peripheralName = "warpdriveCamera";
        this.addMethods(new String[]{"videoChannel"});
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            --this.packetSendTicks;
            if (this.packetSendTicks <= 0) {
                this.packetSendTicks = 1200;
                PacketHandler.sendVideoChannelPacket(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.videoChannel);
            }
        } else {
            --this.registryUpdateTicks;
            if (this.registryUpdateTicks <= 0) {
                this.registryUpdateTicks = 300;
                if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                    WarpDrive.logger.info(this + " Updating registry (" + this.videoChannel + ")");
                }
                WarpDrive.cameras.updateInRegistry(this.field_145850_b, new ChunkPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e), this.videoChannel, EnumCameraType.SIMPLE_CAMERA);
            }
        }
    }

    @Override
    public int getVideoChannel() {
        return this.videoChannel;
    }

    @Override
    public void setVideoChannel(int parVideoChannel) {
        if (this.videoChannel != parVideoChannel && parVideoChannel <= 0xFFFFFFF && parVideoChannel > 0) {
            this.videoChannel = parVideoChannel;
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info(this + " Video channel set to " + this.videoChannel);
            }
            this.packetSendTicks = 0;
            this.registryUpdateTicks = 0;
            this.func_70296_d();
        }
    }

    @Override
    public void func_145843_s() {
        if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
            WarpDrive.logger.info(this + " invalidated");
        }
        WarpDrive.cameras.removeFromRegistry(this.field_145850_b, new ChunkPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        super.func_145843_s();
    }

    @Override
    public void onChunkUnload() {
        if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
            WarpDrive.logger.info(this + " onChunkUnload");
        }
        WarpDrive.cameras.removeFromRegistry(this.field_145850_b, new ChunkPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        super.onChunkUnload();
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.videoChannel = tagCompound.func_74762_e("frequency") + tagCompound.func_74762_e("videoChannel");
        if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
            WarpDrive.logger.info(this + " readFromNBT");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("videoChannel", this.videoChannel);
        if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
            WarpDrive.logger.info(this + " writeToNBT");
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 10, tagCompound);
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tagCompound = packet.func_148857_g();
        this.func_145839_a(tagCompound);
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] videoChannel(Context context, Arguments arguments) {
        if (arguments.count() == 1) {
            this.setVideoChannel(arguments.checkInteger(0));
        }
        return new Integer[]{this.videoChannel};
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName = this.getMethodName(method);
        if (methodName.equals("videoChannel")) {
            if (arguments.length == 1 && arguments[0] != null) {
                this.setVideoChannel(Commons.toInt(arguments[0]));
            }
            return new Integer[]{this.videoChannel};
        }
        return super.callMethod(computer, context, method, arguments);
    }

    @Override
    public String toString() {
        return String.format("%s %d @ %s (%d %d %d)", this.getClass().getSimpleName(), this.videoChannel, this.field_145850_b == null ? "~NULL~" : this.field_145850_b.field_73011_w.func_80007_l(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

