/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CloakedArea;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.network.PacketHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.Arrays;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCloakingCore
extends TileEntityAbstractEnergy {
    private static final int CLOAKING_CORE_SOUND_UPDATE_TICKS = 40;
    private static final int DISTANCE_INNER_COILS_BLOCKS = 2;
    private static final int LASER_REFRESH_TICKS = 100;
    private static final int LASER_DURATION_TICKS = 110;
    public boolean isEnabled = false;
    public byte tier = 1;
    private final float[] innerCoilColor_r = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.25f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 1.0f};
    private final float[] innerCoilColor_g = new float[]{0.0f, 0.25f, 0.75f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.5f, 0.25f, 0.0f, 0.0f};
    private final float[] innerCoilColor_b = new float[]{0.25f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f, 1.0f, 0.75f};
    private final boolean[] isValidInnerCoils = new boolean[]{false, false, false, false, false, false};
    private final int[] distanceOuterCoils_blocks = new int[]{0, 0, 0, 0, 0, 0};
    private int minX = 0;
    private int minY = 0;
    private int minZ = 0;
    private int maxX = 0;
    private int maxY = 0;
    private int maxZ = 0;
    private boolean isValid = false;
    private String messageValidityIssues = "";
    private boolean isCloaking = false;
    private int volume = 0;
    private int energyRequired = 0;
    private int updateTicks = 0;
    private int laserDrawingTicks = 0;
    private boolean soundPlayed = false;
    private int soundTicks = 0;

    public TileEntityCloakingCore() {
        this.peripheralName = "warpdriveCloakingCore";
        this.addMethods(new String[]{"tier", "isAssemblyValid", "enable"});
        this.CC_scripts = Arrays.asList("cloak1", "cloak2", "uncloak");
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.soundTicks;
        if (this.soundTicks < 0) {
            this.soundTicks = 40;
            this.soundPlayed = false;
        }
        boolean isRefreshNeeded = false;
        --this.updateTicks;
        if (this.updateTicks <= 0) {
            this.updateTicks = (this.tier == 1 ? 20 : (this.tier == 2 ? 10 : 20)) * WarpDriveConfig.CLOAKING_FIELD_REFRESH_INTERVAL_SECONDS;
            isRefreshNeeded = this.validateAssembly();
            this.isCloaking = WarpDrive.cloaks.isAreaExists(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (!this.isEnabled) {
                if (this.isCloaking) {
                    if (WarpDriveConfig.LOGGING_CLOAKING) {
                        WarpDrive.logger.info(this + " Disabled, cloak field going down...");
                    }
                    this.disableCloakingField();
                    isRefreshNeeded = true;
                } else if (isRefreshNeeded) {
                    this.setCoilsState(false);
                }
            } else {
                this.updateVolumeAndEnergyRequired();
                boolean hasEnoughPower = this.energy_consume(this.energyRequired, false);
                if (!this.isCloaking) {
                    if (hasEnoughPower && this.isValid) {
                        CloakedArea area;
                        this.setCoilsState(true);
                        isRefreshNeeded = true;
                        WarpDrive.cloaks.updateCloakedArea(this.field_145850_b, this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.tier, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
                        if (!this.soundPlayed) {
                            this.soundPlayed = true;
                            this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "warpdrive:cloak", 4.0f, 1.0f);
                        }
                        if ((area = WarpDrive.cloaks.getCloakedArea(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) != null) {
                            area.sendCloakPacketToPlayersEx(false);
                        } else {
                            WarpDrive.logger.error("getCloakedArea1 returned null for " + this.field_145850_b + " " + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e);
                        }
                    } else {
                        this.setCoilsState(false);
                    }
                } else if (!this.isValid) {
                    if (WarpDriveConfig.LOGGING_CLOAKING) {
                        WarpDrive.logger.info(this + " Coil(s) lost, cloak field is collapsing...");
                    }
                    this.energy_consume(this.energy_getEnergyStored());
                    this.disableCloakingField();
                    isRefreshNeeded = true;
                } else if (hasEnoughPower) {
                    CloakedArea area;
                    if (isRefreshNeeded) {
                        WarpDrive.cloaks.updateCloakedArea(this.field_145850_b, this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.tier, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
                    }
                    if ((area = WarpDrive.cloaks.getCloakedArea(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) != null) {
                        area.sendCloakPacketToPlayersEx(false);
                    } else {
                        WarpDrive.logger.error("getCloakedArea2 returned null for " + this.field_145850_b + " " + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e);
                    }
                    this.setCoilsState(true);
                } else {
                    if (WarpDriveConfig.LOGGING_CLOAKING) {
                        WarpDrive.logger.info(this + " Low power, cloak field is collapsing...");
                    }
                    this.disableCloakingField();
                    isRefreshNeeded = true;
                }
            }
        }
        --this.laserDrawingTicks;
        if (isRefreshNeeded || this.laserDrawingTicks < 0) {
            this.laserDrawingTicks = 100;
            if (this.isEnabled && this.isValid) {
                this.drawLasers();
            }
        }
    }

    private void setCoilsState(boolean enabled) {
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, enabled ? 1 : 0, 2);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (this.isValidInnerCoils[direction.ordinal()]) {
                this.setCoilState(2, direction, enabled);
            }
            if (this.distanceOuterCoils_blocks[direction.ordinal()] <= 0) continue;
            this.setCoilState(this.distanceOuterCoils_blocks[direction.ordinal()], direction, enabled);
        }
    }

    private void setCoilState(int distance, ForgeDirection direction, boolean enabled) {
        int metadata_new;
        int metadata_current;
        int x = this.field_145851_c + distance * direction.offsetX;
        int y = this.field_145848_d + distance * direction.offsetY;
        int z = this.field_145849_e + distance * direction.offsetZ;
        if (this.field_145850_b.func_147439_a(x, y, z).func_149667_c(WarpDrive.blockCloakingCoil) && (metadata_current = this.field_145850_b.func_72805_g(x, y, z)) != (metadata_new = distance == 2 ? (enabled ? 9 : 1) : (enabled ? 10 : 2) + direction.ordinal())) {
            this.field_145850_b.func_72921_c(x, y, z, metadata_new, 2);
        }
    }

    private void drawLasers() {
        float r = 0.0f;
        float g = 1.0f;
        float b = 0.0f;
        if (!this.isCloaking) {
            r = 0.75f;
            g = 0.5f;
            b = 0.5f;
        } else if (this.tier == 1) {
            r = 0.0f;
            g = 1.0f;
            b = 0.25f;
        } else if (this.tier == 2) {
            r = 0.0f;
            g = 0.25f;
            b = 1.0f;
        }
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.isValidInnerCoils[direction.ordinal()] || this.distanceOuterCoils_blocks[direction.ordinal()] <= 0) continue;
            PacketHandler.sendBeamPacketToPlayersInArea(this.field_145850_b, new Vector3((double)this.field_145851_c + 0.5 + 2.3 * (double)direction.offsetX, (double)this.field_145848_d + 0.5 + 2.3 * (double)direction.offsetY, (double)this.field_145849_e + 0.5 + 2.3 * (double)direction.offsetZ), new Vector3((double)this.field_145851_c + 0.5 + (double)(this.distanceOuterCoils_blocks[direction.ordinal()] * direction.offsetX), (double)this.field_145848_d + 0.5 + (double)(this.distanceOuterCoils_blocks[direction.ordinal()] * direction.offsetY), (double)this.field_145849_e + 0.5 + (double)(this.distanceOuterCoils_blocks[direction.ordinal()] * direction.offsetZ)), r, g, b, 110, AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ));
        }
        for (int i = 0; i < 5; ++i) {
            ForgeDirection start = ForgeDirection.VALID_DIRECTIONS[i];
            for (int j = i + 1; j < 6; ++j) {
                ForgeDirection stop = ForgeDirection.VALID_DIRECTIONS[j];
                if (start.getOpposite() == stop) continue;
                int mapIndex = this.field_145850_b.field_73012_v.nextInt(this.innerCoilColor_b.length);
                r = this.innerCoilColor_r[mapIndex];
                g = this.innerCoilColor_g[mapIndex];
                b = this.innerCoilColor_b[mapIndex];
                PacketHandler.sendBeamPacketToPlayersInArea(this.field_145850_b, new Vector3((double)this.field_145851_c + 0.5 + 2.3 * (double)start.offsetX + 0.2 * (double)stop.offsetX, (double)this.field_145848_d + 0.5 + 2.3 * (double)start.offsetY + 0.2 * (double)stop.offsetY, (double)this.field_145849_e + 0.5 + 2.3 * (double)start.offsetZ + 0.2 * (double)stop.offsetZ), new Vector3((double)this.field_145851_c + 0.5 + 2.3 * (double)stop.offsetX + 0.2 * (double)start.offsetX, (double)this.field_145848_d + 0.5 + 2.3 * (double)stop.offsetY + 0.2 * (double)start.offsetY, (double)this.field_145849_e + 0.5 + 2.3 * (double)stop.offsetZ + 0.2 * (double)start.offsetZ), r, g, b, 110, AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ));
            }
        }
    }

    public void disableCloakingField() {
        this.setCoilsState(false);
        if (WarpDrive.cloaks.isAreaExists(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            WarpDrive.cloaks.removeCloakedArea(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (!this.soundPlayed) {
                this.soundPlayed = true;
                this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "warpdrive:decloak", 4.0f, 1.0f);
            }
        }
    }

    public void updateVolumeAndEnergyRequired() {
        int energyRequired_new;
        int volume_new = 0;
        if (this.tier == 1) {
            for (int y = this.minY; y <= this.maxY; ++y) {
                for (int x = this.minX; x <= this.maxX; ++x) {
                    for (int z = this.minZ; z <= this.maxZ; ++z) {
                        if (this.field_145850_b.func_147437_c(x, y, z)) continue;
                        ++volume_new;
                    }
                }
            }
            energyRequired_new = volume_new * WarpDriveConfig.CLOAKING_TIER1_ENERGY_PER_BLOCK;
        } else {
            for (int y = this.minY; y <= this.maxY; ++y) {
                for (int x = this.minX; x <= this.maxX; ++x) {
                    for (int z = this.minZ; z <= this.maxZ; ++z) {
                        if (this.field_145850_b.func_147439_a(x, y, z) == Blocks.field_150350_a) continue;
                        ++volume_new;
                    }
                }
            }
            energyRequired_new = volume_new * WarpDriveConfig.CLOAKING_TIER2_ENERGY_PER_BLOCK;
        }
        this.volume = volume_new;
        this.energyRequired = energyRequired_new;
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("%s Requiring %d EU for %d blocks", this, this.energyRequired, this.volume));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.tier = tagCompound.func_74771_c("tier");
        this.isEnabled = tagCompound.func_74767_n("enabled");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74774_a("tier", this.tier);
        tagCompound.func_74757_a("enabled", this.isEnabled);
    }

    public boolean validateAssembly() {
        int maxOuterCoilDistance = WarpDriveConfig.CLOAKING_MAX_FIELD_RADIUS - WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS;
        boolean isRefreshNeeded = false;
        int countIntegrity = 1;
        StringBuilder messageInnerCoils = new StringBuilder();
        StringBuilder messageOuterCoils = new StringBuilder();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            int oldCoilDistance;
            boolean isInnerValid;
            int x = this.field_145851_c + 2 * direction.offsetX;
            int y = this.field_145848_d + 2 * direction.offsetY;
            int z = this.field_145849_e + 2 * direction.offsetZ;
            boolean bl = isInnerValid = this.field_145850_b.func_147439_a(x, y, z) == WarpDrive.blockCloakingCoil;
            if (isInnerValid != this.isValidInnerCoils[direction.ordinal()]) {
                isRefreshNeeded = true;
                this.isValidInnerCoils[direction.ordinal()] = isInnerValid;
            }
            if (this.isValidInnerCoils[direction.ordinal()]) {
                ++countIntegrity;
            } else {
                if (messageInnerCoils.length() != 0) {
                    messageInnerCoils.append(", ");
                }
                messageInnerCoils.append(direction.name());
            }
            int newCoilDistance = 0;
            for (int distance = 3; distance < maxOuterCoilDistance; ++distance) {
                if (this.field_145850_b.func_147439_a(x += direction.offsetX, y += direction.offsetY, z += direction.offsetZ) != WarpDrive.blockCloakingCoil) continue;
                newCoilDistance = distance;
                break;
            }
            if (newCoilDistance != (oldCoilDistance = this.distanceOuterCoils_blocks[direction.ordinal()])) {
                int oldZ;
                int oldY;
                int oldX;
                if (oldCoilDistance > 0 && this.field_145850_b.func_147439_a(oldX = this.field_145851_c + oldCoilDistance * direction.offsetX, oldY = this.field_145848_d + oldCoilDistance * direction.offsetY, oldZ = this.field_145849_e + oldCoilDistance * direction.offsetZ) == WarpDrive.blockCloakingCoil) {
                    this.field_145850_b.func_72921_c(oldX, oldY, oldZ, 0, 2);
                }
                isRefreshNeeded = true;
                this.distanceOuterCoils_blocks[direction.ordinal()] = Math.max(0, newCoilDistance);
            }
            if (newCoilDistance > 0) {
                ++countIntegrity;
                continue;
            }
            if (messageOuterCoils.length() != 0) {
                messageOuterCoils.append(", ");
            }
            messageOuterCoils.append(direction.name());
        }
        float integrity = (float)countIntegrity / 13.0f;
        this.messageValidityIssues = messageInnerCoils.length() > 0 && messageOuterCoils.length() > 0 ? StatCollector.func_74837_a((String)"warpdrive.cloaking_core.missing_channeling_and_projecting_coils", (Object[])new Object[]{Math.round(100.0f * integrity), messageInnerCoils, messageOuterCoils}) : (messageInnerCoils.length() > 0 ? StatCollector.func_74837_a((String)"warpdrive.cloaking_core.missing_channeling_coils", (Object[])new Object[]{Math.round(100.0f * integrity), messageInnerCoils}) : (messageOuterCoils.length() > 0 ? StatCollector.func_74837_a((String)"warpdrive.cloaking_core.missing_projecting_coils", (Object[])new Object[]{Math.round(100.0f * integrity), messageOuterCoils}) : StatCollector.func_74837_a((String)"warpdrive.cloaking_core.valid", (Object[])new Object[0])));
        this.isValid = countIntegrity >= 13;
        this.minX = this.field_145851_c - this.distanceOuterCoils_blocks[4] - WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS;
        this.maxX = this.field_145851_c + this.distanceOuterCoils_blocks[5] + WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS;
        this.minY = Math.max(0, this.field_145848_d - this.distanceOuterCoils_blocks[0] - WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS);
        this.maxY = Math.min(255, this.field_145848_d + this.distanceOuterCoils_blocks[1] + WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS);
        this.minZ = this.field_145849_e - this.distanceOuterCoils_blocks[2] - WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS;
        this.maxZ = this.field_145849_e + this.distanceOuterCoils_blocks[3] + WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS;
        return isRefreshNeeded;
    }

    @Override
    public String getStatusHeader() {
        if (this.field_145850_b == null) {
            return super.getStatusHeader();
        }
        String unlocalizedStatus = !this.isValid ? this.messageValidityIssues : (!this.isEnabled ? "warpdrive.cloaking_core.disabled" : (!this.isCloaking ? "warpdrive.cloaking_core.low_power" : "warpdrive.cloaking_core.cloaking"));
        return super.getStatusHeader() + "\n" + StatCollector.func_74837_a((String)unlocalizedStatus, (Object[])new Object[]{this.tier, this.volume});
    }

    public Object[] tier(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            int tier_new;
            try {
                tier_new = Commons.toInt(arguments[0]);
            }
            catch (Exception exception) {
                return new Integer[]{this.tier};
            }
            this.tier = tier_new == 2 ? (byte)2 : (byte)1;
            this.func_70296_d();
        }
        return new Integer[]{this.tier};
    }

    public Object[] isAssemblyValid() {
        return new Object[]{this.isValid, Commons.removeFormatting(this.messageValidityIssues)};
    }

    public Object[] enable(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            this.isEnabled = Commons.toBool(arguments[0]);
            this.func_70296_d();
        }
        return new Object[]{this.isEnabled};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] tier(Context context, Arguments arguments) {
        return this.tier(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] isAssemblyValid(Context context, Arguments arguments) {
        return this.isAssemblyValid();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] enable(Context context, Arguments arguments) {
        return this.enable(this.argumentsOCtoCC(arguments));
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName;
        switch (methodName = this.getMethodName(method)) {
            case "tier": {
                return this.tier(arguments);
            }
            case "isAssemblyValid": {
                return this.isAssemblyValid();
            }
            case "enable": {
                return this.enable(arguments);
            }
        }
        return super.callMethod(computer, context, method, arguments);
    }

    @Override
    public int energy_getMaxStorage() {
        return WarpDriveConfig.CLOAKING_MAX_ENERGY_STORED;
    }

    @Override
    public boolean energy_canInput(ForgeDirection from) {
        return true;
    }
}

