/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.energy;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.IWarpTool;
import cr0s.warpdrive.block.BlockAbstractContainer;
import cr0s.warpdrive.block.energy.TileEntityEnergyBank;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEnergyBank
extends BlockAbstractContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public BlockEnergyBank() {
        super(Material.field_151573_f);
        this.func_149663_c("warpdrive.energy.energy_bank.");
        this.hasSubBlocks = true;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityEnergyBank((byte)(metadata % 4));
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTab, List list) {
        for (byte tier = 0; tier < 4; tier = (byte)((byte)(tier + 1))) {
            ItemStack itemStack = new ItemStack(item, 1, (int)tier);
            list.add(itemStack);
            if (tier <= 0) continue;
            itemStack = new ItemStack(item, 1, (int)tier);
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("tier", tier);
            tagCompound.func_74768_a("energy", WarpDriveConfig.ENERGY_BANK_MAX_ENERGY_STORED[tier - 1]);
            itemStack.func_77982_d(tagCompound);
            list.add(itemStack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[12];
        this.icons[0] = iconRegister.func_94245_a("warpdrive:energy/energy_bank_creative-disabled");
        this.icons[1] = iconRegister.func_94245_a("warpdrive:energy/energy_bank_creative-input");
        this.icons[2] = iconRegister.func_94245_a("warpdrive:energy/energy_bank_creative-output");
        this.icons[3] = iconRegister.func_94245_a("warpdrive:energy/energy_bank_basic-disabled");
        this.icons[4] = iconRegister.func_94245_a("warpdrive:energy/energy_bank_basic-input");
        this.icons[5] = iconRegister.func_94245_a("warpdrive:energy/energy_bank_basic-output");
        this.icons[6] = iconRegister.func_94245_a("warpdrive:energy/energy_bank_advanced-disabled");
        this.icons[7] = iconRegister.func_94245_a("warpdrive:energy/energy_bank_advanced-input");
        this.icons[8] = iconRegister.func_94245_a("warpdrive:energy/energy_bank_advanced-output");
        this.icons[9] = iconRegister.func_94245_a("warpdrive:energy/energy_bank_superior-disabled");
        this.icons[10] = iconRegister.func_94245_a("warpdrive:energy/energy_bank_superior-input");
        this.icons[11] = iconRegister.func_94245_a("warpdrive:energy/energy_bank_superior-output");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity tileEntity = blockAccess.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TileEntityEnergyBank)) {
            return this.icons[3];
        }
        return this.icons[3 * ((TileEntityEnergyBank)tileEntity).getTier() + ((TileEntityEnergyBank)tileEntity).getMode(EnumFacing.func_82600_a((int)side))];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.icons[(metadata * 3 + (side == 1 ? 1 : 2)) % this.icons.length];
    }

    @Override
    public byte getTier(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77973_b() != Item.func_150898_a((Block)this)) {
            return 1;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("tier")) {
            return tagCompound.func_74771_c("tier");
        }
        return (byte)itemStack.func_77960_j();
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TileEntityEnergyBank)) {
            return false;
        }
        TileEntityEnergyBank tileEntityEnergyBank = (TileEntityEnergyBank)tileEntity;
        ItemStack itemStackHeld = entityPlayer.func_70694_bm();
        EnumFacing facing = EnumFacing.func_82600_a((int)side);
        if (itemStackHeld != null && itemStackHeld.func_77973_b() instanceof IWarpTool) {
            if (entityPlayer.func_70093_af()) {
                tileEntityEnergyBank.setMode(facing, (byte)((tileEntityEnergyBank.getMode(facing) + 2) % 3));
            } else {
                tileEntityEnergyBank.setMode(facing, (byte)((tileEntityEnergyBank.getMode(facing) + 1) % 3));
            }
            ItemStack itemStack = new ItemStack(Item.func_150898_a((Block)this), 1, world.func_72805_g(x, y, z));
            switch (tileEntityEnergyBank.getMode(facing)) {
                case 1: {
                    Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.guide.prefix", (Object[])new Object[]{StatCollector.func_74837_a((String)(itemStack.func_77977_a() + ".name"), (Object[])new Object[0])}) + StatCollector.func_74837_a((String)"warpdrive.energy.side.changed_to_input", (Object[])new Object[]{facing.name()}));
                    return true;
                }
                case 2: {
                    Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.guide.prefix", (Object[])new Object[]{StatCollector.func_74837_a((String)(itemStack.func_77977_a() + ".name"), (Object[])new Object[0])}) + StatCollector.func_74837_a((String)"warpdrive.energy.side.changed_to_output", (Object[])new Object[]{facing.name()}));
                    return true;
                }
            }
            Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.guide.prefix", (Object[])new Object[]{StatCollector.func_74837_a((String)(itemStack.func_77977_a() + ".name"), (Object[])new Object[0])}) + StatCollector.func_74837_a((String)"warpdrive.energy.side.changed_to_disabled", (Object[])new Object[]{facing.name()}));
            return true;
        }
        return super.func_149727_a(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ);
    }
}

