/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.energy;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.computer.IEnanReactorCore;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.block.energy.TileEntityEnanReactorLaser;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumReactorFace;
import cr0s.warpdrive.data.EnumReactorReleaseMode;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.network.PacketHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import java.util.Collections;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityEnanReactorCore
extends TileEntityAbstractEnergy
implements IEnanReactorCore {
    private static final int ENAN_REACTOR_SETUP_TICKS = 1200;
    private static final int PR_MIN_GENERATION = 4;
    private static final int PR_MAX_GENERATION = 64000;
    private static final double PR_MIN_INSTABILITY = 0.004;
    private static final double PR_MAX_INSTABILITY = 0.06;
    private static final int PR_MAX_EXPLOSION_RADIUS = 6;
    private static final double PR_MAX_EXPLOSION_REMOVAL_CHANCE = 0.1;
    private static final double PR_MAX_LASER_ENERGY = 200000.0;
    private static final double PR_MAX_LASER_EFFECT = 3.6363636363636362;
    private boolean hold = true;
    private EnumTier tier = EnumTier.BASIC;
    private boolean isEnabled = false;
    private EnumReactorReleaseMode releaseMode = EnumReactorReleaseMode.OFF;
    private int releaseRate = 0;
    private int releaseAbove = 0;
    private double instabilityTarget = 50.0;
    private int stabilizerEnergy = 10000;
    private int containedEnergy = 0;
    private double[] instabilityValues = new double[]{0.0, 0.0, 0.0, 0.0};
    private int updateTicks = 0;
    private int setupTicks = 0;
    private float lasersReceived = 0.0f;
    private int lastGenerationRate = 0;
    private int releasedThisTick = 0;
    private long releasedThisCycle = 0L;
    private long releasedLastCycle = 0L;

    public TileEntityEnanReactorCore() {
        this.peripheralName = "warpdriveEnanReactorCore";
        this.addMethods(new String[]{"enable", "energy", "instability", "instabilityTarget", "release", "releaseRate", "releaseAbove", "stabilizerEnergy", "state"});
        this.CC_scripts = Collections.singletonList("startup");
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("updateTicks %d setupTicks %d releasedThisTick %6d lasersReceived %.5f releasedThisCycle %6d containedEnergy %8d", this.updateTicks, this.setupTicks, this.releasedThisTick, Float.valueOf(this.lasersReceived), this.releasedThisCycle, this.containedEnergy));
        }
        this.releasedThisTick = 0;
        --this.setupTicks;
        if (this.setupTicks <= 0) {
            this.setupTicks = 1200;
            this.scanSetup();
        }
        this.lasersReceived = Math.max(0.0f, this.lasersReceived - 0.05f);
        --this.updateTicks;
        if (this.updateTicks > 0) {
            return;
        }
        this.updateTicks = WarpDriveConfig.ENAN_REACTOR_UPDATE_INTERVAL_TICKS;
        this.releasedLastCycle = this.releasedThisCycle;
        this.releasedThisCycle = 0L;
        this.updateMetadata();
        if (!this.hold) {
            if (this.shouldExplode()) {
                this.explode();
            }
            this.increaseInstability();
            this.generateEnergy();
            this.runControlLoop();
        }
        this.sendEvent("reactorPulse", this.lastGenerationRate);
    }

    private void increaseInstability() {
        for (EnumReactorFace reactorFace : EnumReactorFace.getLasers(this.tier)) {
            int indexStability = reactorFace.indexStability;
            if (this.containedEnergy > WarpDriveConfig.ENAN_REACTOR_UPDATE_INTERVAL_TICKS * 4 * 100) {
                double amountToIncrease = (double)WarpDriveConfig.ENAN_REACTOR_UPDATE_INTERVAL_TICKS * Math.max(0.004, 0.06 * Math.pow(this.field_145850_b.field_73012_v.nextDouble() * (double)this.containedEnergy / (double)WarpDriveConfig.ENAN_REACTOR_MAX_ENERGY_STORED, 0.1));
                if (WarpDriveConfig.LOGGING_ENERGY) {
                    WarpDrive.logger.info(String.format("increaseInstability %.5f", amountToIncrease));
                }
                int n = indexStability;
                this.instabilityValues[n] = this.instabilityValues[n] + amountToIncrease;
                continue;
            }
            double amountToDecrease = (double)WarpDriveConfig.ENAN_REACTOR_UPDATE_INTERVAL_TICKS * Math.max(0.004, this.instabilityValues[indexStability] * 0.02);
            this.instabilityValues[indexStability] = Math.max(0.0, this.instabilityValues[indexStability] - amountToDecrease);
        }
    }

    public void decreaseInstability(EnumReactorFace reactorFace, int energy) {
        if (reactorFace.indexStability < 0) {
            return;
        }
        int amount = TileEntityEnanReactorCore.convertInternalToRF_floor(energy);
        if (amount <= 1) {
            return;
        }
        this.lasersReceived = Math.min(10.0f, this.lasersReceived + 1.0f / (float)WarpDriveConfig.ENAN_REACTOR_MAX_LASERS_PER_SECOND);
        double nospamFactor = 1.0;
        if (this.lasersReceived > 1.0f) {
            nospamFactor = 0.5;
            this.field_145850_b.func_72885_a(null, (double)(this.field_145851_c + reactorFace.facing.func_82601_c()), (double)(this.field_145848_d + reactorFace.facing.func_96559_d()), (double)(this.field_145849_e + reactorFace.facing.func_82599_e()), 1.0f, false, false);
        }
        double normalisedAmount = Math.min(1.0, Math.max(0.0, (double)amount / 200000.0));
        double baseLaserEffect = 0.5 + 0.5 * Math.cos(Math.PI - (1.0 + Math.log10(0.1 + 0.9 * normalisedAmount)) * Math.PI);
        double randomVariation = 0.8 + 0.4 * this.field_145850_b.field_73012_v.nextDouble();
        double amountToRemove = 3.6363636363636362 * baseLaserEffect * randomVariation * nospamFactor;
        int indexStability = reactorFace.indexStability;
        if (WarpDriveConfig.LOGGING_ENERGY && indexStability == 3) {
            WarpDrive.logger.info("Instability on " + reactorFace + " decreased by " + String.format("%.1f", amountToRemove) + "/" + String.format("%.1f", 3.6363636363636362) + " after consuming " + amount + "/" + 200000.0 + " lasersReceived is " + String.format("%.1f", Float.valueOf(this.lasersReceived)) + " hence nospamFactor is " + nospamFactor);
        }
        this.instabilityValues[indexStability] = Math.max(0.0, this.instabilityValues[indexStability] - amountToRemove);
        this.updateMetadata();
    }

    private void generateEnergy() {
        double stabilityOffset = 0.5;
        for (EnumReactorFace reactorFace : EnumReactorFace.getLasers(this.tier)) {
            stabilityOffset *= Math.max(0.01, this.instabilityValues[reactorFace.indexStability] / 100.0);
        }
        if (this.isEnabled) {
            int amountToGenerate = (int)Math.ceil((double)WarpDriveConfig.ENAN_REACTOR_UPDATE_INTERVAL_TICKS * (0.5 + stabilityOffset) * (4.0 + 64000.0 * Math.pow((double)this.containedEnergy / (double)WarpDriveConfig.ENAN_REACTOR_MAX_ENERGY_STORED, 0.6)));
            this.containedEnergy = Math.min(this.containedEnergy + amountToGenerate, WarpDriveConfig.ENAN_REACTOR_MAX_ENERGY_STORED);
            this.lastGenerationRate = amountToGenerate / WarpDriveConfig.ENAN_REACTOR_UPDATE_INTERVAL_TICKS;
            if (WarpDriveConfig.LOGGING_ENERGY) {
                WarpDrive.logger.info("Generated " + amountToGenerate);
            }
        } else {
            int amountToDecay = (int)((double)WarpDriveConfig.ENAN_REACTOR_UPDATE_INTERVAL_TICKS * (1.0 - stabilityOffset) * (4.0 + (double)this.containedEnergy * 0.01));
            this.containedEnergy = Math.max(0, this.containedEnergy - amountToDecay);
            this.lastGenerationRate = 0;
            if (WarpDriveConfig.LOGGING_ENERGY) {
                WarpDrive.logger.info("Decayed " + amountToDecay);
            }
        }
    }

    private void runControlLoop() {
        for (EnumReactorFace reactorFace : EnumReactorFace.getLasers(this.tier)) {
            TileEntity tileEntity;
            if (!(this.instabilityValues[reactorFace.indexStability] > this.instabilityTarget) || !((tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + reactorFace.x, this.field_145848_d + reactorFace.y, this.field_145849_e + reactorFace.z)) instanceof TileEntityEnanReactorLaser)) continue;
            ((TileEntityEnanReactorLaser)tileEntity).stabilize(this.stabilizerEnergy);
        }
    }

    private boolean shouldExplode() {
        boolean exploding = false;
        StringBuilder laserStatus = new StringBuilder();
        for (EnumReactorFace reactorFace : EnumReactorFace.getLasers(this.tier)) {
            exploding = exploding || this.instabilityValues[reactorFace.indexStability] >= 100.0;
            int laserEnergy = 0;
            TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + reactorFace.x, this.field_145848_d + reactorFace.y, this.field_145849_e + reactorFace.z);
            if (tileEntity instanceof TileEntityEnanReactorLaser) {
                try {
                    laserEnergy = (Integer)((TileEntityEnanReactorLaser)tileEntity).energy()[0];
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    WarpDrive.logger.error(String.format("%s tileEntity is %s", this, tileEntity));
                }
            }
            laserStatus.append(String.format("\n- face %s has reached instability %.2f while laser has %d energy available", reactorFace.name, this.instabilityValues[reactorFace.indexStability], laserEnergy));
        }
        if (exploding &= this.field_145850_b.field_73012_v.nextInt(4) == 2) {
            WarpDrive.logger.info(String.format("%s Explosion triggered\nEnergy stored is %d, Laser received is %.2f, reactor is %s%s", this, this.containedEnergy, Float.valueOf(this.lasersReceived), this.isEnabled ? "ENABLED" : "DISABLED", laserStatus.toString()));
            this.isEnabled = false;
        }
        return exploding;
    }

    private void explode() {
        double normalizedEnergy = (double)this.containedEnergy / (double)WarpDriveConfig.ENAN_REACTOR_MAX_ENERGY_STORED;
        int radius = (int)Math.round(6.0 * Math.pow(normalizedEnergy, 0.125));
        double chanceOfRemoval = 0.1 * Math.pow(normalizedEnergy, 0.125);
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(this + " Explosion radius is " + radius + ", Chance of removal is " + chanceOfRemoval);
        }
        if (radius > 1) {
            float bedrockExplosionResistance = Blocks.field_150357_h.func_149638_a(null);
            for (int x = this.field_145851_c - radius; x <= this.field_145851_c + radius; ++x) {
                for (int y = this.field_145848_d - radius; y <= this.field_145848_d + radius; ++y) {
                    for (int z = this.field_145849_e - radius; z <= this.field_145849_e + radius; ++z) {
                        if (z == this.field_145849_e && y == this.field_145848_d && x == this.field_145851_c || !(this.field_145850_b.field_73012_v.nextDouble() < chanceOfRemoval) || !(this.field_145850_b.func_147439_a(x, y, z).func_149638_a(null) >= bedrockExplosionResistance)) continue;
                        this.field_145850_b.func_147468_f(x, y, z);
                    }
                }
            }
        }
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        for (int i = 0; i < 3; ++i) {
            this.field_145850_b.func_72885_a(null, (double)(this.field_145851_c + this.field_145850_b.field_73012_v.nextInt(3)) - 0.5, (double)(this.field_145848_d + this.field_145850_b.field_73012_v.nextInt(3)) - 0.5, (double)(this.field_145849_e + this.field_145850_b.field_73012_v.nextInt(3)) - 0.5, 4.0f + (float)this.field_145850_b.field_73012_v.nextInt(3), true, true);
        }
    }

    private void updateMetadata() {
        double maxInstability = 0.0;
        double[] dArray = this.instabilityValues;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double instability = dArray[i];
            if (!(instability > maxInstability)) continue;
            maxInstability = instability;
        }
        int instabilityNibble = (int)Math.max(0L, Math.min(3L, Math.round(maxInstability / 25.0)));
        int energyNibble = (int)Math.max(0L, Math.min(3L, Math.round(4.0 * (double)this.containedEnergy / (double)WarpDriveConfig.ENAN_REACTOR_MAX_ENERGY_STORED)));
        int metadata = 4 * instabilityNibble + energyNibble;
        if (this.func_145832_p() != metadata) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata, 3);
        }
    }

    @Override
    public void onBlockUpdateDetected() {
        super.onBlockUpdateDetected();
        this.setupTicks = 0;
    }

    private void scanSetup() {
        boolean isValid = true;
        for (EnumReactorFace reactorFace : EnumReactorFace.values()) {
            Block block;
            boolean isAir;
            if (reactorFace.tier != this.tier || reactorFace.indexStability >= 0 || (isAir = (block = this.field_145850_b.func_147439_a(this.field_145851_c + reactorFace.x, this.field_145848_d + reactorFace.y, this.field_145849_e + reactorFace.z)).isAir((IBlockAccess)this.field_145850_b, this.field_145851_c + reactorFace.x, this.field_145848_d + reactorFace.y, this.field_145849_e + reactorFace.z))) continue;
            isValid = false;
            Vector3 vPosition = new Vector3((double)(this.field_145851_c + reactorFace.x) + 0.5, (double)(this.field_145848_d + reactorFace.y) + 0.5, (double)(this.field_145849_e + reactorFace.z) + 0.5);
            PacketHandler.sendSpawnParticlePacket(this.field_145850_b, "jammed", (byte)5, vPosition, new Vector3(0.0, 0.0, 0.0), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 32);
        }
        for (EnumReactorFace reactorFace : EnumReactorFace.getLasers(this.tier)) {
            TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + reactorFace.x, this.field_145848_d + reactorFace.y, this.field_145849_e + reactorFace.z);
            if (!(tileEntity instanceof TileEntityEnanReactorLaser)) continue;
            if (isValid) {
                ((TileEntityEnanReactorLaser)tileEntity).setReactorFace(reactorFace, this);
                continue;
            }
            ((TileEntityEnanReactorLaser)tileEntity).setReactorFace(EnumReactorFace.UNKNOWN, null);
        }
    }

    @Override
    public Object[] enable(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            boolean enableRequest;
            try {
                enableRequest = Commons.toBool(arguments[0]);
            }
            catch (Exception exception) {
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.error(this + " LUA error on enable(): Boolean expected for 1st argument " + arguments[0]);
                }
                return this.enable(new Object[0]);
            }
            if (this.isEnabled && !enableRequest) {
                this.sendEvent("reactorDeactivation", new Object[0]);
            } else if (!this.isEnabled && enableRequest) {
                this.sendEvent("reactorActivation", new Object[0]);
            }
            this.isEnabled = enableRequest;
        }
        return new Object[]{this.isEnabled};
    }

    @Override
    public Object[] energy() {
        return new Object[]{this.containedEnergy, WarpDriveConfig.ENAN_REACTOR_MAX_ENERGY_STORED, this.releasedLastCycle / (long)WarpDriveConfig.ENAN_REACTOR_UPDATE_INTERVAL_TICKS};
    }

    @Override
    public Object[] instability() {
        this.hold = false;
        ArrayList<Double> result = new ArrayList<Double>(16);
        for (EnumReactorFace reactorFace : EnumReactorFace.getLasers(this.tier)) {
            result.add(reactorFace.indexStability, this.instabilityValues[reactorFace.indexStability]);
        }
        return result.toArray();
    }

    @Override
    public Object[] instabilityTarget(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            double instabilityTargetRequested;
            try {
                instabilityTargetRequested = Commons.toDouble(arguments[0]);
            }
            catch (Exception exception) {
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.error(this + " LUA error on instabilityTarget(): Double expected for 1st argument " + arguments[0]);
                }
                return new Object[]{this.instabilityTarget};
            }
            this.instabilityTarget = Commons.clamp(0.0, 100.0, instabilityTargetRequested);
        }
        return new Object[]{this.instabilityTarget};
    }

    @Override
    public Object[] release(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            boolean releaseRequested;
            try {
                releaseRequested = Commons.toBool(arguments[0]);
            }
            catch (Exception exception) {
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.error(this + " LUA error on release(): Boolean expected for 1st argument " + arguments[0]);
                }
                return new Object[]{this.releaseMode != EnumReactorReleaseMode.OFF};
            }
            this.releaseMode = releaseRequested ? EnumReactorReleaseMode.UNLIMITED : EnumReactorReleaseMode.OFF;
            this.releaseAbove = 0;
            this.releaseRate = 0;
        }
        return new Object[]{this.releaseMode != EnumReactorReleaseMode.OFF};
    }

    @Override
    public Object[] releaseRate(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            int releaseRateRequested;
            try {
                releaseRateRequested = Commons.toInt(arguments[0]);
            }
            catch (Exception exception) {
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.error(this + " LUA error on releaseRate(): Integer expected for 1st argument " + arguments[0]);
                }
                return new Object[]{this.releaseMode.getName(), this.releaseRate};
            }
            if (releaseRateRequested <= 0) {
                this.releaseMode = EnumReactorReleaseMode.OFF;
                this.releaseRate = 0;
            } else {
                this.releaseRate = releaseRateRequested;
                this.releaseMode = EnumReactorReleaseMode.AT_RATE;
            }
        }
        return new Object[]{this.releaseMode.getName(), this.releaseRate};
    }

    @Override
    public Object[] releaseAbove(Object[] arguments) {
        int releaseAboveRequested;
        try {
            releaseAboveRequested = Commons.toInt(arguments[0]);
        }
        catch (Exception exception) {
            if (WarpDriveConfig.LOGGING_LUA) {
                WarpDrive.logger.error(this + " LUA error on releaseAbove(): Integer expected for 1st argument " + arguments[0]);
            }
            return new Object[]{this.releaseMode.getName(), this.releaseAbove};
        }
        if (releaseAboveRequested <= 0) {
            this.releaseMode = EnumReactorReleaseMode.OFF;
            this.releaseAbove = 0;
        } else {
            this.releaseMode = EnumReactorReleaseMode.ABOVE;
            this.releaseAbove = releaseAboveRequested;
        }
        return new Object[]{this.releaseMode.getName(), this.releaseAbove};
    }

    @Override
    public Object[] stabilizerEnergy(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            int stabilizerEnergyRequested;
            try {
                stabilizerEnergyRequested = Commons.toInt(arguments[0]);
            }
            catch (Exception exception) {
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.error(this + " LUA error on stabilizerEnergy(): Integer expected for 1st argument " + arguments[0]);
                }
                return new Object[]{this.stabilizerEnergy};
            }
            this.stabilizerEnergy = Commons.clamp(0, Integer.MAX_VALUE, stabilizerEnergyRequested);
        }
        return new Object[]{this.stabilizerEnergy};
    }

    @Override
    public Object[] state() {
        String status = this.getStatusHeaderInPureText();
        if (this.releaseMode == EnumReactorReleaseMode.OFF || this.releaseMode == EnumReactorReleaseMode.UNLIMITED) {
            return new Object[]{status, this.isEnabled, this.containedEnergy, this.releaseMode.getName(), 0};
        }
        if (this.releaseMode == EnumReactorReleaseMode.ABOVE) {
            return new Object[]{status, this.isEnabled, this.containedEnergy, this.releaseMode.getName(), this.releaseAbove};
        }
        return new Object[]{status, this.isEnabled, this.containedEnergy, this.releaseMode.getName(), this.releaseRate};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] enable(Context context, Arguments arguments) {
        return this.enable(this.argumentsOCtoCC(arguments));
    }

    @Override
    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] energy(Context context, Arguments arguments) {
        return this.energy();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] instability(Context context, Arguments arguments) {
        return this.instability();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] instabilityTarget(Context context, Arguments arguments) {
        return this.instabilityTarget(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] release(Context context, Arguments arguments) {
        return this.release(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] releaseRate(Context context, Arguments arguments) {
        return this.releaseRate(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] releaseAbove(Context context, Arguments arguments) {
        return this.releaseAbove(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] stabilizerEnergy(Context context, Arguments arguments) {
        return this.stabilizerEnergy(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] state(Context context, Arguments arguments) {
        return this.state();
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        this.hold = false;
        String methodName = this.getMethodName(method);
        try {
            switch (methodName) {
                case "enable": {
                    return this.enable(arguments);
                }
                case "energy": {
                    return this.energy();
                }
                case "instability": {
                    return this.instability();
                }
                case "instabilityTarget": {
                    return this.instabilityTarget(arguments);
                }
                case "release": {
                    return this.release(arguments);
                }
                case "releaseRate": {
                    return this.releaseRate(arguments);
                }
                case "releaseAbove": {
                    return this.releaseAbove(arguments);
                }
                case "stabilizerEnergy": {
                    return this.stabilizerEnergy(arguments);
                }
                case "state": {
                    return this.state();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new String[]{exception.getMessage()};
        }
        return super.callMethod(computer, context, method, arguments);
    }

    @Override
    public int energy_getPotentialOutput() {
        if (this.hold) {
            return 0;
        }
        int result = 0;
        int capacity = Math.max(0, 2 * this.lastGenerationRate - this.releasedThisTick);
        if (this.releaseMode == EnumReactorReleaseMode.UNLIMITED) {
            result = Math.min(Math.max(0, this.containedEnergy), capacity);
            if (WarpDriveConfig.LOGGING_ENERGY) {
                WarpDrive.logger.info("PotentialOutput Manual " + result + " RF (" + TileEntityEnanReactorCore.convertRFtoInternal_floor(result) + " internal) capacity " + capacity);
            }
        } else if (this.releaseMode == EnumReactorReleaseMode.ABOVE) {
            result = Math.min(Math.max(0, this.containedEnergy - this.releaseAbove), capacity);
            if (WarpDriveConfig.LOGGING_ENERGY) {
                WarpDrive.logger.info("PotentialOutput Above " + result + " RF (" + TileEntityEnanReactorCore.convertRFtoInternal_floor(result) + " internal) capacity " + capacity);
            }
        } else if (this.releaseMode == EnumReactorReleaseMode.AT_RATE) {
            int remainingRate = Math.max(0, this.releaseRate - this.releasedThisTick);
            result = Math.min(Math.max(0, this.containedEnergy), Math.min(remainingRate, capacity));
            if (WarpDriveConfig.LOGGING_ENERGY) {
                WarpDrive.logger.info("PotentialOutput Rated " + result + " RF (" + TileEntityEnanReactorCore.convertRFtoInternal_floor(result) + " internal) remainingRate " + remainingRate + " RF/t capacity " + capacity);
            }
        }
        return (int)TileEntityEnanReactorCore.convertRFtoInternal_floor(result);
    }

    @Override
    public boolean energy_canOutput(ForgeDirection from) {
        return from.equals((Object)ForgeDirection.UP) || from.equals((Object)ForgeDirection.DOWN);
    }

    @Override
    protected void energy_outputDone(long energyOutput_internal) {
        long energyOutput_RF = TileEntityEnanReactorCore.convertInternalToRF_ceil(energyOutput_internal);
        this.containedEnergy = (int)((long)this.containedEnergy - energyOutput_RF);
        if (this.containedEnergy < 0) {
            this.containedEnergy = 0;
        }
        this.releasedThisTick = (int)((long)this.releasedThisTick + energyOutput_RF);
        this.releasedThisCycle += energyOutput_RF;
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info("OutputDone " + energyOutput_internal + " (" + energyOutput_RF + " RF)");
        }
    }

    @Override
    public int energy_getEnergyStored() {
        return (int)Commons.clamp(0L, (long)this.energy_getMaxStorage(), TileEntityEnanReactorCore.convertRFtoInternal_floor(this.containedEnergy));
    }

    @Override
    public int energy_getMaxStorage() {
        return (int)TileEntityEnanReactorCore.convertRFtoInternal_floor(WarpDriveConfig.ENAN_REACTOR_MAX_ENERGY_STORED);
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("tier", this.tier.ordinal());
        tagCompound.func_74757_a("isEnabled", this.isEnabled);
        tagCompound.func_74768_a("releaseMode", this.releaseMode.ordinal());
        tagCompound.func_74768_a("releaseRate", this.releaseRate);
        tagCompound.func_74768_a("releaseAbove", this.releaseAbove);
        tagCompound.func_74780_a("instabilityTarget", this.instabilityTarget);
        tagCompound.func_74768_a("stabilizerEnergy", this.stabilizerEnergy);
        tagCompound.func_74768_a("energy", this.containedEnergy);
        NBTTagCompound tagCompoundInstability = new NBTTagCompound();
        for (EnumReactorFace reactorFace : EnumReactorFace.getLasers(this.tier)) {
            tagCompoundInstability.func_74780_a(reactorFace.name, this.instabilityValues[reactorFace.indexStability]);
        }
        tagCompound.func_74782_a("instability", (NBTBase)tagCompoundInstability);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("tier")) {
            this.tier = EnumTier.get(tagCompound.func_74762_e("tier"));
            this.isEnabled = tagCompound.func_74767_n("isEnabled");
            this.releaseMode = EnumReactorReleaseMode.get(tagCompound.func_74762_e("releaseMode"));
            this.releaseRate = tagCompound.func_74762_e("releaseRate");
            this.releaseAbove = tagCompound.func_74762_e("releaseAbove");
            this.instabilityTarget = tagCompound.func_74769_h("instabilityTarget");
            this.stabilizerEnergy = tagCompound.func_74762_e("stabilizerEnergy");
            this.containedEnergy = tagCompound.func_74762_e("energy");
            NBTTagCompound tagCompoundInstability = tagCompound.func_74775_l("instability");
            for (EnumReactorFace reactorFace : EnumReactorFace.getLasers(this.tier)) {
                this.instabilityValues[reactorFace.indexStability] = tagCompoundInstability.func_74769_h(reactorFace.name);
            }
        } else {
            this.tier = EnumTier.BASIC;
            this.isEnabled = false;
            this.releaseMode = EnumReactorReleaseMode.get(tagCompound.func_74762_e("releaseMode"));
            this.releaseRate = tagCompound.func_74762_e("releaseRate");
            this.releaseAbove = tagCompound.func_74762_e("releaseAbove");
        }
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        tagCompound = super.writeItemDropNBT(tagCompound);
        tagCompound.func_82580_o("isEnabled");
        tagCompound.func_82580_o("releaseMode");
        tagCompound.func_82580_o("releaseRate");
        tagCompound.func_82580_o("releaseAbove");
        tagCompound.func_82580_o("instabilityTarget");
        tagCompound.func_82580_o("stabilizerEnergy");
        tagCompound.func_82580_o("energy");
        tagCompound.func_82580_o("instability");
        return tagCompound;
    }

    @Override
    public String toString() {
        return String.format("%s %s @ %s (%d %d %d)", this.getClass().getSimpleName(), this.connectedComputers == null ? "~NULL~" : this.connectedComputers, this.field_145850_b == null ? "~NULL~" : this.field_145850_b.field_73011_w.func_80007_l(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

