/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.energy;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.block.TileEntityAbstractLaser;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.item.ItemIC2reactorLaserFocus;
import cr0s.warpdrive.network.PacketHandler;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.BlockFluidBase;

public class TileEntityIC2reactorLaserMonitor
extends TileEntityAbstractLaser {
    private int ticks = WarpDriveConfig.IC2_REACTOR_COOLING_INTERVAL_TICKS;
    public EnumFacing facing = null;
    private boolean isValid = false;

    public TileEntityIC2reactorLaserMonitor() {
        this.laserMedium_maxCount = 1;
        this.peripheralName = "warpdriveIC2reactorLaserCooler";
    }

    @Optional.Method(modid="IC2")
    private IReactor findReactor() {
        for (EnumFacing facing : EnumFacing.values()) {
            TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + 2 * facing.func_82601_c(), this.field_145848_d + 2 * facing.func_96559_d(), this.field_145849_e + 2 * facing.func_82599_e());
            if (tileEntity == null) continue;
            IReactor output = null;
            if (tileEntity instanceof IReactor) {
                output = (IReactor)tileEntity;
            } else if (tileEntity instanceof IReactorChamber) {
                IReactor reactor = ((IReactorChamber)tileEntity).getReactor();
                if (reactor == null) continue;
                ChunkCoordinates coords = reactor.getPosition();
                if (coords.field_71574_a != this.field_145851_c + 3 * facing.func_82601_c() || coords.field_71572_b != this.field_145848_d + 3 * facing.func_96559_d() || coords.field_71573_c != this.field_145849_e + 3 * facing.func_82599_e()) continue;
                output = reactor;
            }
            if (output == null) continue;
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c + facing.func_82601_c(), this.field_145848_d + facing.func_96559_d(), this.field_145849_e + facing.func_82599_e());
            boolean isAir = block.isAir((IBlockAccess)this.field_145850_b, this.field_145851_c + facing.func_82601_c(), this.field_145848_d + facing.func_96559_d(), this.field_145849_e + facing.func_82599_e());
            this.isValid = isAir || block instanceof BlockFluidBase || block instanceof IReactorChamber || !block.func_149688_o().func_76218_k();
            this.facing = facing;
            return output;
        }
        this.isValid = false;
        this.facing = null;
        return null;
    }

    @Optional.Method(modid="IC2")
    private boolean coolReactor(IReactor reactor) {
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 6; ++y) {
                ItemStack itemStack = reactor.getItemAt(x, y);
                if (itemStack == null || !(itemStack.func_77973_b() instanceof ItemIC2reactorLaserFocus)) continue;
                int heatInLaserFocus = itemStack.func_77960_j();
                int heatEnergyCap = (int)Math.floor(Math.min((double)this.laserMedium_getEnergyStored() / WarpDriveConfig.IC2_REACTOR_ENERGY_PER_HEAT, (double)heatInLaserFocus));
                int heatToTransfer = Math.min(heatEnergyCap, WarpDriveConfig.IC2_REACTOR_COOLING_PER_INTERVAL);
                if (heatToTransfer > 0 && this.laserMedium_consumeExactly((int)Math.ceil((double)heatToTransfer * WarpDriveConfig.IC2_REACTOR_ENERGY_PER_HEAT), false)) {
                    ItemIC2reactorLaserFocus.addHeat(itemStack, -heatToTransfer);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    @Optional.Method(modid="IC2")
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.ticks;
        if (this.ticks <= 0) {
            this.ticks = WarpDriveConfig.IC2_REACTOR_COOLING_INTERVAL_TICKS;
            IReactor reactor = this.findReactor();
            this.setMetadata();
            if (reactor == null) {
                return;
            }
            if (this.coolReactor(reactor)) {
                Vector3 vMonitor = new Vector3(this).translate(0.5);
                PacketHandler.sendBeamPacket(this.field_145850_b, vMonitor, new Vector3(reactor.getPosition()).translate(0.5), 0.0f, 0.8f, 1.0f, 20, 0, 20);
            }
        }
    }

    private void setMetadata() {
        int metadata;
        int n = metadata = this.facing != null ? this.facing.ordinal() : 6;
        if (this.isValid && (double)this.cache_laserMedium_energyStored >= WarpDriveConfig.IC2_REACTOR_ENERGY_PER_HEAT) {
            metadata |= 8;
        }
        if (this.func_145832_p() != metadata) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata, 3);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("ticks", this.ticks);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.ticks = tagCompound.func_74762_e("ticks");
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tagCompound = packet.func_148857_g();
        this.func_145839_a(tagCompound);
    }

    @Override
    @Optional.Method(modid="IC2")
    public String getStatus() {
        if (this.field_145850_b == null) {
            return super.getStatus();
        }
        if (this.facing != null) {
            return super.getStatus() + StatCollector.func_74837_a((String)"warpdrive.ic2_reactor_laser_monitor.reactor_found", (Object[])new Object[]{this.facing.name().toLowerCase()});
        }
        return super.getStatus() + StatCollector.func_74837_a((String)"warpdrive.ic2_reactor_laser_monitor.no_reactor", (Object[])new Object[0]);
    }
}

