/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.forcefield;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.block.forcefield.BlockAbstractForceField;
import cr0s.warpdrive.block.forcefield.TileEntityForceFieldRelay;
import cr0s.warpdrive.data.EnumForceFieldUpgrade;
import cr0s.warpdrive.item.ItemForceFieldUpgrade;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockForceFieldRelay
extends BlockAbstractForceField {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public BlockForceFieldRelay(byte tier) {
        super(tier, Material.field_151573_f);
        this.isRotating = false;
        this.func_149663_c("warpdrive.forcefield.relay" + tier);
        this.func_149658_d("warpdrive:forcefield/relay");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[EnumForceFieldUpgrade.length + 1];
        for (EnumForceFieldUpgrade enumForceFieldUpgrade : EnumForceFieldUpgrade.values()) {
            this.icons[enumForceFieldUpgrade.ordinal()] = enumForceFieldUpgrade.maxCountOnRelay > 0 ? iconRegister.func_94245_a("warpdrive:forcefield/relay-" + enumForceFieldUpgrade.getName()) : iconRegister.func_94245_a("warpdrive:forcefield/relay-" + EnumForceFieldUpgrade.NONE.getName());
        }
        this.icons[EnumForceFieldUpgrade.length] = iconRegister.func_94245_a("warpdrive:forcefield/relay-top");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity tileEntity = blockAccess.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TileEntityForceFieldRelay)) {
            return this.icons[0];
        }
        if (side == 0 || side == 1) {
            return this.icons[EnumForceFieldUpgrade.length];
        }
        if (((TileEntityForceFieldRelay)tileEntity).isConnected) {
            return this.icons[((TileEntityForceFieldRelay)tileEntity).getUpgrade().ordinal()];
        }
        return this.icons[EnumForceFieldUpgrade.NONE.ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int damage) {
        if (side == 0 || side == 1) {
            return this.icons[EnumForceFieldUpgrade.length];
        }
        if (damage >= 0 && damage < EnumForceFieldUpgrade.length) {
            return this.icons[damage];
        }
        return this.icons[0];
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityForceFieldRelay();
    }

    public int func_149692_a(int damage) {
        return damage;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TileEntityForceFieldRelay)) {
            return false;
        }
        TileEntityForceFieldRelay tileEntityForceFieldRelay = (TileEntityForceFieldRelay)tileEntity;
        ItemStack itemStackHeld = entityPlayer.func_70694_bm();
        if (entityPlayer.func_70093_af()) {
            EnumForceFieldUpgrade enumForceFieldUpgrade = tileEntityForceFieldRelay.getUpgrade();
            if (enumForceFieldUpgrade == EnumForceFieldUpgrade.NONE) {
                Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.no_upgrade_to_dismount", (Object[])new Object[0]));
                return true;
            }
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                ItemStack itemStackDrop = ItemForceFieldUpgrade.getItemStackNoCache(enumForceFieldUpgrade, 1);
                EntityItem entityItem = new EntityItem(world, entityPlayer.field_70165_t, entityPlayer.field_70163_u + 0.5, entityPlayer.field_70161_v, itemStackDrop);
                entityItem.field_145804_b = 0;
                world.func_72838_d((Entity)entityItem);
            }
            tileEntityForceFieldRelay.setUpgrade(EnumForceFieldUpgrade.NONE);
            Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.dismounted", (Object[])new Object[]{enumForceFieldUpgrade.name()}));
            return false;
        }
        if (itemStackHeld == null) {
            Commons.addChatMessage((ICommandSender)entityPlayer, tileEntityForceFieldRelay.getStatus());
            return true;
        }
        if (!(itemStackHeld.func_77973_b() instanceof ItemForceFieldUpgrade)) return false;
        if (EnumForceFieldUpgrade.get((int)itemStackHeld.func_77960_j()).maxCountOnRelay <= 0) {
            Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.invalid_upgrade_for_relay", (Object[])new Object[0]));
            return true;
        }
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            if (itemStackHeld.field_77994_a < 1) {
                Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.not_enough_upgrades", (Object[])new Object[0]));
                return true;
            }
            --itemStackHeld.field_77994_a;
            if (tileEntityForceFieldRelay.getUpgrade() != EnumForceFieldUpgrade.NONE) {
                ItemStack itemStackDrop = ItemForceFieldUpgrade.getItemStackNoCache(tileEntityForceFieldRelay.getUpgrade(), 1);
                EntityItem entityItem = new EntityItem(world, entityPlayer.field_70165_t, entityPlayer.field_70163_u + 0.5, entityPlayer.field_70161_v, itemStackDrop);
                entityItem.field_145804_b = 0;
                world.func_72838_d((Entity)entityItem);
            }
        }
        EnumForceFieldUpgrade enumForceFieldUpgrade = EnumForceFieldUpgrade.get(itemStackHeld.func_77960_j());
        tileEntityForceFieldRelay.setUpgrade(enumForceFieldUpgrade);
        Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.mounted", (Object[])new Object[]{enumForceFieldUpgrade.name()}));
        return false;
    }
}

