/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.forcefield;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBeamFrequency;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.block.forcefield.BlockAbstractForceField;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.ForceFieldRegistry;
import cr0s.warpdrive.data.Vector3;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

public class TileEntityAbstractForceField
extends TileEntityAbstractEnergy
implements IBeamFrequency {
    protected byte tier = (byte)-1;
    protected int beamFrequency = -1;
    public boolean isEnabled = true;
    protected boolean isConnected = false;
    protected Vector3 vRGB;

    public TileEntityAbstractForceField() {
        this.addMethods(new String[]{"enable", "beamFrequency"});
    }

    @Override
    protected void onFirstUpdateTick() {
        Block block = this.func_145838_q();
        if (block instanceof BlockAbstractForceField) {
            this.tier = ((BlockAbstractForceField)block).tier;
        } else {
            WarpDrive.logger.error("Missing block for " + this + " at " + this.field_145850_b + " " + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e);
        }
        if (this.beamFrequency >= 0 && this.beamFrequency <= 65000) {
            ForceFieldRegistry.updateInRegistry(this);
        }
    }

    @Override
    public void func_145845_h() {
        boolean new_isConnected;
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean bl = new_isConnected = this.beamFrequency > 0 && this.beamFrequency <= 65000;
        if (this.isConnected != new_isConnected) {
            this.isConnected = new_isConnected;
            this.func_70296_d();
        }
    }

    @Override
    public void func_145843_s() {
        ForceFieldRegistry.removeFromRegistry(this);
        super.func_145843_s();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
    }

    @Override
    public int getBeamFrequency() {
        return this.beamFrequency;
    }

    @Override
    public void setBeamFrequency(int parBeamFrequency) {
        if (this.beamFrequency != parBeamFrequency && parBeamFrequency <= 65000 && parBeamFrequency > 0) {
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info(this + " Beam frequency set from " + this.beamFrequency + " to " + parBeamFrequency);
            }
            if (this.func_145830_o()) {
                ForceFieldRegistry.removeFromRegistry(this);
            }
            this.beamFrequency = parBeamFrequency;
            this.vRGB = IBeamFrequency.getBeamColor(this.beamFrequency);
        }
        this.func_70296_d();
        if (this.func_145830_o()) {
            ForceFieldRegistry.updateInRegistry(this);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.tier = tagCompound.func_74771_c("tier");
        this.setBeamFrequency(tagCompound.func_74762_e("beamFrequency"));
        this.isEnabled = !tagCompound.func_74764_b("isEnabled") || tagCompound.func_74767_n("isEnabled");
        this.isConnected = tagCompound.func_74767_n("isConnected");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74774_a("tier", this.tier);
        tagCompound.func_74768_a("beamFrequency", this.beamFrequency);
        tagCompound.func_74757_a("isEnabled", this.isEnabled);
        tagCompound.func_74757_a("isConnected", this.isConnected);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tagCompound = packet.func_148857_g();
        this.func_145839_a(tagCompound);
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] enable(Context context, Arguments arguments) {
        return this.enable(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] beamFrequency(Context context, Arguments arguments) {
        if (arguments.count() == 1) {
            this.setBeamFrequency(arguments.checkInteger(0));
        }
        return new Integer[]{this.beamFrequency};
    }

    public Object[] enable(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            boolean enable;
            try {
                enable = Commons.toBool(arguments[0]);
            }
            catch (Exception exception) {
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.error(this + " LUA error on enable(): Boolean expected for 1st argument " + arguments[0]);
                }
                return new Object[]{this.isEnabled};
            }
            this.isEnabled = enable;
        }
        return new Object[]{this.isEnabled};
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName = this.getMethodName(method);
        try {
            switch (methodName) {
                case "enable": {
                    return this.enable(arguments);
                }
                case "beamFrequency": {
                    if (arguments.length == 1 && arguments[0] != null) {
                        this.setBeamFrequency(Commons.toInt(arguments[0]));
                    }
                    return new Integer[]{this.beamFrequency};
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new String[]{exception.getMessage()};
        }
        return super.callMethod(computer, context, method, arguments);
    }

    @Override
    public String toString() {
        return String.format("%s Beam '%d' @ %s (%d %d %d)", this.getClass().getSimpleName(), this.beamFrequency, this.field_145850_b == null ? "~NULL~" : this.field_145850_b.field_73011_w.func_80007_l(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

