/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.block.BlockAbstractContainer;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.data.EnumShipCoreState;
import cr0s.warpdrive.item.ItemComponent;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockShipCore
extends BlockAbstractContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconBuffer;
    private static final int ICON_TOP_BOTTOM = 0;
    private static final int ICON_LEFT_OFFLINE = 1;
    private static final int ICON_LEFT_ONLINE = 2;
    private static final int ICON_LEFT_ACTIVE = 3;
    private static final int ICON_LEFT_COOLING = 4;
    private static final int ICON_RIGHT_OFFLINE = 5;
    private static final int ICON_RIGHT_ONLINE = 6;
    private static final int ICON_RIGHT_ACTIVE = 7;
    private static final int ICON_RIGHT_COOLING = 8;
    private static final int ICON_CONTROL = 9;

    public BlockShipCore() {
        super(Material.field_151573_f);
        this.func_149663_c("warpdrive.movement.ship_core");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconBuffer = new IIcon[18];
        this.iconBuffer[0] = iconRegister.func_94245_a("warpdrive:movement/ship_core-top-bottom");
        this.iconBuffer[1] = iconRegister.func_94245_a("warpdrive:movement/ship_core-left_offline");
        this.iconBuffer[2] = iconRegister.func_94245_a("warpdrive:movement/ship_core-left_online");
        this.iconBuffer[3] = iconRegister.func_94245_a("warpdrive:movement/ship_core-left_active");
        this.iconBuffer[4] = iconRegister.func_94245_a("warpdrive:movement/ship_core-left_cooling");
        this.iconBuffer[5] = iconRegister.func_94245_a("warpdrive:movement/ship_core-right_offline");
        this.iconBuffer[6] = iconRegister.func_94245_a("warpdrive:movement/ship_core-right_online");
        this.iconBuffer[7] = iconRegister.func_94245_a("warpdrive:movement/ship_core-right_active");
        this.iconBuffer[8] = iconRegister.func_94245_a("warpdrive:movement/ship_core-right_cooling");
        this.iconBuffer[9] = iconRegister.func_94245_a("warpdrive:movement/ship_controller-side_inactive");
        this.iconBuffer[10] = iconRegister.func_94245_a("warpdrive:movement/ship_controller-side_active0");
        this.iconBuffer[11] = iconRegister.func_94245_a("warpdrive:movement/ship_controller-side_active1");
        this.iconBuffer[12] = iconRegister.func_94245_a("warpdrive:movement/ship_controller-side_active2");
        this.iconBuffer[13] = iconRegister.func_94245_a("warpdrive:movement/ship_controller-side_active3");
        this.iconBuffer[14] = iconRegister.func_94245_a("warpdrive:movement/ship_controller-side_active4");
        this.iconBuffer[15] = iconRegister.func_94245_a("warpdrive:movement/ship_controller-side_active5");
        this.iconBuffer[16] = iconRegister.func_94245_a("warpdrive:movement/ship_controller-side_active6");
        this.iconBuffer[17] = iconRegister.func_94245_a("warpdrive:movement/ship_controller-side_active7");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        if (side == 0 || side == 1) {
            return this.iconBuffer[0];
        }
        TileEntity tileEntity = blockAccess.func_147438_o(x, y, z);
        ForgeDirection facingTile = tileEntity instanceof TileEntityShipCore ? ((TileEntityShipCore)tileEntity).facing : ForgeDirection.DOWN;
        if (facingTile == ForgeDirection.DOWN || facingTile == ForgeDirection.UP) {
            return null;
        }
        ForgeDirection facingSide = ForgeDirection.getOrientation((int)side);
        int metadata = blockAccess.func_72805_g(x, y, z);
        EnumShipCoreState shipCoreState = EnumShipCoreState.get(metadata);
        if (facingTile == facingSide || facingTile == facingSide.getOpposite()) {
            return this.iconBuffer[9 + metadata];
        }
        if (facingTile == facingSide.getRotation(ForgeDirection.UP)) {
            switch (shipCoreState) {
                default: {
                    return this.iconBuffer[1];
                }
                case IDLE: {
                    return this.iconBuffer[2];
                }
                case SCANNING: {
                    return this.iconBuffer[3];
                }
                case ONLINE: {
                    return this.iconBuffer[3];
                }
                case WARMING_UP: {
                    return this.iconBuffer[3];
                }
                case COOLING_DOWN: 
            }
            return this.iconBuffer[4];
        }
        switch (shipCoreState) {
            default: {
                return this.iconBuffer[5];
            }
            case IDLE: {
                return this.iconBuffer[6];
            }
            case SCANNING: {
                return this.iconBuffer[7];
            }
            case ONLINE: {
                return this.iconBuffer[7];
            }
            case WARMING_UP: {
                return this.iconBuffer[7];
            }
            case COOLING_DOWN: 
        }
        return this.iconBuffer[8];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (side == 0 || side == 1) {
            return this.iconBuffer[0];
        }
        if (side == 3) {
            return this.iconBuffer[12];
        }
        return this.iconBuffer[6];
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityShipCore();
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityShipCore) {
            ((TileEntityShipCore)tileEntity).facing = Commons.getHorizontalDirectionFromEntity(entityLiving).getOpposite();
            world.func_147471_g(x, y, z);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityShipCore && ((TileEntityShipCore)tileEntity).jumpCount == 0) {
            return super.getDrops(world, x, y, z, metadata, fortune);
        }
        if (!world.field_72995_K) {
            EntityTNTPrimed entityTNTPrimed = new EntityTNTPrimed(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), null);
            entityTNTPrimed.field_70516_a = 10 + world.field_73012_v.nextInt(10);
            world.func_72838_d((Entity)entityTNTPrimed);
        }
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        itemStacks.add(ItemComponent.getItemStackNoCache(EnumComponentType.CAPACITIVE_CRYSTAL, 1));
        if (fortune > 0 && world.field_73012_v.nextBoolean()) {
            itemStacks.add(ItemComponent.getItemStackNoCache(EnumComponentType.CAPACITIVE_CRYSTAL, 1));
        }
        if (fortune > 1 && world.field_73012_v.nextBoolean()) {
            itemStacks.add(ItemComponent.getItemStackNoCache(EnumComponentType.CAPACITIVE_CRYSTAL, 1));
        }
        if (fortune > 1 & world.field_73012_v.nextBoolean()) {
            itemStacks.add(ItemComponent.getItemStackNoCache(EnumComponentType.POWER_INTERFACE, 1));
        }
        return itemStacks;
    }

    public float func_149737_a(EntityPlayer entityPlayer, World world, int x, int y, int z) {
        boolean willBreak = true;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityShipCore && ((TileEntityShipCore)tileEntity).jumpCount == 0) {
            willBreak = false;
        }
        return (willBreak ? 0.02f : 1.0f) * super.func_149737_a(entityPlayer, world, x, y, z);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (entityPlayer.func_70694_bm() == null && (tileEntity = world.func_147438_o(x, y, z)) instanceof TileEntityShipCore) {
            TileEntityShipCore tileEntityShipCore = (TileEntityShipCore)tileEntity;
            if (world.field_72995_K && entityPlayer.func_70093_af()) {
                boolean bl = tileEntityShipCore.showBoundingBox = !tileEntityShipCore.showBoundingBox;
                if (tileEntityShipCore.showBoundingBox) {
                    world.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "warpdrive:lowlaser", 4.0f, 2.0f, false);
                } else {
                    world.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "warpdrive:lowlaser", 4.0f, 1.4f, false);
                }
                Commons.addChatMessage((ICommandSender)entityPlayer, tileEntityShipCore.getBoundingBoxStatus());
                return true;
            }
            if (!world.field_72995_K && !entityPlayer.func_70093_af()) {
                Commons.addChatMessage((ICommandSender)entityPlayer, tileEntityShipCore.getStatus());
                return true;
            }
        }
        return false;
    }
}

