/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.block.BlockAbstractBase;
import cr0s.warpdrive.block.movement.BlockTransporterContainment;
import cr0s.warpdrive.data.VectorI;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockTransporterScanner
extends BlockAbstractBase {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconBuffer;

    public BlockTransporterScanner() {
        super(Material.field_151573_f);
        this.func_149663_c("warpdrive.movement.transporter_scanner");
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        this.func_149713_g(255);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconBuffer = new IIcon[4];
        this.iconBuffer[0] = iconRegister.func_94245_a("warpdrive:movement/transporter_scanner-bottom");
        this.iconBuffer[1] = iconRegister.func_94245_a("warpdrive:movement/transporter_scanner-side");
        this.iconBuffer[2] = iconRegister.func_94245_a("warpdrive:movement/transporter_scanner-top_offline");
        this.iconBuffer[3] = iconRegister.func_94245_a("warpdrive:movement/transporter_scanner-top_online");
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess blockAccess, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.DOWN;
    }

    public int getLightValue(IBlockAccess blockAccess, int x, int y, int z) {
        int metadata = blockAccess.func_72805_g(x, y, z);
        return metadata == 0 ? 0 : 6;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (side == 0) {
            return this.iconBuffer[0];
        }
        if (side != 1) {
            return this.iconBuffer[1];
        }
        return this.iconBuffer[metadata == 0 ? 2 : 3];
    }

    public Collection<VectorI> getValidContainment(World worldObj, VectorI vScanner) {
        ArrayList<VectorI> vContainments = new ArrayList<VectorI>(8);
        boolean isScannerPosition = true;
        for (int x = vScanner.x - 1; x <= vScanner.x + 1; ++x) {
            for (int z = vScanner.z - 1; z <= vScanner.z + 1; ++z) {
                Block blockBase = worldObj.func_147439_a(x, vScanner.y, z);
                if (!(blockBase instanceof BlockTransporterContainment || isScannerPosition && blockBase instanceof BlockTransporterScanner)) {
                    return null;
                }
                boolean bl = isScannerPosition = !isScannerPosition;
                if (!worldObj.func_147437_c(x, vScanner.y + 1, z)) {
                    return null;
                }
                if (!worldObj.func_147437_c(x, vScanner.y + 2, z)) {
                    return null;
                }
                if (!(blockBase instanceof BlockTransporterContainment)) continue;
                vContainments.add(new VectorI(x, vScanner.y, z));
            }
        }
        return vContainments;
    }
}

