/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IItemTransporterBeacon;
import cr0s.warpdrive.api.computer.ITransporterCore;
import cr0s.warpdrive.block.ItemBlockAbstractBase;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumTransporterBeaconState;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemBlockTransporterBeacon
extends ItemBlockAbstractBase
implements IItemTransporterBeacon {
    public ItemBlockTransporterBeacon(Block block) {
        super(block);
        this.func_77625_d(1);
        this.func_77656_e(800);
    }

    @Override
    public String func_77667_c(ItemStack itemstack) {
        return this.func_77658_a();
    }

    private static String getTransporterName(ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemBlockTransporterBeacon)) {
            return "";
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            return "";
        }
        String name = tagCompound.func_74779_i("name");
        UUID uuid = new UUID(tagCompound.func_74763_f("uuidMost"), tagCompound.func_74763_f("uuidLeast"));
        if (uuid.getMostSignificantBits() == 0L && uuid.getLeastSignificantBits() == 0L) {
            return "";
        }
        return name;
    }

    private static ItemStack setTransporterName(ItemStack itemStack, String name) {
        if (!(itemStack.func_77973_b() instanceof ItemBlockTransporterBeacon)) {
            return itemStack;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (name == null || name.isEmpty()) {
            tagCompound.func_82580_o("name");
        } else {
            tagCompound.func_74778_a("name", name);
        }
        itemStack.func_77982_d(tagCompound);
        return itemStack;
    }

    private static UUID getTransporterSignature(ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemBlockTransporterBeacon)) {
            return null;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        UUID uuid = new UUID(tagCompound.func_74763_f("uuidMost"), tagCompound.func_74763_f("uuidLeast"));
        if (uuid.getMostSignificantBits() == 0L && uuid.getLeastSignificantBits() == 0L) {
            return null;
        }
        return uuid;
    }

    private static ItemStack setTransporterSignature(ItemStack itemStack, UUID uuid) {
        if (!(itemStack.func_77973_b() instanceof ItemBlockTransporterBeacon)) {
            return itemStack;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (uuid == null) {
            tagCompound.func_82580_o("uuidMost");
            tagCompound.func_82580_o("uuidLeast");
        } else {
            tagCompound.func_74772_a("uuidMost", uuid.getMostSignificantBits());
            tagCompound.func_74772_a("uuidLeast", uuid.getLeastSignificantBits());
        }
        itemStack.func_77982_d(tagCompound);
        return itemStack;
    }

    private static int getEnergy(ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemBlockTransporterBeacon)) {
            return 0;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            return 0;
        }
        if (tagCompound.func_74764_b("energy")) {
            return tagCompound.func_74762_e("energy");
        }
        return 0;
    }

    private static ItemStack setEnergy(ItemStack itemStack, int energy) {
        if (!(itemStack.func_77973_b() instanceof ItemBlockTransporterBeacon)) {
            return itemStack;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74768_a("energy", energy);
        itemStack.func_77982_d(tagCompound);
        return itemStack;
    }

    private static ItemStack updateDamage(ItemStack itemStack, int energy, boolean isActive) {
        EnumTransporterBeaconState enumTransporterBeaconState;
        int maxDamage = itemStack.func_77958_k();
        int metadataEnergy = maxDamage - maxDamage * energy / WarpDriveConfig.TRANSPORTER_BEACON_MAX_ENERGY_STORED;
        int metadataNew = (metadataEnergy & 0xFFFFFFF8) + (enumTransporterBeaconState = isActive ? EnumTransporterBeaconState.PACKED_ACTIVE : EnumTransporterBeaconState.PACKED_INACTIVE).getMetadata();
        if (metadataNew != itemStack.func_77960_j()) {
            itemStack.func_77964_b(metadataNew);
            return itemStack;
        }
        return null;
    }

    @Override
    public boolean isActive(ItemStack itemStack) {
        return ItemBlockTransporterBeacon.getEnergy(itemStack) > WarpDriveConfig.TRANSPORTER_BEACON_ENERGY_PER_TICK;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int indexSlot, boolean isHeld) {
        if (entity instanceof EntityPlayer) {
            ItemStack itemStackNew;
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            ItemStack itemStackCheck = entityPlayer.field_71071_by.func_70301_a(indexSlot);
            if (itemStackCheck != itemStack) {
                WarpDrive.logger.error(String.format("Invalid item selection: possible dup tentative from %s", entityPlayer));
                return;
            }
            int energy = ItemBlockTransporterBeacon.getEnergy(itemStack) - WarpDriveConfig.TRANSPORTER_BEACON_ENERGY_PER_TICK;
            if (isHeld && energy >= 0) {
                ItemStack itemStackNew2 = ItemBlockTransporterBeacon.setEnergy(itemStack, energy);
                ItemBlockTransporterBeacon.updateDamage(itemStackNew2, energy, true);
                ((EntityPlayer)entity).field_71071_by.func_70299_a(indexSlot, itemStackNew2);
            } else if (itemStack.func_77960_j() != EnumTransporterBeaconState.PACKED_INACTIVE.getMetadata() && (itemStackNew = ItemBlockTransporterBeacon.updateDamage(itemStack, energy, false)) != null) {
                ((EntityPlayer)entity).field_71071_by.func_70299_a(indexSlot, itemStackNew);
            }
        }
        super.func_77663_a(itemStack, world, entity, indexSlot, isHeld);
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (entityPlayer.func_70093_af()) {
            return false;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity == null || tileEntity instanceof ITransporterCore) {
            return false;
        }
        return this.isActive(itemStack);
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        if (itemStack.field_77994_a == 0) {
            return false;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof ITransporterCore)) {
            return super.func_77648_a(itemStack, entityPlayer, world, x, y, z, side, hitX, hitY, hitZ);
        }
        if (!entityPlayer.func_82247_a(x, y, z, side, itemStack)) {
            return false;
        }
        UUID uuidBeacon = ItemBlockTransporterBeacon.getTransporterSignature(itemStack);
        String nameBeacon = ItemBlockTransporterBeacon.getTransporterName(itemStack);
        UUID uuidTransporter = ((ITransporterCore)tileEntity).getUUID();
        if (entityPlayer.func_70093_af()) {
            String nameTransporter = ((ITransporterCore)tileEntity).getStarMapName();
            if (uuidTransporter == null || nameTransporter == null || nameTransporter.isEmpty()) {
                Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.transporter_signature.get_missing", (Object[])new Object[0]));
            } else if (uuidTransporter.equals(uuidBeacon)) {
                Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.transporter_signature.get_same", (Object[])new Object[]{nameTransporter}));
            } else {
                ItemStack itemStackNew = ItemBlockTransporterBeacon.setTransporterName(itemStack, nameTransporter);
                ItemBlockTransporterBeacon.setTransporterSignature(itemStackNew, uuidTransporter);
                Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.transporter_signature.get", (Object[])new Object[]{nameTransporter}));
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.zombie.unfect", 1.0f, world.field_73012_v.nextFloat() * 0.2f + 1.8f);
            }
        } else {
            UUID uuidRemoteLocation;
            Object[] remoteLocation = ((ITransporterCore)tileEntity).remoteLocation(new Object[0]);
            if (remoteLocation == null || remoteLocation.length != 1 || !(remoteLocation[0] instanceof String)) {
                uuidRemoteLocation = null;
            } else {
                try {
                    uuidRemoteLocation = UUID.fromString((String)remoteLocation[0]);
                }
                catch (IllegalArgumentException exception) {
                    uuidRemoteLocation = null;
                }
            }
            if (uuidBeacon == null) {
                Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.transporter_signature.set_missing", (Object[])new Object[]{nameBeacon}));
            } else if (uuidBeacon.equals(uuidTransporter)) {
                Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.transporter_signature.set_self", (Object[])new Object[]{nameBeacon}));
            } else if (uuidBeacon.equals(uuidRemoteLocation)) {
                Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.transporter_signature.set_same", (Object[])new Object[]{nameBeacon}));
            } else {
                ((ITransporterCore)tileEntity).remoteLocation(new Object[]{uuidBeacon});
                Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.transporter_signature.set", (Object[])new Object[]{nameBeacon}));
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.zombie.infect", 1.0f, world.field_73012_v.nextFloat() * 0.2f + 1.2f);
            }
        }
        return true;
    }
}

