/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.computer.IShipController;
import cr0s.warpdrive.block.TileEntityAbstractInterfaced;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.EnumShipControllerCommand;
import cr0s.warpdrive.data.VectorI;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;

public class TileEntityShipController
extends TileEntityAbstractInterfaced
implements IShipController {
    private int moveFront = 0;
    private int moveUp = 0;
    private int moveRight = 0;
    private byte rotationSteps = 0;
    private EnumShipControllerCommand command = EnumShipControllerCommand.IDLE;
    protected boolean isEnabled = false;
    private String nameTarget = "";
    private int front;
    private int right;
    private int up;
    private int back;
    private int left;
    private int down;
    private boolean isPendingScan = false;
    public final ArrayList<String> players = new ArrayList();
    private final int updateInterval_ticks;
    private int updateTicks = this.updateInterval_ticks = 20 * WarpDriveConfig.SHIP_CONTROLLER_UPDATE_INTERVAL_SECONDS;
    private int bootTicks = 20;
    private WeakReference<TileEntityShipCore> tileEntityShipCoreWeakReference = null;

    public TileEntityShipController() {
        this.peripheralName = "warpdriveShipController";
        this.addMethods(new String[]{"isAssemblyValid", "getOrientation", "isInSpace", "isInHyperspace", "shipName", "dim_positive", "dim_negative", "energy", "getAttachedPlayers", "command", "enable", "getShipSize", "getMaxJumpDistance", "movement", "rotationSteps", "targetName", "getEnergyRequired"});
        this.CC_scripts = Collections.singletonList("startup");
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.bootTicks > 0) {
            --this.bootTicks;
            if (this.tileEntityShipCoreWeakReference == null) {
                this.updateTicks = 1;
            }
        }
        --this.updateTicks;
        if (this.updateTicks <= 0) {
            this.updateTicks = this.updateInterval_ticks;
            TileEntityShipCore tileEntityShipCore = this.findCoreBlock();
            if (tileEntityShipCore != null) {
                if (this.tileEntityShipCoreWeakReference == null || tileEntityShipCore != this.tileEntityShipCoreWeakReference.get()) {
                    this.tileEntityShipCoreWeakReference = new WeakReference<TileEntityShipCore>(tileEntityShipCore);
                }
                if (this.command.getCode() != this.func_145832_p()) {
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.command.getCode(), 3);
                }
                if (this.isPendingScan && tileEntityShipCore.isAttached(this)) {
                    this.isPendingScan = false;
                    StringBuilder reason = new StringBuilder();
                    try {
                        if (!tileEntityShipCore.validateShipSpatialParameters(this, reason)) {
                            tileEntityShipCore.messageToAllPlayersOnShip(reason.toString());
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        WarpDrive.logger.info(this + " Exception in validateShipSpatialParameters, reason: " + reason.toString());
                    }
                }
            } else if (this.func_145832_p() != 0) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.players.clear();
        if (tagCompound.func_150297_b("players", 8)) {
            String[] namePlayers_table;
            String namePlayers_tag = tagCompound.func_74779_i("players");
            for (String namePlayer : namePlayers_table = namePlayers_tag.split("\\|")) {
                if (namePlayer.isEmpty()) continue;
                this.players.add(namePlayer);
            }
        } else {
            NBTTagList tagListPlayers = tagCompound.func_150295_c("players", 8);
            for (int index = 0; index < tagListPlayers.func_74745_c(); ++index) {
                String namePlayer = tagListPlayers.func_150307_f(index);
                this.players.add(namePlayer);
            }
        }
        this.isEnabled = tagCompound.func_74764_b("isEnabled") && tagCompound.func_74767_n("isEnabled");
        this.setCommand(tagCompound.func_74779_i("command"));
        this.setFront(tagCompound.func_74762_e("front"));
        this.setRight(tagCompound.func_74762_e("right"));
        this.setUp(tagCompound.func_74762_e("up"));
        this.setBack(tagCompound.func_74762_e("back"));
        this.setLeft(tagCompound.func_74762_e("left"));
        this.setDown(tagCompound.func_74762_e("down"));
        this.setMovement(tagCompound.func_74762_e("moveFront"), tagCompound.func_74762_e("moveUp"), tagCompound.func_74762_e("moveRight"));
        this.setRotationSteps(tagCompound.func_74771_c("rotationSteps"));
        this.nameTarget = tagCompound.func_74779_i("nameTarget");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList tagListPlayers = new NBTTagList();
        for (String namePlayer : this.players) {
            NBTTagString tagStringPlayer = new NBTTagString(namePlayer);
            tagListPlayers.func_74742_a((NBTBase)tagStringPlayer);
        }
        tagCompound.func_74782_a("players", (NBTBase)tagListPlayers);
        tagCompound.func_74757_a("isEnabled", this.isEnabled);
        tagCompound.func_74778_a("command", this.command.name());
        tagCompound.func_74768_a("front", this.front);
        tagCompound.func_74768_a("right", this.right);
        tagCompound.func_74768_a("up", this.up);
        tagCompound.func_74768_a("back", this.back);
        tagCompound.func_74768_a("left", this.left);
        tagCompound.func_74768_a("down", this.down);
        tagCompound.func_74768_a("moveFront", this.moveFront);
        tagCompound.func_74768_a("moveUp", this.moveUp);
        tagCompound.func_74768_a("moveRight", this.moveRight);
        tagCompound.func_74774_a("rotationSteps", this.rotationSteps);
        tagCompound.func_74778_a("nameTarget", this.nameTarget);
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        tagCompound = super.writeItemDropNBT(tagCompound);
        tagCompound.func_82580_o("players");
        tagCompound.func_82580_o("isEnabled");
        tagCompound.func_82580_o("command");
        tagCompound.func_82580_o("front");
        tagCompound.func_82580_o("right");
        tagCompound.func_82580_o("up");
        tagCompound.func_82580_o("back");
        tagCompound.func_82580_o("left");
        tagCompound.func_82580_o("down");
        tagCompound.func_82580_o("moveFront");
        tagCompound.func_82580_o("moveUp");
        tagCompound.func_82580_o("moveRight");
        tagCompound.func_82580_o("rotationSteps");
        tagCompound.func_82580_o("nameTarget");
        return tagCompound;
    }

    @Override
    public String getStatus() {
        return super.getStatus() + StatCollector.func_74837_a((String)"warpdrive.ship.attached_players", (Object[])new Object[]{this.getAttachedPlayersList()});
    }

    private TileEntityShipCore findCoreBlock() {
        TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
        if (tileEntity instanceof TileEntityShipCore) {
            return (TileEntityShipCore)tileEntity;
        }
        tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
        if (tileEntity instanceof TileEntityShipCore) {
            return (TileEntityShipCore)tileEntity;
        }
        tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
        if (tileEntity instanceof TileEntityShipCore) {
            return (TileEntityShipCore)tileEntity;
        }
        tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
        if (tileEntity instanceof TileEntityShipCore) {
            return (TileEntityShipCore)tileEntity;
        }
        return null;
    }

    protected void cooldownDone() {
        this.sendEvent("shipCoreCooldownDone", new Object[0]);
    }

    protected String attachPlayer(EntityPlayer entityPlayer) {
        TileEntityShipCore tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        for (int i = 0; i < this.players.size(); ++i) {
            String name = this.players.get(i);
            if (!entityPlayer.getDisplayName().equals(name)) continue;
            this.players.remove(i);
            return StatCollector.func_74837_a((String)"warpdrive.guide.prefix", (Object[])new Object[]{this.func_145838_q().func_149732_F()}) + StatCollector.func_74837_a((String)"warpdrive.ship.player_detached", (Object[])new Object[]{tileEntityShipCore != null && !tileEntityShipCore.shipName.isEmpty() ? tileEntityShipCore.shipName : "-", this.getAttachedPlayersList()});
        }
        entityPlayer.func_70097_a(DamageSource.field_76377_j, 1.0f);
        this.players.add(entityPlayer.getDisplayName());
        return StatCollector.func_74837_a((String)"warpdrive.guide.prefix", (Object[])new Object[]{this.func_145838_q().func_149732_F()}) + StatCollector.func_74837_a((String)"warpdrive.ship.player_attached", (Object[])new Object[]{tileEntityShipCore != null && !tileEntityShipCore.shipName.isEmpty() ? tileEntityShipCore.shipName : "-", this.getAttachedPlayersList()});
    }

    protected String getAttachedPlayersList() {
        if (this.players.isEmpty()) {
            return "<nobody>";
        }
        StringBuilder list = new StringBuilder();
        for (int i = 0; i < this.players.size(); ++i) {
            String nick = this.players.get(i);
            list.append(nick).append(i == this.players.size() - 1 ? "" : ", ");
        }
        return list.toString();
    }

    protected int getFront() {
        return this.front;
    }

    private void setFront(int front) {
        this.front = front;
        this.isPendingScan = true;
    }

    protected int getRight() {
        return this.right;
    }

    private void setRight(int right) {
        this.right = right;
        this.isPendingScan = true;
    }

    protected int getUp() {
        return this.up;
    }

    private void setUp(int up) {
        this.up = up;
        this.isPendingScan = true;
    }

    protected int getBack() {
        return this.back;
    }

    private void setBack(int back) {
        this.back = back;
        this.isPendingScan = true;
    }

    protected int getLeft() {
        return this.left;
    }

    private void setLeft(int left) {
        this.left = left;
        this.isPendingScan = true;
    }

    protected int getDown() {
        return this.down;
    }

    private void setDown(int down) {
        this.down = down;
        this.isPendingScan = true;
    }

    public EnumShipControllerCommand getCommand() {
        return this.command;
    }

    private void setCommand(String command) {
        for (EnumShipControllerCommand enumShipControllerCommand : EnumShipControllerCommand.values()) {
            if (!enumShipControllerCommand.name().equalsIgnoreCase(command)) continue;
            this.command = enumShipControllerCommand;
            this.func_70296_d();
            if (!WarpDriveConfig.LOGGING_LUA || !this.func_145830_o()) continue;
            WarpDrive.logger.info(String.format("%s Command set to %s (%d)", new Object[]{this, this.command, this.command.getCode()}));
        }
    }

    void commandDone(boolean success, String reason) {
        this.isEnabled = false;
        this.command = EnumShipControllerCommand.IDLE;
        if (!success) {
            TileEntityShipCore tileEntityShipCore;
            TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
            if (tileEntityShipCore != null) {
                tileEntityShipCore.messageToAllPlayersOnShip(reason);
            }
        }
    }

    protected VectorI getMovement() {
        return new VectorI(this.moveFront, this.moveUp, this.moveRight);
    }

    private void setMovement(int moveFront, int moveUp, int moveRight) {
        this.moveFront = moveFront;
        this.moveUp = moveUp;
        this.moveRight = moveRight;
        this.func_70296_d();
        if (WarpDriveConfig.LOGGING_LUA && this.func_145830_o()) {
            WarpDrive.logger.info(String.format("%s Movement set to %d front, %d up, %d right", this, this.moveFront, this.moveUp, this.moveRight));
        }
    }

    protected byte getRotationSteps() {
        return this.rotationSteps;
    }

    private void setRotationSteps(byte rotationSteps) {
        this.rotationSteps = (byte)((rotationSteps + 4) % 4);
        this.func_70296_d();
        if (WarpDriveConfig.LOGGING_LUA && this.func_145830_o()) {
            WarpDrive.logger.info(String.format("%s Movement set to %d rotation steps", this, this.rotationSteps));
        }
    }

    String getTargetName() {
        return this.nameTarget;
    }

    @Override
    public Object[] position() {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return null;
        }
        return new Object[]{tileEntityShipCore.field_145851_c, tileEntityShipCore.field_145848_d, tileEntityShipCore.field_145849_e, "?", tileEntityShipCore.field_145851_c, tileEntityShipCore.field_145848_d, tileEntityShipCore.field_145849_e};
    }

    @Override
    public Object[] isAssemblyValid() {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return new Object[]{false, "No core detected"};
        }
        return new Object[]{true, "ok"};
    }

    @Override
    public Object[] getOrientation() {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore != null) {
            return new Object[]{tileEntityShipCore.facing.offsetX, 0, tileEntityShipCore.facing.offsetZ};
        }
        return null;
    }

    @Override
    public Object[] isInSpace() {
        return new Boolean[]{CelestialObjectManager.isInSpace(this.field_145850_b, this.field_145851_c, this.field_145849_e)};
    }

    @Override
    public Object[] isInHyperspace() {
        return new Boolean[]{CelestialObjectManager.isInHyperspace(this.field_145850_b, this.field_145851_c, this.field_145849_e)};
    }

    @Override
    public Object[] shipName(Object[] arguments) {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return null;
        }
        if (arguments.length == 1 && arguments[0] != null) {
            String shipNamePrevious = tileEntityShipCore.shipName;
            tileEntityShipCore.shipName = Commons.sanitizeFileName((String)arguments[0]);
            if (!tileEntityShipCore.shipName.equals(shipNamePrevious)) {
                WarpDrive.logger.info(String.format("Ship renamed from '%s' to '%s' with player(s) %s", shipNamePrevious == null ? "-null-" : shipNamePrevious, tileEntityShipCore.shipName, tileEntityShipCore.getAllPlayersOnShip()));
            }
        }
        return new Object[]{tileEntityShipCore.shipName};
    }

    @Override
    public Object[] dim_positive(Object[] arguments) {
        try {
            if (arguments.length == 3) {
                int argInt0 = Commons.clamp(0, WarpDriveConfig.SHIP_MAX_SIDE_SIZE, Math.abs(Commons.toInt(arguments[0])));
                int argInt1 = Commons.clamp(0, WarpDriveConfig.SHIP_MAX_SIDE_SIZE, Math.abs(Commons.toInt(arguments[1])));
                int argInt2 = Commons.clamp(0, WarpDriveConfig.SHIP_MAX_SIDE_SIZE, Math.abs(Commons.toInt(arguments[2])));
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.info(this + " Positive dimensions set to front " + argInt0 + ", right " + argInt1 + ", up " + argInt2);
                }
                this.setFront(argInt0);
                this.setRight(argInt1);
                this.setUp(Math.min(255 - this.field_145848_d, argInt2));
            }
        }
        catch (Exception exception) {
            return new Integer[]{this.getFront(), this.getRight(), this.getUp()};
        }
        return new Integer[]{this.getFront(), this.getRight(), this.getUp()};
    }

    @Override
    public Object[] dim_negative(Object[] arguments) {
        try {
            if (arguments.length == 3) {
                int argInt0 = Commons.clamp(0, WarpDriveConfig.SHIP_MAX_SIDE_SIZE, Math.abs(Commons.toInt(arguments[0])));
                int argInt1 = Commons.clamp(0, WarpDriveConfig.SHIP_MAX_SIDE_SIZE, Math.abs(Commons.toInt(arguments[1])));
                int argInt2 = Commons.clamp(0, WarpDriveConfig.SHIP_MAX_SIDE_SIZE, Math.abs(Commons.toInt(arguments[2])));
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.info(this + " Negative dimensions set to back " + argInt0 + ", left " + argInt1 + ", down " + argInt2);
                }
                this.setBack(argInt0);
                this.setLeft(argInt1);
                this.setDown(Math.min(this.field_145848_d, argInt2));
            }
        }
        catch (Exception exception) {
            return new Integer[]{this.getBack(), this.getLeft(), this.getDown()};
        }
        return new Integer[]{this.getBack(), this.getLeft(), this.getDown()};
    }

    @Override
    public Object[] getAttachedPlayers() {
        StringBuilder list = new StringBuilder();
        if (!this.players.isEmpty()) {
            for (int i = 0; i < this.players.size(); ++i) {
                String nick = this.players.get(i);
                list.append(nick).append(i == this.players.size() - 1 ? "" : ",");
            }
        }
        return new Object[]{list.toString(), this.players.toArray()};
    }

    @Override
    public Object[] energy() {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return null;
        }
        return tileEntityShipCore.energy();
    }

    @Override
    public Object[] command(Object[] arguments) {
        try {
            if (arguments.length == 1 && arguments[0] != null) {
                this.setCommand(arguments[0].toString());
            }
        }
        catch (Exception exception) {
            return new Object[]{this.command.toString()};
        }
        return new Object[]{this.command.toString()};
    }

    @Override
    public Object[] enable(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            this.isEnabled = Commons.toBool(arguments[0]);
            if (WarpDriveConfig.LOGGING_LUA) {
                WarpDrive.logger.info(this + " enable(" + this.isEnabled + ")");
            }
        }
        return new Object[]{this.isEnabled};
    }

    @Override
    public Object[] getShipSize() {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return null;
        }
        return new Object[]{tileEntityShipCore.shipMass, tileEntityShipCore.shipVolume};
    }

    @Override
    public Object[] movement(Object[] arguments) {
        try {
            if (arguments.length == 3) {
                this.setMovement(Commons.toInt(arguments[0]), Commons.toInt(arguments[1]), Commons.toInt(arguments[2]));
            }
        }
        catch (Exception exception) {
            return new Integer[]{this.moveFront, this.moveUp, this.moveRight};
        }
        return new Integer[]{this.moveFront, this.moveUp, this.moveRight};
    }

    @Override
    public Object[] getMaxJumpDistance() {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return new Object[]{false, "No ship core detected"};
        }
        StringBuilder reason = new StringBuilder();
        int maximumDistance_blocks = tileEntityShipCore.getMaxJumpDistance(this, this.command, reason);
        if (maximumDistance_blocks < 0) {
            return new Object[]{false, reason.toString()};
        }
        return new Object[]{true, maximumDistance_blocks};
    }

    @Override
    public Object[] rotationSteps(Object[] arguments) {
        try {
            if (arguments.length == 1 && arguments[0] != null) {
                this.setRotationSteps((byte)Commons.toInt(arguments[0]));
            }
        }
        catch (Exception exception) {
            return new Integer[]{this.rotationSteps};
        }
        return new Integer[]{this.rotationSteps};
    }

    @Override
    public Object[] targetName(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            this.nameTarget = (String)arguments[0];
        }
        return new Object[]{this.nameTarget};
    }

    @Override
    public Object[] getEnergyRequired() {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return new Object[]{false, "No ship core detected"};
        }
        StringBuilder reason = new StringBuilder();
        int energyRequired = tileEntityShipCore.getEnergyRequired(this, this.command, reason);
        if (energyRequired < 0) {
            return new Object[]{false, reason.toString()};
        }
        return new Object[]{true, energyRequired};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] isAssemblyValid(Context context, Arguments arguments) {
        return this.isAssemblyValid();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getOrientation(Context context, Arguments arguments) {
        return this.getOrientation();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] isInSpace(Context context, Arguments arguments) {
        return this.isInSpace();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] isInHyperspace(Context context, Arguments arguments) {
        return this.isInHyperspace();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] shipName(Context context, Arguments arguments) {
        return this.shipName(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] dim_positive(Context context, Arguments arguments) {
        return this.dim_positive(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] dim_negative(Context context, Arguments arguments) {
        return this.dim_negative(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] energy(Context context, Arguments arguments) {
        return this.energy();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getAttachedPlayers(Context context, Arguments arguments) {
        return this.getAttachedPlayers();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] command(Context context, Arguments arguments) {
        return this.command(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] enable(Context context, Arguments arguments) {
        return this.enable(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getShipSize(Context context, Arguments arguments) {
        return this.getShipSize();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getMaxJumpDistance(Context context, Arguments arguments) {
        return this.getMaxJumpDistance();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] movement(Context context, Arguments arguments) {
        return this.movement(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] rotationSteps(Context context, Arguments arguments) {
        return this.rotationSteps(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] targetName(Context context, Arguments arguments) {
        return this.targetName(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getEnergyRequired(Context context, Arguments arguments) {
        return this.getEnergyRequired();
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName;
        switch (methodName = this.getMethodName(method, arguments)) {
            case "isAssemblyValid": {
                return this.isAssemblyValid();
            }
            case "getOrientation": {
                return this.getOrientation();
            }
            case "isInSpace": {
                return this.isInSpace();
            }
            case "isInHyperspace": {
                return this.isInHyperspace();
            }
            case "shipName": {
                return this.shipName(arguments);
            }
            case "dim_positive": {
                return this.dim_positive(arguments);
            }
            case "dim_negative": {
                return this.dim_negative(arguments);
            }
            case "energy": {
                return this.energy();
            }
            case "getAttachedPlayers": {
                return this.getAttachedPlayers();
            }
            case "command": {
                return this.command(arguments);
            }
            case "enable": {
                return this.enable(arguments);
            }
            case "getShipSize": {
                return this.getShipSize();
            }
            case "getMaxJumpDistance": {
                return this.getMaxJumpDistance();
            }
            case "movement": {
                return this.movement(arguments);
            }
            case "rotationSteps": {
                return this.rotationSteps(arguments);
            }
            case "targetName": {
                return this.targetName(arguments);
            }
            case "getEnergyRequired": {
                return this.getEnergyRequired();
            }
        }
        return super.callMethod(computer, context, method, arguments);
    }

    @Override
    public String toString() {
        TileEntityShipCore tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        return String.format("%s '%s' @ %s (%d %d %d)", this.getClass().getSimpleName(), tileEntityShipCore == null ? "-NULL-" : tileEntityShipCore.shipName, this.field_145850_b == null ? "~NULL~" : this.field_145850_b.field_73011_w.func_80007_l(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

