/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.computer.ITransporterBeacon;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.block.movement.TileEntityTransporterCore;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumStarMapEntryType;
import cr0s.warpdrive.data.EnumTransporterBeaconState;
import cr0s.warpdrive.data.StarMapRegistryItem;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.UUID;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTransporterBeacon
extends TileEntityAbstractEnergy
implements ITransporterBeacon {
    private boolean isEnabled = true;
    private String nameTransporterCore;
    private UUID uuidTransporterCore;
    private int tickDeploying = 0;
    private boolean isActive = false;

    public TileEntityTransporterBeacon() {
        this.IC2_sinkTier = 2;
        this.isEnergyLostWhenBroken = false;
        this.peripheralName = "warpdriveTransporterBeacon";
        this.addMethods(new String[]{"enable", "isActive"});
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
    }

    @Override
    public void func_145845_h() {
        boolean isDeployed;
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean bl = isDeployed = this.tickDeploying > WarpDriveConfig.TRANSPORTER_BEACON_DEPLOYING_DELAY_TICKS;
        if (!isDeployed) {
            ++this.tickDeploying;
        }
        if (!this.isEnabled) {
            this.isActive = false;
        } else {
            boolean isConnected = this.uuidTransporterCore != null && (this.uuidTransporterCore.getLeastSignificantBits() != 0L || this.uuidTransporterCore.getMostSignificantBits() != 0L);
            boolean isPowered = this.energy_consume(WarpDriveConfig.TRANSPORTER_BEACON_ENERGY_PER_TICK, true);
            boolean isActiveNew = false;
            if (isPowered) {
                if (isConnected) {
                    isActiveNew = this.pingTransporter();
                    if (isActiveNew) {
                        this.energy_consume(WarpDriveConfig.TRANSPORTER_BEACON_ENERGY_PER_TICK, false);
                    }
                } else {
                    this.energy_consume(WarpDriveConfig.TRANSPORTER_BEACON_ENERGY_PER_TICK, false);
                }
            }
            this.isActive = isActiveNew;
        }
        EnumTransporterBeaconState enumTransporterBeaconState = isDeployed ? (this.isActive ? EnumTransporterBeaconState.DEPLOYED_ACTIVE : EnumTransporterBeaconState.DEPLOYED_INACTIVE) : (this.isActive ? EnumTransporterBeaconState.PACKED_ACTIVE : EnumTransporterBeaconState.PACKED_INACTIVE);
        int metadataNew = enumTransporterBeaconState.getMetadata();
        this.updateMetadata(metadataNew);
    }

    private boolean pingTransporter() {
        StarMapRegistryItem starMapRegistryItem = WarpDrive.starMap.getByUUID(EnumStarMapEntryType.TRANSPORTER, this.uuidTransporterCore);
        if (starMapRegistryItem == null) {
            return false;
        }
        WorldServer worldTransporter = Commons.getOrCreateWorldServer(starMapRegistryItem.dimensionId);
        if (worldTransporter == null) {
            WarpDrive.logger.error(String.format("%s Unable to load dimension %d for transporter with UUID %s", this, starMapRegistryItem.dimensionId, this.uuidTransporterCore));
            return false;
        }
        TileEntity tileEntity = worldTransporter.func_147438_o(starMapRegistryItem.x, starMapRegistryItem.y, starMapRegistryItem.z);
        if (!(tileEntity instanceof TileEntityTransporterCore)) {
            WarpDrive.logger.warn(String.format("%s Transporter has gone missing for %s, found %s", this, starMapRegistryItem, tileEntity));
            return false;
        }
        TileEntityTransporterCore tileEntityTransporterCore = (TileEntityTransporterCore)tileEntity;
        return tileEntityTransporterCore.updateBeacon(this, this.uuidTransporterCore);
    }

    @Override
    public void energizeDone() {
        this.isEnabled = false;
    }

    @Override
    public Boolean[] enable(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            boolean isEnabled_old = this.isEnabled;
            this.isEnabled = Commons.toBool(arguments[0]);
            if (!isEnabled_old && this.isEnabled) {
                this.tickDeploying = 0;
            }
            this.func_70296_d();
        }
        return new Boolean[]{this.isEnabled};
    }

    @Override
    public Boolean[] isActive(Object[] arguments) {
        return new Boolean[]{this.isActive};
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] enable(Context context, Arguments arguments) {
        return this.enable(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] isActive(Context context, Arguments arguments) {
        return this.isActive(this.argumentsOCtoCC(arguments));
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName;
        switch (methodName = this.getMethodName(method)) {
            case "enable": {
                return this.enable(arguments);
            }
            case "isActive": {
                return this.isActive(arguments);
            }
        }
        return super.callMethod(computer, context, method, arguments);
    }

    private String getSignatureStatus() {
        if (this.uuidTransporterCore == null) {
            return StatCollector.func_74837_a((String)"warpdrive.transporter_beacon.status.invalid", (Object[])new Object[0]);
        }
        return StatCollector.func_74837_a((String)"warpdrive.transporter_beacon.status.valid", (Object[])new Object[]{this.nameTransporterCore, this.uuidTransporterCore});
    }

    @Override
    public String getStatus() {
        String strSignatureStatus = this.getSignatureStatus();
        return super.getStatus() + (strSignatureStatus.isEmpty() ? "" : "\n" + strSignatureStatus);
    }

    @Override
    public int energy_getMaxStorage() {
        return WarpDriveConfig.TRANSPORTER_BEACON_MAX_ENERGY_STORED;
    }

    @Override
    public boolean energy_canInput(ForgeDirection from) {
        return from == ForgeDirection.DOWN;
    }

    @Override
    public boolean energy_canOutput(ForgeDirection to) {
        return false;
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        if (this.uuidTransporterCore != null) {
            tagCompound.func_74778_a("name", this.nameTransporterCore);
            tagCompound.func_74772_a("uuidMost", this.uuidTransporterCore.getMostSignificantBits());
            tagCompound.func_74772_a("uuidLeast", this.uuidTransporterCore.getLeastSignificantBits());
        }
        tagCompound.func_74757_a("isEnabled", this.isEnabled);
        tagCompound.func_74768_a("tickDeploying", this.tickDeploying);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.nameTransporterCore = tagCompound.func_74779_i("name");
        this.uuidTransporterCore = new UUID(tagCompound.func_74763_f("uuidMost"), tagCompound.func_74763_f("uuidLeast"));
        if (this.uuidTransporterCore.getMostSignificantBits() == 0L && this.uuidTransporterCore.getLeastSignificantBits() == 0L) {
            this.uuidTransporterCore = null;
            this.nameTransporterCore = "";
        }
        this.isEnabled = !tagCompound.func_74764_b("isEnabled") || tagCompound.func_74767_n("isEnabled");
        this.tickDeploying = tagCompound.func_74762_e("tickDeploying");
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        tagCompound = super.writeItemDropNBT(tagCompound);
        tagCompound.func_82580_o("tickDeploying");
        return tagCompound;
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tagCompound = packet.func_148857_g();
        this.func_145839_a(tagCompound);
    }

    @Override
    public String toString() {
        return String.format("%s @ %s (%d %d %d) %8d EU linked to %s %s", this.getClass().getSimpleName(), this.field_145850_b == null ? "~NULL~" : this.field_145850_b.field_73011_w.func_80007_l(), this.field_145851_c, this.field_145848_d, this.field_145849_e, this.energy_getEnergyStored(), this.nameTransporterCore, this.uuidTransporterCore);
    }
}

