/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.command;

import cpw.mods.fml.common.registry.GameRegistry;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CommandDump
extends CommandBase {
    public int func_82362_a() {
        return 2;
    }

    public String func_71517_b() {
        return "wdump";
    }

    public void func_71515_b(ICommandSender commandSender, String[] args) {
        if (commandSender == null) {
            return;
        }
        World world = commandSender.func_130014_f_();
        ChunkCoordinates coordinates = commandSender.func_82114_b();
        if (world == null || coordinates == null) {
            Commons.addChatMessage(commandSender, "* wdump: unknown world or coordinates, probably an invalid command sender in action here.");
            return;
        }
        int x = coordinates.field_71574_a;
        int y = coordinates.field_71572_b;
        int z = coordinates.field_71573_c;
        if (args.length != 0) {
            Commons.addChatMessage(commandSender, this.func_71518_a(commandSender));
            return;
        }
        IInventory inventory = null;
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            inventory = this.getInventory(world, x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ);
            if (inventory == null) continue;
            x += direction.offsetX;
            y += direction.offsetY;
            z += direction.offsetZ;
            break;
        }
        if (inventory == null) {
            Commons.addChatMessage(commandSender, "\u00c2\u00a7c/wdump: no container found around player");
            return;
        }
        WarpDrive.logger.info(String.format("Dumping content from container @ %s (%d %d %d):", world.field_73011_w.func_80007_l(), x, y, z));
        for (int indexSlot = 0; indexSlot < inventory.func_70302_i_(); ++indexSlot) {
            ItemStack itemStack = inventory.func_70301_a(indexSlot);
            if (itemStack == null) continue;
            GameRegistry.UniqueIdentifier uniqueIdentifier = GameRegistry.findUniqueIdentifierFor((Item)itemStack.func_77973_b());
            String stringDamage = itemStack.func_77960_j() == 0 ? "" : String.format(" damage=\"%d\"", itemStack.func_77960_j());
            String stringNBT = !itemStack.func_77942_o() ? "" : String.format(" nbt=\"%s\"", itemStack.func_77978_p());
            WarpDrive.logger.info(String.format("Slot %3d is <loot item=\"%s:%s\"%s minQuantity=\"%d\" minQuantity=\"%d\"%s weight=\"1\" /><!-- %s -->", indexSlot, uniqueIdentifier.modId, uniqueIdentifier.name, stringDamage, itemStack.field_77994_a, itemStack.field_77994_a, stringNBT, itemStack.func_82833_r()));
        }
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/wdump: write loot table in console for item container below or next to player";
    }

    private IInventory getInventory(World world, int x, int y, int z) {
        TileEntity tileEntity;
        int metadata;
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof ITileEntityProvider && block.hasTileEntity(metadata = world.func_72805_g(x, y, z)) && (tileEntity = world.func_147438_o(x, y, z)) instanceof IInventory && ((IInventory)tileEntity).func_70302_i_() > 0) {
            return (IInventory)tileEntity;
        }
        return null;
    }
}

