/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import am2.api.power.IPowerNode;
import am2.power.PowerNodeRegistry;
import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class CompatArsMagica2
implements IBlockTransformer {
    private static Class<?> classBlockInscriptionTable;
    private static Class<?> classBlockKeystoneReceptacle;
    private static Class<?> classBlockLectern;
    private static Class<?> classBlockMagiciansWorkbench;
    private static Class<?> classBlockOcculus;
    private static final int[] mrotInscriptionTable;
    private static final int[] mrotKeystoneReceptacle;
    private static final int[] mrotLectern;

    public static void register() {
        try {
            classBlockInscriptionTable = Class.forName("am2.blocks.BlockInscriptionTable");
            classBlockKeystoneReceptacle = Class.forName("am2.blocks.BlockKeystoneReceptacle");
            classBlockLectern = Class.forName("am2.blocks.BlockLectern");
            classBlockMagiciansWorkbench = Class.forName("am2.blocks.BlockMagiciansWorkbench");
            classBlockOcculus = Class.forName("am2.blocks.BlockOcculus");
            WarpDriveConfig.registerBlockTransformer("arsmagica2", new CompatArsMagica2());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockInscriptionTable.isInstance(block) || classBlockKeystoneReceptacle.isInstance(block) || classBlockLectern.isInstance(block) || classBlockMagiciansWorkbench.isInstance(block) || classBlockOcculus.isInstance(block) || tileEntity instanceof IPowerNode;
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    @Optional.Method(modid="arsmagica2")
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        if (tileEntity instanceof IPowerNode) {
            return PowerNodeRegistry.For((World)tileEntity.func_145831_w()).getDataCompoundForNode((IPowerNode)tileEntity);
        }
        return null;
    }

    @Override
    @Optional.Method(modid="arsmagica2")
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        if (tileEntity instanceof IPowerNode) {
            PowerNodeRegistry.For((World)tileEntity.func_145831_w()).removePowerNode((IPowerNode)tileEntity);
        }
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return metadata;
        }
        if (classBlockInscriptionTable.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotInscriptionTable[metadata];
                }
                case 2: {
                    return mrotInscriptionTable[mrotInscriptionTable[metadata]];
                }
                case 3: {
                    return mrotInscriptionTable[mrotInscriptionTable[mrotInscriptionTable[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockKeystoneReceptacle.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotKeystoneReceptacle[metadata];
                }
                case 2: {
                    return mrotKeystoneReceptacle[mrotKeystoneReceptacle[metadata]];
                }
                case 3: {
                    return mrotKeystoneReceptacle[mrotKeystoneReceptacle[mrotKeystoneReceptacle[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockLectern.isInstance(block) || classBlockMagiciansWorkbench.isInstance(block) || classBlockOcculus.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotLectern[metadata];
                }
                case 2: {
                    return mrotLectern[mrotLectern[metadata]];
                }
                case 3: {
                    return mrotLectern[mrotLectern[mrotLectern[metadata]]];
                }
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    @Optional.Method(modid="arsmagica2")
    public void restoreExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
        if (!(tileEntity instanceof IPowerNode) || nbtBase == null) {
            return;
        }
        NBTTagCompound tagCompound = (NBTTagCompound)nbtBase;
        NBTTagList powerPathList = tagCompound.func_150295_c("powerPathList", 10);
        if (powerPathList != null) {
            for (int powerPathIndex = 0; powerPathIndex < powerPathList.func_74745_c(); ++powerPathIndex) {
                NBTTagCompound powerPathEntry = (NBTTagCompound)powerPathList.func_74744_a(0);
                NBTTagList nodePaths = powerPathEntry.func_150295_c("nodePaths", 9);
                if (nodePaths != null) {
                    for (int nodePathIndex = 0; nodePathIndex < nodePaths.func_74745_c(); ++nodePathIndex) {
                        NBTTagList nodeList = (NBTTagList)nodePaths.func_74744_a(0);
                        if (nodeList == null) continue;
                        for (int nodeIndex = 0; nodeIndex < nodeList.func_74745_c(); ++nodeIndex) {
                            NBTTagCompound node = (NBTTagCompound)nodeList.func_74744_a(0);
                            Vec3 target = transformation.apply(node.func_74760_g("Vec3_x"), node.func_74760_g("Vec3_y"), node.func_74760_g("Vec3_z"));
                            node.func_74776_a("Vec3_x", (float)target.field_72450_a);
                            node.func_74776_a("Vec3_y", (float)target.field_72448_b);
                            node.func_74776_a("Vec3_z", (float)target.field_72449_c);
                            nodeList.func_74742_a((NBTBase)node);
                        }
                        nodePaths.func_74742_a((NBTBase)nodeList);
                    }
                    powerPathEntry.func_74782_a("nodePaths", (NBTBase)nodePaths);
                }
                powerPathList.func_74742_a((NBTBase)powerPathEntry);
            }
            tagCompound.func_74782_a("powerPathList", (NBTBase)powerPathList);
        }
        World targetWorld = transformation.getTargetWorld();
        ChunkCoordinates target = transformation.apply(tileEntity);
        TileEntity tileEntityTarget = targetWorld.func_147438_o(target.field_71574_a, target.field_71572_b, target.field_71573_c);
        if (tileEntityTarget == null) {
            WarpDrive.logger.error("ArsMagica2 compat: No tile entity found at target location " + target + ". We might loose mana network " + nbtBase + ".");
        } else if (!(tileEntityTarget instanceof IPowerNode)) {
            WarpDrive.logger.error("ArsMagica2 compat: invalid tile entity " + tileEntityTarget + " found at target location " + target + ".");
        } else {
            PowerNodeRegistry.For((World)targetWorld).setDataCompoundForNode((IPowerNode)tileEntityTarget, tagCompound);
        }
    }

    static {
        mrotInscriptionTable = new int[]{0, 4, 1, 2, 3, 5, 6, 7, 8, 12, 9, 10, 11, 13, 14, 15};
        mrotKeystoneReceptacle = new int[]{3, 0, 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        mrotLectern = new int[]{0, 4, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

