/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CompatCustomNpcs
implements IBlockTransformer {
    private static Class<?> classBlockBlood;
    private static Class<?> classBlockBorder;
    private static Class<?> classBlockCarpentryBench;
    private static Class<?> classBlockMailbox;
    private static Class<?> classTileColorable;
    private static Class<?> classTileBigSign;
    private static final int[] mrot4;
    private static final int[] mrot8;

    public static void register() {
        try {
            classBlockBlood = Class.forName("noppes.npcs.blocks.BlockBlood");
            classBlockBorder = Class.forName("noppes.npcs.blocks.BlockBorder");
            classBlockCarpentryBench = Class.forName("noppes.npcs.blocks.BlockCarpentryBench");
            classBlockMailbox = Class.forName("noppes.npcs.blocks.BlockMailbox");
            classTileColorable = Class.forName("noppes.npcs.blocks.tiles.TileColorable");
            classTileBigSign = Class.forName("noppes.npcs.blocks.tiles.TileBigSign");
            WarpDriveConfig.registerBlockTransformer("CustomNpcs", new CompatCustomNpcs());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockBlood.isInstance(block) || classBlockBorder.isInstance(block) || classBlockCarpentryBench.isInstance(block) || classBlockMailbox.isInstance(block) || classTileColorable.isInstance(tileEntity) || classTileBigSign.isInstance(tileEntity);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return metadata;
        }
        if (classBlockBlood.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrot4[metadata];
                }
                case 2: {
                    return mrot4[mrot4[metadata]];
                }
                case 3: {
                    return mrot4[mrot4[mrot4[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockCarpentryBench.isInstance(block) || classBlockMailbox.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrot8[metadata];
                }
                case 2: {
                    return mrot8[mrot8[metadata]];
                }
                case 3: {
                    return mrot8[mrot8[mrot8[metadata]]];
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("BannerRotation")) {
            int BannerRotation = nbtTileEntity.func_74762_e("BannerRotation");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("BannerRotation", mrot4[BannerRotation]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("BannerRotation", mrot4[mrot4[BannerRotation]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("BannerRotation", mrot4[mrot4[mrot4[BannerRotation]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("BorderRotation")) {
            int BorderRotation = nbtTileEntity.func_74762_e("BorderRotation");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("BorderRotation", mrot4[BorderRotation]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("BorderRotation", mrot4[mrot4[BorderRotation]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("BorderRotation", mrot4[mrot4[mrot4[BorderRotation]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("SignRotation")) {
            int SignRotation = nbtTileEntity.func_74762_e("SignRotation");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("SignRotation", mrot4[SignRotation]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("SignRotation", mrot4[mrot4[SignRotation]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("SignRotation", mrot4[mrot4[mrot4[SignRotation]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrot4 = new int[]{1, 2, 3, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        mrot8 = new int[]{1, 2, 3, 0, 5, 6, 7, 4, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

