/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class CompatDraconicEvolution
implements IBlockTransformer {
    private static Class<?> classBlockBlockDE;
    private static Class<?> classBlockDraconiumBlock;
    private static Class<?> classBlockGenerator;
    private static Class<?> classBlockTeleporterStand;
    private static Class<?> classBlockPlacedItem;
    private static final int[] rotRotation;
    private static final int[] rotGenerator;

    public static void register() {
        try {
            classBlockBlockDE = Class.forName("com.brandon3055.draconicevolution.common.blocks.BlockDE");
            classBlockDraconiumBlock = Class.forName("com.brandon3055.draconicevolution.common.blocks.DraconiumBlock");
            classBlockGenerator = Class.forName("com.brandon3055.draconicevolution.common.blocks.machine.Generator");
            classBlockPlacedItem = Class.forName("com.brandon3055.draconicevolution.common.blocks.PlacedItem");
            classBlockTeleporterStand = Class.forName("com.brandon3055.draconicevolution.common.blocks.TeleporterStand");
            WarpDriveConfig.registerBlockTransformer("DraconicEvolution", new CompatDraconicEvolution());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockBlockDE.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        if (classBlockDraconiumBlock.isInstance(block) && metadata == 1) {
            reason.append("Ender resurrection anchor detected!");
            return false;
        }
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        int countCores;
        NBTTagList stabilizers;
        ChunkCoordinates targetLink;
        int countLinks;
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0 && nbtTileEntity == null) {
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("facing")) {
            int facing = nbtTileEntity.func_74762_e("facing");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("facing", rotRotation[facing]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("facing", rotRotation[rotRotation[facing]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("facing", rotRotation[rotRotation[rotRotation[facing]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        if (classBlockGenerator.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return rotGenerator[metadata];
                }
                case 2: {
                    return rotGenerator[rotGenerator[metadata]];
                }
                case 3: {
                    return rotGenerator[rotGenerator[rotGenerator[metadata]]];
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("Facing")) {
            int facing = nbtTileEntity.func_74762_e("Facing");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("Facing", rotRotation[facing]);
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("Facing", rotRotation[rotRotation[facing]]);
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("Facing", rotRotation[rotRotation[rotRotation[facing]]]);
                    break;
                }
            }
        }
        if (nbtTileEntity.func_74764_b("LinkCount") && (countLinks = nbtTileEntity.func_74762_e("LinkCount")) > 0) {
            for (int indexLink = 0; indexLink < countLinks; ++indexLink) {
                targetLink = transformation.apply(nbtTileEntity.func_74762_e(String.format("X_LinkedDevice_%d", indexLink)), nbtTileEntity.func_74762_e(String.format("Y_LinkedDevice_%d", indexLink)), nbtTileEntity.func_74762_e(String.format("Z_LinkedDevice_%d", indexLink)));
                nbtTileEntity.func_74768_a(String.format("X_LinkedDevice_%d", indexLink), targetLink.field_71574_a);
                nbtTileEntity.func_74768_a(String.format("Y_LinkedDevice_%d", indexLink), targetLink.field_71572_b);
                nbtTileEntity.func_74768_a(String.format("Z_LinkedDevice_%d", indexLink), targetLink.field_71573_c);
            }
        }
        if (nbtTileEntity.func_74764_b("X_Master")) {
            ChunkCoordinates targetLink2 = transformation.apply(nbtTileEntity.func_74762_e("X_Master"), nbtTileEntity.func_74762_e("Y_Master"), nbtTileEntity.func_74762_e("Z_Master"));
            nbtTileEntity.func_74768_a("X_Master", targetLink2.field_71574_a);
            nbtTileEntity.func_74768_a("Y_Master", targetLink2.field_71572_b);
            nbtTileEntity.func_74768_a("Z_Master", targetLink2.field_71573_c);
        }
        if (nbtTileEntity.func_74764_b("X_Key")) {
            ChunkCoordinates targetLink3 = transformation.apply(nbtTileEntity.func_74762_e("X_Key"), nbtTileEntity.func_74762_e("Y_Key"), nbtTileEntity.func_74762_e("Z_Key"));
            nbtTileEntity.func_74768_a("X_Key", targetLink3.field_71574_a);
            nbtTileEntity.func_74768_a("Y_Key", targetLink3.field_71572_b);
            nbtTileEntity.func_74768_a("Z_Key", targetLink3.field_71573_c);
        }
        if (nbtTileEntity.func_74764_b("Stabilizers") && (stabilizers = nbtTileEntity.func_150295_c("Stabilizers", 10)) != null) {
            for (int nodeIndex = 0; nodeIndex < stabilizers.func_74745_c(); ++nodeIndex) {
                NBTTagCompound stabilizer = (NBTTagCompound)stabilizers.func_74744_a(0);
                ChunkCoordinates target = transformation.apply(stabilizer.func_74762_e("X_tag"), stabilizer.func_74762_e("Y_tag"), stabilizer.func_74762_e("Z_tag"));
                stabilizer.func_74768_a("X_tag", target.field_71574_a);
                stabilizer.func_74768_a("Y_tag", target.field_71572_b);
                stabilizer.func_74768_a("Z_tag", target.field_71573_c);
                stabilizers.func_74742_a((NBTBase)stabilizer);
            }
        }
        if (nbtTileEntity.func_74764_b("Cores") && (countCores = nbtTileEntity.func_74762_e("Cores")) > 0) {
            for (int indexCore = 0; indexCore < countCores; ++indexCore) {
                targetLink = transformation.apply(nbtTileEntity.func_74762_e(String.format("X_Core%d", indexCore)), nbtTileEntity.func_74762_e(String.format("Y_Core%d", indexCore)), nbtTileEntity.func_74762_e(String.format("Z_Core%d", indexCore)));
                nbtTileEntity.func_74768_a(String.format("X_Core%d", indexCore), targetLink.field_71574_a);
                nbtTileEntity.func_74768_a(String.format("Y_Core%d", indexCore), targetLink.field_71572_b);
                nbtTileEntity.func_74768_a(String.format("Z_Core%d", indexCore), targetLink.field_71573_c);
            }
        }
        if (nbtTileEntity.func_74764_b("X_0")) {
            ChunkCoordinates targetLink4 = transformation.apply(nbtTileEntity.func_74762_e("X_0"), nbtTileEntity.func_74762_e("Y_0"), nbtTileEntity.func_74762_e("Z_0"));
            nbtTileEntity.func_74768_a("X_0", targetLink4.field_71574_a);
            nbtTileEntity.func_74768_a("Y_0", targetLink4.field_71572_b);
            nbtTileEntity.func_74768_a("Z_0", targetLink4.field_71573_c);
        }
        if (nbtTileEntity.func_74764_b("X_1")) {
            ChunkCoordinates targetLink5 = transformation.apply(nbtTileEntity.func_74762_e("X_1"), nbtTileEntity.func_74762_e("Y_1"), nbtTileEntity.func_74762_e("Z_1"));
            nbtTileEntity.func_74768_a("X_1", targetLink5.field_71574_a);
            nbtTileEntity.func_74768_a("Y_1", targetLink5.field_71572_b);
            nbtTileEntity.func_74768_a("Z_1", targetLink5.field_71573_c);
        }
        if (nbtTileEntity.func_74764_b("X_2")) {
            ChunkCoordinates targetLink6 = transformation.apply(nbtTileEntity.func_74762_e("X_2"), nbtTileEntity.func_74762_e("Y_2"), nbtTileEntity.func_74762_e("Z_2"));
            nbtTileEntity.func_74768_a("X_2", targetLink6.field_71574_a);
            nbtTileEntity.func_74768_a("Y_2", targetLink6.field_71572_b);
            nbtTileEntity.func_74768_a("Z_2", targetLink6.field_71573_c);
        }
        if (nbtTileEntity.func_74764_b("X_3")) {
            ChunkCoordinates targetLink7 = transformation.apply(nbtTileEntity.func_74762_e("X_3"), nbtTileEntity.func_74762_e("Y_3"), nbtTileEntity.func_74762_e("Z_3"));
            nbtTileEntity.func_74768_a("X_3", targetLink7.field_71574_a);
            nbtTileEntity.func_74768_a("Y_3", targetLink7.field_71572_b);
            nbtTileEntity.func_74768_a("Z_3", targetLink7.field_71573_c);
        }
        if (classBlockPlacedItem.isInstance(block)) {
            if (rotationSteps > 0) {
                if (metadata == 0) {
                    float rotation = nbtTileEntity.func_74762_e("Rotation");
                    nbtTileEntity.func_74776_a("Rotation", (rotation + (float)rotationSteps * 90.0f) % 360.0f);
                } else if (metadata == 1) {
                    float rotation = nbtTileEntity.func_74762_e("Rotation");
                    nbtTileEntity.func_74776_a("Rotation", (rotation + (float)rotationSteps * 270.0f) % 360.0f);
                }
            }
            switch (rotationSteps) {
                case 1: {
                    return rotRotation[metadata];
                }
                case 2: {
                    return rotRotation[rotRotation[metadata]];
                }
                case 3: {
                    return rotRotation[rotRotation[rotRotation[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockTeleporterStand.isInstance(block)) {
            if (rotationSteps > 0) {
                float rotation = nbtTileEntity.func_74762_e("Rotation");
                nbtTileEntity.func_74776_a("Rotation", (rotation + (float)rotationSteps * 90.0f) % 360.0f);
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotRotation = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotGenerator = new int[]{1, 2, 3, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

