/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class CompatImmersiveEngineering
implements IBlockTransformer {
    private static Class<?> classTileEntityIEBase;

    public static void register() {
        try {
            classTileEntityIEBase = Class.forName("blusunrize.immersiveengineering.common.blocks.TileEntityIEBase");
            WarpDriveConfig.registerBlockTransformer("ImmersiveEngineering", new CompatImmersiveEngineering());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return tileEntity instanceof IImmersiveConnectable || classTileEntityIEBase.isInstance(tileEntity);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    @Optional.Method(modid="ImmersiveEngineering")
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        if (tileEntity instanceof IImmersiveConnectable) {
            ChunkCoordinates node = new ChunkCoordinates(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
            Set connections = ImmersiveNetHandler.INSTANCE.getConnections(tileEntity.func_145831_w(), node);
            if (connections != null) {
                NBTTagList nbtImmersiveEngineering = new NBTTagList();
                for (ImmersiveNetHandler.Connection connection : connections) {
                    nbtImmersiveEngineering.func_74742_a((NBTBase)connection.writeToNBT());
                }
                ImmersiveNetHandler.INSTANCE.clearConnectionsOriginatingFrom(node, tileEntity.func_145831_w());
                return nbtImmersiveEngineering;
            }
        }
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0 || !nbtTileEntity.func_74764_b("facing")) {
            return metadata;
        }
        int facing = nbtTileEntity.func_74762_e("facing");
        int[] mrot = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        switch (rotationSteps) {
            case 1: {
                nbtTileEntity.func_74768_a("facing", mrot[facing]);
                return metadata;
            }
            case 2: {
                nbtTileEntity.func_74768_a("facing", mrot[mrot[facing]]);
                return metadata;
            }
            case 3: {
                nbtTileEntity.func_74768_a("facing", mrot[mrot[mrot[facing]]]);
                return metadata;
            }
        }
        return metadata;
    }

    @Override
    @Optional.Method(modid="ImmersiveEngineering")
    public void restoreExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
        NBTTagList nbtImmersiveEngineering = (NBTTagList)nbtBase;
        if (nbtImmersiveEngineering == null) {
            return;
        }
        World targetWorld = transformation.getTargetWorld();
        for (int indexConnectionToAdd = 0; indexConnectionToAdd < nbtImmersiveEngineering.func_74745_c(); ++indexConnectionToAdd) {
            ImmersiveNetHandler.Connection connectionToAdd = ImmersiveNetHandler.Connection.readFromNBT((NBTTagCompound)nbtImmersiveEngineering.func_150305_b(indexConnectionToAdd));
            connectionToAdd.start = transformation.apply(connectionToAdd.start);
            connectionToAdd.end = transformation.apply(connectionToAdd.end);
            ChunkCoordinates node = new ChunkCoordinates(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
            Set connectionActuals = ImmersiveNetHandler.INSTANCE.getConnections(tileEntity.func_145831_w(), node);
            boolean existing = false;
            if (connectionActuals != null) {
                for (ImmersiveNetHandler.Connection connectionActual : connectionActuals) {
                    if (connectionActual.start.field_71574_a == connectionToAdd.start.field_71574_a && connectionActual.start.field_71572_b == connectionToAdd.start.field_71572_b && connectionActual.start.field_71573_c == connectionToAdd.start.field_71573_c && connectionActual.end.field_71574_a == connectionToAdd.end.field_71574_a && connectionActual.end.field_71572_b == connectionToAdd.end.field_71572_b && connectionActual.end.field_71573_c == connectionToAdd.end.field_71573_c) {
                        existing = true;
                        break;
                    }
                    if (connectionActual.start.field_71574_a != connectionToAdd.end.field_71574_a || connectionActual.start.field_71572_b != connectionToAdd.end.field_71572_b || connectionActual.start.field_71573_c != connectionToAdd.end.field_71573_c || connectionActual.end.field_71574_a != connectionToAdd.start.field_71574_a || connectionActual.end.field_71572_b != connectionToAdd.start.field_71572_b || connectionActual.end.field_71573_c != connectionToAdd.start.field_71573_c) continue;
                    existing = true;
                    break;
                }
            }
            if (existing) continue;
            ImmersiveNetHandler.INSTANCE.addConnection(targetWorld, new ChunkCoordinates(connectionToAdd.start.field_71574_a, connectionToAdd.start.field_71572_b, connectionToAdd.start.field_71573_c), connectionToAdd);
        }
    }
}

