/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CompatOpenComputers
implements IBlockTransformer {
    private static Class<?> classTileEntityRotatable;

    public static void register() {
        try {
            classTileEntityRotatable = Class.forName("li.cil.oc.common.tileentity.traits.Rotatable");
            WarpDriveConfig.registerBlockTransformer("OpenComputers", new CompatOpenComputers());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classTileEntityRotatable.isInstance(tileEntity);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0 || !nbtTileEntity.func_74764_b("oc:yaw")) {
            return metadata;
        }
        int facing = nbtTileEntity.func_74762_e("oc:yaw");
        int[] mrot = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        switch (rotationSteps) {
            case 1: {
                nbtTileEntity.func_74768_a("oc:yaw", mrot[facing]);
                return metadata;
            }
            case 2: {
                nbtTileEntity.func_74768_a("oc:yaw", mrot[mrot[facing]]);
                return metadata;
            }
            case 3: {
                nbtTileEntity.func_74768_a("oc:yaw", mrot[mrot[mrot[facing]]]);
                return metadata;
            }
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }
}

