/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class CompatPneumaticCraft
implements IBlockTransformer {
    private static Class<?> classTileEntityBase;
    private static final byte[] mrotForgeDirection;
    private static final byte[] mrotTextRotation;
    private static final byte[] mrotDoor;

    public static void register() {
        try {
            classTileEntityBase = Class.forName("pneumaticCraft.common.tileentity.TileEntityBase");
            WarpDriveConfig.registerBlockTransformer("PneumaticCraft", new CompatPneumaticCraft());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classTileEntityBase.isInstance(tileEntity);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0 && !nbtTileEntity.func_74764_b("valveX") && !nbtTileEntity.func_74764_b("multiBlockX")) {
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("inputDir")) {
            int inputDir = nbtTileEntity.func_74762_e("inputDir");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("inputDir", (int)mrotForgeDirection[inputDir]);
                    return mrotForgeDirection[metadata];
                }
                case 2: {
                    nbtTileEntity.func_74768_a("inputDir", (int)mrotForgeDirection[mrotForgeDirection[inputDir]]);
                    return mrotForgeDirection[mrotForgeDirection[metadata]];
                }
                case 3: {
                    nbtTileEntity.func_74768_a("inputDir", (int)mrotForgeDirection[mrotForgeDirection[mrotForgeDirection[inputDir]]]);
                    return mrotForgeDirection[mrotForgeDirection[mrotForgeDirection[metadata]]];
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("textRotation")) {
            int textRotation = nbtTileEntity.func_74762_e("textRotation");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("textRotation", (int)mrotTextRotation[textRotation]);
                    return mrotForgeDirection[metadata];
                }
                case 2: {
                    nbtTileEntity.func_74768_a("textRotation", (int)mrotTextRotation[mrotTextRotation[textRotation]]);
                    return mrotForgeDirection[mrotForgeDirection[metadata]];
                }
                case 3: {
                    nbtTileEntity.func_74768_a("textRotation", (int)mrotTextRotation[mrotTextRotation[mrotTextRotation[textRotation]]]);
                    return mrotForgeDirection[mrotForgeDirection[mrotForgeDirection[metadata]]];
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("orientation")) {
            int orientation = nbtTileEntity.func_74762_e("orientation");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("orientation", (int)mrotTextRotation[orientation]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("orientation", (int)mrotTextRotation[mrotTextRotation[orientation]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("orientation", (int)mrotTextRotation[mrotTextRotation[mrotTextRotation[orientation]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74779_i("id").equals("TileEntityPneumaticDoor")) {
            switch (rotationSteps) {
                case 1: {
                    return mrotDoor[metadata];
                }
                case 2: {
                    return mrotDoor[mrotDoor[metadata]];
                }
                case 3: {
                    return mrotDoor[mrotDoor[mrotDoor[metadata]]];
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("valveX")) {
            ChunkCoordinates target = transformation.apply(nbtTileEntity.func_74762_e("valveX"), nbtTileEntity.func_74762_e("valveY"), nbtTileEntity.func_74762_e("valveZ"));
            nbtTileEntity.func_74768_a("valveX", target.field_71574_a);
            nbtTileEntity.func_74768_a("valveY", target.field_71572_b);
            nbtTileEntity.func_74768_a("valveZ", target.field_71573_c);
        }
        if (nbtTileEntity.func_74764_b("multiBlockX")) {
            ChunkCoordinates sourceMin = new ChunkCoordinates(nbtTileEntity.func_74762_e("multiBlockX"), nbtTileEntity.func_74762_e("multiBlockY"), nbtTileEntity.func_74762_e("multiBlockZ"));
            int multiBlockSize = nbtTileEntity.func_74762_e("multiBlockSize");
            ChunkCoordinates sourceMax = new ChunkCoordinates(sourceMin.field_71574_a + multiBlockSize - 1, sourceMin.field_71572_b + multiBlockSize - 1, sourceMin.field_71573_c + multiBlockSize - 1);
            ChunkCoordinates target1 = transformation.apply(sourceMin);
            ChunkCoordinates target2 = transformation.apply(sourceMax);
            nbtTileEntity.func_74768_a("multiBlockX", Math.min(target1.field_71574_a, target2.field_71574_a));
            nbtTileEntity.func_74768_a("multiBlockY", Math.min(target1.field_71572_b, target2.field_71572_b));
            nbtTileEntity.func_74768_a("multiBlockZ", Math.min(target1.field_71573_c, target2.field_71573_c));
            NBTTagList tagListOld = nbtTileEntity.func_150295_c("Valves", 10);
            NBTTagList tagListNew = new NBTTagList();
            for (int index = 0; index < tagListOld.func_74745_c(); ++index) {
                NBTTagCompound tagCompound = tagListOld.func_150305_b(index);
                if (tagCompound == null) continue;
                ChunkCoordinates coordinates = transformation.apply(tagCompound.func_74762_e("xCoord"), tagCompound.func_74762_e("yCoord"), tagCompound.func_74762_e("zCoord"));
                tagCompound.func_74768_a("xCoord", coordinates.field_71574_a);
                tagCompound.func_74768_a("yCoord", coordinates.field_71572_b);
                tagCompound.func_74768_a("zCoord", coordinates.field_71573_c);
                tagListNew.func_74742_a((NBTBase)tagCompound);
            }
            nbtTileEntity.func_74782_a("Valves", (NBTBase)tagListNew);
        }
        switch (rotationSteps) {
            case 1: {
                return mrotForgeDirection[metadata];
            }
            case 2: {
                return mrotForgeDirection[mrotForgeDirection[metadata]];
            }
            case 3: {
                return mrotForgeDirection[mrotForgeDirection[mrotForgeDirection[metadata]]];
            }
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrotForgeDirection = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        mrotTextRotation = new byte[]{1, 2, 3, 0};
        mrotDoor = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 11, 10, 8, 9, 12, 13, 14, 15};
    }
}

