/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class CompatTechguns
implements IBlockTransformer {
    private static Class<?> classBlockLadder;
    private static Class<?> classBlockLamp;
    private static Class<?> classBlockBasicMachine;
    private static Class<?> classBlockMultiBlockMachineBlock;
    private static final int[] mrotLadder;
    private static final int[] mrotLamp;
    private static final byte[] rotBasicMachine;
    private static final byte[] orientExplosiveCharge;
    private static final byte[] rotExplosiveCharge;

    public static void register() {
        try {
            classBlockLadder = Class.forName("techguns.blocks.BlockTGLadder");
            classBlockLamp = Class.forName("techguns.blocks.BlockTGLamp");
            classBlockBasicMachine = Class.forName("techguns.blocks.machines.BasicMachine");
            classBlockMultiBlockMachineBlock = Class.forName("techguns.blocks.machines.MultiBlockMachineBlock");
            WarpDriveConfig.registerBlockTransformer("Techguns", new CompatTechguns());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockLadder.isInstance(block) || classBlockLamp.isInstance(block) || classBlockBasicMachine.isInstance(block) || classBlockMultiBlockMachineBlock.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    private static byte rotRepairCamoBench(byte value) {
        switch (value) {
            case 1: {
                return 0;
            }
            case 0: {
                return -1;
            }
            case -1: {
                return -2;
            }
            case -2: {
                return 1;
            }
        }
        return value;
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (classBlockLadder.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotLadder[metadata];
                }
                case 2: {
                    return mrotLadder[mrotLadder[metadata]];
                }
                case 3: {
                    return mrotLadder[mrotLadder[mrotLadder[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockLamp.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotLamp[metadata];
                }
                case 2: {
                    return mrotLamp[mrotLamp[metadata]];
                }
                case 3: {
                    return mrotLamp[mrotLamp[mrotLamp[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockBasicMachine.isInstance(block)) {
            switch (metadata) {
                case 0: 
                case 1: 
                case 4: 
                case 9: {
                    if (!nbtTileEntity.func_74764_b("rotation")) break;
                    byte rotation = nbtTileEntity.func_74771_c("rotation");
                    switch (rotationSteps) {
                        case 1: {
                            nbtTileEntity.func_74774_a("rotation", rotBasicMachine[rotation]);
                            return metadata;
                        }
                        case 2: {
                            nbtTileEntity.func_74774_a("rotation", rotBasicMachine[rotBasicMachine[rotation]]);
                            return metadata;
                        }
                        case 3: {
                            nbtTileEntity.func_74774_a("rotation", rotBasicMachine[rotBasicMachine[rotBasicMachine[rotation]]]);
                            return metadata;
                        }
                    }
                    return metadata;
                }
                case 2: {
                    return metadata;
                }
                case 3: 
                case 5: {
                    if (!nbtTileEntity.func_74764_b("rotation")) break;
                    byte rotation = nbtTileEntity.func_74771_c("rotation");
                    switch (rotationSteps) {
                        case 1: {
                            nbtTileEntity.func_74774_a("rotation", CompatTechguns.rotRepairCamoBench(rotation));
                            return metadata;
                        }
                        case 2: {
                            nbtTileEntity.func_74774_a("rotation", CompatTechguns.rotRepairCamoBench(CompatTechguns.rotRepairCamoBench(rotation)));
                            return metadata;
                        }
                        case 3: {
                            nbtTileEntity.func_74774_a("rotation", CompatTechguns.rotRepairCamoBench(CompatTechguns.rotRepairCamoBench(CompatTechguns.rotRepairCamoBench(rotation))));
                            return metadata;
                        }
                    }
                    return metadata;
                }
                case 6: 
                case 8: {
                    if (!nbtTileEntity.func_74764_b("orientation")) break;
                    byte orientation = nbtTileEntity.func_74771_c("orientation");
                    byte rotation = nbtTileEntity.func_74771_c("rotation");
                    if (orientation == 0 || orientation == 1) {
                        return metadata;
                    }
                    switch (rotationSteps) {
                        case 1: {
                            nbtTileEntity.func_74774_a("orientation", orientExplosiveCharge[orientation]);
                            nbtTileEntity.func_74774_a("rotation", rotExplosiveCharge[rotation]);
                            return metadata;
                        }
                        case 2: {
                            nbtTileEntity.func_74774_a("orientation", orientExplosiveCharge[orientExplosiveCharge[orientation]]);
                            nbtTileEntity.func_74774_a("rotation", rotExplosiveCharge[rotExplosiveCharge[rotation]]);
                            return metadata;
                        }
                        case 3: {
                            nbtTileEntity.func_74774_a("orientation", orientExplosiveCharge[orientExplosiveCharge[orientExplosiveCharge[orientation]]]);
                            nbtTileEntity.func_74774_a("rotation", rotExplosiveCharge[rotExplosiveCharge[rotExplosiveCharge[rotation]]]);
                            return metadata;
                        }
                    }
                    return metadata;
                }
                default: {
                    return metadata;
                }
            }
        }
        if (classBlockMultiBlockMachineBlock.isInstance(block) && nbtTileEntity.func_74764_b("hasMaster") && nbtTileEntity.func_74767_n("hasMaster")) {
            int xMaster = nbtTileEntity.func_74762_e("masterX");
            short yMaster = nbtTileEntity.func_74765_d("masterY");
            int zMaster = nbtTileEntity.func_74762_e("masterZ");
            ChunkCoordinates chunkCoordinatesMaster = transformation.apply(xMaster, yMaster, zMaster);
            nbtTileEntity.func_74768_a("masterX", chunkCoordinatesMaster.field_71574_a);
            nbtTileEntity.func_74768_a("masterY", chunkCoordinatesMaster.field_71572_b);
            nbtTileEntity.func_74768_a("masterZ", chunkCoordinatesMaster.field_71573_c);
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrotLadder = new int[]{3, 2, 0, 1, 7, 6, 4, 5, 11, 10, 8, 9, 15, 14, 12, 13};
        mrotLamp = new int[]{0, 1, 2, 6, 5, 3, 4, 7, 8, 9, 10, 14, 13, 11, 12, 15};
        rotBasicMachine = new byte[]{1, 2, 3, 0, 5, 3, 4, 7, 8, 9, 10, 14, 13, 11, 12, 15};
        orientExplosiveCharge = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotExplosiveCharge = new byte[]{3, 2, 0, 1, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

