/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CompatThermalDynamics
implements IBlockTransformer {
    private static Class<?> blockTDBase;
    private static final Map<String, String> rotConAttachmentNames;

    public static void register() {
        try {
            blockTDBase = Class.forName("cofh.thermaldynamics.block.BlockTDBase");
            WarpDriveConfig.registerBlockTransformer("ThermalDynamics", new CompatThermalDynamics());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return blockTDBase.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0 || nbtTileEntity == null) {
            return metadata;
        }
        HashMap<String, NBTBase> mapRotated = new HashMap<String, NBTBase>(9);
        block5: for (String string : rotConAttachmentNames.keySet()) {
            if (!nbtTileEntity.func_74764_b(string)) continue;
            NBTBase nbtBase = nbtTileEntity.func_74781_a(string);
            nbtTileEntity.func_82580_o(string);
            switch (rotationSteps) {
                case 1: {
                    mapRotated.put(rotConAttachmentNames.get(string), nbtBase);
                    continue block5;
                }
                case 2: {
                    mapRotated.put(rotConAttachmentNames.get(rotConAttachmentNames.get(string)), nbtBase);
                    continue block5;
                }
                case 3: {
                    mapRotated.put(rotConAttachmentNames.get(rotConAttachmentNames.get(rotConAttachmentNames.get(string))), nbtBase);
                    continue block5;
                }
            }
            mapRotated.put(string, nbtBase);
        }
        for (Map.Entry entry : mapRotated.entrySet()) {
            nbtTileEntity.func_74782_a((String)entry.getKey(), (NBTBase)entry.getValue());
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("attachment2", "attachment5");
        map.put("attachment5", "attachment3");
        map.put("attachment3", "attachment4");
        map.put("attachment4", "attachment2");
        map.put("conTypes2", "conTypes5");
        map.put("conTypes5", "conTypes3");
        map.put("conTypes3", "conTypes4");
        map.put("conTypes4", "conTypes2");
        map.put("facade2", "facade5");
        map.put("facade5", "facade3");
        map.put("facade3", "facade4");
        map.put("facade4", "facade2");
        rotConAttachmentNames = Collections.unmodifiableMap(map);
    }
}

