/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.block.BlockAbstractBase;
import cr0s.warpdrive.block.BlockAbstractContainer;
import cr0s.warpdrive.block.breathing.BlockAirFlow;
import cr0s.warpdrive.block.breathing.BlockAirGeneratorTiered;
import cr0s.warpdrive.block.breathing.BlockAirSource;
import cr0s.warpdrive.block.detection.BlockMonitor;
import cr0s.warpdrive.block.energy.TileEntityEnergyBank;
import cr0s.warpdrive.block.forcefield.BlockForceFieldProjector;
import cr0s.warpdrive.block.hull.BlockHullSlab;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.ChunkData;
import cr0s.warpdrive.data.StateAir;
import cr0s.warpdrive.event.ChunkHandler;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CompatWarpDrive
implements IBlockTransformer {
    private static final short[] mrotDirection = new short[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final short[] mrotHullSlab = new short[]{0, 1, 5, 4, 2, 3, 6, 7, 11, 10, 8, 9, 12, 13, 15, 14};
    private static final byte[] rotFacing = new byte[]{0, 1, 5, 4, 2, 3, 6, 7};

    public static void register() {
        WarpDriveConfig.registerBlockTransformer("WarpDrive", new CompatWarpDrive());
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return block instanceof BlockHullSlab || block instanceof BlockAbstractBase || block instanceof BlockAbstractContainer || tileEntity instanceof TileEntityEnergyBank;
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        if (block instanceof BlockAirFlow || block instanceof BlockAirSource) {
            ChunkData chunkData = ChunkHandler.getChunkData(world, x, y, z);
            if (chunkData == null) {
                return null;
            }
            int dataAir = chunkData.getDataAir(x, y, z);
            if (dataAir == 0x60000C0) {
                return null;
            }
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("dataAir", dataAir);
            return tagCompound;
        }
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        if (block instanceof BlockAirFlow || block instanceof BlockAirSource) {
            ChunkData chunkData = ChunkHandler.getChunkData(world, x, y, z);
            if (chunkData == null) {
                return;
            }
            chunkData.setDataAir(x, y, z, 0x60000C0);
        }
    }

    private byte[] rotate_byteArray(byte rotationSteps, byte[] data) {
        byte[] newData = (byte[])data.clone();
        block5: for (int index = 0; index < data.length; ++index) {
            switch (rotationSteps) {
                case 1: {
                    newData[CompatWarpDrive.mrotDirection[index]] = data[index];
                    continue block5;
                }
                case 2: {
                    newData[CompatWarpDrive.mrotDirection[CompatWarpDrive.mrotDirection[index]]] = data[index];
                    continue block5;
                }
                case 3: {
                    newData[CompatWarpDrive.mrotDirection[CompatWarpDrive.mrotDirection[CompatWarpDrive.mrotDirection[index]]]] = data[index];
                    continue block5;
                }
            }
        }
        return newData;
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (block instanceof BlockHullSlab) {
            switch (rotationSteps) {
                case 1: {
                    return mrotHullSlab[metadata];
                }
                case 2: {
                    return mrotHullSlab[mrotHullSlab[metadata]];
                }
                case 3: {
                    return mrotHullSlab[mrotHullSlab[mrotHullSlab[metadata]]];
                }
            }
            return metadata;
        }
        if (block instanceof BlockMonitor) {
            switch (rotationSteps) {
                case 1: {
                    return mrotDirection[metadata];
                }
                case 2: {
                    return mrotDirection[mrotDirection[metadata]];
                }
                case 3: {
                    return mrotDirection[mrotDirection[mrotDirection[metadata]]];
                }
            }
            return metadata;
        }
        if (block instanceof BlockAirGeneratorTiered || block instanceof BlockForceFieldProjector) {
            switch (rotationSteps) {
                case 1: {
                    return mrotDirection[metadata & 7] | metadata & 8;
                }
                case 2: {
                    return mrotDirection[mrotDirection[metadata & 7]] | metadata & 8;
                }
                case 3: {
                    return mrotDirection[mrotDirection[mrotDirection[metadata & 7]]] | metadata & 8;
                }
            }
            return metadata;
        }
        if (nbtTileEntity != null && nbtTileEntity.func_74764_b("facing")) {
            short facing = nbtTileEntity.func_74771_c("facing");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74774_a("facing", rotFacing[facing]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74774_a("facing", rotFacing[rotFacing[facing]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74774_a("facing", rotFacing[rotFacing[rotFacing[facing]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        if (nbtTileEntity != null && nbtTileEntity.func_74764_b("modeSide")) {
            nbtTileEntity.func_74773_a("modeSide", this.rotate_byteArray(rotationSteps, nbtTileEntity.func_74770_j("modeSide")));
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
        if (nbtBase == null) {
            return;
        }
        if (!(nbtBase instanceof NBTTagCompound)) {
            return;
        }
        if (((NBTTagCompound)nbtBase).func_74764_b("dataAir")) {
            byte rotationSteps = transformation.getRotationSteps();
            int dataAir = ((NBTTagCompound)nbtBase).func_74762_e("dataAir");
            ChunkData chunkData = ChunkHandler.getChunkData(world, x, y, z);
            if (chunkData == null) {
                return;
            }
            int dataAirRotated = StateAir.rotate(dataAir, rotationSteps);
            chunkData.setDataAir(x, y, z, dataAirRotated);
        }
    }
}

