/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IXmlRepresentable;
import cr0s.warpdrive.api.IXmlRepresentableUnit;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.XmlFileManager;
import cr0s.warpdrive.config.XmlRandomCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import org.w3c.dom.Element;

public class GenericSet<E extends IXmlRepresentableUnit>
implements IXmlRepresentable,
Comparable {
    protected String group;
    protected String name;
    private E unitDefault;
    private String nameElementUnit;
    private XmlRandomCollection<E> units;
    private ArrayList<String> importGroupNames;
    private ArrayList<String> importGroups;

    public String getFullName() {
        return this.group + ":" + this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public GenericSet(String group, String name, E unitDefault, String nameElementUnit) {
        this.group = group;
        this.name = name;
        this.unitDefault = unitDefault;
        this.nameElementUnit = nameElementUnit;
        this.units = new XmlRandomCollection();
        this.importGroupNames = new ArrayList();
        this.importGroups = new ArrayList();
    }

    public boolean isEmpty() {
        return this.units.isEmpty();
    }

    public E getRandomUnit(Random random) {
        IXmlRepresentableUnit unit = (IXmlRepresentableUnit)this.units.getRandomEntry(random);
        if (unit == null) {
            WarpDrive.logger.error(String.format("null %s encountered in set %s", this.nameElementUnit, this.getFullName()));
            unit = this.unitDefault;
        }
        return (E)unit;
    }

    @Override
    public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
        List<Element> listChildren = XmlFileManager.getChildrenElementByTagName(element, this.nameElementUnit);
        for (Element elementChild : listChildren) {
            IXmlRepresentableUnit unit = this.unitDefault.constructor();
            this.units.loadFromXML(unit, elementChild);
        }
        List<Element> listImports = XmlFileManager.getChildrenElementByTagName(element, "import");
        if (!listImports.isEmpty()) {
            for (Element elementImport : listImports) {
                String importGroup = elementImport.getAttribute("group");
                String importName = elementImport.getAttribute("name");
                if (!importGroup.isEmpty()) {
                    if (!importName.isEmpty()) {
                        this.importGroupNames.add(importGroup + ":" + importName);
                        continue;
                    }
                    this.importGroups.add(importGroup);
                    continue;
                }
                WarpDrive.logger.warn("Ignoring import with no group definition in import element from " + this.getFullName());
            }
        }
        return true;
    }

    public int compareTo(@Nonnull Object object) {
        return this.name.compareTo(((GenericSet)object).name);
    }

    public String toString() {
        return this.getFullName() + "(" + (this.units == null ? "-empty-" : Integer.valueOf(this.units.elements().size())) + ")";
    }

    public void loadFrom(GenericSet<E> genericSet) throws InvalidXmlException {
        this.units.loadFrom(genericSet.units);
    }

    public Collection<String> getImportGroupNames() {
        return this.importGroupNames;
    }

    public Collection<String> getImportGroups() {
        return this.importGroups;
    }
}

