/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IXmlRepresentableUnit;
import cr0s.warpdrive.config.InvalidXmlException;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import org.w3c.dom.Element;

public class Loot
implements IXmlRepresentableUnit {
    public static final Loot DEFAULT = new Loot();
    private String name;
    public Item item;
    public int damage;
    public NBTTagCompound tagCompound = null;
    public int quantityMin;
    public int quantityMax;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
        if (!element.hasAttribute("item")) {
            throw new InvalidXmlException("Loot " + element + " is missing an item attribute!");
        }
        String nameItem = element.getAttribute("item");
        this.item = (Item)Item.field_150901_e.func_82594_a(nameItem);
        if (this.item == null) {
            WarpDrive.logger.warn("Skipping missing item " + nameItem);
            return false;
        }
        this.damage = 0;
        String stringDamage = element.getAttribute("damage");
        if (!stringDamage.isEmpty()) {
            try {
                this.damage = Integer.parseInt(stringDamage);
            }
            catch (NumberFormatException exception) {
                throw new InvalidXmlException("Invalid damage for item " + nameItem);
            }
        }
        this.tagCompound = null;
        String stringNBT = element.getAttribute("nbt");
        if (!stringNBT.isEmpty()) {
            try {
                this.tagCompound = (NBTTagCompound)JsonToNBT.func_150315_a((String)stringNBT);
            }
            catch (NBTException exception) {
                throw new InvalidXmlException("Invalid nbt for item " + nameItem);
            }
        }
        this.quantityMin = 1;
        String stringQuantityMin = element.getAttribute("minQuantity");
        if (!stringQuantityMin.isEmpty()) {
            try {
                this.quantityMin = Integer.parseInt(stringQuantityMin);
            }
            catch (NumberFormatException exception) {
                throw new InvalidXmlException("Invalid minQuantity for item " + nameItem);
            }
        }
        this.quantityMax = 1;
        String stringQuantityMax = element.getAttribute("maxQuantity");
        if (!stringQuantityMax.isEmpty()) {
            try {
                this.quantityMax = Integer.parseInt(stringQuantityMax);
            }
            catch (NumberFormatException exception) {
                throw new InvalidXmlException("Invalid maxQuantity for item " + nameItem);
            }
        }
        this.name = nameItem + "@" + this.damage + "{" + this.tagCompound + "}";
        return true;
    }

    public ItemStack getItemStack(Random rand) {
        int quantity = this.quantityMin + (this.quantityMax > this.quantityMin ? rand.nextInt(this.quantityMax - this.quantityMin) : 0);
        ItemStack itemStack = new ItemStack(this.item, quantity, this.damage);
        if (this.tagCompound != null) {
            NBTTagCompound tagCompoundNew = (NBTTagCompound)this.tagCompound.func_74737_b();
            itemStack.func_77982_d(tagCompoundNew);
        }
        return itemStack;
    }

    @Override
    public IXmlRepresentableUnit constructor() {
        return new Loot();
    }

    public boolean equals(Object object) {
        return !(!(object instanceof Loot) || this.item != null && !this.item.equals(((Loot)object).item) || this.damage != ((Loot)object).damage || this.tagCompound != null && !this.tagCompound.equals((Object)((Loot)object).tagCompound));
    }

    public String toString() {
        return "Loot(" + this.item.func_77658_a() + "@" + this.damage + ")";
    }

    public int hashCode() {
        return Item.func_150891_b((Item)this.item) * 16 + this.damage + (this.tagCompound == null ? 0 : this.tagCompound.hashCode() * 32768 * 16);
    }

    static {
        Loot.DEFAULT.name = "-default-";
        Loot.DEFAULT.item = Items.field_151055_y;
        Loot.DEFAULT.damage = 0;
        Loot.DEFAULT.tagCompound = null;
        Loot.DEFAULT.quantityMin = 0;
        Loot.DEFAULT.quantityMax = 0;
    }
}

