/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config;

import cpw.mods.fml.common.registry.GameRegistry;
import cr0s.warpdrive.api.IParticleContainerItem;
import cr0s.warpdrive.api.ParticleStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class RecipeParticleShapedOre
implements IRecipe {
    private static final int MAX_CRAFT_GRID_WIDTH = 3;
    private static final int MAX_CRAFT_GRID_HEIGHT = 3;
    private ItemStack itemStackResult = null;
    private Object[] itemStackIngredients = null;
    private int width = 0;
    private int height = 0;
    private boolean isMirrored = true;

    public RecipeParticleShapedOre(Block result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public RecipeParticleShapedOre(Item result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public RecipeParticleShapedOre(ItemStack result, Object ... recipe) {
        this.itemStackResult = result.func_77946_l();
        String shape = "";
        int indexRecipe = 0;
        if (recipe[indexRecipe] instanceof Boolean) {
            this.isMirrored = (Boolean)recipe[indexRecipe];
            if (recipe[indexRecipe + 1] instanceof Object[]) {
                recipe = (Object[])recipe[indexRecipe + 1];
            } else {
                indexRecipe = 1;
            }
        }
        if (recipe[indexRecipe] instanceof String[]) {
            String[] stringRecipeLines = (String[])recipe[indexRecipe++];
            for (String stringRecipeLine : stringRecipeLines) {
                this.width = stringRecipeLine.length();
                shape = shape + (String)stringRecipeLine;
            }
            this.height = stringRecipeLines.length;
        } else {
            while (recipe[indexRecipe] instanceof String) {
                String stringRecipeLine = (String)recipe[indexRecipe++];
                shape = shape + stringRecipeLine;
                this.width = stringRecipeLine.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String stringMessage = "Invalid shaped ore recipe: ";
            for (Object objectIngredient : recipe) {
                stringMessage = stringMessage + objectIngredient + ", ";
            }
            stringMessage = stringMessage + this.itemStackResult;
            throw new RuntimeException(stringMessage);
        }
        HashMap<Character, Object> mapInputs = new HashMap<Character, Object>();
        while (indexRecipe < recipe.length) {
            Character character = (Character)recipe[indexRecipe];
            Object object = recipe[indexRecipe + 1];
            if (object instanceof ItemStack) {
                mapInputs.put(character, ((ItemStack)object).func_77946_l());
            } else if (object instanceof Item) {
                mapInputs.put(character, new ItemStack((Item)object));
            } else if (object instanceof Block) {
                mapInputs.put(character, new ItemStack((Block)object, 1, Short.MAX_VALUE));
            } else if (object instanceof String) {
                mapInputs.put(character, OreDictionary.getOres((String)((String)object)));
            } else {
                String stringMessage = "Invalid shaped ore recipe: ";
                for (Object objectIngredient : recipe) {
                    stringMessage = stringMessage + objectIngredient + ", ";
                }
                stringMessage = stringMessage + this.itemStackResult;
                throw new RuntimeException(stringMessage);
            }
            indexRecipe += 2;
        }
        this.itemStackIngredients = new Object[this.width * this.height];
        int indexSlot = 0;
        for (char chr : shape.toCharArray()) {
            this.itemStackIngredients[indexSlot++] = mapInputs.get(Character.valueOf(chr));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result, recipe));
    }

    RecipeParticleShapedOre(ShapedRecipes recipe, Map<ItemStack, String> replacements) {
        this.itemStackResult = recipe.func_77571_b();
        this.width = recipe.field_77576_b;
        this.height = recipe.field_77577_c;
        this.itemStackIngredients = new Object[recipe.field_77574_d.length];
        block0: for (int i = 0; i < this.itemStackIngredients.length; ++i) {
            ItemStack itemStackIngredient = recipe.field_77574_d[i];
            if (itemStackIngredient == null) continue;
            this.itemStackIngredients[i] = recipe.field_77574_d[i];
            for (Map.Entry<ItemStack, String> entry : replacements.entrySet()) {
                if (!OreDictionary.itemMatches((ItemStack)entry.getKey(), (ItemStack)itemStackIngredient, (boolean)true)) continue;
                this.itemStackIngredients[i] = OreDictionary.getOres((String)entry.getValue());
                continue block0;
            }
        }
    }

    public ItemStack func_77572_b(InventoryCrafting inventoryCrafting) {
        return this.itemStackResult.func_77946_l();
    }

    public int func_77570_a() {
        return this.itemStackIngredients.length;
    }

    public ItemStack func_77571_b() {
        return this.itemStackResult;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.isMirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting inventoryCrafting, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.itemStackIngredients[this.width - subX - 1 + subY * this.width] : this.itemStackIngredients[subX + subY * this.width];
                }
                ItemStack itemStackSlot = inventoryCrafting.func_70463_b(x, y);
                if (target instanceof ItemStack) {
                    if (itemStackSlot != null && itemStackSlot.func_77942_o() && itemStackSlot.func_77973_b() instanceof IParticleContainerItem && ((ItemStack)target).func_77973_b() instanceof IParticleContainerItem) {
                        IParticleContainerItem particleContainerItemTarget;
                        ParticleStack particleStackTarget;
                        IParticleContainerItem particleContainerItemSlot = (IParticleContainerItem)itemStackSlot.func_77973_b();
                        ParticleStack particleStackSlot = particleContainerItemSlot.getParticleStack(itemStackSlot);
                        if (!particleStackSlot.containsParticle(particleStackTarget = (particleContainerItemTarget = (IParticleContainerItem)((ItemStack)target).func_77973_b()).getParticleStack((ItemStack)target))) {
                            return false;
                        }
                        particleContainerItemSlot.setAmountToConsume(itemStackSlot, particleStackTarget.getAmount());
                        continue;
                    }
                    if (OreDictionary.itemMatches((ItemStack)((ItemStack)target), (ItemStack)itemStackSlot, (boolean)false)) continue;
                    return false;
                }
                if (target instanceof ArrayList) {
                    boolean matched = false;
                    Iterator iterator = ((ArrayList)target).iterator();
                    while (iterator.hasNext() && !matched) {
                        matched = OreDictionary.itemMatches((ItemStack)((ItemStack)iterator.next()), (ItemStack)itemStackSlot, (boolean)false);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || itemStackSlot == null) continue;
                return false;
            }
        }
        return true;
    }

    public RecipeParticleShapedOre setMirrored(boolean isMirrored) {
        this.isMirrored = isMirrored;
        return this;
    }

    public Object[] getIngredients() {
        return this.itemStackIngredients;
    }

    @Deprecated
    public Object[] getInput() {
        return this.itemStackIngredients;
    }
}

