/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.compat.CompatAdvancedRepulsionSystems;
import cr0s.warpdrive.compat.CompatAppliedEnergistics2;
import cr0s.warpdrive.compat.CompatArsMagica2;
import cr0s.warpdrive.compat.CompatBiblioCraft;
import cr0s.warpdrive.compat.CompatBotania;
import cr0s.warpdrive.compat.CompatBuildCraft;
import cr0s.warpdrive.compat.CompatCarpentersBlocks;
import cr0s.warpdrive.compat.CompatComputerCraft;
import cr0s.warpdrive.compat.CompatCustomNpcs;
import cr0s.warpdrive.compat.CompatDraconicEvolution;
import cr0s.warpdrive.compat.CompatEnderIO;
import cr0s.warpdrive.compat.CompatEvilCraft;
import cr0s.warpdrive.compat.CompatForgeMultipart;
import cr0s.warpdrive.compat.CompatImmersiveEngineering;
import cr0s.warpdrive.compat.CompatIndustrialCraft2;
import cr0s.warpdrive.compat.CompatJABBA;
import cr0s.warpdrive.compat.CompatMekanism;
import cr0s.warpdrive.compat.CompatMetallurgy;
import cr0s.warpdrive.compat.CompatNatura;
import cr0s.warpdrive.compat.CompatOpenComputers;
import cr0s.warpdrive.compat.CompatParziStarWars;
import cr0s.warpdrive.compat.CompatPneumaticCraft;
import cr0s.warpdrive.compat.CompatRedstonePaste;
import cr0s.warpdrive.compat.CompatSGCraft;
import cr0s.warpdrive.compat.CompatStargateTech2;
import cr0s.warpdrive.compat.CompatTConstruct;
import cr0s.warpdrive.compat.CompatTechguns;
import cr0s.warpdrive.compat.CompatThaumcraft;
import cr0s.warpdrive.compat.CompatThermalDynamics;
import cr0s.warpdrive.compat.CompatThermalExpansion;
import cr0s.warpdrive.compat.CompatWarpDrive;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.Filler;
import cr0s.warpdrive.config.GenericSetManager;
import cr0s.warpdrive.config.Loot;
import cr0s.warpdrive.config.ShipMovementCosts;
import cr0s.warpdrive.config.structures.StructureManager;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.EnumDisplayAlignment;
import cr0s.warpdrive.data.EnumShipMovementType;
import cr0s.warpdrive.data.EnumTooltipCondition;
import cr0s.warpdrive.network.PacketHandler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.oredict.OreDictionary;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class WarpDriveConfig {
    private static final boolean unused = false;
    private static String stringConfigDirectory;
    private static File configDirectory;
    private static DocumentBuilder xmlDocumentBuilder;
    private static final String[] defaultXML_fillers;
    private static final String[] defaultXML_loots;
    private static final String[] defaultXML_structures;
    private static final String[] defaultXML_celestialObjects;
    public static GenericSetManager<Filler> FillerManager;
    public static GenericSetManager<Loot> LootManager;
    public static boolean isAdvancedRepulsionSystemLoaded;
    public static boolean isAdvancedSolarPanelLoaded;
    public static boolean isCoFHCoreLoaded;
    public static boolean isComputerCraftLoaded;
    public static boolean isDefenseTechLoaded;
    public static boolean isEnderIOLoaded;
    public static boolean isForgeMultipartLoaded;
    public static boolean isGregTech5Loaded;
    public static boolean isGregTech6Loaded;
    public static boolean isICBMClassicLoaded;
    public static boolean isICBMLoaded;
    public static boolean isImmersiveEngineeringLoaded;
    public static boolean isIndustrialCraft2Loaded;
    public static boolean isNotEnoughItemsLoaded;
    public static boolean isOpenComputersLoaded;
    public static boolean isThermalExpansionLoaded;
    public static ItemStack IC2_compressedAir;
    public static ItemStack IC2_emptyCell;
    public static Block IC2_rubberWood;
    public static ItemStack IC2_Resin;
    public static Block CC_Computer;
    public static Block CC_peripheral;
    public static Block CCT_Turtle;
    public static Block CCT_Expanded;
    public static Block CCT_Advanced;
    public static int G_SPACE_BIOME_ID;
    public static int G_SPACE_PROVIDER_ID;
    public static int G_HYPERSPACE_PROVIDER_ID;
    public static int G_ENTITY_SPHERE_GENERATOR_ID;
    public static int G_ENTITY_STAR_CORE_ID;
    public static int G_ENTITY_CAMERA_ID;
    public static int G_ENTITY_PARTICLE_BUNCH_ID;
    public static final int LUA_SCRIPTS_NONE = 0;
    public static final int LUA_SCRIPTS_TEMPLATES = 1;
    public static final int LUA_SCRIPTS_ALL = 2;
    public static int G_LUA_SCRIPTS;
    public static String G_SCHEMALOCATION;
    public static int G_BLOCKS_PER_TICK;
    public static boolean G_ENABLE_PROTECTION_CHECKS;
    public static float CLIENT_LOCATION_SCALE;
    public static String CLIENT_LOCATION_FORMAT_TITLE;
    public static int CLIENT_LOCATION_BACKGROUND_COLOR;
    public static int CLIENT_LOCATION_TEXT_COLOR;
    public static boolean CLIENT_LOCATION_HAS_SHADOW;
    public static EnumDisplayAlignment CLIENT_LOCATION_SCREEN_ALIGNMENT;
    public static int CLIENT_LOCATION_SCREEN_OFFSET_X;
    public static int CLIENT_LOCATION_SCREEN_OFFSET_Y;
    public static EnumDisplayAlignment CLIENT_LOCATION_TEXT_ALIGNMENT;
    public static float CLIENT_LOCATION_WIDTH_RATIO;
    public static int CLIENT_LOCATION_WIDTH_MIN;
    public static EnumTooltipCondition CLIENT_TOOLTIP_REGISTRY_NAME;
    public static EnumTooltipCondition CLIENT_TOOLTIP_ORE_DICTIONARY_NAME;
    public static EnumTooltipCondition CLIENT_TOOLTIP_ARMOR;
    public static EnumTooltipCondition CLIENT_TOOLTIP_BURN_TIME;
    public static EnumTooltipCondition CLIENT_TOOLTIP_DURABILITY;
    public static EnumTooltipCondition CLIENT_TOOLTIP_FLAMMABILITY;
    public static EnumTooltipCondition CLIENT_TOOLTIP_FLUID;
    public static EnumTooltipCondition CLIENT_TOOLTIP_HARDNESS;
    public static EnumTooltipCondition CLIENT_TOOLTIP_HARVESTING;
    public static EnumTooltipCondition CLIENT_TOOLTIP_OPACITY;
    public static EnumTooltipCondition CLIENT_TOOLTIP_REPAIR_WITH;
    public static boolean LOGGING_JUMP;
    public static boolean LOGGING_JUMPBLOCKS;
    public static boolean LOGGING_ENERGY;
    public static boolean LOGGING_EFFECTS;
    public static boolean LOGGING_CLOAKING;
    public static boolean LOGGING_VIDEO_CHANNEL;
    public static boolean LOGGING_TARGETING;
    public static boolean LOGGING_WEAPON;
    public static boolean LOGGING_CAMERA;
    public static boolean LOGGING_BUILDING;
    public static boolean LOGGING_COLLECTION;
    public static boolean LOGGING_TRANSPORTER;
    public static boolean LOGGING_LUA;
    public static boolean LOGGING_RADAR;
    public static boolean LOGGING_BREATHING;
    public static boolean LOGGING_WORLD_GENERATION;
    public static boolean LOGGING_PROFILING_CPU_USAGE;
    public static boolean LOGGING_PROFILING_MEMORY_ALLOCATION;
    public static boolean LOGGING_PROFILING_THREAD_SAFETY;
    public static boolean LOGGING_DICTIONARY;
    public static boolean LOGGING_STARMAP;
    public static boolean LOGGING_BREAK_PLACE;
    public static boolean LOGGING_FORCEFIELD;
    public static boolean LOGGING_FORCEFIELD_REGISTRY;
    public static boolean LOGGING_ACCELERATOR;
    public static boolean LOGGING_XML_PREPROCESSOR;
    public static boolean LOGGING_RENDERING;
    public static boolean LOGGING_CHUNK_HANDLER;
    public static boolean LOGGING_CHUNK_LOADING;
    public static boolean LOGGING_ENTITY_FX;
    public static boolean LOGGING_CLIENT_SYNCHRONIZATION;
    public static int STARMAP_REGISTRY_UPDATE_INTERVAL_SECONDS;
    public static boolean STARMAP_ALLOW_OVERLAPPING_CELESTIAL_OBJECTS;
    public static int SPACE_GENERATOR_Y_MIN_CENTER;
    public static int SPACE_GENERATOR_Y_MAX_CENTER;
    public static int SPACE_GENERATOR_Y_MIN_BORDER;
    public static int SPACE_GENERATOR_Y_MAX_BORDER;
    public static ShipMovementCosts.Factors[] SHIP_MOVEMENT_COSTS_FACTORS;
    public static int SHIP_MAX_ENERGY_STORED;
    public static int SHIP_TELEPORT_ENERGY_PER_ENTITY;
    public static int SHIP_VOLUME_MAX_ON_PLANET_SURFACE;
    public static int SHIP_VOLUME_MIN_FOR_HYPERSPACE;
    public static int SHIP_MAX_SIDE_SIZE;
    public static int SHIP_COLLISION_TOLERANCE_BLOCKS;
    public static int SHIP_WARMUP_RANDOM_TICKS;
    public static int SHIP_CONTROLLER_UPDATE_INTERVAL_SECONDS;
    public static int SHIP_CORE_ISOLATION_UPDATE_INTERVAL_SECONDS;
    public static int SHIP_VOLUME_SCAN_AGE_TOLERANCE_SECONDS;
    public static String[] SHIP_VOLUME_UNLIMITED_PLAYERNAMES;
    public static int SHIP_SUMMON_MAX_RANGE;
    public static boolean SHIP_SUMMON_ACROSS_DIMENSIONS;
    public static int RADAR_MAX_ENERGY_STORED;
    public static int RADAR_SCAN_MIN_ENERGY_COST;
    public static double[] RADAR_SCAN_ENERGY_COST_FACTORS;
    public static int RADAR_SCAN_MIN_DELAY_SECONDS;
    public static double[] RADAR_SCAN_DELAY_FACTORS_SECONDS;
    public static int RADAR_MAX_ISOLATION_RANGE;
    public static int RADAR_MIN_ISOLATION_BLOCKS;
    public static int RADAR_MAX_ISOLATION_BLOCKS;
    public static double RADAR_MIN_ISOLATION_EFFECT;
    public static double RADAR_MAX_ISOLATION_EFFECT;
    public static int SS_MAX_DEPLOY_RADIUS_BLOCKS;
    public static int SS_SEARCH_INTERVAL_TICKS;
    public static int SS_SCAN_BLOCKS_PER_SECOND;
    public static int SS_DEPLOY_BLOCKS_PER_INTERVAL;
    public static int SS_DEPLOY_INTERVAL_TICKS;
    public static int LASER_MEDIUM_MAX_ENERGY_STORED;
    public static int LASER_CANNON_MAX_MEDIUMS_COUNT;
    public static int LASER_CANNON_MAX_LASER_ENERGY;
    public static int LASER_CANNON_EMIT_FIRE_DELAY_TICKS;
    public static int LASER_CANNON_EMIT_SCAN_DELAY_TICKS;
    public static double LASER_CANNON_BOOSTER_BEAM_ENERGY_EFFICIENCY;
    public static double LASER_CANNON_ENERGY_ATTENUATION_PER_AIR_BLOCK;
    public static double LASER_CANNON_ENERGY_ATTENUATION_PER_VOID_BLOCK;
    public static double LASER_CANNON_ENERGY_ATTENUATION_PER_BROKEN_BLOCK;
    public static int LASER_CANNON_RANGE_MAX;
    public static int LASER_CANNON_ENTITY_HIT_SET_ON_FIRE_SECONDS;
    public static int LASER_CANNON_ENTITY_HIT_ENERGY;
    public static int LASER_CANNON_ENTITY_HIT_BASE_DAMAGE;
    public static int LASER_CANNON_ENTITY_HIT_ENERGY_PER_DAMAGE;
    public static int LASER_CANNON_ENTITY_HIT_MAX_DAMAGE;
    public static int LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_THRESHOLD;
    public static float LASER_CANNON_ENTITY_HIT_EXPLOSION_BASE_STRENGTH;
    public static int LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_PER_STRENGTH;
    public static float LASER_CANNON_ENTITY_HIT_EXPLOSION_MAX_STRENGTH;
    public static int LASER_CANNON_BLOCK_HIT_ENERGY_MIN;
    public static int LASER_CANNON_BLOCK_HIT_ENERGY_PER_BLOCK_HARDNESS;
    public static int LASER_CANNON_BLOCK_HIT_ENERGY_MAX;
    public static double LASER_CANNON_BLOCK_HIT_ABSORPTION_PER_BLOCK_HARDNESS;
    public static double LASER_CANNON_BLOCK_HIT_ABSORPTION_MAX;
    public static float LASER_CANNON_BLOCK_HIT_EXPLOSION_HARDNESS_THRESHOLD;
    public static float LASER_CANNON_BLOCK_HIT_EXPLOSION_BASE_STRENGTH;
    public static int LASER_CANNON_BLOCK_HIT_EXPLOSION_ENERGY_PER_STRENGTH;
    public static float LASER_CANNON_BLOCK_HIT_EXPLOSION_MAX_STRENGTH;
    public static int MINING_LASER_MAX_MEDIUMS_COUNT;
    public static int MINING_LASER_RADIUS_NO_LASER_MEDIUM;
    public static int MINING_LASER_RADIUS_PER_LASER_MEDIUM;
    public static int MINING_LASER_WARMUP_DELAY_TICKS;
    public static int MINING_LASER_SCAN_DELAY_TICKS;
    public static int MINING_LASER_MINE_DELAY_TICKS;
    public static int MINING_LASER_SPACE_ENERGY_PER_LAYER;
    public static int MINING_LASER_PLANET_ENERGY_PER_LAYER;
    public static int MINING_LASER_SPACE_ENERGY_PER_BLOCK;
    public static int MINING_LASER_PLANET_ENERGY_PER_BLOCK;
    public static double MINING_LASER_ORESONLY_ENERGY_FACTOR;
    public static double MINING_LASER_SILKTOUCH_ENERGY_FACTOR;
    public static double MINING_LASER_SILKTOUCH_DEUTERIUM_L;
    public static double MINING_LASER_FORTUNE_ENERGY_FACTOR;
    public static int TREE_FARM_MAX_MEDIUMS_COUNT;
    public static int TREE_FARM_MAX_SCAN_RADIUS_NO_LASER_MEDIUM;
    public static int TREE_FARM_MAX_SCAN_RADIUS_PER_LASER_MEDIUM;
    public static int TREE_FARM_totalMaxRadius;
    public static int TREE_FARM_MAX_LOG_DISTANCE;
    public static int TREE_FARM_MAX_LOG_DISTANCE_PER_MEDIUM;
    public static int CLOAKING_MAX_ENERGY_STORED;
    public static int CLOAKING_COIL_CAPTURE_BLOCKS;
    public static int CLOAKING_MAX_FIELD_RADIUS;
    public static int CLOAKING_TIER1_ENERGY_PER_BLOCK;
    public static int CLOAKING_TIER2_ENERGY_PER_BLOCK;
    public static int CLOAKING_FIELD_REFRESH_INTERVAL_SECONDS;
    public static int BREATHING_ENERGY_PER_CANISTER;
    public static int[] BREATHING_ENERGY_PER_NEW_AIR_BLOCK;
    public static int[] BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK;
    public static int[] BREATHING_MAX_ENERGY_STORED;
    public static int BREATHING_AIR_GENERATION_TICKS;
    public static int[] BREATHING_AIR_GENERATION_RANGE_BLOCKS;
    public static int BREATHING_VOLUME_UPDATE_DEPTH_BLOCKS;
    public static int BREATHING_AIR_SIMULATION_DELAY_TICKS;
    public static final boolean BREATHING_AIR_BLOCK_DEBUG = false;
    public static boolean BREATHING_AIR_AT_ENTITY_DEBUG;
    public static int IC2_REACTOR_MAX_HEAT_STORED;
    public static int IC2_REACTOR_FOCUS_HEAT_TRANSFER_PER_TICK;
    public static int IC2_REACTOR_COMPONENT_HEAT_TRANSFER_PER_TICK;
    public static int IC2_REACTOR_REACTOR_HEAT_TRANSFER_PER_TICK;
    public static int IC2_REACTOR_COOLING_PER_INTERVAL;
    public static double IC2_REACTOR_ENERGY_PER_HEAT;
    public static int IC2_REACTOR_COOLING_INTERVAL_TICKS;
    public static int TRANSPORTER_MAX_ENERGY_STORED;
    public static int TRANSPORTER_ENERGY_STORED_UPGRADE_BONUS;
    public static int TRANSPORTER_ENERGY_STORED_UPGRADE_MAX_QUANTITY;
    public static int TRANSPORTER_SETUP_UPDATE_PARAMETERS_TICKS;
    public static int TRANSPORTER_SETUP_SCANNER_RANGE_XZ_BLOCKS;
    public static int TRANSPORTER_SETUP_SCANNER_RANGE_Y_BELOW_BLOCKS;
    public static int TRANSPORTER_SETUP_SCANNER_RANGE_Y_ABOVE_BLOCKS;
    public static int TRANSPORTER_RANGE_BASE_BLOCKS;
    public static int TRANSPORTER_RANGE_UPGRADE_BLOCKS;
    public static int TRANSPORTER_RANGE_UPGRADE_MAX_QUANTITY;
    public static double[] TRANSPORTER_LOCKING_ENERGY_FACTORS;
    public static double TRANSPORTER_LOCKING_STRENGTH_FACTOR_PER_TICK;
    public static double TRANSPORTER_LOCKING_STRENGTH_IN_WILDERNESS;
    public static double TRANSPORTER_LOCKING_STRENGTH_AT_BEACON;
    public static double TRANSPORTER_LOCKING_STRENGTH_AT_TRANSPORTER;
    public static double TRANSPORTER_LOCKING_STRENGTH_BONUS_AT_MAX_ENERGY_FACTOR;
    public static double TRANSPORTER_LOCKING_STRENGTH_UPGRADE;
    public static double TRANSPORTER_LOCKING_SPEED_IN_WILDERNESS;
    public static double TRANSPORTER_LOCKING_SPEED_AT_BEACON;
    public static double TRANSPORTER_LOCKING_SPEED_AT_TRANSPORTER;
    public static double TRANSPORTER_LOCKING_SPEED_UPGRADE;
    public static int TRANSPORTER_LOCKING_SPEED_OPTIMAL_TICKS;
    public static int TRANSPORTER_LOCKING_UPGRADE_MAX_QUANTITY;
    public static int TRANSPORTER_JAMMED_COOLDOWN_TICKS;
    public static double[] TRANSPORTER_ENERGIZING_ENERGY_FACTORS;
    public static double TRANSPORTER_ENERGIZING_MAX_ENERGY_FACTOR;
    public static int TRANSPORTER_ENERGIZING_FAILURE_MAX_DAMAGE;
    public static double TRANSPORTER_ENERGIZING_SUCCESS_LOCK_BONUS;
    public static int TRANSPORTER_ENERGIZING_SUCCESS_MAX_DAMAGE;
    public static double TRANSPORTER_ENERGIZING_LOCKING_LOST;
    public static int TRANSPORTER_ENERGIZING_CHARGING_TICKS;
    public static int TRANSPORTER_ENERGIZING_COOLDOWN_TICKS;
    public static double TRANSPORTER_ENERGIZING_ENTITY_MOVEMENT_TOLERANCE_BLOCKS;
    public static int TRANSPORTER_ENTITY_GRAB_RADIUS_BLOCKS;
    public static int TRANSPORTER_FOCUS_SEARCH_RADIUS_BLOCKS;
    public static int TRANSPORTER_BEACON_MAX_ENERGY_STORED;
    public static int TRANSPORTER_BEACON_ENERGY_PER_TICK;
    public static int TRANSPORTER_BEACON_DEPLOYING_DELAY_TICKS;
    public static int ENAN_REACTOR_MAX_ENERGY_STORED;
    public static int ENAN_REACTOR_UPDATE_INTERVAL_TICKS;
    public static int ENAN_REACTOR_MAX_LASERS_PER_SECOND;
    public static int[] ENERGY_BANK_MAX_ENERGY_STORED;
    public static int[] ENERGY_BANK_IC2_TIER;
    public static int[] ENERGY_BANK_TRANSFER_PER_TICK;
    public static double[] ENERGY_BANK_EFFICIENCY_PER_UPGRADE;
    public static int LIFT_MAX_ENERGY_STORED;
    public static int LIFT_ENERGY_PER_ENTITY;
    public static int LIFT_UPDATE_INTERVAL_TICKS;
    public static int LIFT_ENTITY_COOLDOWN_TICKS;
    public static int CHUNK_LOADER_MAX_ENERGY_STORED;
    public static int CHUNK_LOADER_MAX_RADIUS;
    public static int CHUNK_LOADER_ENERGY_PER_CHUNK;
    public static float[] HULL_HARDNESS;
    public static float[] HULL_BLAST_RESISTANCE;
    public static HashMap<String, IBlockTransformer> blockTransformers;
    public static boolean ACCELERATOR_ENABLE;
    public static final double[] ACCELERATOR_TEMPERATURES_K;
    public static final double ACCELERATOR_THRESHOLD_DEFAULT = 0.95;
    public static int ACCELERATOR_MAX_PARTICLE_BUNCHES;

    public static Block getModBlock(String mod, String id) {
        try {
            return GameRegistry.findBlock((String)mod, (String)id);
        }
        catch (Exception exception) {
            WarpDrive.logger.info(String.format("Failed to get mod block for %s:%s", mod, id));
            exception.printStackTrace();
            return Blocks.field_150480_ab;
        }
    }

    public static ItemStack getModItemStack(String mod, String id, int meta) {
        ItemStack itemStack = WarpDriveConfig.getModItemStackOrNull(mod, id, meta);
        if (itemStack != null) {
            return itemStack;
        }
        return new ItemStack((Block)Blocks.field_150480_ab);
    }

    public static ItemStack getModItemStack(String mod1, String id1, int meta1, String mod2, String id2, int meta2) {
        ItemStack itemStack = WarpDriveConfig.getModItemStackOrNull(mod1, id1, meta1);
        if (itemStack != null) {
            return itemStack;
        }
        itemStack = WarpDriveConfig.getModItemStackOrNull(mod2, id2, meta2);
        if (itemStack != null) {
            return itemStack;
        }
        return new ItemStack((Block)Blocks.field_150480_ab);
    }

    public static ItemStack getModItemStack(String mod1, String id1, int meta1, String mod2, String id2, int meta2, String mod3, String id3, int meta3) {
        ItemStack itemStack = WarpDriveConfig.getModItemStackOrNull(mod1, id1, meta1);
        if (itemStack != null) {
            return itemStack;
        }
        itemStack = WarpDriveConfig.getModItemStackOrNull(mod2, id2, meta2);
        if (itemStack != null) {
            return itemStack;
        }
        itemStack = WarpDriveConfig.getModItemStackOrNull(mod3, id3, meta3);
        if (itemStack != null) {
            return itemStack;
        }
        return new ItemStack((Block)Blocks.field_150480_ab);
    }

    private static ItemStack getModItemStackOrNull(String mod, String id, int meta) {
        try {
            ItemStack itemStack = new ItemStack((Item)Item.field_150901_e.func_82594_a(mod + ":" + id));
            if (meta != -1) {
                itemStack.func_77964_b(meta);
            }
            return itemStack;
        }
        catch (Exception exception) {
            WarpDrive.logger.info(String.format("Failed to get mod item for %s:%s@%d", mod, id, meta));
            return null;
        }
    }

    public static ItemStack getOreDictionaryEntry(String ore) {
        if (!OreDictionary.doesOreNameExist((String)ore)) {
            WarpDrive.logger.info("Failed to get ore named " + ore);
            return new ItemStack((Block)Blocks.field_150480_ab);
        }
        ArrayList itemStacks = OreDictionary.getOres((String)ore);
        if (itemStacks.isEmpty()) {
            WarpDrive.logger.info(String.format("Failed to get item from empty ore dictionary '%s'", ore));
            return new ItemStack((Block)Blocks.field_150480_ab);
        }
        return (ItemStack)itemStacks.get(0);
    }

    protected static double[] getDoubleList(Configuration config, String category, String key, String comment, double[] valuesDefault) {
        double[] valuesRead = config.get(category, key, valuesDefault, comment).getDoubleList();
        if (valuesRead.length != valuesDefault.length) {
            valuesRead = (double[])valuesDefault.clone();
        }
        return valuesRead;
    }

    public static void reload() {
        CelestialObjectManager.clearForReload(false);
        WarpDriveConfig.onFMLpreInitialization(stringConfigDirectory);
        WarpDriveConfig.onFMLPostInitialization();
        List entityPlayers = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayer entityPlayer : entityPlayers) {
            if (!(entityPlayer instanceof EntityPlayerMP) || entityPlayer instanceof FakePlayer) continue;
            CelestialObject celestialObject = CelestialObjectManager.get(entityPlayer.field_70170_p, MathHelper.func_76128_c((double)entityPlayer.field_70165_t), MathHelper.func_76128_c((double)entityPlayer.field_70161_v));
            PacketHandler.sendClientSync((EntityPlayerMP)entityPlayer, celestialObject);
        }
    }

    public static void onFMLpreInitialization(String stringConfigDirectory) {
        WarpDriveConfig.stringConfigDirectory = stringConfigDirectory;
        configDirectory = new File(stringConfigDirectory, "WarpDrive");
        configDirectory.mkdir();
        if (!configDirectory.isDirectory()) {
            throw new RuntimeException("Unable to create config directory " + configDirectory);
        }
        WarpDriveConfig.unpackResourcesToFolder("filler", ".xml", defaultXML_fillers, "config", configDirectory);
        WarpDriveConfig.unpackResourcesToFolder("loot", ".xml", defaultXML_loots, "config", configDirectory);
        WarpDriveConfig.unpackResourcesToFolder("structures", ".xml", defaultXML_structures, "config", configDirectory);
        WarpDriveConfig.unpackResourcesToFolder("celestialObjects", ".xml", defaultXML_celestialObjects, "config", configDirectory);
        WarpDriveConfig.unpackResourceToFolder("WarpDrive.xsd", "config", configDirectory);
        WarpDriveConfig.loadConfig(new File(configDirectory, "config.yml"));
        WarpDriveConfig.loadDictionary(new File(configDirectory, "dictionary.yml"));
        CelestialObjectManager.load(configDirectory);
        isCoFHCoreLoaded = Loader.isModLoaded((String)"CoFHCore");
        isComputerCraftLoaded = Loader.isModLoaded((String)"ComputerCraft");
        isEnderIOLoaded = Loader.isModLoaded((String)"EnderIO");
        isDefenseTechLoaded = Loader.isModLoaded((String)"DefenseTech");
        isICBMLoaded = Loader.isModLoaded((String)"icbm");
        isGregTech5Loaded = false;
        isGregTech6Loaded = false;
        if (Loader.isModLoaded((String)"gregtech")) {
            String gregTechVersion = FMLCommonHandler.instance().findContainerFor((Object)"gregtech").getVersion();
            isGregTech5Loaded = gregTechVersion.equalsIgnoreCase("MC1710") || gregTechVersion.startsWith("5.");
            isGregTech6Loaded = gregTechVersion.startsWith("GT6-MC1710");
            if (isGregTech5Loaded && isGregTech6Loaded || !isGregTech5Loaded && !isGregTech6Loaded) {
                throw new RuntimeException(String.format("Unsupported gregtech version '%s', please report to mod author", gregTechVersion));
            }
        }
        isIndustrialCraft2Loaded = Loader.isModLoaded((String)"IC2");
        isOpenComputersLoaded = Loader.isModLoaded((String)"OpenComputers");
    }

    public static void loadConfig(File file) {
        Configuration config = new Configuration(file);
        config.load();
        G_SPACE_BIOME_ID = Commons.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "space_biome_id", G_SPACE_BIOME_ID, "Space biome ID").getInt());
        G_SPACE_PROVIDER_ID = Commons.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "space_provider_id", G_SPACE_PROVIDER_ID, "Space dimension provider ID").getInt());
        G_HYPERSPACE_PROVIDER_ID = Commons.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "hyperspace_provider_id", G_HYPERSPACE_PROVIDER_ID, "Hyperspace dimension provider ID").getInt());
        G_ENTITY_SPHERE_GENERATOR_ID = Commons.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "entity_sphere_generator_id", G_ENTITY_SPHERE_GENERATOR_ID, "Entity sphere generator ID").getInt());
        G_ENTITY_STAR_CORE_ID = Commons.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "entity_star_core_id", G_ENTITY_STAR_CORE_ID, "Entity star core ID").getInt());
        G_ENTITY_CAMERA_ID = Commons.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "entity_camera_id", G_ENTITY_CAMERA_ID, "Entity camera ID").getInt());
        G_ENTITY_PARTICLE_BUNCH_ID = Commons.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "entity_particle_bunch_id", G_ENTITY_PARTICLE_BUNCH_ID, "Entity particle bunch ID").getInt());
        G_LUA_SCRIPTS = Commons.clamp(0, 2, config.get("general", "lua_scripts", G_LUA_SCRIPTS, "LUA scripts to load when connecting machines: 0 = none, 1 = templates in a subfolder, 2 = ready to roll (templates are still provided)").getInt());
        G_SCHEMALOCATION = config.get("general", "schematic_location", G_SCHEMALOCATION, "Folder where to save ship schematics").getString();
        G_BLOCKS_PER_TICK = Commons.clamp(100, 100000, config.get("general", "blocks_per_tick", G_BLOCKS_PER_TICK, "Number of blocks to move per ticks, too high will cause lag spikes on ship jumping or deployment, too low may break the ship wirings").getInt());
        G_ENABLE_PROTECTION_CHECKS = config.get("general", "enable_protection_checks", G_ENABLE_PROTECTION_CHECKS, "Enable area protection checks from other mods or plugins, disable if you use the event system exclusively").getBoolean(G_ENABLE_PROTECTION_CHECKS);
        CLIENT_LOCATION_SCALE = Commons.clamp(0.25f, 4.0f, (float)config.get("client", "location_scale", (double)CLIENT_LOCATION_SCALE, "Scale for location text font").getDouble());
        CLIENT_LOCATION_FORMAT_TITLE = config.get("client", "location_prefix", CLIENT_LOCATION_FORMAT_TITLE, "Format for location title").getString();
        String stringValue = config.get("client", "location_background_color", String.format("0x%6X", CLIENT_LOCATION_BACKGROUND_COLOR), "Hexadecimal color code for location tile and description background (0xAARRGGBB where AA is alpha, RR is Red, GG is Green and BB is Blue component)").getString();
        CLIENT_LOCATION_BACKGROUND_COLOR = (int)(Long.decode(stringValue) & 0xFFFFFFFFL);
        stringValue = config.get("client", "location_text_color", String.format("0x%6X", CLIENT_LOCATION_TEXT_COLOR), "Hexadecimal color code for location tile and description foreground (0xAARRGGBB where AA is alpha, RR is Red, GG is Green and BB is Blue component)").getString();
        CLIENT_LOCATION_TEXT_COLOR = (int)(Long.decode(stringValue) & 0xFFFFFFFFL);
        CLIENT_LOCATION_HAS_SHADOW = config.get("client", "location_has_shadow", CLIENT_LOCATION_HAS_SHADOW, "Shadow casting option for current celestial object name").getBoolean(CLIENT_LOCATION_HAS_SHADOW);
        CLIENT_LOCATION_SCREEN_ALIGNMENT = EnumDisplayAlignment.valueOf(config.get("client", "location_screen_alignment", CLIENT_LOCATION_SCREEN_ALIGNMENT.name(), "Alignment on screen: TOP_LEFT, TOP_CENTER, TOP_RIGHT, MIDDLE_LEFT, MIDDLE_CENTER, MIDDLE_RIGHT, BOTTOM_LEFT, BOTTOM_CENTER or BOTTOM_RIGHT").getString());
        CLIENT_LOCATION_SCREEN_OFFSET_X = config.get("client", "location_offset_x", CLIENT_LOCATION_SCREEN_OFFSET_X, "Horizontal offset on screen, increase to move to the right").getInt();
        CLIENT_LOCATION_SCREEN_OFFSET_Y = config.get("client", "location_offset_y", CLIENT_LOCATION_SCREEN_OFFSET_Y, "Vertical offset on screen, increase to move down").getInt();
        CLIENT_LOCATION_TEXT_ALIGNMENT = EnumDisplayAlignment.valueOf(config.get("client", "location_text_alignment", CLIENT_LOCATION_TEXT_ALIGNMENT.name(), "Text alignment: TOP_LEFT, TOP_CENTER, TOP_RIGHT, MIDDLE_LEFT, MIDDLE_CENTER, MIDDLE_RIGHT, BOTTOM_LEFT, BOTTOM_CENTER or BOTTOM_RIGHT").getString());
        CLIENT_LOCATION_WIDTH_RATIO = (float)config.get("client", "location_width_ratio", (double)CLIENT_LOCATION_WIDTH_RATIO, "Text width as a ratio of full screen width").getDouble();
        CLIENT_LOCATION_WIDTH_MIN = config.get("client", "location_width_min", CLIENT_LOCATION_WIDTH_MIN, "Text width as a minimum 'pixel' count").getInt();
        String commentTooltip = "When to show %s in tooltips. Valid values are " + EnumTooltipCondition.formatAllValues() + ".";
        CLIENT_TOOLTIP_REGISTRY_NAME = EnumTooltipCondition.valueOf(config.get("client", "tooltip_registry_name", CLIENT_TOOLTIP_REGISTRY_NAME.name(), String.format(commentTooltip, "registry name")).getString());
        CLIENT_TOOLTIP_ORE_DICTIONARY_NAME = EnumTooltipCondition.valueOf(config.get("client", "tooltip_ore_dictionary_name", CLIENT_TOOLTIP_ORE_DICTIONARY_NAME.name(), String.format(commentTooltip, "ore dictionary names")).getString());
        CLIENT_TOOLTIP_ARMOR = EnumTooltipCondition.valueOf(config.get("client", "tooltip_armor_stats", CLIENT_TOOLTIP_ARMOR.name(), String.format(commentTooltip, "armor stats")).getString());
        CLIENT_TOOLTIP_BURN_TIME = EnumTooltipCondition.valueOf(config.get("client", "tooltip_burn_time", CLIENT_TOOLTIP_BURN_TIME.name(), String.format(commentTooltip, "burn time")).getString());
        CLIENT_TOOLTIP_DURABILITY = EnumTooltipCondition.valueOf(config.get("client", "tooltip_durability", CLIENT_TOOLTIP_DURABILITY.name(), String.format(commentTooltip, "durability")).getString());
        CLIENT_TOOLTIP_FLAMMABILITY = EnumTooltipCondition.valueOf(config.get("client", "tooltip_flammability", CLIENT_TOOLTIP_FLAMMABILITY.name(), String.format(commentTooltip, "flammability")).getString());
        CLIENT_TOOLTIP_FLUID = EnumTooltipCondition.valueOf(config.get("client", "tooltip_fluid_stats", CLIENT_TOOLTIP_FLUID.name(), String.format(commentTooltip, "fluid stats")).getString());
        CLIENT_TOOLTIP_HARDNESS = EnumTooltipCondition.valueOf(config.get("client", "tooltip_hardness", CLIENT_TOOLTIP_HARDNESS.name(), String.format(commentTooltip, "hardness & explosion resistance")).getString());
        CLIENT_TOOLTIP_HARVESTING = EnumTooltipCondition.valueOf(config.get("client", "tooltip_harvesting_stats", CLIENT_TOOLTIP_HARVESTING.name(), String.format(commentTooltip, "harvesting stats")).getString());
        CLIENT_TOOLTIP_OPACITY = EnumTooltipCondition.valueOf(config.get("client", "tooltip_opacity", CLIENT_TOOLTIP_OPACITY.name(), String.format(commentTooltip, "opacity")).getString());
        CLIENT_TOOLTIP_REPAIR_WITH = EnumTooltipCondition.valueOf(config.get("client", "tooltip_repair_material", CLIENT_TOOLTIP_REPAIR_WITH.name(), String.format(commentTooltip, "repair material")).getString());
        LOGGING_JUMP = config.get("logging", "enable_jump_logs", LOGGING_JUMP, "Basic jump logs, should always be enabled").getBoolean(true);
        LOGGING_JUMPBLOCKS = config.get("logging", "enable_jumpblocks_logs", LOGGING_JUMPBLOCKS, "Detailed jump logs to help debug the mod, will spam your logs...").getBoolean(false);
        LOGGING_ENERGY = config.get("logging", "enable_energy_logs", LOGGING_ENERGY, "Detailed energy logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        if (WarpDrive.isDev) {
            LOGGING_EFFECTS = config.get("logging", "enable_effects_logs", LOGGING_EFFECTS, "Detailed effects logs to help debug the mod, will spam your console!").getBoolean(false);
            LOGGING_CLOAKING = config.get("logging", "enable_cloaking_logs", LOGGING_CLOAKING, "Detailed cloaking logs to help debug the mod, will spam your console!").getBoolean(false);
            LOGGING_VIDEO_CHANNEL = config.get("logging", "enable_videoChannel_logs", LOGGING_VIDEO_CHANNEL, "Detailed video channel logs to help debug the mod, will spam your console!").getBoolean(false);
            LOGGING_TARGETING = config.get("logging", "enable_targeting_logs", LOGGING_TARGETING, "Detailed targeting logs to help debug the mod, will spam your console!").getBoolean(false);
            LOGGING_CLIENT_SYNCHRONIZATION = config.get("logging", "enable_client_synchronization_logs", LOGGING_CLIENT_SYNCHRONIZATION, "Detailed client synchronization logs to help debug the mod.").getBoolean(false);
        } else {
            LOGGING_EFFECTS = false;
            LOGGING_CLOAKING = false;
            LOGGING_VIDEO_CHANNEL = false;
            LOGGING_TARGETING = false;
            LOGGING_CLIENT_SYNCHRONIZATION = false;
        }
        LOGGING_WEAPON = config.get("logging", "enable_weapon_logs", LOGGING_WEAPON, "Detailed weapon logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_CAMERA = config.get("logging", "enable_camera_logs", LOGGING_CAMERA, "Detailed camera logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_BUILDING = config.get("logging", "enable_building_logs", LOGGING_BUILDING, "Detailed building logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_COLLECTION = config.get("logging", "enable_collection_logs", LOGGING_COLLECTION, "Detailed collection logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_TRANSPORTER = config.get("logging", "enable_transporter_logs", LOGGING_TRANSPORTER, "Detailed transporter logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_LUA = config.get("logging", "enable_LUA_logs", LOGGING_LUA, "Detailed LUA logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_RADAR = config.get("logging", "enable_radar_logs", LOGGING_RADAR, "Detailed radar logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_BREATHING = config.get("logging", "enable_breathing_logs", LOGGING_BREATHING, "Detailed breathing logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_WORLD_GENERATION = config.get("logging", "enable_world_generation_logs", LOGGING_WORLD_GENERATION, "Detailed world generation logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_PROFILING_CPU_USAGE = config.get("logging", "enable_profiling_CPU_time", LOGGING_PROFILING_CPU_USAGE, "Profiling logs for CPU time, enable it to check for lag").getBoolean(true);
        LOGGING_PROFILING_MEMORY_ALLOCATION = config.get("logging", "enable_profiling_memory_allocation", LOGGING_PROFILING_MEMORY_ALLOCATION, "Profiling logs for memory allocation, enable it to check for lag").getBoolean(true);
        LOGGING_PROFILING_THREAD_SAFETY = config.get("logging", "enable_profiling_thread_safety", LOGGING_PROFILING_THREAD_SAFETY, "Profiling logs for multi-threading, enable it to check for ConcurrentModificationException").getBoolean(false);
        LOGGING_DICTIONARY = config.get("logging", "enable_dictionary_logs", LOGGING_DICTIONARY, "Dictionary logs, enable it to dump blocks hardness and blast resistance at boot").getBoolean(true);
        LOGGING_STARMAP = config.get("logging", "enable_starmap_logs", LOGGING_STARMAP, "Starmap logs, enable it to dump starmap registry updates").getBoolean(false);
        LOGGING_BREAK_PLACE = config.get("logging", "enable_break_place_logs", LOGGING_BREAK_PLACE, "Detailed break/place event logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_FORCEFIELD = config.get("logging", "enable_forcefield_logs", LOGGING_FORCEFIELD, "Detailed forcefield logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_FORCEFIELD_REGISTRY = config.get("logging", "enable_forcefield_registry_logs", LOGGING_FORCEFIELD_REGISTRY, "ForceField registry logs, enable it to dump forcefield registry updates").getBoolean(false);
        LOGGING_ACCELERATOR = config.get("logging", "enable_accelerator_logs", LOGGING_ACCELERATOR, "Detailed accelerator logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_XML_PREPROCESSOR = config.get("logging", "enable_XML_preprocessor_logs", LOGGING_XML_PREPROCESSOR, "Save XML preprocessor results as output*.xml file, enable it to debug your XML configuration files").getBoolean(false);
        LOGGING_RENDERING = config.get("logging", "enable_rendering_logs", LOGGING_RENDERING, "Detailed rendering logs to help debug the mod.").getBoolean(false);
        LOGGING_CHUNK_HANDLER = config.get("logging", "enable_chunk_handler_logs", LOGGING_CHUNK_HANDLER, "Detailed chunk data logs to help debug the mod.").getBoolean(false);
        LOGGING_CHUNK_LOADING = config.get("logging", "enable_chunk_loading_logs", LOGGING_CHUNK_LOADING, "Chunk loading logs, enable it to report chunk loaders updates").getBoolean(false);
        LOGGING_ENTITY_FX = config.get("logging", "enable_entity_fx_logs", LOGGING_ENTITY_FX, "EntityFX logs, enable it to dump entityFX registry updates").getBoolean(false);
        STARMAP_REGISTRY_UPDATE_INTERVAL_SECONDS = Commons.clamp(0, 300, config.get("starmap", "registry_update_interval", STARMAP_REGISTRY_UPDATE_INTERVAL_SECONDS, "(measured in seconds)").getInt());
        STARMAP_ALLOW_OVERLAPPING_CELESTIAL_OBJECTS = config.get("starmap", "allow_overlapping_celestial_objects", STARMAP_ALLOW_OVERLAPPING_CELESTIAL_OBJECTS, "Enable to bypass the check at boot. Use at your own risk!").getBoolean();
        SHIP_MOVEMENT_COSTS_FACTORS = new ShipMovementCosts.Factors[EnumShipMovementType.length];
        for (EnumShipMovementType shipMovementType : EnumShipMovementType.values()) {
            WarpDriveConfig.SHIP_MOVEMENT_COSTS_FACTORS[shipMovementType.ordinal()] = new ShipMovementCosts.Factors(shipMovementType.maximumDistanceDefault, shipMovementType.energyRequiredDefault, shipMovementType.warmupDefault, shipMovementType.sicknessDefault, shipMovementType.cooldownDefault);
            if (!shipMovementType.hasConfiguration) continue;
            SHIP_MOVEMENT_COSTS_FACTORS[shipMovementType.ordinal()].load(config, "ship_movement_costs", shipMovementType.getName(), shipMovementType.getDescription());
        }
        SHIP_MAX_ENERGY_STORED = Commons.clamp(0, Integer.MAX_VALUE, config.get("ship", "max_energy_stored", SHIP_MAX_ENERGY_STORED, "Maximum energy stored").getInt());
        SHIP_TELEPORT_ENERGY_PER_ENTITY = Commons.clamp(0, Integer.MAX_VALUE, config.get("ship", "teleport_energy_per_entity", SHIP_TELEPORT_ENERGY_PER_ENTITY, "Energy cost per entity").getInt());
        SHIP_VOLUME_MAX_ON_PLANET_SURFACE = Commons.clamp(0, 10000000, config.get("ship", "volume_max_on_planet_surface", SHIP_VOLUME_MAX_ON_PLANET_SURFACE, "Maximum ship mass (in blocks) to jump on a planet").getInt());
        SHIP_VOLUME_MIN_FOR_HYPERSPACE = Commons.clamp(0, 10000000, config.get("ship", "volume_min_for_hyperspace", SHIP_VOLUME_MIN_FOR_HYPERSPACE, "Minimum ship mass (in blocks) to enter or exit hyperspace without a jumpgate").getInt());
        SHIP_VOLUME_UNLIMITED_PLAYERNAMES = config.get("ship", "volume_unlimited_playernames", SHIP_VOLUME_UNLIMITED_PLAYERNAMES, "List of player names which have unlimited block counts to their ship").getStringList();
        SHIP_MAX_SIDE_SIZE = Commons.clamp(0, 30000000, config.get("ship", "max_side_size", SHIP_MAX_SIDE_SIZE, "Maximum ship size on each axis in blocks").getInt());
        SHIP_COLLISION_TOLERANCE_BLOCKS = Commons.clamp(0, 30000000, config.get("ship", "collision_tolerance_blocks", SHIP_COLLISION_TOLERANCE_BLOCKS, "Tolerance in block in case of collision before causing damages...").getInt());
        SHIP_WARMUP_RANDOM_TICKS = Commons.clamp(10, 200, config.get("ship", "warmup_random_ticks", SHIP_WARMUP_RANDOM_TICKS, "Random variation added to warmup (measured in ticks)").getInt());
        SHIP_SUMMON_MAX_RANGE = config.get("ship", "summon_max_range", SHIP_SUMMON_MAX_RANGE, "Maximum range from which players can be summoned (measured in blocks), set to -1 for unlimited range").getInt();
        SHIP_SUMMON_ACROSS_DIMENSIONS = config.get("ship", "summon_across_dimensions", false, "Enable summoning players from another dimension").getBoolean(false);
        SHIP_CORE_ISOLATION_UPDATE_INTERVAL_SECONDS = Commons.clamp(0, 300, config.get("ship", "core_isolation_update_interval", SHIP_CORE_ISOLATION_UPDATE_INTERVAL_SECONDS, "(measured in seconds)").getInt());
        SHIP_VOLUME_SCAN_AGE_TOLERANCE_SECONDS = Commons.clamp(0, 300, config.get("ship", "volume_scan_age_tolerance", SHIP_VOLUME_SCAN_AGE_TOLERANCE_SECONDS, "Ship volume won't be refreshed unless it's older than that many seconds").getInt());
        SHIP_CONTROLLER_UPDATE_INTERVAL_SECONDS = Commons.clamp(0, 300, config.get("ship", "controller_update_interval", SHIP_CONTROLLER_UPDATE_INTERVAL_SECONDS, "(measured in seconds)").getInt());
        RADAR_MAX_ENERGY_STORED = Commons.clamp(0, Integer.MAX_VALUE, config.get("radar", "max_energy_stored", RADAR_MAX_ENERGY_STORED, "maximum energy stored").getInt());
        RADAR_SCAN_MIN_ENERGY_COST = Commons.clamp(0, Integer.MAX_VALUE, config.get("radar", "min_energy_cost", RADAR_SCAN_MIN_ENERGY_COST, "minimum energy cost per scan (0+), independently of radius").getInt());
        if ((RADAR_SCAN_ENERGY_COST_FACTORS = config.get("radar", "factors_energy_cost", RADAR_SCAN_ENERGY_COST_FACTORS, "energy cost factors {a, b, c, d}. You need to provide exactly 4 values.\nThe equation used is a + b * radius + c * radius^2 + d * radius^3").getDoubleList()).length != 4) {
            RADAR_SCAN_ENERGY_COST_FACTORS = new double[4];
            Arrays.fill(RADAR_SCAN_ENERGY_COST_FACTORS, 1.0);
        }
        RADAR_SCAN_MIN_DELAY_SECONDS = Commons.clamp(1, Integer.MAX_VALUE, config.get("radar", "scan_min_delay_seconds", RADAR_SCAN_MIN_DELAY_SECONDS, "minimum scan delay per scan (1+), (measured in seconds)").getInt());
        if ((RADAR_SCAN_DELAY_FACTORS_SECONDS = config.get("radar", "scan_delay_factors_seconds", RADAR_SCAN_DELAY_FACTORS_SECONDS, "scan delay factors {a, b, c, d}. You need to provide exactly 4 values.\nThe equation used is a + b * radius + c * radius^2 + d * radius^3, (measured in seconds)").getDoubleList()).length != 4) {
            RADAR_SCAN_DELAY_FACTORS_SECONDS = new double[4];
            Arrays.fill(RADAR_SCAN_DELAY_FACTORS_SECONDS, 1.0);
        }
        RADAR_MAX_ISOLATION_RANGE = Commons.clamp(2, 8, config.get("radar", "max_isolation_range", RADAR_MAX_ISOLATION_RANGE, "radius around core where isolation blocks count (2 to 8), higher is lagger").getInt());
        RADAR_MIN_ISOLATION_BLOCKS = Commons.clamp(0, 20, config.get("radar", "min_isolation_blocks", RADAR_MIN_ISOLATION_BLOCKS, "number of isolation blocks required to get some isolation (0 to 20)").getInt());
        RADAR_MAX_ISOLATION_BLOCKS = Commons.clamp(5, 94, config.get("radar", "max_isolation_blocks", RADAR_MAX_ISOLATION_BLOCKS, "number of isolation blocks required to reach maximum effect (5 to 94)").getInt());
        RADAR_MIN_ISOLATION_EFFECT = Commons.clamp(0.01, 0.95, config.get("radar", "min_isolation_effect", RADAR_MIN_ISOLATION_EFFECT, "isolation effect achieved with min number of isolation blocks (0.01 to 0.95)").getDouble(0.12));
        RADAR_MAX_ISOLATION_EFFECT = Commons.clamp(0.01, 1.0, config.get("radar", "max_isolation_effect", RADAR_MAX_ISOLATION_EFFECT, "isolation effect achieved with max number of isolation blocks (0.01 to 1.00)").getDouble(1.0));
        SS_MAX_DEPLOY_RADIUS_BLOCKS = Commons.clamp(5, 150, config.get("ship_scanner", "max_deploy_radius_blocks", SS_MAX_DEPLOY_RADIUS_BLOCKS, "Max distance from ship scanner to ship core, measured in blocks (5-150)").getInt());
        SS_SEARCH_INTERVAL_TICKS = Commons.clamp(5, 150, config.get("ship_scanner", "search_interval_ticks", SS_SEARCH_INTERVAL_TICKS, "Max distance from ship scanner to ship core, measured in blocks (5-150)").getInt());
        SS_SCAN_BLOCKS_PER_SECOND = Commons.clamp(1, 50000, config.get("ship_scanner", "scan_blocks_per_second", SS_SCAN_BLOCKS_PER_SECOND, "Scanning speed, measured in blocks (1-5000)").getInt());
        SS_DEPLOY_BLOCKS_PER_INTERVAL = Commons.clamp(1, 3000, config.get("ship_scanner", "deploy_blocks_per_interval", SS_DEPLOY_BLOCKS_PER_INTERVAL, "Deployment speed, measured in blocks (1-3000)").getInt());
        SS_DEPLOY_INTERVAL_TICKS = Commons.clamp(1, 60, config.get("ship_scanner", "deploy_interval_ticks", SS_DEPLOY_INTERVAL_TICKS, "Delay between deployment of 2 sets of blocks, measured in ticks (1-60)").getInt());
        LASER_MEDIUM_MAX_ENERGY_STORED = Commons.clamp(1, Integer.MAX_VALUE, config.get("laser_medium", "max_energy_stored", LASER_MEDIUM_MAX_ENERGY_STORED, "Maximum energy stored").getInt());
        LASER_CANNON_MAX_MEDIUMS_COUNT = Commons.clamp(1, 64, config.get("laser_cannon", "max_mediums_count", LASER_CANNON_MAX_MEDIUMS_COUNT, "Maximum number of laser mediums per laser").getInt());
        LASER_CANNON_MAX_LASER_ENERGY = Commons.clamp(1, Integer.MAX_VALUE, config.get("laser_cannon", "max_laser_energy", LASER_CANNON_MAX_LASER_ENERGY, "Maximum energy in beam after accounting for boosters beams").getInt());
        LASER_CANNON_EMIT_FIRE_DELAY_TICKS = Commons.clamp(1, 100, config.get("laser_cannon", "emit_fire_delay_ticks", LASER_CANNON_EMIT_FIRE_DELAY_TICKS, "Delay while booster beams are accepted, before actually shooting").getInt());
        LASER_CANNON_EMIT_SCAN_DELAY_TICKS = Commons.clamp(1, 100, config.get("laser_cannon", "emit_scan_delay_ticks", LASER_CANNON_EMIT_SCAN_DELAY_TICKS, "Delay while booster beams are accepted, before actually scanning").getInt());
        LASER_CANNON_BOOSTER_BEAM_ENERGY_EFFICIENCY = Commons.clamp(0.01, 10.0, config.get("laser_cannon", "booster_beam_energy_efficiency", LASER_CANNON_BOOSTER_BEAM_ENERGY_EFFICIENCY, "Energy factor applied from boosting to main laser").getDouble(0.6));
        LASER_CANNON_ENERGY_ATTENUATION_PER_AIR_BLOCK = Commons.clamp(0.0, 0.1, config.get("laser_cannon", "energy_attenuation_per_air_block", LASER_CANNON_ENERGY_ATTENUATION_PER_AIR_BLOCK, "Energy attenuation when going through air blocks (on a planet or any gaz in space)").getDouble());
        LASER_CANNON_ENERGY_ATTENUATION_PER_VOID_BLOCK = Commons.clamp(0.0, 0.1, config.get("laser_cannon", "energy_attenuation_per_air_block", LASER_CANNON_ENERGY_ATTENUATION_PER_VOID_BLOCK, "Energy attenuation when going through void blocks (in space or hyperspace)").getDouble());
        LASER_CANNON_ENERGY_ATTENUATION_PER_BROKEN_BLOCK = Commons.clamp(0.0, 1.0, config.get("laser_cannon", "energy_attenuation_per_air_block", LASER_CANNON_ENERGY_ATTENUATION_PER_BROKEN_BLOCK, "Energy attenuation when going through a broken block").getDouble());
        LASER_CANNON_RANGE_MAX = Commons.clamp(64, 512, config.get("laser_cannon", "range_max", LASER_CANNON_RANGE_MAX, "Maximum distance travelled").getInt());
        LASER_CANNON_ENTITY_HIT_SET_ON_FIRE_SECONDS = Commons.clamp(0, 300, config.get("laser_cannon", "entity_hit_set_on_fire_seconds", LASER_CANNON_ENTITY_HIT_SET_ON_FIRE_SECONDS, "Duration of fire effect on entity hit (in seconds)").getInt());
        LASER_CANNON_ENTITY_HIT_ENERGY = Commons.clamp(0, LASER_CANNON_MAX_LASER_ENERGY, config.get("laser_cannon", "entity_hit_energy", LASER_CANNON_ENTITY_HIT_ENERGY, "Base energy consumed from hitting an entity").getInt());
        LASER_CANNON_ENTITY_HIT_BASE_DAMAGE = Commons.clamp(0, LASER_CANNON_MAX_LASER_ENERGY, config.get("laser_cannon", "entity_hit_base_damage", LASER_CANNON_ENTITY_HIT_BASE_DAMAGE, "Minimum damage to entity hit (measured in half hearts)").getInt());
        LASER_CANNON_ENTITY_HIT_ENERGY_PER_DAMAGE = Commons.clamp(0, LASER_CANNON_MAX_LASER_ENERGY, config.get("laser_cannon", "entity_hit_energy_per_damage", LASER_CANNON_ENTITY_HIT_ENERGY_PER_DAMAGE, "Energy required by additional hit point (won't be consumed)").getInt());
        LASER_CANNON_ENTITY_HIT_MAX_DAMAGE = Commons.clamp(0, Integer.MAX_VALUE, config.get("laser_cannon", "entity_hit_max_damage", LASER_CANNON_ENTITY_HIT_MAX_DAMAGE, "Maximum damage to entity hit, set to 0 to disable damage completely").getInt());
        LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_THRESHOLD = Commons.clamp(0, Integer.MAX_VALUE, config.get("laser_cannon", "entity_hit_energy_threshold_for_explosion", LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_THRESHOLD, "Minimum energy to cause explosion effect").getInt());
        LASER_CANNON_ENTITY_HIT_EXPLOSION_BASE_STRENGTH = (float)Commons.clamp(0.0, 100.0, config.get("laser_cannon", "entity_hit_explosion_base_strength", (double)LASER_CANNON_ENTITY_HIT_EXPLOSION_BASE_STRENGTH, "Explosion base strength, 4 is Vanilla TNT").getDouble());
        LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_PER_STRENGTH = Commons.clamp(1, Integer.MAX_VALUE, config.get("laser_cannon", "entity_hit_explosion_energy_per_strength", LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_PER_STRENGTH, "Energy per added explosion strength").getInt());
        LASER_CANNON_ENTITY_HIT_EXPLOSION_MAX_STRENGTH = (float)Commons.clamp(0.0, 1000.0, config.get("laser_cannon", "entity_hit_explosion_max_strength", (double)LASER_CANNON_ENTITY_HIT_EXPLOSION_MAX_STRENGTH, "Maximum explosion strength, set to 0 to disable explosion completely").getDouble());
        LASER_CANNON_BLOCK_HIT_ENERGY_MIN = Commons.clamp(0, Integer.MAX_VALUE, config.get("laser_cannon", "block_hit_energy_min", LASER_CANNON_BLOCK_HIT_ENERGY_MIN, "Minimum energy required for breaking a block").getInt());
        LASER_CANNON_BLOCK_HIT_ENERGY_PER_BLOCK_HARDNESS = Commons.clamp(0, Integer.MAX_VALUE, config.get("laser_cannon", "block_hit_energy_per_block_hardness", LASER_CANNON_BLOCK_HIT_ENERGY_PER_BLOCK_HARDNESS, "Energy cost per block hardness for breaking a block").getInt());
        LASER_CANNON_BLOCK_HIT_ENERGY_MAX = Commons.clamp(0, Integer.MAX_VALUE, config.get("laser_cannon", "block_hit_energy_max", LASER_CANNON_BLOCK_HIT_ENERGY_MAX, "Maximum energy required for breaking a block").getInt());
        LASER_CANNON_BLOCK_HIT_ABSORPTION_PER_BLOCK_HARDNESS = Commons.clamp(0.0, 1.0, config.get("laser_cannon", "block_hit_absorption_per_block_hardness", LASER_CANNON_BLOCK_HIT_ABSORPTION_PER_BLOCK_HARDNESS, "Probability of energy absorption (i.e. block not breaking) per block hardness. Set to 1.0 to always break the block.").getDouble());
        LASER_CANNON_BLOCK_HIT_ABSORPTION_MAX = Commons.clamp(0.0, 1.0, config.get("laser_cannon", "block_hit_absorption_max", LASER_CANNON_BLOCK_HIT_ABSORPTION_MAX, "Maximum probability of energy absorption (i.e. block not breaking)").getDouble());
        LASER_CANNON_BLOCK_HIT_EXPLOSION_HARDNESS_THRESHOLD = (float)Commons.clamp(0.0, 10000.0, config.get("laser_cannon", "block_hit_explosion_hardness_threshold", (double)LASER_CANNON_BLOCK_HIT_EXPLOSION_HARDNESS_THRESHOLD, "Minimum block hardness required to cause an explosion").getDouble());
        LASER_CANNON_BLOCK_HIT_EXPLOSION_BASE_STRENGTH = (float)Commons.clamp(0.0, 1000.0, config.get("laser_cannon", "block_hit_explosion_base_strength", (double)LASER_CANNON_BLOCK_HIT_EXPLOSION_BASE_STRENGTH, "Explosion base strength, 4 is Vanilla TNT").getDouble());
        LASER_CANNON_BLOCK_HIT_EXPLOSION_ENERGY_PER_STRENGTH = Commons.clamp(1, Integer.MAX_VALUE, config.get("laser_cannon", "block_hit_explosion_energy_per_strength", LASER_CANNON_BLOCK_HIT_EXPLOSION_ENERGY_PER_STRENGTH, "Energy per added explosion strength").getInt());
        LASER_CANNON_BLOCK_HIT_EXPLOSION_MAX_STRENGTH = (float)Commons.clamp(0.0, 1000.0, config.get("laser_cannon", "block_hit_explosion_max_strength", (double)LASER_CANNON_BLOCK_HIT_EXPLOSION_MAX_STRENGTH, "Maximum explosion strength, set to 0 to disable explosion completely").getDouble());
        MINING_LASER_MAX_MEDIUMS_COUNT = Commons.clamp(1, 10, config.get("mining_laser", "max_mediums_count", MINING_LASER_MAX_MEDIUMS_COUNT, "Maximum number of laser mediums").getInt());
        MINING_LASER_RADIUS_NO_LASER_MEDIUM = Commons.clamp(0, 15, config.get("mining_laser", "radius_no_laser_medium", MINING_LASER_RADIUS_NO_LASER_MEDIUM, "Mining radius without any laser medium, measured in blocks").getInt());
        MINING_LASER_RADIUS_PER_LASER_MEDIUM = Commons.clamp(1, 8, config.get("mining_laser", "radius_per_laser_medium", MINING_LASER_RADIUS_PER_LASER_MEDIUM, "Bonus to mining radius per laser medium, measured in blocks").getInt());
        MINING_LASER_WARMUP_DELAY_TICKS = Commons.clamp(1, 300, config.get("mining_laser", "warmup_delay_ticks", MINING_LASER_WARMUP_DELAY_TICKS, "Warmup duration (buffer on startup when energy source is weak)").getInt());
        MINING_LASER_SCAN_DELAY_TICKS = Commons.clamp(1, 300, config.get("mining_laser", "scan_delay_ticks", MINING_LASER_SCAN_DELAY_TICKS, "Scan duration per layer").getInt());
        MINING_LASER_MINE_DELAY_TICKS = Commons.clamp(1, 300, config.get("mining_laser", "mine_delay_ticks", MINING_LASER_MINE_DELAY_TICKS, "Mining duration per scanned block").getInt());
        MINING_LASER_PLANET_ENERGY_PER_LAYER = Commons.clamp(1, Integer.MAX_VALUE, config.get("mining_laser", "planet_energy_per_layer", MINING_LASER_PLANET_ENERGY_PER_LAYER, "Energy cost per layer on a planet").getInt());
        MINING_LASER_PLANET_ENERGY_PER_BLOCK = Commons.clamp(1, Integer.MAX_VALUE, config.get("mining_laser", "planet_energy_per_block", MINING_LASER_PLANET_ENERGY_PER_BLOCK, "Energy cost per block in space").getInt());
        MINING_LASER_SPACE_ENERGY_PER_LAYER = Commons.clamp(1, Integer.MAX_VALUE, config.get("mining_laser", "space_energy_per_layer", MINING_LASER_SPACE_ENERGY_PER_LAYER, "Energy cost per layer on a planet").getInt());
        MINING_LASER_SPACE_ENERGY_PER_BLOCK = Commons.clamp(1, Integer.MAX_VALUE, config.get("mining_laser", "space_energy_per_block", MINING_LASER_SPACE_ENERGY_PER_BLOCK, "Energy cost per block in space").getInt());
        MINING_LASER_ORESONLY_ENERGY_FACTOR = Commons.clamp(1.5, 1000.0, config.get("mining_laser", "oresonly_energy_factor", MINING_LASER_ORESONLY_ENERGY_FACTOR, "Energy cost multiplier per block when mining only ores").getDouble(MINING_LASER_ORESONLY_ENERGY_FACTOR));
        MINING_LASER_SILKTOUCH_ENERGY_FACTOR = Commons.clamp(1.5, 1000.0, config.get("mining_laser", "silktouch_energy_factor", MINING_LASER_SILKTOUCH_ENERGY_FACTOR, "Energy cost multiplier per block when mining with silktouch").getDouble(MINING_LASER_SILKTOUCH_ENERGY_FACTOR));
        TREE_FARM_MAX_MEDIUMS_COUNT = Commons.clamp(1, 10, config.get("tree_farm", "max_mediums_count", TREE_FARM_MAX_MEDIUMS_COUNT, "Maximum number of laser mediums").getInt());
        TREE_FARM_MAX_SCAN_RADIUS_NO_LASER_MEDIUM = Commons.clamp(0, 15, config.get("tree_farm", "max_scan_radius_no_laser_medium", TREE_FARM_MAX_SCAN_RADIUS_NO_LASER_MEDIUM, "Maximum scan radius without any laser medium, on X and Z axis, measured in blocks").getInt());
        TREE_FARM_MAX_SCAN_RADIUS_PER_LASER_MEDIUM = Commons.clamp(1, 8, config.get("tree_farm", "max_scan_radius_per_laser_medium", TREE_FARM_MAX_SCAN_RADIUS_PER_LASER_MEDIUM, "Bonus to maximum scan radius per laser medium, on X and Z axis, measured in blocks").getInt());
        TREE_FARM_totalMaxRadius = TREE_FARM_MAX_SCAN_RADIUS_NO_LASER_MEDIUM + TREE_FARM_MAX_MEDIUMS_COUNT * TREE_FARM_MAX_SCAN_RADIUS_PER_LASER_MEDIUM;
        TREE_FARM_MAX_LOG_DISTANCE = Commons.clamp(1, 64, config.get("tree_farm", "max_reach_distance", TREE_FARM_MAX_LOG_DISTANCE, "Maximum reach distance of the laser without any laser medium, measured in blocks").getInt());
        TREE_FARM_MAX_LOG_DISTANCE_PER_MEDIUM = Commons.clamp(0, 16, config.get("tree_farm", "max_reach_distance_per_laser_medium", TREE_FARM_MAX_LOG_DISTANCE_PER_MEDIUM, "Bonus to maximum reach distance per laser medium, measured in blocks").getInt());
        CLOAKING_MAX_ENERGY_STORED = Commons.clamp(1, Integer.MAX_VALUE, config.get("cloaking", "max_energy_stored", CLOAKING_MAX_ENERGY_STORED, "Maximum energy stored").getInt());
        CLOAKING_COIL_CAPTURE_BLOCKS = Commons.clamp(0, 30, config.get("cloaking", "coil_capture_blocks", CLOAKING_COIL_CAPTURE_BLOCKS, "Extra blocks covered after the outer coils").getInt());
        CLOAKING_MAX_FIELD_RADIUS = Commons.clamp(CLOAKING_COIL_CAPTURE_BLOCKS + 3, 128, config.get("cloaking", "max_field_radius", CLOAKING_MAX_FIELD_RADIUS, "Maximum distance between cloaking core and any cloaked side").getInt());
        CLOAKING_TIER1_ENERGY_PER_BLOCK = Commons.clamp(0, Integer.MAX_VALUE, config.get("cloaking", "tier1_energy_per_block", CLOAKING_TIER1_ENERGY_PER_BLOCK, "Energy cost per non-air block in a Tier1 cloak").getInt());
        CLOAKING_TIER2_ENERGY_PER_BLOCK = Commons.clamp(CLOAKING_TIER1_ENERGY_PER_BLOCK, Integer.MAX_VALUE, config.get("cloaking", "tier2_energy_per_block", CLOAKING_TIER2_ENERGY_PER_BLOCK, "Energy cost per non-air block in a Tier2 cloak").getInt());
        CLOAKING_FIELD_REFRESH_INTERVAL_SECONDS = Commons.clamp(1, 30, config.get("cloaking", "field_refresh_interval_seconds", CLOAKING_FIELD_REFRESH_INTERVAL_SECONDS, "Update speed of cloak simulation").getInt());
        BREATHING_MAX_ENERGY_STORED = config.get("breathing", "max_energy_stored", BREATHING_MAX_ENERGY_STORED, "Maximum energy stored").getIntList();
        assert (BREATHING_MAX_ENERGY_STORED.length == 3);
        WarpDriveConfig.BREATHING_MAX_ENERGY_STORED[0] = Commons.clamp(1, BREATHING_MAX_ENERGY_STORED[1], BREATHING_MAX_ENERGY_STORED[0]);
        WarpDriveConfig.BREATHING_MAX_ENERGY_STORED[1] = Commons.clamp(BREATHING_MAX_ENERGY_STORED[0], BREATHING_MAX_ENERGY_STORED[2], BREATHING_MAX_ENERGY_STORED[1]);
        WarpDriveConfig.BREATHING_MAX_ENERGY_STORED[2] = Commons.clamp(BREATHING_MAX_ENERGY_STORED[1], Integer.MAX_VALUE, BREATHING_MAX_ENERGY_STORED[2]);
        BREATHING_ENERGY_PER_CANISTER = Commons.clamp(1, BREATHING_MAX_ENERGY_STORED[0], config.get("breathing", "energy_per_canister", BREATHING_ENERGY_PER_CANISTER, "Energy cost per air canister refilled").getInt());
        BREATHING_ENERGY_PER_NEW_AIR_BLOCK = config.get("breathing", "energy_per_new_air_block", BREATHING_ENERGY_PER_NEW_AIR_BLOCK, "Energy cost to start air distribution per open side per interval").getIntList();
        assert (BREATHING_ENERGY_PER_NEW_AIR_BLOCK.length == 3);
        WarpDriveConfig.BREATHING_ENERGY_PER_NEW_AIR_BLOCK[0] = Commons.clamp(1, BREATHING_MAX_ENERGY_STORED[0], BREATHING_ENERGY_PER_NEW_AIR_BLOCK[0]);
        WarpDriveConfig.BREATHING_ENERGY_PER_NEW_AIR_BLOCK[1] = Commons.clamp(BREATHING_ENERGY_PER_NEW_AIR_BLOCK[0], BREATHING_MAX_ENERGY_STORED[1], BREATHING_ENERGY_PER_NEW_AIR_BLOCK[1]);
        WarpDriveConfig.BREATHING_ENERGY_PER_NEW_AIR_BLOCK[2] = Commons.clamp(BREATHING_ENERGY_PER_NEW_AIR_BLOCK[1], BREATHING_MAX_ENERGY_STORED[2], BREATHING_ENERGY_PER_NEW_AIR_BLOCK[2]);
        BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK = config.get("breathing", "energy_per_existing_air_block", BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK, "Energy cost to sustain air distribution per open side per interval").getIntList();
        assert (BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK.length == 3);
        WarpDriveConfig.BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK[0] = Commons.clamp(1, BREATHING_MAX_ENERGY_STORED[0], BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK[0]);
        WarpDriveConfig.BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK[1] = Commons.clamp(BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK[0], BREATHING_MAX_ENERGY_STORED[1], BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK[1]);
        WarpDriveConfig.BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK[2] = Commons.clamp(BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK[1], BREATHING_MAX_ENERGY_STORED[2], BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK[2]);
        BREATHING_AIR_GENERATION_TICKS = Commons.clamp(1, 300, config.get("breathing", "air_generation_interval_ticks", BREATHING_AIR_GENERATION_TICKS, "Update speed of air generation").getInt());
        BREATHING_AIR_GENERATION_RANGE_BLOCKS = config.get("breathing", "air_generation_range_blocks", BREATHING_AIR_GENERATION_RANGE_BLOCKS, "Maximum range of an air generator for each tier, measured in block").getIntList();
        assert (BREATHING_AIR_GENERATION_RANGE_BLOCKS.length == 3);
        WarpDriveConfig.BREATHING_AIR_GENERATION_RANGE_BLOCKS[0] = Commons.clamp(8, BREATHING_AIR_GENERATION_RANGE_BLOCKS[1], BREATHING_AIR_GENERATION_RANGE_BLOCKS[0]);
        WarpDriveConfig.BREATHING_AIR_GENERATION_RANGE_BLOCKS[1] = Commons.clamp(BREATHING_AIR_GENERATION_RANGE_BLOCKS[0], BREATHING_AIR_GENERATION_RANGE_BLOCKS[2], BREATHING_AIR_GENERATION_RANGE_BLOCKS[1]);
        WarpDriveConfig.BREATHING_AIR_GENERATION_RANGE_BLOCKS[2] = Commons.clamp(BREATHING_AIR_GENERATION_RANGE_BLOCKS[1], 256, BREATHING_AIR_GENERATION_RANGE_BLOCKS[2]);
        BREATHING_VOLUME_UPDATE_DEPTH_BLOCKS = Commons.clamp(10, 256, config.get("breathing", "volume_update_depth_blocks", BREATHING_VOLUME_UPDATE_DEPTH_BLOCKS, "Maximum depth of blocks to update when a volume has changed.\nHigher values may cause TPS lag spikes, Lower values will exponentially increase the repressurization time").getInt());
        BREATHING_AIR_SIMULATION_DELAY_TICKS = Commons.clamp(1, 90, config.get("breathing", "simulation_delay_ticks", BREATHING_AIR_SIMULATION_DELAY_TICKS, "Minimum delay between consecutive air propagation updates of the same block.").getInt());
        BREATHING_AIR_AT_ENTITY_DEBUG = config.get("breathing", "enable_air_at_entity_debug", BREATHING_AIR_AT_ENTITY_DEBUG, "Spam creative players with air status around them, use at your own risk.").getBoolean(false);
        IC2_REACTOR_MAX_HEAT_STORED = Commons.clamp(1, Short.MAX_VALUE, config.get("ic2_reactor_laser", "max_heat_stored", IC2_REACTOR_MAX_HEAT_STORED, "Maximum heat stored in the focus").getInt());
        IC2_REACTOR_COMPONENT_HEAT_TRANSFER_PER_TICK = Commons.clamp(0, Short.MAX_VALUE, config.get("ic2_reactor_laser", "component_heat_transfer_per_tick", IC2_REACTOR_COMPONENT_HEAT_TRANSFER_PER_TICK, "Maximum component heat added to the focus every reactor tick").getInt());
        IC2_REACTOR_FOCUS_HEAT_TRANSFER_PER_TICK = Commons.clamp(0, Short.MAX_VALUE, config.get("ic2_reactor_laser", "focus_heat_transfer_per_tick", IC2_REACTOR_FOCUS_HEAT_TRANSFER_PER_TICK, "Maximum heat transferred between 2 connected focus every reactor tick").getInt());
        IC2_REACTOR_REACTOR_HEAT_TRANSFER_PER_TICK = Commons.clamp(0, Short.MAX_VALUE, config.get("ic2_reactor_laser", "reactor_heat_transfer_per_tick", IC2_REACTOR_REACTOR_HEAT_TRANSFER_PER_TICK, "Maximum reactor heat added to the focus every reactor tick").getInt());
        IC2_REACTOR_COOLING_PER_INTERVAL = Commons.clamp(1, Short.MAX_VALUE, config.get("ic2_reactor_laser", "cooling_per_interval", IC2_REACTOR_COOLING_PER_INTERVAL, "Heat extracted from the focus by interval").getInt());
        IC2_REACTOR_ENERGY_PER_HEAT = Commons.clamp(2.0, 100000.0, config.get("ic2_reactor_laser", "energy_per_heat", IC2_REACTOR_ENERGY_PER_HEAT, "Energy cost per heat absorbed").getDouble());
        IC2_REACTOR_COOLING_INTERVAL_TICKS = Commons.clamp(0, 1200, config.get("ic2_reactor_laser", "cooling_interval_ticks", IC2_REACTOR_COOLING_INTERVAL_TICKS, "Update speed of the check for reactors to cooldown. Use 10 to tick as fast as the reactor simulation").getInt());
        TRANSPORTER_MAX_ENERGY_STORED = Commons.clamp(1, Integer.MAX_VALUE, config.get("transporter", "max_energy_stored", TRANSPORTER_MAX_ENERGY_STORED, "Maximum energy stored").getInt());
        ENAN_REACTOR_MAX_ENERGY_STORED = Commons.clamp(1, Integer.MAX_VALUE, config.get("enantiomorphic_reactor", "max_energy_stored", ENAN_REACTOR_MAX_ENERGY_STORED, "Maximum energy stored").getInt());
        ENAN_REACTOR_UPDATE_INTERVAL_TICKS = Commons.clamp(1, 300, config.get("enantiomorphic_reactor", "update_interval_ticks", ENAN_REACTOR_UPDATE_INTERVAL_TICKS, "Update speed of the reactor simulation").getInt());
        ENAN_REACTOR_MAX_LASERS_PER_SECOND = Commons.clamp(4, 80, config.get("enantiomorphic_reactor", "max_lasers", ENAN_REACTOR_MAX_LASERS_PER_SECOND, "Maximum number of stabilisation laser shots per seconds before loosing efficiency").getInt());
        ENERGY_BANK_MAX_ENERGY_STORED = config.get("energy_bank", "max_energy_stored", ENERGY_BANK_MAX_ENERGY_STORED, "Maximum energy stored for each energy bank").getIntList();
        assert (ENERGY_BANK_MAX_ENERGY_STORED.length == 3);
        WarpDriveConfig.ENERGY_BANK_MAX_ENERGY_STORED[0] = Commons.clamp(0, ENERGY_BANK_MAX_ENERGY_STORED[1], ENERGY_BANK_MAX_ENERGY_STORED[0]);
        WarpDriveConfig.ENERGY_BANK_MAX_ENERGY_STORED[1] = Commons.clamp(ENERGY_BANK_MAX_ENERGY_STORED[0], ENERGY_BANK_MAX_ENERGY_STORED[2], ENERGY_BANK_MAX_ENERGY_STORED[1]);
        WarpDriveConfig.ENERGY_BANK_MAX_ENERGY_STORED[2] = Commons.clamp(ENERGY_BANK_MAX_ENERGY_STORED[1], Integer.MAX_VALUE, ENERGY_BANK_MAX_ENERGY_STORED[2]);
        ENERGY_BANK_IC2_TIER = config.get("energy_bank", "ic2_tier", ENERGY_BANK_IC2_TIER, "IC2 energy tier for each energy bank (0 is BatBox, etc.)").getIntList();
        assert (ENERGY_BANK_IC2_TIER.length == 3);
        WarpDriveConfig.ENERGY_BANK_IC2_TIER[0] = Commons.clamp(0, ENERGY_BANK_IC2_TIER[1], ENERGY_BANK_IC2_TIER[0]);
        WarpDriveConfig.ENERGY_BANK_IC2_TIER[1] = Commons.clamp(ENERGY_BANK_IC2_TIER[0], ENERGY_BANK_IC2_TIER[2], ENERGY_BANK_IC2_TIER[1]);
        WarpDriveConfig.ENERGY_BANK_IC2_TIER[2] = Commons.clamp(ENERGY_BANK_IC2_TIER[1], Integer.MAX_VALUE, ENERGY_BANK_IC2_TIER[2]);
        ENERGY_BANK_TRANSFER_PER_TICK = config.get("energy_bank", "transfer_per_tick", ENERGY_BANK_TRANSFER_PER_TICK, "Internal energy transferred per tick for each energy bank").getIntList();
        assert (ENERGY_BANK_TRANSFER_PER_TICK.length == 3);
        WarpDriveConfig.ENERGY_BANK_TRANSFER_PER_TICK[0] = Commons.clamp(0, ENERGY_BANK_TRANSFER_PER_TICK[1], ENERGY_BANK_TRANSFER_PER_TICK[0]);
        WarpDriveConfig.ENERGY_BANK_TRANSFER_PER_TICK[1] = Commons.clamp(ENERGY_BANK_TRANSFER_PER_TICK[0], ENERGY_BANK_TRANSFER_PER_TICK[2], ENERGY_BANK_TRANSFER_PER_TICK[1]);
        WarpDriveConfig.ENERGY_BANK_TRANSFER_PER_TICK[2] = Commons.clamp(ENERGY_BANK_TRANSFER_PER_TICK[1], Integer.MAX_VALUE, ENERGY_BANK_TRANSFER_PER_TICK[2]);
        ENERGY_BANK_EFFICIENCY_PER_UPGRADE = config.get("energy_bank", "efficiency_per_upgrade", ENERGY_BANK_EFFICIENCY_PER_UPGRADE, "Energy transfer efficiency for each upgrade apply, first value is without upgrades (0.8 means 20% loss)").getDoubleList();
        assert (ENERGY_BANK_EFFICIENCY_PER_UPGRADE.length >= 1);
        WarpDriveConfig.ENERGY_BANK_EFFICIENCY_PER_UPGRADE[0] = Math.min(1.0, Commons.clamp(0.5, ENERGY_BANK_EFFICIENCY_PER_UPGRADE[1], ENERGY_BANK_EFFICIENCY_PER_UPGRADE[0]));
        WarpDriveConfig.ENERGY_BANK_EFFICIENCY_PER_UPGRADE[1] = Math.min(1.0, Commons.clamp(ENERGY_BANK_EFFICIENCY_PER_UPGRADE[0], ENERGY_BANK_EFFICIENCY_PER_UPGRADE[2], ENERGY_BANK_EFFICIENCY_PER_UPGRADE[1]));
        WarpDriveConfig.ENERGY_BANK_EFFICIENCY_PER_UPGRADE[2] = Math.min(1.0, Commons.clamp(ENERGY_BANK_EFFICIENCY_PER_UPGRADE[1], 2.147483647E9, ENERGY_BANK_EFFICIENCY_PER_UPGRADE[2]));
        LIFT_MAX_ENERGY_STORED = Commons.clamp(1, Integer.MAX_VALUE, config.get("lift", "max_energy_stored", LIFT_MAX_ENERGY_STORED, "Maximum energy stored").getInt());
        LIFT_ENERGY_PER_ENTITY = Commons.clamp(1, Integer.MAX_VALUE, config.get("lift", "energy_per_entity", LIFT_ENERGY_PER_ENTITY, "Energy consumed per entity moved").getInt());
        LIFT_UPDATE_INTERVAL_TICKS = Commons.clamp(1, 60, config.get("lift", "update_interval_ticks", LIFT_UPDATE_INTERVAL_TICKS, "Update speed of the check for entities").getInt());
        LIFT_ENTITY_COOLDOWN_TICKS = Commons.clamp(1, 6000, config.get("lift", "entity_cooldown_ticks", LIFT_ENTITY_COOLDOWN_TICKS, "Cooldown after moving an entity").getInt());
        CHUNK_LOADER_MAX_ENERGY_STORED = Commons.clamp(1, Integer.MAX_VALUE, config.get("chunk_loader", "max_energy_stored", CHUNK_LOADER_MAX_ENERGY_STORED, "Maximum energy stored").getInt());
        CHUNK_LOADER_MAX_RADIUS = Commons.clamp(1, Integer.MAX_VALUE, config.get("chunk_loader", "max_radius", CHUNK_LOADER_MAX_RADIUS, "Maximum radius when loading a square shape, measured in chunks. A linear shape can be up to 1 chunk wide by (radius + 1 + radius) ^ 2 chunks long.").getInt());
        CHUNK_LOADER_ENERGY_PER_CHUNK = Commons.clamp(1, 100, config.get("chunk_loader", "energy_per_chunk", CHUNK_LOADER_ENERGY_PER_CHUNK, "Energy consumed per chunk loaded").getInt());
        ACCELERATOR_ENABLE = config.get("accelerator", "enable", ACCELERATOR_ENABLE, "Enable accelerator blocks. Requires a compatible server, as it won't work in single player").getBoolean(false);
        ACCELERATOR_MAX_PARTICLE_BUNCHES = Commons.clamp(2, 100, config.get("accelerator", "max_particle_bunches", ACCELERATOR_MAX_PARTICLE_BUNCHES, "Maximum number of particle bunches per accelerator controller").getInt());
        config.save();
    }

    public static void loadDictionary(File file) {
        Configuration config = new Configuration(file);
        config.load();
        Dictionary.loadConfig(config);
        config.save();
    }

    public static void registerBlockTransformer(String modId, IBlockTransformer blockTransformer) {
        blockTransformers.put(modId, blockTransformer);
        WarpDrive.logger.info(modId + " blockTransformer registered");
    }

    public static void onFMLInitialization() {
        boolean isThermalDynamicsLoaded;
        boolean isThaumcraftLoaded;
        boolean isTechgunsLoaded;
        boolean isTConstructLoaded;
        boolean isStargateTech2Loaded;
        boolean isSGCraftLoaded;
        boolean isRedstonePasteLoaded;
        boolean isParziStarWarsLoaded;
        boolean isPneumaticCraftLoaded;
        boolean isNaturaLoaded;
        boolean isMetallurgyLoaded;
        boolean isMekanismLoaded;
        boolean isJABBAloaded;
        boolean isEvilCraftLoaded;
        boolean isDraconicEvolutionLoaded;
        boolean isCustomNpcsLoaded;
        boolean isCarpentersBlocksLoaded;
        boolean isBuildCraftLoaded;
        boolean isBiblioCraftLoaded;
        boolean isBotaniaLoaded;
        boolean isArsMagica2Loaded;
        boolean isAppliedEnergistics2Loaded;
        CompatWarpDrive.register();
        isAdvancedRepulsionSystemLoaded = Loader.isModLoaded((String)"AdvancedRepulsionSystems");
        isAdvancedSolarPanelLoaded = Loader.isModLoaded((String)"AdvancedSolarPanel");
        isForgeMultipartLoaded = Loader.isModLoaded((String)"ForgeMultipart");
        isICBMClassicLoaded = Loader.isModLoaded((String)"icbmclassic");
        isNotEnoughItemsLoaded = Loader.isModLoaded((String)"NotEnoughItems");
        isImmersiveEngineeringLoaded = Loader.isModLoaded((String)"ImmersiveEngineering");
        isThermalExpansionLoaded = Loader.isModLoaded((String)"ThermalExpansion");
        if (isAdvancedRepulsionSystemLoaded) {
            CompatAdvancedRepulsionSystems.register();
        }
        if (isAppliedEnergistics2Loaded = Loader.isModLoaded((String)"appliedenergistics2")) {
            CompatAppliedEnergistics2.register();
        }
        if (isArsMagica2Loaded = Loader.isModLoaded((String)"arsmagica2")) {
            CompatArsMagica2.register();
        }
        if (isComputerCraftLoaded) {
            WarpDriveConfig.loadCC();
            CompatComputerCraft.register();
        }
        if (isEnderIOLoaded) {
            CompatEnderIO.register();
        }
        if (isForgeMultipartLoaded) {
            isForgeMultipartLoaded = CompatForgeMultipart.register();
        }
        if (isImmersiveEngineeringLoaded) {
            CompatImmersiveEngineering.register();
        }
        if (isIndustrialCraft2Loaded) {
            WarpDriveConfig.loadIC2();
            CompatIndustrialCraft2.register();
        }
        if (isOpenComputersLoaded) {
            CompatOpenComputers.register();
        }
        if (isThermalExpansionLoaded) {
            CompatThermalExpansion.register();
        }
        if (isBotaniaLoaded = Loader.isModLoaded((String)"Botania")) {
            CompatBotania.register();
        }
        if (isBiblioCraftLoaded = Loader.isModLoaded((String)"BiblioCraft")) {
            CompatBiblioCraft.register();
        }
        if (isBuildCraftLoaded = Loader.isModLoaded((String)"BuildCraft|Core")) {
            CompatBuildCraft.register();
        }
        if (isCarpentersBlocksLoaded = Loader.isModLoaded((String)"CarpentersBlocks")) {
            CompatCarpentersBlocks.register();
        }
        if (isCustomNpcsLoaded = Loader.isModLoaded((String)"customnpcs")) {
            CompatCustomNpcs.register();
        }
        if (isDraconicEvolutionLoaded = Loader.isModLoaded((String)"DraconicEvolution")) {
            CompatDraconicEvolution.register();
        }
        if (isEvilCraftLoaded = Loader.isModLoaded((String)"evilcraft")) {
            CompatEvilCraft.register();
        }
        if (isJABBAloaded = Loader.isModLoaded((String)"JABBA")) {
            CompatJABBA.register();
        }
        if (isMekanismLoaded = Loader.isModLoaded((String)"Mekanism")) {
            CompatMekanism.register();
        }
        if (isMetallurgyLoaded = Loader.isModLoaded((String)"Metallurgy")) {
            CompatMetallurgy.register();
        }
        if (isNaturaLoaded = Loader.isModLoaded((String)"Natura")) {
            CompatNatura.register();
        }
        if (isPneumaticCraftLoaded = Loader.isModLoaded((String)"PneumaticCraft")) {
            CompatPneumaticCraft.register();
        }
        if (isParziStarWarsLoaded = Loader.isModLoaded((String)"starwarsmod")) {
            CompatParziStarWars.register();
        }
        if (isRedstonePasteLoaded = Loader.isModLoaded((String)"RedstonePasteMod")) {
            CompatRedstonePaste.register();
        }
        if (isSGCraftLoaded = Loader.isModLoaded((String)"SGCraft")) {
            CompatSGCraft.register();
        }
        if (isStargateTech2Loaded = Loader.isModLoaded((String)"StargateTech2")) {
            CompatStargateTech2.register();
        }
        if (isTConstructLoaded = Loader.isModLoaded((String)"TConstruct")) {
            CompatTConstruct.register();
        }
        if (isTechgunsLoaded = Loader.isModLoaded((String)"Techguns")) {
            CompatTechguns.register();
        }
        if (isThaumcraftLoaded = Loader.isModLoaded((String)"Thaumcraft")) {
            CompatThaumcraft.register();
        }
        if (isThermalDynamicsLoaded = Loader.isModLoaded((String)"ThermalDynamics")) {
            CompatThermalDynamics.register();
        }
    }

    public static void onFMLPostInitialization() {
        FillerManager.load(configDirectory);
        LootManager.load(configDirectory);
        StructureManager.load(configDirectory);
        Dictionary.apply();
    }

    private static void loadIC2() {
        try {
            IC2_emptyCell = WarpDriveConfig.getModItemStack("IC2", "itemCellEmpty", -1);
            IC2_compressedAir = WarpDriveConfig.getModItemStack("IC2", "itemCellEmpty", 5);
            IC2_rubberWood = WarpDriveConfig.getModBlock("IC2", "blockRubWood");
            IC2_Resin = WarpDriveConfig.getModItemStack("IC2", "itemHarz", -1);
        }
        catch (Exception exception) {
            WarpDrive.logger.error("Error loading IndustrialCraft2 classes");
            exception.printStackTrace();
        }
    }

    private static void loadCC() {
        try {
            CC_Computer = WarpDriveConfig.getModBlock("ComputerCraft", "CC-Computer");
            CC_peripheral = WarpDriveConfig.getModBlock("ComputerCraft", "CC-Peripheral");
            CCT_Turtle = WarpDriveConfig.getModBlock("ComputerCraft", "CC-Turtle");
            CCT_Expanded = WarpDriveConfig.getModBlock("ComputerCraft", "CC-TurtleExpanded");
            CCT_Advanced = WarpDriveConfig.getModBlock("ComputerCraft", "CC-TurtleAdvanced");
        }
        catch (Exception exception) {
            WarpDrive.logger.error("Error loading ComputerCraft classes");
            exception.printStackTrace();
        }
    }

    public static DocumentBuilder getXmlDocumentBuilder() {
        if (xmlDocumentBuilder == null) {
            ErrorHandler xmlErrorHandler = new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) {
                    WarpDrive.logger.warn(String.format("XML warning at line %d: %s", exception.getLineNumber(), exception.getLocalizedMessage()));
                }

                @Override
                public void fatalError(SAXParseException exception) {
                    WarpDrive.logger.warn(String.format("XML fatal error at line %d: %s", exception.getLineNumber(), exception.getLocalizedMessage()));
                }

                @Override
                public void error(SAXParseException exception) {
                    WarpDrive.logger.warn(String.format("XML error at line %d: %s", exception.getLineNumber(), exception.getLocalizedMessage()));
                }
            };
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(false);
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            try {
                xmlDocumentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException exception) {
                exception.printStackTrace();
            }
            xmlDocumentBuilder.setErrorHandler(xmlErrorHandler);
        }
        return xmlDocumentBuilder;
    }

    private static void unpackResourcesToFolder(String prefix, String suffix, String[] filenames, String resourcePathSource, File folderTarget) {
        File[] files = configDirectory.listFiles((file_notUsed, name) -> name.startsWith(prefix) && name.endsWith(suffix));
        if (files == null) {
            throw new RuntimeException(String.format("Critical error accessing configuration directory, searching for %s*%s files: %s", prefix, suffix, configDirectory));
        }
        if (files.length == 0) {
            for (String filename : filenames) {
                WarpDriveConfig.unpackResourceToFolder(filename, resourcePathSource, folderTarget);
            }
        }
    }

    private static void unpackResourceToFolder(String filename, String resourcePathSource, File folderTarget) {
        String resourceName = resourcePathSource + "/" + filename;
        File destination = new File(folderTarget, filename);
        try {
            int bytesRead;
            InputStream inputStream = WarpDrive.class.getClassLoader().getResourceAsStream(resourceName);
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(destination));
            byte[] byteBuffer = new byte[Math.max(8192, inputStream.available())];
            while ((bytesRead = inputStream.read(byteBuffer)) >= 0) {
                outputStream.write(byteBuffer, 0, bytesRead);
            }
            inputStream.close();
            outputStream.close();
        }
        catch (Exception exception) {
            WarpDrive.logger.error("Failed to unpack resource '" + resourceName + "' into " + destination);
            exception.printStackTrace();
        }
    }

    static {
        defaultXML_fillers = new String[]{"filler-default.xml", "filler-netherores.xml", "filler-undergroundbiomes.xml"};
        defaultXML_loots = new String[]{"loot-default.xml"};
        defaultXML_structures = new String[]{"structures-default.xml", "structures-netherores.xml"};
        defaultXML_celestialObjects = new String[]{"celestialObjects-default.xml"};
        FillerManager = new GenericSetManager<Filler>("filler", "filler", "fillerSet", Filler.DEFAULT);
        LootManager = new GenericSetManager<Loot>("loot", "loot", "lootSet", Loot.DEFAULT);
        isAdvancedRepulsionSystemLoaded = false;
        isAdvancedSolarPanelLoaded = false;
        isCoFHCoreLoaded = false;
        isComputerCraftLoaded = false;
        isDefenseTechLoaded = false;
        isEnderIOLoaded = false;
        isForgeMultipartLoaded = false;
        isGregTech5Loaded = false;
        isGregTech6Loaded = false;
        isICBMClassicLoaded = false;
        isICBMLoaded = false;
        isImmersiveEngineeringLoaded = false;
        isIndustrialCraft2Loaded = false;
        isNotEnoughItemsLoaded = false;
        isOpenComputersLoaded = false;
        isThermalExpansionLoaded = false;
        G_SPACE_BIOME_ID = 95;
        G_SPACE_PROVIDER_ID = 14;
        G_HYPERSPACE_PROVIDER_ID = 15;
        G_ENTITY_SPHERE_GENERATOR_ID = 241;
        G_ENTITY_STAR_CORE_ID = 242;
        G_ENTITY_CAMERA_ID = 243;
        G_ENTITY_PARTICLE_BUNCH_ID = 244;
        G_LUA_SCRIPTS = 2;
        G_SCHEMALOCATION = "warpDrive_schematics";
        G_BLOCKS_PER_TICK = 3500;
        G_ENABLE_PROTECTION_CHECKS = true;
        CLIENT_LOCATION_SCALE = 1.0f;
        CLIENT_LOCATION_FORMAT_TITLE = "\u00c2\u00a7l%1$s";
        CLIENT_LOCATION_BACKGROUND_COLOR = Commons.colorARGBtoInt(64, 48, 48, 48);
        CLIENT_LOCATION_TEXT_COLOR = Commons.colorARGBtoInt(230, 180, 180, 240);
        CLIENT_LOCATION_HAS_SHADOW = true;
        CLIENT_LOCATION_SCREEN_ALIGNMENT = EnumDisplayAlignment.MIDDLE_RIGHT;
        CLIENT_LOCATION_SCREEN_OFFSET_X = 0;
        CLIENT_LOCATION_SCREEN_OFFSET_Y = -20;
        CLIENT_LOCATION_TEXT_ALIGNMENT = EnumDisplayAlignment.TOP_RIGHT;
        CLIENT_LOCATION_WIDTH_RATIO = 0.0f;
        CLIENT_LOCATION_WIDTH_MIN = 90;
        CLIENT_TOOLTIP_REGISTRY_NAME = EnumTooltipCondition.ADVANCED_TOOLTIPS;
        CLIENT_TOOLTIP_ORE_DICTIONARY_NAME = EnumTooltipCondition.ALWAYS;
        CLIENT_TOOLTIP_ARMOR = EnumTooltipCondition.ALWAYS;
        CLIENT_TOOLTIP_BURN_TIME = EnumTooltipCondition.ADVANCED_TOOLTIPS;
        CLIENT_TOOLTIP_DURABILITY = EnumTooltipCondition.ALWAYS;
        CLIENT_TOOLTIP_FLAMMABILITY = EnumTooltipCondition.ADVANCED_TOOLTIPS;
        CLIENT_TOOLTIP_FLUID = EnumTooltipCondition.ALWAYS;
        CLIENT_TOOLTIP_HARDNESS = EnumTooltipCondition.ADVANCED_TOOLTIPS;
        CLIENT_TOOLTIP_HARVESTING = EnumTooltipCondition.ALWAYS;
        CLIENT_TOOLTIP_OPACITY = EnumTooltipCondition.ADVANCED_TOOLTIPS;
        CLIENT_TOOLTIP_REPAIR_WITH = EnumTooltipCondition.ON_SNEAK;
        LOGGING_JUMP = false;
        LOGGING_JUMPBLOCKS = false;
        LOGGING_ENERGY = false;
        LOGGING_EFFECTS = false;
        LOGGING_CLOAKING = false;
        LOGGING_VIDEO_CHANNEL = false;
        LOGGING_TARGETING = false;
        LOGGING_WEAPON = false;
        LOGGING_CAMERA = false;
        LOGGING_BUILDING = false;
        LOGGING_COLLECTION = false;
        LOGGING_TRANSPORTER = false;
        LOGGING_LUA = false;
        LOGGING_RADAR = false;
        LOGGING_BREATHING = false;
        LOGGING_WORLD_GENERATION = false;
        LOGGING_PROFILING_CPU_USAGE = true;
        LOGGING_PROFILING_MEMORY_ALLOCATION = false;
        LOGGING_PROFILING_THREAD_SAFETY = false;
        LOGGING_DICTIONARY = false;
        LOGGING_STARMAP = false;
        LOGGING_BREAK_PLACE = false;
        LOGGING_FORCEFIELD = false;
        LOGGING_FORCEFIELD_REGISTRY = false;
        LOGGING_ACCELERATOR = false;
        LOGGING_XML_PREPROCESSOR = false;
        LOGGING_RENDERING = false;
        LOGGING_CHUNK_HANDLER = false;
        LOGGING_CHUNK_LOADING = true;
        LOGGING_ENTITY_FX = false;
        LOGGING_CLIENT_SYNCHRONIZATION = false;
        STARMAP_REGISTRY_UPDATE_INTERVAL_SECONDS = 10;
        STARMAP_ALLOW_OVERLAPPING_CELESTIAL_OBJECTS = false;
        SPACE_GENERATOR_Y_MIN_CENTER = 55;
        SPACE_GENERATOR_Y_MAX_CENTER = 128;
        SPACE_GENERATOR_Y_MIN_BORDER = 5;
        SPACE_GENERATOR_Y_MAX_BORDER = 200;
        SHIP_MOVEMENT_COSTS_FACTORS = null;
        SHIP_MAX_ENERGY_STORED = 100000000;
        SHIP_TELEPORT_ENERGY_PER_ENTITY = 1000000;
        SHIP_VOLUME_MAX_ON_PLANET_SURFACE = 1200;
        SHIP_VOLUME_MIN_FOR_HYPERSPACE = 3000;
        SHIP_MAX_SIDE_SIZE = 127;
        SHIP_COLLISION_TOLERANCE_BLOCKS = 3;
        SHIP_WARMUP_RANDOM_TICKS = 60;
        SHIP_CONTROLLER_UPDATE_INTERVAL_SECONDS = 2;
        SHIP_CORE_ISOLATION_UPDATE_INTERVAL_SECONDS = 10;
        SHIP_VOLUME_SCAN_AGE_TOLERANCE_SECONDS = 120;
        SHIP_VOLUME_UNLIMITED_PLAYERNAMES = new String[]{"notch", "someone"};
        SHIP_SUMMON_MAX_RANGE = 500;
        SHIP_SUMMON_ACROSS_DIMENSIONS = false;
        RADAR_MAX_ENERGY_STORED = 100000000;
        RADAR_SCAN_MIN_ENERGY_COST = 10000;
        RADAR_SCAN_ENERGY_COST_FACTORS = new double[]{0.0, 0.0, 0.0, 1.0E-4};
        RADAR_SCAN_MIN_DELAY_SECONDS = 1;
        RADAR_SCAN_DELAY_FACTORS_SECONDS = new double[]{1.0, 0.001, 0.0, 0.0};
        RADAR_MAX_ISOLATION_RANGE = 2;
        RADAR_MIN_ISOLATION_BLOCKS = 2;
        RADAR_MAX_ISOLATION_BLOCKS = 16;
        RADAR_MIN_ISOLATION_EFFECT = 0.12;
        RADAR_MAX_ISOLATION_EFFECT = 1.0;
        SS_MAX_DEPLOY_RADIUS_BLOCKS = 50;
        SS_SEARCH_INTERVAL_TICKS = 20;
        SS_SCAN_BLOCKS_PER_SECOND = 10;
        SS_DEPLOY_BLOCKS_PER_INTERVAL = 10;
        SS_DEPLOY_INTERVAL_TICKS = 4;
        LASER_MEDIUM_MAX_ENERGY_STORED = 100000;
        LASER_CANNON_MAX_MEDIUMS_COUNT = 10;
        LASER_CANNON_MAX_LASER_ENERGY = 3400000;
        LASER_CANNON_EMIT_FIRE_DELAY_TICKS = 5;
        LASER_CANNON_EMIT_SCAN_DELAY_TICKS = 1;
        LASER_CANNON_BOOSTER_BEAM_ENERGY_EFFICIENCY = 0.6;
        LASER_CANNON_ENERGY_ATTENUATION_PER_AIR_BLOCK = 2.0E-4;
        LASER_CANNON_ENERGY_ATTENUATION_PER_VOID_BLOCK = 5.0E-6;
        LASER_CANNON_ENERGY_ATTENUATION_PER_BROKEN_BLOCK = 0.23;
        LASER_CANNON_RANGE_MAX = 500;
        LASER_CANNON_ENTITY_HIT_SET_ON_FIRE_SECONDS = 20;
        LASER_CANNON_ENTITY_HIT_ENERGY = 15000;
        LASER_CANNON_ENTITY_HIT_BASE_DAMAGE = 3;
        LASER_CANNON_ENTITY_HIT_ENERGY_PER_DAMAGE = 30000;
        LASER_CANNON_ENTITY_HIT_MAX_DAMAGE = 100;
        LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_THRESHOLD = 900000;
        LASER_CANNON_ENTITY_HIT_EXPLOSION_BASE_STRENGTH = 4.0f;
        LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_PER_STRENGTH = 125000;
        LASER_CANNON_ENTITY_HIT_EXPLOSION_MAX_STRENGTH = 4.0f;
        LASER_CANNON_BLOCK_HIT_ENERGY_MIN = 75000;
        LASER_CANNON_BLOCK_HIT_ENERGY_PER_BLOCK_HARDNESS = 150000;
        LASER_CANNON_BLOCK_HIT_ENERGY_MAX = 750000;
        LASER_CANNON_BLOCK_HIT_ABSORPTION_PER_BLOCK_HARDNESS = 0.01;
        LASER_CANNON_BLOCK_HIT_ABSORPTION_MAX = 0.8;
        LASER_CANNON_BLOCK_HIT_EXPLOSION_HARDNESS_THRESHOLD = 5.0f;
        LASER_CANNON_BLOCK_HIT_EXPLOSION_BASE_STRENGTH = 8.0f;
        LASER_CANNON_BLOCK_HIT_EXPLOSION_ENERGY_PER_STRENGTH = 125000;
        LASER_CANNON_BLOCK_HIT_EXPLOSION_MAX_STRENGTH = 50.0f;
        MINING_LASER_MAX_MEDIUMS_COUNT = 3;
        MINING_LASER_RADIUS_NO_LASER_MEDIUM = 4;
        MINING_LASER_RADIUS_PER_LASER_MEDIUM = 1;
        MINING_LASER_WARMUP_DELAY_TICKS = 20;
        MINING_LASER_SCAN_DELAY_TICKS = 20;
        MINING_LASER_MINE_DELAY_TICKS = 3;
        MINING_LASER_SPACE_ENERGY_PER_LAYER = 20000;
        MINING_LASER_PLANET_ENERGY_PER_LAYER = 33000;
        MINING_LASER_SPACE_ENERGY_PER_BLOCK = 1500;
        MINING_LASER_PLANET_ENERGY_PER_BLOCK = 2500;
        MINING_LASER_ORESONLY_ENERGY_FACTOR = 15.0;
        MINING_LASER_SILKTOUCH_ENERGY_FACTOR = 1.5;
        MINING_LASER_SILKTOUCH_DEUTERIUM_L = 0.0;
        MINING_LASER_FORTUNE_ENERGY_FACTOR = 1.5;
        TREE_FARM_MAX_MEDIUMS_COUNT = 5;
        TREE_FARM_MAX_SCAN_RADIUS_NO_LASER_MEDIUM = 3;
        TREE_FARM_MAX_SCAN_RADIUS_PER_LASER_MEDIUM = 2;
        TREE_FARM_totalMaxRadius = 0;
        TREE_FARM_MAX_LOG_DISTANCE = 8;
        TREE_FARM_MAX_LOG_DISTANCE_PER_MEDIUM = 4;
        CLOAKING_MAX_ENERGY_STORED = 500000000;
        CLOAKING_COIL_CAPTURE_BLOCKS = 5;
        CLOAKING_MAX_FIELD_RADIUS = 63;
        CLOAKING_TIER1_ENERGY_PER_BLOCK = 32;
        CLOAKING_TIER2_ENERGY_PER_BLOCK = 128;
        CLOAKING_FIELD_REFRESH_INTERVAL_SECONDS = 3;
        BREATHING_ENERGY_PER_CANISTER = 200;
        BREATHING_ENERGY_PER_NEW_AIR_BLOCK = new int[]{12, 180, 2610};
        BREATHING_ENERGY_PER_EXISTING_AIR_BLOCK = new int[]{4, 60, 870};
        BREATHING_MAX_ENERGY_STORED = new int[]{1400, 21000, 304500};
        BREATHING_AIR_GENERATION_TICKS = 40;
        BREATHING_AIR_GENERATION_RANGE_BLOCKS = new int[]{16, 48, 144};
        BREATHING_VOLUME_UPDATE_DEPTH_BLOCKS = 256;
        BREATHING_AIR_SIMULATION_DELAY_TICKS = 30;
        BREATHING_AIR_AT_ENTITY_DEBUG = false;
        IC2_REACTOR_MAX_HEAT_STORED = 30000;
        IC2_REACTOR_FOCUS_HEAT_TRANSFER_PER_TICK = 648;
        IC2_REACTOR_COMPONENT_HEAT_TRANSFER_PER_TICK = 54;
        IC2_REACTOR_REACTOR_HEAT_TRANSFER_PER_TICK = 54;
        IC2_REACTOR_COOLING_PER_INTERVAL = 1080;
        IC2_REACTOR_ENERGY_PER_HEAT = 2.0;
        IC2_REACTOR_COOLING_INTERVAL_TICKS = 10;
        TRANSPORTER_MAX_ENERGY_STORED = 1000000;
        TRANSPORTER_ENERGY_STORED_UPGRADE_BONUS = TRANSPORTER_MAX_ENERGY_STORED / 2;
        TRANSPORTER_ENERGY_STORED_UPGRADE_MAX_QUANTITY = 8;
        TRANSPORTER_SETUP_UPDATE_PARAMETERS_TICKS = 20;
        TRANSPORTER_SETUP_SCANNER_RANGE_XZ_BLOCKS = 8;
        TRANSPORTER_SETUP_SCANNER_RANGE_Y_BELOW_BLOCKS = 3;
        TRANSPORTER_SETUP_SCANNER_RANGE_Y_ABOVE_BLOCKS = 1;
        TRANSPORTER_RANGE_BASE_BLOCKS = 256;
        TRANSPORTER_RANGE_UPGRADE_BLOCKS = 64;
        TRANSPORTER_RANGE_UPGRADE_MAX_QUANTITY = 8;
        TRANSPORTER_LOCKING_ENERGY_FACTORS = new double[]{20.0, 3.0, 0.0, 10.0, 1.0 / Math.sqrt(2.0)};
        TRANSPORTER_LOCKING_STRENGTH_FACTOR_PER_TICK = Math.pow(0.01, 0.0033333333333333335);
        TRANSPORTER_LOCKING_STRENGTH_IN_WILDERNESS = 0.25;
        TRANSPORTER_LOCKING_STRENGTH_AT_BEACON = 0.5;
        TRANSPORTER_LOCKING_STRENGTH_AT_TRANSPORTER = 1.0;
        TRANSPORTER_LOCKING_STRENGTH_BONUS_AT_MAX_ENERGY_FACTOR = 0.5;
        TRANSPORTER_LOCKING_STRENGTH_UPGRADE = 0.15;
        TRANSPORTER_LOCKING_SPEED_IN_WILDERNESS = 0.25;
        TRANSPORTER_LOCKING_SPEED_AT_BEACON = 0.75;
        TRANSPORTER_LOCKING_SPEED_AT_TRANSPORTER = 1.0;
        TRANSPORTER_LOCKING_SPEED_UPGRADE = 0.25;
        TRANSPORTER_LOCKING_SPEED_OPTIMAL_TICKS = 100;
        TRANSPORTER_LOCKING_UPGRADE_MAX_QUANTITY = 2;
        TRANSPORTER_JAMMED_COOLDOWN_TICKS = 40;
        TRANSPORTER_ENERGIZING_ENERGY_FACTORS = new double[]{10000.0, 1500.0, 0.0, 10.0, 1.0 / Math.sqrt(2.0)};
        TRANSPORTER_ENERGIZING_MAX_ENERGY_FACTOR = 10.0;
        TRANSPORTER_ENERGIZING_FAILURE_MAX_DAMAGE = 5;
        TRANSPORTER_ENERGIZING_SUCCESS_LOCK_BONUS = 0.2;
        TRANSPORTER_ENERGIZING_SUCCESS_MAX_DAMAGE = 100;
        TRANSPORTER_ENERGIZING_LOCKING_LOST = 0.5;
        TRANSPORTER_ENERGIZING_CHARGING_TICKS = 60;
        TRANSPORTER_ENERGIZING_COOLDOWN_TICKS = 200;
        TRANSPORTER_ENERGIZING_ENTITY_MOVEMENT_TOLERANCE_BLOCKS = 1.0;
        TRANSPORTER_ENTITY_GRAB_RADIUS_BLOCKS = 2;
        TRANSPORTER_FOCUS_SEARCH_RADIUS_BLOCKS = 2;
        TRANSPORTER_BEACON_MAX_ENERGY_STORED = 60000;
        TRANSPORTER_BEACON_ENERGY_PER_TICK = 10;
        TRANSPORTER_BEACON_DEPLOYING_DELAY_TICKS = 20;
        ENAN_REACTOR_MAX_ENERGY_STORED = 100000000;
        ENAN_REACTOR_UPDATE_INTERVAL_TICKS = 5;
        ENAN_REACTOR_MAX_LASERS_PER_SECOND = 6;
        ENERGY_BANK_MAX_ENERGY_STORED = new int[]{800000, 4000000, 20000000};
        ENERGY_BANK_IC2_TIER = new int[]{2, 3, 4};
        ENERGY_BANK_TRANSFER_PER_TICK = new int[]{200, 1000, 5000};
        ENERGY_BANK_EFFICIENCY_PER_UPGRADE = new double[]{0.95, 0.98, 1.0};
        LIFT_MAX_ENERGY_STORED = 900;
        LIFT_ENERGY_PER_ENTITY = 150;
        LIFT_UPDATE_INTERVAL_TICKS = 10;
        LIFT_ENTITY_COOLDOWN_TICKS = 40;
        CHUNK_LOADER_MAX_ENERGY_STORED = 1000000;
        CHUNK_LOADER_MAX_RADIUS = 2;
        CHUNK_LOADER_ENERGY_PER_CHUNK = 8;
        HULL_HARDNESS = new float[]{25.0f, 50.0f, 80.0f};
        HULL_BLAST_RESISTANCE = new float[]{60.0f, 90.0f, 120.0f};
        blockTransformers = new HashMap(30);
        ACCELERATOR_ENABLE = false;
        ACCELERATOR_TEMPERATURES_K = new double[]{270.0, 200.0, 7.0};
        ACCELERATOR_MAX_PARTICLE_BUNCHES = 20;
    }
}

