/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.XmlPreprocessor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class XmlFileManager {
    protected void load(File dir, String prefixFilename, String nameElement) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("File path " + dir.getPath() + " must be a directory!");
        }
        File[] files = dir.listFiles((file_notUsed, name) -> name.startsWith(prefixFilename) && name.endsWith(".xml"));
        if (files == null || files.length == 0) {
            throw new IllegalArgumentException("File path " + dir.getPath() + " contains no " + prefixFilename + "*.xml files!");
        }
        for (File file : files) {
            try {
                WarpDrive.logger.info("Loading configuration file " + file.getName());
                Document document = WarpDriveConfig.getXmlDocumentBuilder().parse(file);
                String result = XmlPreprocessor.checkModRequirements(document.getDocumentElement());
                if (!result.isEmpty()) {
                    WarpDrive.logger.info("Skipping configuration file " + file.getName() + " due to " + result);
                    continue;
                }
                XmlPreprocessor.doModReqSanitation(document);
                XmlPreprocessor.doLogicPreprocessing(document);
                List<Element> listElements = XmlFileManager.getChildrenElementByTagName(document.getDocumentElement(), nameElement);
                for (int indexElement = 0; indexElement < listElements.size(); ++indexElement) {
                    Element element = listElements.get(indexElement);
                    String location = String.format("%s %d/%d", nameElement, indexElement + 1, listElements.size());
                    this.parseRootElement(location, element);
                }
            }
            catch (Exception exception) {
                WarpDrive.logger.error("Error loading file " + file.getName() + ": " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    protected abstract void parseRootElement(String var1, Element var2) throws InvalidXmlException, SAXException, IOException;

    public static List<Element> getChildrenElementByTagName(Element parent, String name) {
        ArrayList<Element> listElements = new ArrayList<Element>();
        for (Node nodeChild = parent.getFirstChild(); nodeChild != null; nodeChild = nodeChild.getNextSibling()) {
            if (nodeChild.getNodeType() != 1 || !name.equals(nodeChild.getNodeName())) continue;
            listElements.add((Element)nodeChild);
        }
        return listElements;
    }
}

