/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.api.IXmlRepresentable;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.XmlFileManager;
import cr0s.warpdrive.config.structures.AbstractStructureInstance;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.w3c.dom.Element;

public abstract class AbstractStructure
extends WorldGenerator
implements IXmlRepresentable {
    protected String group;
    protected String name;
    protected HashMap<String, String> variables = new HashMap();

    public AbstractStructure(String group, String name) {
        this.group = group;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.group + ":" + this.name;
    }

    public abstract AbstractStructureInstance instantiate(Random var1);

    @Override
    public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
        List<Element> listVariables = XmlFileManager.getChildrenElementByTagName(element, "variable");
        for (Element elementVariable : listVariables) {
            String variableName = elementVariable.getAttribute("name");
            String variableExpression = elementVariable.getTextContent();
            this.variables.put(variableName, variableExpression);
        }
        return true;
    }
}

