/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.LocalProfiler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.structures.AbstractStructure;
import cr0s.warpdrive.config.structures.AbstractStructureInstance;
import cr0s.warpdrive.config.structures.AsteroidField;
import cr0s.warpdrive.config.structures.StructureManager;
import cr0s.warpdrive.world.WorldGenSmallShip;
import cr0s.warpdrive.world.WorldGenStation;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class AsteroidFieldInstance
extends AbstractStructureInstance {
    public AsteroidFieldInstance(AsteroidField asteroidField, Random random) {
        super(asteroidField, random);
    }

    public AsteroidFieldInstance(NBTTagCompound tagCompound) {
        super(tagCompound);
    }

    @Override
    public void WriteToNBT(NBTTagCompound tagCompound) {
        super.WriteToNBT(tagCompound);
    }

    private static float binomialRandom(World world) {
        float linear = world.field_73012_v.nextFloat();
        return 1.25f - 0.625f / (0.5f + 2.0f * linear);
    }

    public boolean func_76484_a(World world, Random random, int x, int y1, int z) {
        AbstractStructure asteroid;
        int aZ;
        int aY;
        int aX;
        float verticalRange;
        float horizontalRange;
        double yawn;
        double bearing;
        float binomial;
        int i;
        LocalProfiler.start("AsteroidFieldInstance.generate");
        float surfacePerAsteroid = 80.0f + world.field_73012_v.nextFloat() * 300.0f;
        int maxDistance = 30 + world.field_73012_v.nextInt(170);
        int maxDistanceBig = Math.round((float)maxDistance * (0.6f + 0.2f * world.field_73012_v.nextFloat()));
        int maxDistanceSmall = Math.round((float)maxDistance * 1.1f);
        float bigRatio = 0.3f + world.field_73012_v.nextFloat() * 0.3f;
        float surfaceBig = (float)(Math.PI * Math.pow(maxDistanceBig, 2.0));
        float surfaceSmall = (float)(Math.PI * Math.pow(maxDistanceSmall, 2.0));
        int numOfBigAsteroids = Math.round(bigRatio * surfaceBig / surfacePerAsteroid);
        int numOfSmallAsteroids = Math.round((1.0f - bigRatio) * surfaceSmall / surfacePerAsteroid);
        int numOfClouds = Math.round((float)numOfBigAsteroids * 1.0f / (10.0f + (float)world.field_73012_v.nextInt(10)));
        int maxHeight = 70 + world.field_73012_v.nextInt(50);
        int y2 = Math.min(WarpDriveConfig.SPACE_GENERATOR_Y_MAX_BORDER - maxHeight, Math.max(y1, WarpDriveConfig.SPACE_GENERATOR_Y_MIN_BORDER + maxHeight));
        WarpDrive.logger.info("Generating asteroid field at (" + x + " " + y2 + " " + z + ") qty " + numOfBigAsteroids + ", " + numOfSmallAsteroids + ", " + numOfClouds + " over " + maxDistance + ", " + maxHeight + " surfacePerAsteroid " + String.format("%.1f", Float.valueOf(surfacePerAsteroid)));
        for (i = 1; i <= numOfBigAsteroids; ++i) {
            binomial = AsteroidFieldInstance.binomialRandom(world);
            bearing = (double)world.field_73012_v.nextFloat() * 2.0 * Math.PI;
            yawn = (double)world.field_73012_v.nextFloat() * Math.PI;
            horizontalRange = Math.max(6.0f, binomial * (float)maxDistanceBig);
            verticalRange = Math.max(3.0f, binomial * (float)maxHeight);
            aX = (int)((long)x + Math.round((double)horizontalRange * Math.cos(bearing)));
            aY = (int)((long)y2 + Math.round((double)verticalRange * Math.cos(yawn)));
            aZ = (int)((long)z + Math.round((double)horizontalRange * Math.sin(bearing)));
            if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
                WarpDrive.logger.info(String.format("Big asteroid: %.3f %.3f r %.3f r makes (%3d %3d %3d)", binomial, bearing, yawn, aX, aY, aZ));
            }
            if ((asteroid = StructureManager.getStructure(world.field_73012_v, "asteroid", null)) == null) {
                WarpDrive.logger.error(String.format("Unable to generate big asteroid in DIM%d @ (%d %d %d), probably a bad configuration", world.field_73011_w.field_76574_g, aX, aY, aZ));
                continue;
            }
            asteroid.func_76484_a(world, world.field_73012_v, aX, aY, aZ);
        }
        for (i = 1; i <= numOfSmallAsteroids; ++i) {
            binomial = AsteroidFieldInstance.binomialRandom(world);
            bearing = (double)world.field_73012_v.nextFloat() * 2.0 * Math.PI;
            yawn = (double)world.field_73012_v.nextFloat() * Math.PI;
            horizontalRange = Math.max(6.0f, binomial * (float)maxDistanceSmall);
            verticalRange = Math.max(3.0f, binomial * (float)maxHeight);
            aX = (int)((long)x + Math.round((double)horizontalRange * Math.cos(bearing)));
            aY = (int)((long)y2 + Math.round((double)verticalRange * Math.cos(yawn)));
            aZ = (int)((long)z + Math.round((double)horizontalRange * Math.sin(bearing)));
            if (world.field_73012_v.nextInt(400) != 1) {
                asteroid = StructureManager.getStructure(world.field_73012_v, "asteroid", null);
                if (asteroid == null) {
                    WarpDrive.logger.error(String.format("Unable to generate small asteroid in DIM%d @ (%d %d %d), probably a bad configuration", world.field_73011_w.field_76574_g, aX, aY, aZ));
                    continue;
                }
                asteroid.func_76484_a(world, world.field_73012_v, aX, aY, aZ);
                continue;
            }
            if (world.field_73012_v.nextInt(20) != 1) {
                AsteroidFieldInstance.generateSmallShip(world, aX, aY, aZ, 8);
                continue;
            }
            AsteroidFieldInstance.generateStation(world, aX, aY, aZ, 8);
        }
        for (i = 1; i <= numOfClouds; ++i) {
            binomial = AsteroidFieldInstance.binomialRandom(world);
            bearing = (double)world.field_73012_v.nextFloat() * 2.0 * Math.PI;
            yawn = (double)world.field_73012_v.nextFloat() * Math.PI;
            horizontalRange = Math.max(6.0f, binomial * (float)maxDistanceBig);
            verticalRange = Math.max(3.0f, binomial * (float)maxHeight);
            aX = (int)((long)x + Math.round((double)horizontalRange * Math.cos(bearing)));
            aY = (int)((long)y2 + Math.round((double)verticalRange * Math.cos(yawn)));
            aZ = (int)((long)z + Math.round((double)horizontalRange * Math.sin(bearing)));
            if (!world.field_73012_v.nextBoolean()) continue;
            AbstractStructure gasCloud = StructureManager.getStructure(world.field_73012_v, "gascloud", null);
            if (gasCloud == null) {
                WarpDrive.logger.error(String.format("Unable to generate gas cloud in DIM%d @ (%d %d %d), probably a bad configuration", world.field_73011_w.field_76574_g, aX, aY, aZ));
                continue;
            }
            gasCloud.func_76484_a(world, world.field_73012_v, aX, aY, aZ);
        }
        LocalProfiler.stop();
        return true;
    }

    private static void generateSmallShip(World world, int x, int y, int z, int jitter) {
        int x2 = x + (world.field_73012_v.nextBoolean() ? -1 : 1) * world.field_73012_v.nextInt(jitter);
        int y2 = y + (world.field_73012_v.nextBoolean() ? -1 : 1) * world.field_73012_v.nextInt(jitter);
        int z2 = z + (world.field_73012_v.nextBoolean() ? -1 : 1) * world.field_73012_v.nextInt(jitter);
        WarpDrive.logger.info("Generating small ship at " + x2 + " " + y2 + " " + z2);
        new WorldGenSmallShip(world.field_73012_v.nextFloat() > 0.2f, false).func_76484_a(world, world.field_73012_v, x2, y2, z2);
    }

    private static void generateStation(World world, int x, int y, int z, int jitter) {
        int x2 = x + (world.field_73012_v.nextBoolean() ? -1 : 1) * world.field_73012_v.nextInt(jitter);
        int y2 = y + (world.field_73012_v.nextBoolean() ? -1 : 1) * world.field_73012_v.nextInt(jitter);
        int z2 = z + (world.field_73012_v.nextBoolean() ? -1 : 1) * world.field_73012_v.nextInt(jitter);
        WarpDrive.logger.info("Generating station at " + x2 + " " + y2 + " " + z2);
        new WorldGenStation(world.field_73012_v.nextBoolean()).func_76484_a(world, world.field_73012_v, x2, y2, z2);
    }
}

