/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.Filler;
import cr0s.warpdrive.config.GenericSet;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.XmlFileManager;
import cr0s.warpdrive.config.structures.AbstractStructure;
import cr0s.warpdrive.config.structures.AbstractStructureInstance;
import cr0s.warpdrive.config.structures.OrbInstance;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import org.w3c.dom.Element;

public class Orb
extends AbstractStructure {
    protected OrbShell[] orbShells;
    protected boolean hasStarCore = false;
    protected String schematicName;

    public Orb(String group, String name) {
        super(group, name);
    }

    @Override
    public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
        super.loadFromXmlElement(element);
        List<Element> listShells = XmlFileManager.getChildrenElementByTagName(element, "shell");
        this.orbShells = new OrbShell[listShells.size()];
        int shellIndexOut = 0;
        for (Element elementShell : listShells) {
            String orbShellName = elementShell.getAttribute("name");
            this.orbShells[shellIndexOut] = new OrbShell(this.getFullName(), orbShellName);
            try {
                this.orbShells[shellIndexOut].loadFromXmlElement(elementShell);
                ++shellIndexOut;
            }
            catch (InvalidXmlException exception) {
                exception.printStackTrace();
                WarpDrive.logger.error("Skipping invalid shell " + orbShellName);
            }
        }
        List<Element> listSchematic = XmlFileManager.getChildrenElementByTagName(element, "schematic");
        if (listSchematic.size() > 1) {
            WarpDrive.logger.error("Too many schematic defined, only first one will be used in structure " + this.getFullName());
        }
        if (listSchematic.size() > 0) {
            this.schematicName = listSchematic.get(0).getAttribute("group");
        }
        return true;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        return this.instantiate(random).func_76484_a(world, random, x, y, z);
    }

    @Override
    public AbstractStructureInstance instantiate(Random random) {
        return new OrbInstance(this, random);
    }

    public class OrbShell
    extends GenericSet<Filler> {
        private final String parentFullName;
        protected int minThickness;
        protected int maxThickness;

        public OrbShell(String parentFullName, String name) {
            super(null, name, Filler.DEFAULT, "filler");
            this.parentFullName = parentFullName;
        }

        @Override
        public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
            if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
                WarpDrive.logger.info("  + found shell " + element.getAttribute("name"));
            }
            super.loadFromXmlElement(element);
            for (String importGroupName : this.getImportGroupNames()) {
                GenericSet<Filler> fillerSet = WarpDriveConfig.FillerManager.getGenericSet(importGroupName);
                if (fillerSet == null) {
                    WarpDrive.logger.warn("Skipping missing FillerSet " + importGroupName + " in shell " + this.parentFullName + ":" + this.name);
                    continue;
                }
                this.loadFrom(fillerSet);
            }
            for (String importGroup : this.getImportGroups()) {
                if (WarpDriveConfig.FillerManager.doesGroupExist(importGroup)) continue;
                WarpDrive.logger.warn("An invalid FillerSet group " + importGroup + " is referenced in shell " + this.parentFullName + ":" + this.name);
            }
            try {
                this.minThickness = Integer.parseInt(element.getAttribute("minThickness"));
            }
            catch (NumberFormatException exception) {
                throw new InvalidXmlException("Invalid minThickness in shell " + this.name + " of structure " + this.parentFullName);
            }
            try {
                this.maxThickness = Integer.parseInt(element.getAttribute("maxThickness"));
            }
            catch (NumberFormatException exception) {
                throw new InvalidXmlException("Invalid maxThickness in shell " + this.name + " of structure " + this.parentFullName);
            }
            if (this.maxThickness < this.minThickness) {
                throw new InvalidXmlException("Invalid maxThickness " + this.maxThickness + " lower than minThickness " + this.minThickness + " in shell " + this.name + " of orb " + this.parentFullName);
            }
            return true;
        }

        public OrbShell instantiate(Random random) {
            OrbShell orbShell = new OrbShell(this.parentFullName, this.name);
            orbShell.minThickness = this.minThickness;
            orbShell.maxThickness = this.maxThickness;
            try {
                orbShell.loadFrom(this);
                for (String importGroup : this.getImportGroups()) {
                    GenericSet<Filler> fillerSet = WarpDriveConfig.FillerManager.getRandomSetFromGroup(random, importGroup);
                    if (fillerSet == null) {
                        WarpDrive.logger.info("Ignoring invalid group " + importGroup + " in shell " + this.name + " of structure " + this.parentFullName);
                        continue;
                    }
                    if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
                        WarpDrive.logger.info("Filling " + this.parentFullName + ":" + this.name + " with " + importGroup + ":" + fillerSet.getName());
                    }
                    orbShell.loadFrom(fillerSet);
                }
            }
            catch (InvalidXmlException exception) {
                exception.printStackTrace();
                WarpDrive.logger.error("Failed to instantiate shell " + this.name + " from structure " + this.parentFullName);
            }
            if (orbShell.isEmpty()) {
                if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
                    WarpDrive.logger.info("Ignoring empty shell " + this.name + " in structure " + this.parentFullName + "");
                }
                return null;
            }
            return orbShell;
        }
    }
}

