/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.LocalProfiler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IControlChannel;
import cr0s.warpdrive.block.atomic.BlockAcceleratorControlPoint;
import cr0s.warpdrive.block.atomic.BlockChiller;
import cr0s.warpdrive.block.atomic.BlockElectromagnetPlain;
import cr0s.warpdrive.block.atomic.BlockParticlesCollider;
import cr0s.warpdrive.block.atomic.BlockParticlesInjector;
import cr0s.warpdrive.block.atomic.BlockVoidShellPlain;
import cr0s.warpdrive.block.atomic.TileEntityAcceleratorControlPoint;
import cr0s.warpdrive.block.atomic.TileEntityParticlesInjector;
import cr0s.warpdrive.block.energy.BlockEnergyBank;
import cr0s.warpdrive.block.energy.TileEntityEnergyBank;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.GlobalPosition;
import cr0s.warpdrive.data.TrajectoryPoint;
import cr0s.warpdrive.data.VectorI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class AcceleratorSetup
extends GlobalPosition {
    private static final int ACCELERATOR_MAX_RANGE_SQUARED = 36864;
    private HashMap<VectorI, TrajectoryPoint> trajectoryAccelerator;
    private HashMap<VectorI, TrajectoryPoint> trajectoryTransfer;
    private int[] countMagnets = new int[3];
    private int[] countChillers = new int[3];
    private final HashMap<VectorI, Integer> controlPoints = new HashMap();
    public final HashMap<VectorI, Byte> chillers = new HashMap();
    public final Set<TileEntityEnergyBank> energyBanks = new HashSet<TileEntityEnergyBank>();
    public final int energy_maxStorage;
    public final Set<VectorI> setJammed = new HashSet<VectorI>();
    public final TreeMap<Integer, VectorI> mapInjectors = new TreeMap();
    public final Integer[] keyInjectors;
    public final ArrayList<TrajectoryPoint> listColliders = new ArrayList();
    private VectorI vMin;
    private VectorI vMax;
    public double temperatureTarget_K;
    public double[] temperatures_cooling_K_perTick = new double[3];
    public double temperature_coolingEnergyCost_perTick;
    public double[] temperatures_sustainEnergyCost_perTick = new double[3];
    public double particleEnergy_energyCost_perTick;

    public AcceleratorSetup(int dimensionId, int x, int y, int z) {
        super(dimensionId, x, y, z);
        LocalProfiler.start(String.format("[AcceleratorSetup] Scanning @ DIM%d (%d %d %d)", dimensionId, x, y, z));
        this.refresh();
        if (this.energyBanks.isEmpty()) {
            this.energy_maxStorage = 0;
        } else {
            int maxStorage = 0;
            for (TileEntityEnergyBank tileEntityEnergyBank : this.energyBanks) {
                maxStorage += tileEntityEnergyBank.energy_getMaxStorage();
            }
            this.energy_maxStorage = maxStorage;
        }
        this.keyInjectors = this.mapInjectors.isEmpty() ? null : this.mapInjectors.keySet().toArray(new Integer[0]);
        if (WarpDriveConfig.LOGGING_ACCELERATOR) {
            WarpDrive.logger.info(String.format("Accelerator length: %d + %d including %d + %d + %d magnets, %d chillers and %d energy banks cooldown: %.3f %.3f %.3f /t %.3f EU/t sustain: %.3f %.3f %.3f EU/t acceleration: %.3f /particle", this.trajectoryAccelerator == null ? -1 : this.trajectoryAccelerator.size(), this.trajectoryTransfer == null ? -1 : this.trajectoryTransfer.size(), this.countMagnets[0], this.countMagnets[1], this.countMagnets[2], this.chillers.size(), this.energyBanks.size(), this.temperatures_cooling_K_perTick[0], this.temperatures_cooling_K_perTick[1], this.temperatures_cooling_K_perTick[2], this.temperature_coolingEnergyCost_perTick, this.temperatures_sustainEnergyCost_perTick[0], this.temperatures_sustainEnergyCost_perTick[1], this.temperatures_sustainEnergyCost_perTick[2], this.particleEnergy_energyCost_perTick));
        }
        LocalProfiler.stop();
    }

    private void addToBoundingBox(VectorI vector, int range) {
        this.vMin.x = Math.min(this.vMin.x, vector.x - range);
        this.vMin.y = Math.min(this.vMin.y, vector.y - range);
        this.vMin.z = Math.min(this.vMin.z, vector.z - range);
        this.vMax.x = Math.max(this.vMax.x, vector.x + range);
        this.vMax.y = Math.max(this.vMax.y, vector.y + range);
        this.vMax.z = Math.max(this.vMax.z, vector.z + range);
    }

    private void refresh() {
        WorldServer world = this.getWorldServerIfLoaded();
        if (world == null) {
            if (WarpDriveConfig.LOGGING_ACCELERATOR) {
                WarpDrive.logger.warn(String.format("Accelerator scan cancelled: Dimension %d isn't loaded", this.dimensionId));
            }
            return;
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            WarpDrive.logger.warn("Accelerator scan cancelled: client side");
            return;
        }
        this.fillTrajectoryPoints(world);
        if (this.trajectoryAccelerator == null) {
            return;
        }
        this.computeCountsAndBoundingBox();
        this.computeVectorArrays(world);
        int indexHighest = this.countMagnets[2] > 0 ? 2 : (this.countMagnets[1] > 0 ? 1 : 0);
        this.temperatureTarget_K = WarpDriveConfig.ACCELERATOR_TEMPERATURES_K[indexHighest];
        double coolingFactor = 10.0 / (double)(this.countMagnets[0] + this.countMagnets[1] + this.countMagnets[2]);
        this.temperatures_cooling_K_perTick[0] = ((double)this.countChillers[0] * 1.0 + (double)this.countChillers[1] * 0.75 + (double)this.countChillers[2] * 0.5) * coolingFactor;
        this.temperatures_cooling_K_perTick[1] = ((double)this.countChillers[1] * 1.0 + (double)this.countChillers[2] * 0.75) * coolingFactor;
        this.temperatures_cooling_K_perTick[2] = (double)this.countChillers[2] * 1.0 * coolingFactor;
        this.temperature_coolingEnergyCost_perTick = (double)this.countChillers[0] * 10.0 + (double)this.countChillers[1] * 20.0 + (double)this.countChillers[2] * 40.0;
        this.temperatures_sustainEnergyCost_perTick[0] = (double)this.countChillers[0] * 1.0 + (double)this.countChillers[1] * 2.0 + (double)this.countChillers[2] * 2.0;
        this.temperatures_sustainEnergyCost_perTick[1] = (double)this.countChillers[0] * 0.5 + (double)this.countChillers[1] * 2.0 + (double)this.countChillers[2] * 3.0;
        this.temperatures_sustainEnergyCost_perTick[2] = (double)this.countChillers[0] * 0.25 + (double)this.countChillers[1] * 1.0 + (double)this.countChillers[2] * 4.0;
        this.particleEnergy_energyCost_perTick = (double)this.countMagnets[0] * 1.0 + (double)this.countMagnets[1] * 2.0 + (double)this.countMagnets[2] * 3.0;
    }

    private void fillTrajectoryPoints(WorldServer world) {
        ImmutableSet whitelist = ImmutableSet.of((Object)WarpDrive.blockElectromagnetPlain[0], (Object)WarpDrive.blockElectromagnetGlass[0], (Object)WarpDrive.blockElectromagnetPlain[1], (Object)WarpDrive.blockElectromagnetGlass[1], (Object)WarpDrive.blockElectromagnetPlain[2], (Object)WarpDrive.blockElectromagnetGlass[2], (Object[])new Block[]{WarpDrive.blockVoidShellPlain, WarpDrive.blockVoidShellGlass});
        Set<VectorI> connections = Commons.getConnectedBlocks((World)world, new VectorI(this.x, this.y, this.z), ForgeDirection.VALID_DIRECTIONS, (Set<Block>)whitelist, 3, new VectorI[0]);
        VectorI firstVoidShell = null;
        for (VectorI vectorI : connections) {
            Block block = vectorI.getBlock((IBlockAccess)world);
            if (!(block instanceof BlockVoidShellPlain)) continue;
            firstVoidShell = vectorI.clone();
            break;
        }
        if (WarpDriveConfig.LOGGING_ACCELERATOR) {
            WarpDrive.logger.info("First void shell is " + firstVoidShell);
        }
        if (firstVoidShell == null) {
            WarpDrive.logger.warn("No void shell connection found");
            return;
        }
        whitelist = ImmutableSet.of((Object)WarpDrive.blockVoidShellPlain, (Object)WarpDrive.blockVoidShellGlass);
        TrajectoryPoint trajectoryPoint = null;
        for (ForgeDirection direction : Commons.HORIZONTAL_DIRECTIONS) {
            VectorI next = firstVoidShell.clone(direction);
            if (!whitelist.contains(next.getBlock_noChunkLoading((IBlockAccess)world))) continue;
            trajectoryPoint = new TrajectoryPoint((World)world, firstVoidShell.translate(direction), direction);
            break;
        }
        if (WarpDriveConfig.LOGGING_ACCELERATOR) {
            WarpDrive.logger.info("First one is " + trajectoryPoint);
        }
        if (trajectoryPoint == null) {
            return;
        }
        this.trajectoryAccelerator = new HashMap();
        this.trajectoryTransfer = new HashMap();
        HashSet<TrajectoryPoint> hashSet = new HashSet<TrajectoryPoint>();
        hashSet.add(trajectoryPoint.clone());
        trajectoryPoint = new TrajectoryPoint((World)world, trajectoryPoint.translate(trajectoryPoint.directionBackward), trajectoryPoint.directionBackward);
        hashSet.add(trajectoryPoint);
        HashSet<TrajectoryPoint> transferToAdd = new HashSet<TrajectoryPoint>();
        while (!hashSet.isEmpty()) {
            TrajectoryPoint trajectoryPointToAdd;
            TrajectoryPoint trajectoryToAdd;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                trajectoryPoint = trajectoryToAdd = (TrajectoryPoint)iterator.next();
                while (trajectoryPoint.hasNoMissingVoidShells() && this.isInRange(trajectoryPoint) && !this.trajectoryAccelerator.containsKey(trajectoryPoint)) {
                    if (WarpDriveConfig.LOGGING_ACCELERATOR) {
                        WarpDrive.logger.info("Adding accelerator " + trajectoryPoint);
                    }
                    trajectoryPointToAdd = trajectoryPoint.clone();
                    this.trajectoryAccelerator.put(trajectoryPointToAdd, trajectoryPointToAdd);
                    if (trajectoryPoint.vJunctionForward != null) {
                        transferToAdd.add(new TrajectoryPoint((World)world, trajectoryPoint, true));
                    }
                    if (trajectoryPoint.vJunctionBackward != null) {
                        transferToAdd.add(new TrajectoryPoint((World)world, trajectoryPoint, false));
                    }
                    trajectoryPoint = new TrajectoryPoint((World)world, trajectoryPoint.translate(trajectoryPoint.directionForward), trajectoryPoint.directionForward);
                }
            }
            hashSet.clear();
            iterator = transferToAdd.iterator();
            while (iterator.hasNext()) {
                trajectoryPoint = trajectoryToAdd = (TrajectoryPoint)iterator.next();
                while (trajectoryPoint.hasNoMissingVoidShells() && this.isInRange(trajectoryPoint) && !this.trajectoryTransfer.containsKey(trajectoryPoint) && !trajectoryPoint.needsReevaluation()) {
                    if (WarpDriveConfig.LOGGING_ACCELERATOR) {
                        WarpDrive.logger.info("Adding transfer " + trajectoryPoint);
                    }
                    trajectoryPointToAdd = trajectoryPoint.clone();
                    this.trajectoryTransfer.put(trajectoryPointToAdd, trajectoryPointToAdd);
                    trajectoryPoint = new TrajectoryPoint((World)world, trajectoryPoint, true);
                }
                if (!trajectoryPoint.needsReevaluation()) continue;
                trajectoryPoint = new TrajectoryPoint((World)world, trajectoryPoint.translate(trajectoryPoint.directionForward), trajectoryPoint.directionForward);
                hashSet.add(trajectoryPoint.clone());
                trajectoryPoint = new TrajectoryPoint((World)world, trajectoryPoint.translate(trajectoryPoint.directionBackward), trajectoryPoint.directionBackward);
                hashSet.add(trajectoryPoint);
            }
            transferToAdd.clear();
        }
    }

    private boolean isInRange(TrajectoryPoint trajectoryPoint) {
        double distanceSquared = trajectoryPoint.distance2To(new VectorI(this.x, this.y, this.z));
        return distanceSquared <= 36864.0;
    }

    private void computeCountsAndBoundingBox() {
        boolean isFirst = true;
        for (TrajectoryPoint trajectoryPoint : this.trajectoryAccelerator.values()) {
            if (isFirst) {
                this.vMin = trajectoryPoint.getVectorI();
                this.vMax = trajectoryPoint.getVectorI();
                isFirst = false;
            }
            this.addToBoundingBox(trajectoryPoint, 2);
            int indexTier = (trajectoryPoint.type & 3) - 1;
            if ((trajectoryPoint.type & 4) != 0 && indexTier >= 0) {
                int n = indexTier;
                this.countMagnets[n] = this.countMagnets[n] + 2;
            }
            if ((trajectoryPoint.type & 8) != 0 && indexTier >= 0) {
                int n = indexTier;
                this.countMagnets[n] = this.countMagnets[n] + 2;
            }
            if ((trajectoryPoint.type & 0x30) != 0 && indexTier > 0) {
                int n = indexTier - 1;
                this.countMagnets[n] = this.countMagnets[n] + 12;
            }
            if ((trajectoryPoint.type & 0xC0) == 0 || indexTier >= 2) continue;
            int n = indexTier + 1;
            this.countMagnets[n] = this.countMagnets[n] + 12;
        }
        WarpDrive.logger.info("Bounding box is " + this.vMin + " to " + this.vMax);
    }

    private void computeVectorArrays(WorldServer world) {
        for (TrajectoryPoint trajectoryPoint : this.trajectoryAccelerator.values()) {
            VectorI vectorToAdd;
            Block blockForward;
            if (trajectoryPoint.isJammed()) {
                this.setJammed.add(trajectoryPoint);
            }
            if ((blockForward = (vectorToAdd = trajectoryPoint.clone(trajectoryPoint.directionForward.getOpposite())).getBlock((IBlockAccess)world)) instanceof BlockParticlesInjector) {
                int controlChannel = ((TileEntityParticlesInjector)vectorToAdd.getTileEntity((IBlockAccess)world)).getControlChannel();
                this.mapInjectors.put(controlChannel, vectorToAdd);
                this.addToBoundingBox(vectorToAdd, 1);
            } else {
                vectorToAdd = trajectoryPoint.clone(trajectoryPoint.directionBackward.getOpposite());
                Block blockBackward = vectorToAdd.getBlock((IBlockAccess)world);
                if (blockBackward instanceof BlockParticlesInjector) {
                    int controlChannel = ((TileEntityParticlesInjector)vectorToAdd.getTileEntity((IBlockAccess)world)).getControlChannel();
                    this.mapInjectors.put(controlChannel, vectorToAdd);
                    this.addToBoundingBox(vectorToAdd, 1);
                }
            }
            if (trajectoryPoint.vControlPoint != null) {
                this.controlPoints.put(trajectoryPoint.vControlPoint, trajectoryPoint.type);
                this.addToBoundingBox(trajectoryPoint.vControlPoint, 1);
                if (trajectoryPoint.isCollider()) {
                    this.listColliders.add(trajectoryPoint);
                }
            }
            if (trajectoryPoint.vControlPoint != null || (trajectoryPoint.type & 0xC) == 0) continue;
            this.scanCorners(world, trajectoryPoint, trajectoryPoint.directionForward);
            if (trajectoryPoint.directionForward == trajectoryPoint.directionBackward.getOpposite()) continue;
            this.scanCorners(world, trajectoryPoint, trajectoryPoint.directionBackward);
        }
    }

    private void scanCorners(WorldServer world, VectorI vCenter, ForgeDirection forgeDirection) {
        ForgeDirection directionLeft = forgeDirection.getRotation(ForgeDirection.UP);
        ForgeDirection directionRight = forgeDirection.getRotation(ForgeDirection.DOWN);
        for (int indexCorner = 0; indexCorner < 4; ++indexCorner) {
            VectorI vector = new VectorI(vCenter.x + ((indexCorner & 1) != 0 ? directionLeft.offsetX : directionRight.offsetX), vCenter.y + ((indexCorner & 2) != 0 ? 1 : -1), vCenter.z + ((indexCorner & 1) != 0 ? directionLeft.offsetZ : directionRight.offsetZ));
            Block block = vector.getBlock((IBlockAccess)world);
            if (block instanceof BlockChiller) {
                this.chillers.put(vector, ((BlockChiller)block).tier);
                int n = ((BlockChiller)block).tier - 1;
                this.countChillers[n] = this.countChillers[n] + 1;
                continue;
            }
            if (!(block instanceof BlockEnergyBank)) continue;
            TileEntity tileEntity = vector.getTileEntity((IBlockAccess)world);
            if (tileEntity instanceof TileEntityEnergyBank) {
                this.energyBanks.add((TileEntityEnergyBank)tileEntity);
                continue;
            }
            WarpDrive.logger.error("Invalid tile entity detected for energy bank at " + vector);
        }
    }

    public int getMass() {
        if (this.trajectoryAccelerator == null) {
            return 0;
        }
        return this.trajectoryAccelerator.size() + this.trajectoryTransfer.size() + this.energyBanks.size() + this.controlPoints.size() + this.countMagnets[0] + this.countMagnets[1] + this.countMagnets[2] + this.countChillers[0] + this.countChillers[1] + this.countChillers[2];
    }

    public boolean isMajorChange(AcceleratorSetup acceleratorSetup) {
        return acceleratorSetup == null || this.trajectoryAccelerator == null || acceleratorSetup.trajectoryAccelerator == null || this.trajectoryAccelerator.size() != acceleratorSetup.trajectoryAccelerator.size() || this.trajectoryTransfer.size() != acceleratorSetup.trajectoryTransfer.size() || this.countMagnets[0] != acceleratorSetup.countMagnets[0] || this.countMagnets[1] != acceleratorSetup.countMagnets[1] || this.countMagnets[2] != acceleratorSetup.countMagnets[2] || this.countChillers[0] != acceleratorSetup.countChillers[0] || this.countChillers[1] != acceleratorSetup.countChillers[1] || this.countChillers[2] != acceleratorSetup.countChillers[2];
    }

    public boolean isBlockUpdated(World world, VectorI vector, Block block) {
        Block blockConnected;
        boolean checkDirectConnection = false;
        boolean checkRangedConnection = false;
        boolean checkCornerConnection = false;
        if (block instanceof BlockChiller) {
            if (this.chillers.containsKey(vector)) {
                return true;
            }
            checkCornerConnection = true;
        } else if (block instanceof BlockVoidShellPlain) {
            if (this.isTrajectoryPoint(vector)) {
                return true;
            }
            checkDirectConnection = true;
        } else if (block instanceof BlockParticlesInjector) {
            checkDirectConnection = true;
        } else if (block instanceof BlockElectromagnetPlain) {
            checkDirectConnection = true;
            checkCornerConnection = true;
        } else if (block instanceof BlockParticlesCollider) {
            checkCornerConnection = true;
        } else if (block instanceof BlockAcceleratorControlPoint) {
            checkRangedConnection = true;
        } else if (block instanceof BlockEnergyBank) {
            TileEntity tileEntity = vector.getTileEntity((IBlockAccess)world);
            if (tileEntity instanceof TileEntityEnergyBank && this.energyBanks.contains(tileEntity)) {
                return true;
            }
            checkCornerConnection = true;
        }
        if (checkDirectConnection || checkCornerConnection) {
            for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                blockConnected = vector.translate(forgeDirection).getBlock((IBlockAccess)world);
                if (blockConnected instanceof BlockVoidShellPlain) {
                    if (!this.isTrajectoryPoint(vector)) continue;
                    return true;
                }
                if (!checkCornerConnection || !(blockConnected instanceof BlockElectromagnetPlain)) continue;
                for (ForgeDirection forgeDirection2 : ForgeDirection.VALID_DIRECTIONS) {
                    Block blockSubConnected = vector.translate(forgeDirection2).getBlock((IBlockAccess)world);
                    if (!(blockSubConnected instanceof BlockVoidShellPlain) || !this.isTrajectoryPoint(vector)) continue;
                    return true;
                }
            }
        }
        if (checkRangedConnection) {
            for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                blockConnected = vector.translate(forgeDirection, 2).getBlock((IBlockAccess)world);
                if (!(blockConnected instanceof BlockVoidShellPlain) || !this.isTrajectoryPoint(vector)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTrajectoryPoint(VectorI vectorI) {
        return this.trajectoryAccelerator.containsKey(vectorI) || this.trajectoryTransfer.containsKey(vectorI);
    }

    public TrajectoryPoint getTrajectoryPoint(VectorI vectorI) {
        TrajectoryPoint trajectoryPoint = this.trajectoryAccelerator.get(vectorI);
        if (trajectoryPoint != null) {
            return trajectoryPoint;
        }
        return this.trajectoryTransfer.get(vectorI);
    }

    public AxisAlignedBB getBoundingBox() {
        if (this.vMin == null || this.vMax == null) {
            return null;
        }
        return AxisAlignedBB.func_72330_a((double)this.vMin.x, (double)this.vMin.y, (double)this.vMin.z, (double)this.vMax.x, (double)this.vMax.y, (double)this.vMax.z);
    }

    public boolean isValid() {
        if (this.trajectoryAccelerator == null) {
            return false;
        }
        for (TileEntityEnergyBank tileEntityEnergyBank : this.energyBanks) {
            if (!tileEntityEnergyBank.func_145837_r()) continue;
            return false;
        }
        return true;
    }

    public int energy_getEnergyStored() {
        int energyStored = 0;
        for (TileEntityEnergyBank tileEntityEnergyBank : this.energyBanks) {
            energyStored += tileEntityEnergyBank.energy_getEnergyStored();
        }
        return energyStored;
    }

    public int energy_getPotentialOutput() {
        long potentialOutput = 0L;
        for (TileEntityEnergyBank tileEntityEnergyBank : this.energyBanks) {
            potentialOutput = Math.min(potentialOutput + (long)tileEntityEnergyBank.energy_getPotentialOutput(), Integer.MAX_VALUE);
        }
        return (int)potentialOutput;
    }

    public int energy_getMaxStorage() {
        return this.energy_maxStorage;
    }

    public void energy_consume(int amount_internal) {
        int energyToConsume;
        int energyMean = amount_internal / this.energyBanks.size();
        int energyConsumed = 0;
        int energyLeft = amount_internal - energyMean * this.energyBanks.size();
        for (TileEntityEnergyBank tileEntityEnergyBank : this.energyBanks) {
            energyToConsume = Math.min(tileEntityEnergyBank.energy_getPotentialOutput(), energyMean + energyLeft);
            tileEntityEnergyBank.energy_consume(energyToConsume);
            energyLeft += energyMean - (energyConsumed += energyToConsume);
        }
        assert (energyConsumed + energyLeft == amount_internal);
        if (energyLeft > 0) {
            for (TileEntityEnergyBank tileEntityEnergyBank : this.energyBanks) {
                energyToConsume = Math.min(tileEntityEnergyBank.energy_getPotentialOutput(), energyLeft);
                tileEntityEnergyBank.energy_consume(energyToConsume);
                energyLeft -= (energyConsumed += energyToConsume);
            }
        }
        assert (energyConsumed == amount_internal);
        assert (energyLeft == 0);
    }

    public Object[][] getControlPoints(IBlockAccess blockAccess) {
        Integer controlChannel;
        Boolean isEnabled;
        TileEntity tileEntity;
        String type;
        Integer tier;
        Object[][] objectResults = new Object[this.controlPoints.size() + (this.keyInjectors == null ? 0 : this.keyInjectors.length)][];
        int index = 0;
        for (Map.Entry<VectorI, Integer> entry : this.controlPoints.entrySet()) {
            tier = TrajectoryPoint.getTier(entry.getValue());
            type = TrajectoryPoint.isCollider(entry.getValue()) ? "Collider" : (TrajectoryPoint.isOutput(entry.getValue()) ? "Output" : (TrajectoryPoint.isInput(entry.getValue()) ? "Input" : "?"));
            tileEntity = entry.getKey().getTileEntity(blockAccess);
            isEnabled = tileEntity instanceof TileEntityAcceleratorControlPoint && ((TileEntityAcceleratorControlPoint)tileEntity).getIsEnabled();
            controlChannel = tileEntity instanceof IControlChannel ? ((IControlChannel)tileEntity).getControlChannel() : -1;
            objectResults[index++] = new Object[]{entry.getKey().x, entry.getKey().y, entry.getKey().z, tier, type, isEnabled, controlChannel};
        }
        for (Map.Entry<Object, Object> entry : this.mapInjectors.entrySet()) {
            tier = 1;
            type = "Injector";
            tileEntity = ((VectorI)entry.getValue()).getTileEntity(blockAccess);
            isEnabled = tileEntity instanceof TileEntityParticlesInjector && ((TileEntityParticlesInjector)tileEntity).getIsEnabled();
            controlChannel = tileEntity instanceof IControlChannel ? ((IControlChannel)tileEntity).getControlChannel() : -1;
            objectResults[index++] = new Object[]{((VectorI)entry.getValue()).x, ((VectorI)entry.getValue()).y, ((VectorI)entry.getValue()).z, tier, "Injector", isEnabled, controlChannel};
        }
        return objectResults;
    }

    public String toString() {
        if (this.vMin == null || this.vMax == null) {
            return String.format("%s @ DIM%d (%d %d %d) (-null-) -> (-null)", this.getClass().getSimpleName(), this.dimensionId, this.x, this.y, this.z);
        }
        return String.format("%s @ DIM%d (%d %d %d) (%d %d %d) -> (%d %d %d)", this.getClass().getSimpleName(), this.dimensionId, this.x, this.y, this.z, this.vMin.x, this.vMin.y, this.vMin.z, this.vMax.x, this.vMax.y, this.vMax.z);
    }
}

