/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.JumpBlock;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.network.PacketHandler;
import cr0s.warpdrive.render.EntityFXBeam;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class CloakedArea {
    public int dimensionId;
    public int coreX;
    public int coreY;
    public int coreZ;
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;
    private CopyOnWriteArraySet<UUID> playersInArea;
    public byte tier;
    public Block fogBlock;
    public int fogMetadata;

    public CloakedArea(World worldObj, int dimensionId, int x, int y, int z, byte tier, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.dimensionId = dimensionId;
        this.coreX = x;
        this.coreY = y;
        this.coreZ = z;
        this.tier = tier;
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.playersInArea = new CopyOnWriteArraySet();
        if (worldObj != null) {
            try {
                List list = worldObj.func_72872_a(EntityPlayerMP.class, AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
                for (EntityPlayer player : list) {
                    this.addPlayer(player.func_110124_au());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (tier == 1) {
            this.fogBlock = WarpDrive.blockGas;
            this.fogMetadata = 5;
        } else {
            this.fogBlock = Blocks.field_150350_a;
            this.fogMetadata = 0;
        }
    }

    public boolean isPlayerListedInArea(UUID uuidPlayer) {
        return this.playersInArea.contains(uuidPlayer);
    }

    private void removePlayer(UUID uuidPlayer) {
        this.playersInArea.remove(uuidPlayer);
    }

    private void addPlayer(UUID uuidPlayer) {
        this.playersInArea.add(uuidPlayer);
    }

    public boolean isEntityWithinArea(EntityLivingBase entity) {
        return (double)this.minX <= entity.field_70165_t && (double)(this.maxX + 1) > entity.field_70165_t && (double)this.minY <= entity.field_70163_u + (double)entity.field_70131_O && (double)(this.maxY + 1) > entity.field_70163_u && (double)this.minZ <= entity.field_70161_v && (double)(this.maxZ + 1) > entity.field_70161_v;
    }

    public boolean isBlockWithinArea(int x, int y, int z) {
        return this.minX <= x && this.maxX + 1 > x && this.minY <= y && this.maxY + 1 > y && this.minZ <= z && this.maxZ + 1 > z;
    }

    public void sendCloakPacketToPlayersEx(boolean decloak) {
        if (WarpDriveConfig.LOGGING_CLOAKING) {
            WarpDrive.logger.info("sendCloakPacketToPlayersEx " + decloak);
        }
        int RADIUS = 250;
        double midX = (double)this.minX + (double)Math.abs(this.maxX - this.minX) / 2.0;
        double midY = (double)this.minY + (double)Math.abs(this.maxY - this.minY) / 2.0;
        double midZ = (double)this.minZ + (double)Math.abs(this.maxZ - this.minZ) / 2.0;
        for (int j = 0; j < MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.size(); ++j) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.get(j);
            if (entityPlayerMP.field_71093_bK != this.dimensionId) continue;
            double dX = midX - entityPlayerMP.field_70165_t;
            double dY = midY - entityPlayerMP.field_70163_u;
            double dZ = midZ - entityPlayerMP.field_70161_v;
            if (!(Math.abs(dX) < 250.0) || !(Math.abs(dY) < 250.0) || !(Math.abs(dZ) < 250.0)) continue;
            if (decloak) {
                PacketHandler.sendCloakPacket(entityPlayerMP, this, true);
                this.revealChunksToPlayer((EntityPlayer)entityPlayerMP);
                this.revealEntitiesToPlayer(entityPlayerMP);
                continue;
            }
            if (this.isEntityWithinArea((EntityLivingBase)entityPlayerMP)) continue;
            PacketHandler.sendCloakPacket(entityPlayerMP, this, false);
        }
    }

    public void updatePlayer(EntityPlayerMP EntityPlayerMP2) {
        if (this.isEntityWithinArea((EntityLivingBase)EntityPlayerMP2)) {
            if (!this.isPlayerListedInArea(EntityPlayerMP2.func_110124_au())) {
                if (WarpDriveConfig.LOGGING_CLOAKING) {
                    WarpDrive.logger.info(this + " Player " + EntityPlayerMP2.func_70005_c_() + " has entered");
                }
                this.addPlayer(EntityPlayerMP2.func_110124_au());
                this.revealChunksToPlayer((EntityPlayer)EntityPlayerMP2);
                this.revealEntitiesToPlayer(EntityPlayerMP2);
                PacketHandler.sendCloakPacket(EntityPlayerMP2, this, false);
            }
        } else if (this.isPlayerListedInArea(EntityPlayerMP2.func_110124_au())) {
            if (WarpDriveConfig.LOGGING_CLOAKING) {
                WarpDrive.logger.info(this + " Player " + EntityPlayerMP2.func_70005_c_() + " has left");
            }
            this.removePlayer(EntityPlayerMP2.func_110124_au());
            MinecraftServer.func_71276_C().func_71203_ab().func_148543_a((EntityPlayer)EntityPlayerMP2, EntityPlayerMP2.field_70165_t, EntityPlayerMP2.field_70163_u, EntityPlayerMP2.field_70161_v, 100.0, EntityPlayerMP2.field_70170_p.field_73011_w.field_76574_g, PacketHandler.getPacketForThisEntity((Entity)EntityPlayerMP2));
            PacketHandler.sendCloakPacket(EntityPlayerMP2, this, false);
        }
    }

    public void revealChunksToPlayer(EntityPlayer player) {
        if (WarpDriveConfig.LOGGING_CLOAKING) {
            WarpDrive.logger.info(this + " Revealing cloaked blocks to player " + player.func_70005_c_());
        }
        int minY_clamped = Math.max(0, this.minY);
        int maxY_clamped = Math.min(255, this.maxY);
        for (int x = this.minX; x <= this.maxX; ++x) {
            for (int z = this.minZ; z <= this.maxZ; ++z) {
                for (int y = minY_clamped; y <= maxY_clamped; ++y) {
                    if (player.field_70170_p.func_147439_a(x, y, z) == Blocks.field_150350_a) continue;
                    player.field_70170_p.func_147471_g(x, y, z);
                    JumpBlock.refreshBlockStateOnClient(player.field_70170_p, x, y, z);
                }
            }
        }
    }

    public void revealEntitiesToPlayer(EntityPlayerMP entityPlayerMP) {
        List list = entityPlayerMP.field_70170_p.func_72839_b((Entity)entityPlayerMP, AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ));
        for (Entity entity : list) {
            PacketHandler.revealEntityToPlayer(entity, entityPlayerMP);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void clientCloak() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (WarpDriveConfig.LOGGING_CLOAKING) {
            WarpDrive.logger.info("Refreshing cloaked blocks...");
        }
        World world = player.func_130014_f_();
        int minY_clamped = Math.max(0, this.minY);
        int maxY_clamped = Math.min(255, this.maxY);
        for (int y = minY_clamped; y <= maxY_clamped; ++y) {
            for (int x = this.minX; x <= this.maxX; ++x) {
                for (int z = this.minZ; z <= this.maxZ; ++z) {
                    Block block = world.func_147439_a(x, y, z);
                    if (block.func_149667_c(Blocks.field_150350_a)) continue;
                    world.func_147465_d(x, y, z, this.fogBlock, this.fogMetadata, 4);
                }
            }
        }
        if (WarpDriveConfig.LOGGING_CLOAKING) {
            WarpDrive.logger.info("Refreshing cloaked entities...");
        }
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)(this.maxX + 1), (double)(this.maxY + 1), (double)(this.maxZ + 1));
        List list = world.func_72839_b((Entity)player, aabb);
        for (Entity entity : list) {
            world.func_72900_e(entity);
            ((WorldClient)world).func_73028_b(entity.func_145782_y());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void clientDecloak() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        world.func_147458_c(this.minX - 1, Math.max(0, this.minY - 1), this.minZ - 1, this.maxX + 1, Math.min(255, this.maxY + 1), this.maxZ + 1);
        int numLasers = 80 + world.field_73012_v.nextInt(50);
        double centerX = (double)(this.minX + this.maxX) / 2.0;
        double centerY = (double)(this.minY + this.maxY) / 2.0;
        double centerZ = (double)(this.minZ + this.maxZ) / 2.0;
        double radiusX = (double)(this.maxX - this.minX) / 2.0 + 5.0;
        double radiusY = (double)(this.maxY - this.minY) / 2.0 + 5.0;
        double radiusZ = (double)(this.maxZ - this.minZ) / 2.0 + 5.0;
        for (int i = 0; i < numLasers; ++i) {
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new EntityFXBeam((World)world, new Vector3(centerX + radiusX * world.field_73012_v.nextGaussian(), centerY + radiusY * world.field_73012_v.nextGaussian(), centerZ + radiusZ * world.field_73012_v.nextGaussian()), new Vector3(centerX + radiusX * world.field_73012_v.nextGaussian(), centerY + radiusY * world.field_73012_v.nextGaussian(), centerZ + radiusZ * world.field_73012_v.nextGaussian()), world.field_73012_v.nextFloat(), world.field_73012_v.nextFloat(), world.field_73012_v.nextFloat(), 60 + world.field_73012_v.nextInt(60)));
        }
    }

    public String toString() {
        return String.format("%s @ DIM%d (%d %d %d) (%d %d %d) -> (%d %d %d)", this.getClass().getSimpleName(), this.dimensionId, this.coreX, this.coreY, this.coreZ, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }
}

