/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.api.IStringSerializable;
import java.util.HashMap;
import javax.annotation.Nonnull;

public enum EnumStarMapEntryType implements IStringSerializable
{
    UNDEFINED(0, "-undefined-", true),
    SHIP(1, "ship", true),
    JUMPGATE(2, "jumpgate", true),
    PLANET(3, "planet", true),
    STAR(4, "star", true),
    STRUCTURE(5, "structure", true),
    WARP_ECHO(6, "warp_echo", true),
    ACCELERATOR(7, "accelerator", false),
    TRANSPORTER(8, "transporter", true);

    private final int id;
    private final String name;
    private final boolean hasRadarEcho;
    public static final int length;
    private static final HashMap<String, EnumStarMapEntryType> mapNames;

    private EnumStarMapEntryType(int id, String name, boolean hasRadarEcho) {
        this.id = id;
        this.name = name;
        this.hasRadarEcho = hasRadarEcho;
    }

    public int getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    public static EnumStarMapEntryType getByName(String name) {
        return mapNames.get(name);
    }

    public boolean hasRadarEcho() {
        return this.hasRadarEcho;
    }

    static {
        mapNames = new HashMap();
        length = EnumStarMapEntryType.values().length;
        for (EnumStarMapEntryType enumStarMapEntryType : EnumStarMapEntryType.values()) {
            mapNames.put(enumStarMapEntryType.getName(), enumStarMapEntryType);
        }
    }
}

