/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.api.IStringSerializable;
import java.util.HashMap;
import javax.annotation.Nonnull;

public enum EnumTier implements IStringSerializable
{
    CREATIVE("creative", 0),
    BASIC("basic", 1),
    ADVANCED("advanced", 2),
    SUPERIOR("superior", 3);

    private final String name;
    private final int index;
    public static final int length;
    private static final HashMap<Integer, EnumTier> ID_MAP;

    private EnumTier(String name, int index) {
        this.name = name;
        this.index = index;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    public static EnumTier get(int index) {
        return ID_MAP.get(index);
    }

    public int getIndex() {
        return this.index;
    }

    static {
        ID_MAP = new HashMap();
        length = EnumTier.values().length;
        for (EnumTier tier : EnumTier.values()) {
            ID_MAP.put(tier.index, tier);
        }
    }
}

