/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.api.IStringSerializable;
import java.util.HashMap;
import javax.annotation.Nonnull;

public enum EnumTransporterState implements IStringSerializable
{
    DISABLED(0, "disabled"),
    IDLE(1, "idle"),
    ACQUIRING(2, "acquiring"),
    ENERGIZING(3, "energizing");

    private final int metadata;
    private final String name;
    public static final int length;
    private static final HashMap<Integer, EnumTransporterState> ID_MAP;

    private EnumTransporterState(int metadata, String name) {
        this.metadata = metadata;
        this.name = name;
    }

    public int getMetadata() {
        return this.metadata;
    }

    public static EnumTransporterState get(int id) {
        return ID_MAP.get(id);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    static {
        ID_MAP = new HashMap();
        length = EnumTransporterState.values().length;
        for (EnumTransporterState transporterState : EnumTransporterState.values()) {
            ID_MAP.put(transporterState.ordinal(), transporterState);
        }
    }
}

