/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.data.GlobalPosition;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class ExtendedProperties
implements IExtendedEntityProperties {
    public static final String IDENTIFIER = "WarpDrive";
    private EntityLivingBase entityLivingBase;
    private GlobalPosition globalPositionHome;
    private static final byte UPDATE_FLAG_ALL = 127;
    private static final byte UPDATE_FLAG_HOME = 1;
    private byte updateFlags;
    private static final int SYNC_DELAY_TICKS = 200;
    private int ticksToSync;

    public static ExtendedProperties For(EntityLivingBase entityLivingBase) {
        return (ExtendedProperties)entityLivingBase.getExtendedProperties(IDENTIFIER);
    }

    public void saveNBTData(NBTTagCompound tagCompound) {
        if (this.globalPositionHome != null) {
            NBTTagCompound nbtHome = new NBTTagCompound();
            this.globalPositionHome.writeToNBT(nbtHome);
            tagCompound.func_74782_a("home", (NBTBase)nbtHome);
        }
    }

    public void loadNBTData(NBTTagCompound tagCompound) {
        if (tagCompound.func_74764_b("home")) {
            NBTTagCompound nbtHome = tagCompound.func_74775_l("home");
            this.globalPositionHome = new GlobalPosition(nbtHome);
        }
    }

    public void init(Entity entity, World world) {
        if (world == null || !(entity instanceof EntityLivingBase) || entity.field_70170_p == null) {
            WarpDrive.logger.error(String.format("Invalid parameters to ExtendedProperty.init(%s, %s)", entity, world));
            return;
        }
        this.entityLivingBase = (EntityLivingBase)entity;
        this.globalPositionHome = null;
        this.updateFlags = (byte)127;
        this.ticksToSync = world.field_73012_v.nextInt(200);
    }

    public void setHome(int dimensionId, int x, int y, int z) {
        this.setHome(new GlobalPosition(dimensionId, x, y, z));
    }

    public void setHome(GlobalPosition globalPosition) {
        this.globalPositionHome = globalPosition;
        this.setUpdateFlag(1);
    }

    public GlobalPosition getHome() {
        return this.globalPositionHome;
    }

    private void setUpdateFlag(int flag) {
        this.updateFlags = (byte)(this.updateFlags | flag);
    }

    public void requestFullSyncWithDelay(int delay) {
        this.setUpdateFlag(127);
        this.ticksToSync = delay;
    }

    public void requestFullSync() {
        this.requestFullSyncWithDelay(0);
    }

    public byte[] getUpdateData() {
        byte updateFlags_save = this.updateFlags;
        this.updateFlags = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.entityLivingBase.func_145782_y());
            dataOutputStream.writeByte(updateFlags_save);
            if ((updateFlags_save & 1) != 0) {
                dataOutputStream.writeBoolean(this.globalPositionHome != null);
                if (this.globalPositionHome != null) {
                    dataOutputStream.writeInt(this.globalPositionHome.dimensionId);
                    dataOutputStream.writeInt(this.globalPositionHome.x);
                    dataOutputStream.writeInt(this.globalPositionHome.y);
                    dataOutputStream.writeInt(this.globalPositionHome.z);
                }
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException exception) {
            exception.printStackTrace();
            WarpDrive.logger.error(String.format("Exception while saving extended properties for entity %s", this.entityLivingBase));
            return null;
        }
    }

    public boolean handleDataPacket(byte[] data) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int entityId = dataInputStream.readInt();
            if (entityId != this.entityLivingBase.func_145782_y()) {
                return false;
            }
            byte updateFlags_read = dataInputStream.readByte();
            if ((updateFlags_read & 1) != 0) {
                boolean isHomeSet = dataInputStream.readBoolean();
                if (isHomeSet) {
                    int dimensionId = dataInputStream.readInt();
                    int x = dataInputStream.readInt();
                    int y = dataInputStream.readInt();
                    int z = dataInputStream.readInt();
                    this.globalPositionHome = new GlobalPosition(dimensionId, x, y, z);
                } else {
                    this.globalPositionHome = null;
                }
            }
            return true;
        }
        catch (IOException exception) {
            exception.printStackTrace();
            WarpDrive.logger.error(String.format("Exception while reading extended properties for entity %s of %d bytes", this.entityLivingBase, data.length));
            return false;
        }
    }

    public void handleSynchronization() {
        if (this.entityLivingBase.field_70170_p.field_72995_K) {
            return;
        }
        --this.ticksToSync;
        if (this.ticksToSync <= 0) {
            this.ticksToSync = 200;
            if (this.updateFlags != 0) {
                byte[] byArray = this.getUpdateData();
            }
        }
    }

    public String toString() {
        try {
            return this.hashCode() + " " + this.entityLivingBase;
        }
        catch (Exception exception) {
            return this.hashCode() + " (error)";
        }
    }
}

