/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBeamFrequency;
import cr0s.warpdrive.block.forcefield.TileEntityForceFieldRelay;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.GlobalPosition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;

public class ForceFieldRegistry {
    private static final HashMap<Integer, CopyOnWriteArraySet<GlobalPosition>> registry = new HashMap();
    private static int countAdd = 0;
    private static int countRemove = 0;
    private static int countRead = 0;

    public static Set<TileEntity> getTileEntities(int beamFrequency, WorldServer worldSource, int x, int y, int z) {
        int range2;
        CopyOnWriteArraySet<GlobalPosition> setGlobalPositions;
        if (WarpDriveConfig.LOGGING_FORCEFIELD_REGISTRY && ++countRead % 1000 == 0) {
            WarpDrive.logger.info("ForceFieldRegistry stats: read " + countRead + " add " + countAdd + " remove " + countRemove + " => " + (float)countRead / (float)(countRemove + countRead + countAdd) + "% read");
        }
        if ((setGlobalPositions = registry.get(beamFrequency)) == null || worldSource == null) {
            return new CopyOnWriteArraySet<TileEntity>();
        }
        HashSet<TileEntity> setNonRelays = new HashSet<TileEntity>();
        HashSet<TileEntity> setRelays = new HashSet<TileEntity>();
        HashSet<TileEntity> setToIterate = new HashSet<TileEntity>();
        int maxRange2 = 400;
        for (GlobalPosition globalPosition : setGlobalPositions) {
            WorldServer world = globalPosition.getWorldServerIfLoaded();
            if (world != null) {
                if (world != worldSource) continue;
                TileEntity tileEntity = world.func_147438_o(globalPosition.x, globalPosition.y, globalPosition.z);
                if (tileEntity instanceof IBeamFrequency && ((IBeamFrequency)tileEntity).getBeamFrequency() == beamFrequency) {
                    if (tileEntity instanceof TileEntityForceFieldRelay) {
                        range2 = (globalPosition.x - x) * (globalPosition.x - x) + (globalPosition.y - y) * (globalPosition.y - y) + (globalPosition.z - z) * (globalPosition.z - z);
                        if (range2 <= 400) {
                            setToIterate.add(tileEntity);
                            continue;
                        }
                        setRelays.add(tileEntity);
                        continue;
                    }
                    setNonRelays.add(tileEntity);
                    continue;
                }
            }
            ++countRemove;
            setGlobalPositions.remove(globalPosition);
            if (!WarpDriveConfig.LOGGING_FORCEFIELD_REGISTRY) continue;
            ForceFieldRegistry.printRegistry("removed");
        }
        if (setToIterate.isEmpty()) {
            HashSet<TileEntity> setResult = new HashSet<TileEntity>();
            setResult.add(worldSource.func_147438_o(x, y, z));
            return setResult;
        }
        HashSet<TileEntity> setRelaysInRange = new HashSet<TileEntity>();
        while (!setToIterate.isEmpty()) {
            HashSet<TileEntity> setToIterateNext = new HashSet<TileEntity>();
            for (TileEntity tileEntityCurrent : setToIterate) {
                setRelaysInRange.add(tileEntityCurrent);
                for (TileEntity tileEntityEntry : setRelays) {
                    if (setRelaysInRange.contains(tileEntityEntry) || setToIterate.contains(tileEntityEntry) || setToIterateNext.contains(tileEntityEntry) || (range2 = (tileEntityCurrent.field_145851_c - tileEntityEntry.field_145851_c) * (tileEntityCurrent.field_145851_c - tileEntityEntry.field_145851_c) + (tileEntityCurrent.field_145848_d - tileEntityEntry.field_145848_d) * (tileEntityCurrent.field_145848_d - tileEntityEntry.field_145848_d) + (tileEntityCurrent.field_145849_e - tileEntityEntry.field_145849_e) * (tileEntityCurrent.field_145849_e - tileEntityEntry.field_145849_e)) > 400) continue;
                    setToIterateNext.add(tileEntityEntry);
                }
            }
            setToIterate = setToIterateNext;
        }
        HashSet<TileEntity> setEntries = new HashSet<TileEntity>();
        for (TileEntity tileEntityRelayInRange : setRelaysInRange) {
            for (TileEntity tileEntityEntry : setNonRelays) {
                if (setEntries.contains(tileEntityEntry) || (range2 = (tileEntityRelayInRange.field_145851_c - tileEntityEntry.field_145851_c) * (tileEntityRelayInRange.field_145851_c - tileEntityEntry.field_145851_c) + (tileEntityRelayInRange.field_145848_d - tileEntityEntry.field_145848_d) * (tileEntityRelayInRange.field_145848_d - tileEntityEntry.field_145848_d) + (tileEntityRelayInRange.field_145849_e - tileEntityEntry.field_145849_e) * (tileEntityRelayInRange.field_145849_e - tileEntityEntry.field_145849_e)) > 400) continue;
                setEntries.add(tileEntityEntry);
            }
        }
        setEntries.addAll(setRelaysInRange);
        return setEntries;
    }

    public static void updateInRegistry(IBeamFrequency tileEntity) {
        assert (tileEntity instanceof TileEntity);
        ++countRead;
        CopyOnWriteArraySet<GlobalPosition> setGlobalPositions = registry.get(tileEntity.getBeamFrequency());
        if (setGlobalPositions == null) {
            setGlobalPositions = new CopyOnWriteArraySet();
        }
        for (GlobalPosition globalPosition : setGlobalPositions) {
            if (!globalPosition.equals(tileEntity)) continue;
            return;
        }
        ++countAdd;
        setGlobalPositions.add(new GlobalPosition((TileEntity)tileEntity));
        registry.put(tileEntity.getBeamFrequency(), setGlobalPositions);
        if (WarpDriveConfig.LOGGING_FORCEFIELD_REGISTRY) {
            ForceFieldRegistry.printRegistry("added");
        }
    }

    public static void removeFromRegistry(IBeamFrequency tileEntity) {
        assert (tileEntity instanceof TileEntity);
        ++countRead;
        Set setGlobalPositions = registry.get(tileEntity.getBeamFrequency());
        if (setGlobalPositions == null) {
            return;
        }
        for (GlobalPosition globalPosition : setGlobalPositions) {
            if (!globalPosition.equals(tileEntity)) continue;
            ++countRemove;
            setGlobalPositions.remove(globalPosition);
            return;
        }
    }

    public static void printRegistry(String trigger) {
        WarpDrive.logger.info("Force field registry (" + registry.size() + " entries after " + trigger + "):");
        for (Map.Entry<Integer, CopyOnWriteArraySet<GlobalPosition>> entry : registry.entrySet()) {
            StringBuilder message = new StringBuilder();
            for (GlobalPosition globalPosition : entry.getValue()) {
                if (message.length() > 0) {
                    message.append(", ");
                }
                message.append(globalPosition.dimensionId).append(": ").append(globalPosition.x).append(" ").append(globalPosition.y).append(" ").append(globalPosition.z);
            }
            WarpDrive.logger.info(String.format("- %d entries at frequency %d : %s", entry.getValue().size(), entry.getKey(), message));
        }
    }
}

