/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.StarMapRegistry;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;

public class GlobalPosition {
    public final int dimensionId;
    public final int x;
    public final int y;
    public final int z;

    public GlobalPosition(int dimensionId, int x, int y, int z) {
        this.dimensionId = dimensionId;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public GlobalPosition(TileEntity tileEntity) {
        this(tileEntity.func_145831_w().field_73011_w.field_76574_g, tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
    }

    public GlobalPosition(Entity entity) {
        this(entity.field_70170_p.field_73011_w.field_76574_g, (int)Math.floor(entity.field_70165_t), (int)Math.floor(entity.field_70163_u), (int)Math.floor(entity.field_70161_v));
    }

    public WorldServer getWorldServerIfLoaded() {
        boolean isLoaded;
        WorldServer world = DimensionManager.getWorld((int)this.dimensionId);
        if (world == null) {
            return null;
        }
        if (world.func_72863_F() instanceof ChunkProviderServer) {
            ChunkProviderServer chunkProviderServer = (ChunkProviderServer)world.func_72863_F();
            try {
                isLoaded = chunkProviderServer.field_73244_f.func_76161_b(ChunkCoordIntPair.func_77272_a((int)(this.x >> 4), (int)(this.z >> 4)));
            }
            catch (NoSuchFieldError exception) {
                isLoaded = chunkProviderServer.func_73149_a(this.x >> 4, this.z >> 4);
            }
        } else {
            isLoaded = world.func_72863_F().func_73149_a(this.x >> 4, this.z >> 4);
        }
        if (!isLoaded) {
            return null;
        }
        return world;
    }

    public boolean isLoaded() {
        return this.getWorldServerIfLoaded() != null;
    }

    public CelestialObject getCelestialObject(boolean isRemote) {
        return CelestialObjectManager.get(isRemote, this.dimensionId, this.x, this.z);
    }

    public Vector3 getUniversalCoordinates(boolean isRemote) {
        CelestialObject celestialObject = CelestialObjectManager.get(isRemote, this.dimensionId, this.x, this.z);
        return StarMapRegistry.getUniversalCoordinates(celestialObject, this.x, this.y, this.z);
    }

    public VectorI getVectorI() {
        return new VectorI(this.x, this.y, this.z);
    }

    public int distance2To(TileEntity tileEntity) {
        if (tileEntity.func_145831_w().field_73011_w.field_76574_g != this.dimensionId) {
            return Integer.MAX_VALUE;
        }
        int newX = tileEntity.field_145851_c - this.x;
        int newY = tileEntity.field_145848_d - this.y;
        int newZ = tileEntity.field_145849_e - this.z;
        return newX * newX + newY * newY + newZ * newZ;
    }

    public double distance2To(Entity entity) {
        if (entity.field_70170_p.field_73011_w.field_76574_g != this.dimensionId) {
            return Double.MAX_VALUE;
        }
        double newX = entity.field_70165_t - (double)this.x;
        double newY = entity.field_70163_u - (double)this.y;
        double newZ = entity.field_70161_v - (double)this.z;
        return newX * newX + newY * newY + newZ * newZ;
    }

    public GlobalPosition(NBTTagCompound tagCompound) {
        this.dimensionId = tagCompound.func_74762_e("dimensionId");
        this.x = tagCompound.func_74762_e("x");
        this.y = tagCompound.func_74762_e("y");
        this.z = tagCompound.func_74762_e("z");
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("dimensionId", this.dimensionId);
        tagCompound.func_74768_a("x", this.x);
        tagCompound.func_74768_a("y", this.y);
        tagCompound.func_74768_a("z", this.z);
    }

    public boolean equals(TileEntity tileEntity) {
        return this.dimensionId == tileEntity.func_145831_w().field_73011_w.field_76574_g && this.x == tileEntity.field_145851_c && this.y == tileEntity.field_145848_d && this.z == tileEntity.field_145849_e;
    }

    public boolean equals(Object object) {
        if (object instanceof GlobalPosition) {
            GlobalPosition globalPosition = (GlobalPosition)object;
            return this.dimensionId == globalPosition.dimensionId && this.x == globalPosition.x && this.y == globalPosition.y && this.z == globalPosition.z;
        }
        if (object instanceof VectorI) {
            VectorI vector = (VectorI)object;
            return this.x == vector.x && this.y == vector.y && this.z == vector.z;
        }
        if (object instanceof TileEntity) {
            TileEntity tileEntity = (TileEntity)object;
            return this.dimensionId == tileEntity.func_145831_w().field_73011_w.field_76574_g && this.x == tileEntity.field_145851_c && this.y == tileEntity.field_145848_d && this.z == tileEntity.field_145849_e;
        }
        return false;
    }

    public int hashCode() {
        return this.dimensionId << 24 + (this.x >> 10) << 12 + this.y << 10 + (this.z >> 10);
    }
}

