/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.LocalProfiler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IStarMapRegistryTileEntity;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.EnumStarMapEntryType;
import cr0s.warpdrive.data.RadarEcho;
import cr0s.warpdrive.data.StarMapRegistryItem;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;

public class StarMapRegistry {
    private final HashMap<Integer, CopyOnWriteArraySet<StarMapRegistryItem>> registry = new HashMap();
    private int countAdd = 0;
    private int countRemove = 0;
    private int countRead = 0;
    private static boolean isExceptionReported = false;

    public void updateInRegistry(IStarMapRegistryTileEntity tileEntity) {
        CopyOnWriteArraySet<StarMapRegistryItem> setRegistryItems;
        assert (tileEntity instanceof TileEntity);
        if (!Commons.isSafeThread()) {
            WarpDrive.logger.error(String.format("Non-threadsafe call to StarMapRegistry:updateInRegistry outside main thread, for %s", tileEntity));
        }
        ++this.countRead;
        if (WarpDriveConfig.LOGGING_STARMAP && this.countRead % 1000 == 0) {
            WarpDrive.logger.info("Starmap registry stats: read " + this.countRead + " add " + this.countAdd + " remove " + this.countRemove + " => " + (float)this.countRead / (float)(this.countRemove + this.countRead + this.countAdd) + "% read");
        }
        if ((setRegistryItems = this.registry.get(((TileEntity)tileEntity).func_145831_w().field_73011_w.field_76574_g)) == null) {
            setRegistryItems = new CopyOnWriteArraySet();
        }
        ArrayList<StarMapRegistryItem> listToRemove = new ArrayList<StarMapRegistryItem>(3);
        UUID uuidTileEntity = tileEntity.getUUID();
        for (StarMapRegistryItem registryItem : setRegistryItems) {
            if (registryItem.uuid == null) {
                WarpDrive.logger.error(String.format("Removing invalid StarMapRegistryItem %s", registryItem));
                listToRemove.add(registryItem);
                continue;
            }
            if (registryItem.type.equals(tileEntity.getStarMapType()) && registryItem.uuid.equals(uuidTileEntity)) {
                registryItem.update(tileEntity);
                return;
            }
            if (!registryItem.sameCoordinates(tileEntity)) continue;
            listToRemove.add(registryItem);
        }
        setRegistryItems.removeAll(listToRemove);
        ++this.countAdd;
        setRegistryItems.add(new StarMapRegistryItem(tileEntity));
        this.registry.put(((TileEntity)tileEntity).func_145831_w().field_73011_w.field_76574_g, setRegistryItems);
        if (WarpDriveConfig.LOGGING_STARMAP) {
            this.printRegistry("added");
        }
    }

    public void removeFromRegistry(IStarMapRegistryTileEntity tileEntity) {
        assert (tileEntity instanceof TileEntity);
        ++this.countRead;
        Set setRegistryItems = this.registry.get(((TileEntity)tileEntity).func_145831_w().field_73011_w.field_76574_g);
        if (setRegistryItems == null) {
            return;
        }
        for (StarMapRegistryItem registryItem : setRegistryItems) {
            if (!registryItem.sameCoordinates(tileEntity)) continue;
            ++this.countRemove;
            setRegistryItems.remove(registryItem);
            return;
        }
    }

    public StarMapRegistryItem getByUUID(EnumStarMapEntryType enumStarMapEntryType, UUID uuid) {
        for (Integer dimensionId : this.registry.keySet()) {
            CopyOnWriteArraySet<StarMapRegistryItem> setStarMapRegistryItems = this.registry.get(dimensionId);
            if (setStarMapRegistryItems == null) continue;
            for (StarMapRegistryItem starMapRegistryItem : setStarMapRegistryItems) {
                if (enumStarMapEntryType != null && starMapRegistryItem.type != enumStarMapEntryType || !starMapRegistryItem.uuid.equals(uuid)) continue;
                return starMapRegistryItem;
            }
        }
        return null;
    }

    public String find(String nameShip) {
        int MAX_LENGTH = 2000;
        StringBuilder resultMatch = new StringBuilder();
        StringBuilder resultCaseInsensitive = new StringBuilder();
        StringBuilder resultContains = new StringBuilder();
        for (Integer dimensionId : this.registry.keySet()) {
            CopyOnWriteArraySet<StarMapRegistryItem> setStarMapRegistryItems = this.registry.get(dimensionId);
            if (setStarMapRegistryItems == null) continue;
            for (StarMapRegistryItem starMapRegistryItem : setStarMapRegistryItems) {
                if (starMapRegistryItem.type != EnumStarMapEntryType.SHIP) continue;
                if (starMapRegistryItem.name.equals(nameShip)) {
                    if (resultMatch.length() < 2000) {
                        if (resultMatch.length() > 0) {
                            resultMatch.append("\n");
                        }
                        resultContains.append(String.format("Ship '%s' found in %s", starMapRegistryItem.name, starMapRegistryItem.getFormattedLocation()));
                        continue;
                    }
                    resultMatch.append(".");
                    continue;
                }
                if (starMapRegistryItem.name.equalsIgnoreCase(nameShip)) {
                    if (resultCaseInsensitive.length() < 2000) {
                        if (resultCaseInsensitive.length() > 0) {
                            resultCaseInsensitive.append("\n");
                        }
                        resultContains.append(String.format("Ship '%s' found in %s", starMapRegistryItem.name, starMapRegistryItem.getFormattedLocation()));
                        continue;
                    }
                    resultCaseInsensitive.append(".");
                    continue;
                }
                if (!starMapRegistryItem.name.contains(nameShip)) continue;
                if (resultContains.length() < 2000) {
                    if (resultContains.length() > 0) {
                        resultContains.append("\n");
                    }
                    resultContains.append(String.format("Ship '%s' found in %s", starMapRegistryItem.name, starMapRegistryItem.getFormattedLocation()));
                    continue;
                }
                resultContains.append(".");
            }
        }
        if (resultMatch.length() > 0) {
            return resultMatch.toString();
        }
        if (resultCaseInsensitive.length() > 0) {
            return resultCaseInsensitive.toString();
        }
        if (resultContains.length() > 0) {
            return resultContains.toString();
        }
        return String.format("No ship found with name '%s'", nameShip);
    }

    public void onBlockUpdated(World world, int x, int y, int z, Block block, int metadata) {
        CopyOnWriteArraySet<StarMapRegistryItem> setStarMapRegistryItems = this.registry.get(world.field_73011_w.field_76574_g);
        if (setStarMapRegistryItems == null) {
            return;
        }
        for (StarMapRegistryItem registryItem : setStarMapRegistryItems) {
            TileEntity tileEntity;
            if (!registryItem.contains(x, y, z) || !((tileEntity = world.func_147438_o(registryItem.x, registryItem.y, registryItem.z)) instanceof IStarMapRegistryTileEntity)) continue;
            ((IStarMapRegistryTileEntity)tileEntity).onBlockUpdatedInArea(new VectorI(x, y, z), block, metadata);
        }
    }

    public static double getGravity(Entity entity) {
        CelestialObject celestialObject = CelestialObjectManager.get(entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70161_v);
        return celestialObject == null ? 1.0 : celestialObject.getGravity();
    }

    public static int getSpaceDimensionId(World world, int x, int z) {
        CelestialObject celestialObject = CelestialObjectManager.get(world, x, z);
        if (celestialObject == null) {
            return world.field_73011_w.field_76574_g;
        }
        if (celestialObject.isSpace()) {
            return celestialObject.dimensionId;
        }
        if (celestialObject.isHyperspace()) {
            celestialObject = CelestialObjectManager.getClosestChild(world, x, z);
            return celestialObject == null ? 0 : celestialObject.dimensionId;
        }
        while (celestialObject != null && !celestialObject.isSpace()) {
            celestialObject = celestialObject.parent;
        }
        return celestialObject == null ? 0 : celestialObject.dimensionId;
    }

    public static int getHyperspaceDimensionId(World world, int x, int z) {
        CelestialObject celestialObject = CelestialObjectManager.get(world, x, z);
        if (celestialObject == null) {
            return world.field_73011_w.field_76574_g;
        }
        if (celestialObject.isHyperspace()) {
            return celestialObject.dimensionId;
        }
        if (celestialObject.isSpace()) {
            return celestialObject.parent.dimensionId;
        }
        while (celestialObject != null && !celestialObject.isSpace()) {
            celestialObject = celestialObject.parent;
        }
        return celestialObject == null || celestialObject.parent == null ? 0 : celestialObject.parent.dimensionId;
    }

    public static int getDimensionId(String stringDimension, Entity entity) {
        switch (stringDimension.toLowerCase()) {
            case "world": 
            case "overworld": 
            case "0": {
                return 0;
            }
            case "nether": 
            case "thenether": 
            case "-1": {
                return -1;
            }
            case "s": 
            case "space": {
                return StarMapRegistry.getSpaceDimensionId(entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70161_v);
            }
            case "h": 
            case "hyper": 
            case "hyperspace": {
                return StarMapRegistry.getHyperspaceDimensionId(entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70161_v);
            }
        }
        try {
            return Integer.parseInt(stringDimension);
        }
        catch (Exception exception) {
            WarpDrive.logger.info("Invalid dimension '" + stringDimension + "', expecting integer or overworld/nether/end/theend/space/hyper/hyperspace");
            return 0;
        }
    }

    public ArrayList<RadarEcho> getRadarEchos(TileEntity tileEntity, int radius) {
        ArrayList<RadarEcho> arrayListRadarEchos = new ArrayList<RadarEcho>(this.registry.size());
        this.cleanup();
        CelestialObject celestialObject = CelestialObjectManager.get(tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145849_e);
        Vector3 vectorRadar = StarMapRegistry.getUniversalCoordinates(celestialObject, tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
        int radius2 = radius * radius;
        for (Map.Entry<Integer, CopyOnWriteArraySet<StarMapRegistryItem>> entryDimension : this.registry.entrySet()) {
            for (StarMapRegistryItem starMapRegistryItem : entryDimension.getValue()) {
                double dZ;
                double dY;
                double dX;
                double distance2;
                Vector3 vectorItem;
                if (!starMapRegistryItem.type.hasRadarEcho() || (vectorItem = starMapRegistryItem.getUniversalCoordinates(tileEntity.func_145831_w().field_72995_K)) == null || (distance2 = (dX = vectorItem.x - vectorRadar.x) * dX + (dY = vectorItem.y - vectorRadar.y) * dY + (dZ = vectorItem.z - vectorRadar.z) * dZ) > (double)radius2 || starMapRegistryItem.isolationRate != 0.0 && tileEntity.func_145831_w().field_73012_v.nextDouble() < starMapRegistryItem.isolationRate) continue;
                arrayListRadarEchos.add(new RadarEcho(starMapRegistryItem.type.getName(), vectorItem, starMapRegistryItem.mass, starMapRegistryItem.name));
            }
        }
        return arrayListRadarEchos;
    }

    public static Vector3 getUniversalCoordinates(CelestialObject celestialObject, double x, double y, double z) {
        if (celestialObject == null) {
            return null;
        }
        Vector3 vec3Result = new Vector3(x, y + 512.0, z);
        CelestialObject celestialObjectNode = celestialObject;
        boolean hasHyperspace = celestialObjectNode.isHyperspace();
        while (celestialObjectNode.parent != null) {
            VectorI vEntry = celestialObjectNode.getEntryOffset();
            vec3Result.x -= (double)vEntry.x;
            vec3Result.y -= 256.0;
            vec3Result.z -= (double)vEntry.z;
            celestialObjectNode = celestialObjectNode.parent;
            hasHyperspace |= celestialObjectNode.isHyperspace();
        }
        return hasHyperspace ? vec3Result : null;
    }

    public void printRegistry(String trigger) {
        WarpDrive.logger.info("Starmap registry (" + this.registry.size() + " entries after " + trigger + "):");
        for (Map.Entry<Integer, CopyOnWriteArraySet<StarMapRegistryItem>> entryDimension : this.registry.entrySet()) {
            StringBuilder message = new StringBuilder();
            for (StarMapRegistryItem registryItem : entryDimension.getValue()) {
                message.append(String.format("\n- %s '%s' @ DIM%d (%d %d %d) with %.3f isolation rate", registryItem.type, registryItem.name, registryItem.dimensionId, registryItem.x, registryItem.y, registryItem.z, registryItem.isolationRate));
            }
            WarpDrive.logger.info(String.format("- %d entries in dimension %d: %s", entryDimension.getValue().size(), entryDimension.getKey(), message.toString()));
        }
    }

    public boolean isWarpCoreIntersectsWithOthers(TileEntityShipCore core) {
        StringBuilder reason = new StringBuilder();
        this.cleanup();
        core.validateShipSpatialParameters(reason);
        AxisAlignedBB aabb1 = AxisAlignedBB.func_72330_a((double)core.minX, (double)core.minY, (double)core.minZ, (double)core.maxX, (double)core.maxY, (double)core.maxZ);
        CopyOnWriteArraySet<StarMapRegistryItem> setRegistryItems = this.registry.get(core.func_145831_w().field_73011_w.field_76574_g);
        if (setRegistryItems == null) {
            return false;
        }
        for (StarMapRegistryItem registryItem : setRegistryItems) {
            TileEntityShipCore shipCore;
            TileEntity tileEntity;
            AxisAlignedBB aabb2;
            assert (registryItem.dimensionId == core.func_145831_w().field_73011_w.field_76574_g);
            if (registryItem.type != EnumStarMapEntryType.SHIP || registryItem.x == core.field_145851_c && registryItem.y == core.field_145848_d && registryItem.z == core.field_145849_e || !aabb1.func_72326_a(aabb2 = AxisAlignedBB.func_72330_a((double)registryItem.minX, (double)registryItem.minY, (double)registryItem.minZ, (double)registryItem.maxX, (double)registryItem.maxY, (double)registryItem.maxZ)) || !((tileEntity = core.func_145831_w().func_147438_o(registryItem.x, registryItem.y, registryItem.z)) instanceof TileEntityShipCore) || (shipCore = (TileEntityShipCore)tileEntity).isOffline() || !shipCore.validateShipSpatialParameters(reason)) continue;
            return true;
        }
        return false;
    }

    private void cleanup() {
        LocalProfiler.start("Starmap registry cleanup");
        for (Map.Entry<Integer, CopyOnWriteArraySet<StarMapRegistryItem>> entryDimension : this.registry.entrySet()) {
            WorldServer world = DimensionManager.getWorld((int)entryDimension.getKey());
            if (world == null) continue;
            for (StarMapRegistryItem registryItem : entryDimension.getValue()) {
                boolean isValid = false;
                if (registryItem != null) {
                    boolean isLoaded;
                    if (world.func_72863_F() instanceof ChunkProviderServer) {
                        ChunkProviderServer chunkProviderServer = (ChunkProviderServer)world.func_72863_F();
                        try {
                            isLoaded = chunkProviderServer.field_73244_f.func_76161_b(ChunkCoordIntPair.func_77272_a((int)(registryItem.x >> 4), (int)(registryItem.z >> 4)));
                        }
                        catch (NoSuchFieldError exception) {
                            if (!isExceptionReported) {
                                WarpDrive.logger.info(String.format("Unable to check non-loaded chunks for star map entry %s", registryItem));
                                exception.printStackTrace();
                                isExceptionReported = true;
                            }
                            isLoaded = chunkProviderServer.func_73149_a(registryItem.x >> 4, registryItem.z >> 4);
                        }
                    } else {
                        isLoaded = world.func_72863_F().func_73149_a(registryItem.x >> 4, registryItem.z >> 4);
                    }
                    if (!isLoaded) {
                        if (!WarpDrive.isDev) continue;
                        WarpDrive.logger.info(String.format("Skipping non-loaded star map entry %s", registryItem));
                        continue;
                    }
                    Block block = world.func_147439_a(registryItem.x, registryItem.y, registryItem.z);
                    TileEntity tileEntity = world.func_147438_o(registryItem.x, registryItem.y, registryItem.z);
                    isValid = true;
                    switch (registryItem.type) {
                        case UNDEFINED: {
                            break;
                        }
                        case SHIP: {
                            isValid = block == WarpDrive.blockShipCore && tileEntity != null && !tileEntity.func_145837_r();
                            break;
                        }
                        case JUMPGATE: {
                            break;
                        }
                        case PLANET: {
                            break;
                        }
                        case STAR: {
                            break;
                        }
                        case STRUCTURE: {
                            break;
                        }
                        case WARP_ECHO: {
                            break;
                        }
                        case ACCELERATOR: {
                            isValid = block == WarpDrive.blockAcceleratorController && tileEntity != null && !tileEntity.func_145837_r();
                            break;
                        }
                        case TRANSPORTER: {
                            isValid = block == WarpDrive.blockTransporterCore && tileEntity != null && !tileEntity.func_145837_r();
                            break;
                        }
                    }
                }
                if (isValid) continue;
                if (registryItem == null) {
                    WarpDrive.logger.info("Cleaning up starmap object ~null~");
                } else {
                    WarpDrive.logger.info("Cleaning up starmap object " + registryItem.type + " at " + registryItem.dimensionId + " " + registryItem.x + " " + registryItem.y + " " + registryItem.z);
                }
                ++this.countRemove;
                entryDimension.getValue().remove(registryItem);
            }
        }
        LocalProfiler.stop();
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound == null || !tagCompound.func_74764_b("starMapRegistryItems")) {
            this.registry.clear();
            return;
        }
        NBTTagList tagList = tagCompound.func_150295_c("starMapRegistryItems", 10);
        StarMapRegistryItem[] registryFlat = new StarMapRegistryItem[tagList.func_74745_c()];
        HashMap<Integer, Integer> sizeDimensions = new HashMap<Integer, Integer>();
        for (int index = 0; index < tagList.func_74745_c(); ++index) {
            Integer n;
            Integer n2;
            StarMapRegistryItem starMapRegistryItem;
            registryFlat[index] = starMapRegistryItem = new StarMapRegistryItem(tagList.func_150305_b(index));
            Integer n3 = n2 = sizeDimensions.computeIfAbsent(starMapRegistryItem.dimensionId, k -> 0);
            Integer n4 = n = Integer.valueOf(n2 + 1);
            sizeDimensions.put(starMapRegistryItem.dimensionId, n);
        }
        HashMap registryLocal = new HashMap();
        for (Map.Entry entry : sizeDimensions.entrySet()) {
            registryLocal.put(entry.getKey(), new ArrayList((Integer)entry.getValue()));
        }
        for (StarMapRegistryItem starMapRegistryItem : registryFlat) {
            ((ArrayList)registryLocal.get(starMapRegistryItem.dimensionId)).add(starMapRegistryItem);
        }
        this.registry.clear();
        for (Map.Entry entry : registryLocal.entrySet()) {
            this.registry.put((Integer)entry.getKey(), new CopyOnWriteArraySet((Collection)entry.getValue()));
        }
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        NBTTagList tagList = new NBTTagList();
        for (CopyOnWriteArraySet<StarMapRegistryItem> starMapRegistryItems : this.registry.values()) {
            for (StarMapRegistryItem starMapRegistryItem : starMapRegistryItems) {
                NBTTagCompound tagCompoundItem = new NBTTagCompound();
                starMapRegistryItem.writeToNBT(tagCompoundItem);
                tagList.func_74742_a((NBTBase)tagCompoundItem);
            }
        }
        tagCompound.func_74782_a("starMapRegistryItems", (NBTBase)tagList);
    }
}

