/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.ExceptionChunkNotLoaded;
import cr0s.warpdrive.block.BlockAbstractOmnipanel;
import cr0s.warpdrive.block.breathing.BlockAirFlow;
import cr0s.warpdrive.block.breathing.BlockAirSource;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.ChunkData;
import cr0s.warpdrive.event.ChunkHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;

public class StateAir {
    public static final int AIR_DEFAULT = 0x60000C0;
    static final int USED_MASK = 0x77FFFF0F;
    static final int CONCENTRATION_MASK = 31;
    static final int CONCENTRATION_MAX = 31;
    static final int GENERATOR_DIRECTION_MASK = 224;
    static final int GENERATOR_PRESSURE_MASK = 65280;
    static final int VOID_PRESSURE_MASK = 0xFF0000;
    static final int VOID_DIRECTION_MASK = 0x7000000;
    static final int BLOCK_MASK = 0x70000000;
    static final int GENERATOR_DIRECTION_SHIFT = 5;
    static final int GENERATOR_PRESSURE_SHIFT = 8;
    static final int VOID_PRESSURE_SHIFT = 16;
    static final int VOID_DIRECTION_SHIFT = 24;
    static final int GENERATOR_PRESSURE_MAX = 255;
    static final int VOID_PRESSURE_MAX = 255;
    static final int BLOCK_UNKNOWN = 0;
    static final int BLOCK_SEALER = 0x10000000;
    static final int BLOCK_AIR_PLACEABLE = 0x20000000;
    static final int BLOCK_AIR_FLOW = 0x30000000;
    static final int BLOCK_AIR_SOURCE = 0x40000000;
    static final int BLOCK_AIR_NON_PLACEABLE_V = 0x50000000;
    static final int BLOCK_AIR_NON_PLACEABLE_H = 0x60000000;
    static final int BLOCK_AIR_NON_PLACEABLE = 0x70000000;
    static final int TICKING_MASK = 0xFFFF1F;
    private ChunkData chunkData;
    private Chunk chunk;
    private int x;
    private int y;
    private int z;
    protected int dataAir;
    protected Block block;
    public byte concentration;
    public short pressureGenerator;
    public short pressureVoid;
    public ForgeDirection directionGenerator;
    public ForgeDirection directionVoid;
    private static final short[] rotDirection = new short[]{0, 1, 5, 4, 2, 3, 6, 7};

    public StateAir(ChunkData chunkData) {
        this.chunkData = chunkData;
        this.chunk = null;
    }

    public void refresh(World world, int x, int y, int z) throws ExceptionChunkNotLoaded {
        this.x = x;
        this.y = y;
        this.z = z;
        this.refresh(world);
    }

    public void refresh(World world, StateAir stateAir, ForgeDirection forgeDirection) throws ExceptionChunkNotLoaded {
        this.x = stateAir.x + forgeDirection.offsetX;
        this.y = stateAir.y + forgeDirection.offsetY;
        this.z = stateAir.z + forgeDirection.offsetZ;
        this.refresh(world);
    }

    private void refresh(World world) throws ExceptionChunkNotLoaded {
        if (this.chunkData == null || !this.chunkData.isInside(this.x, this.y, this.z)) {
            this.chunkData = ChunkHandler.getChunkData(world, this.x, this.y, this.z);
            if (this.chunkData == null) {
                throw new ExceptionChunkNotLoaded(String.format("Air refresh aborted @ %s (%d %d %d)", world.field_73011_w.func_80007_l(), this.x, this.y, this.z));
            }
            this.chunk = null;
        }
        if (this.chunk == null) {
            this.chunk = world.func_72938_d(this.x, this.z);
        }
        this.block = null;
        this.dataAir = this.chunkData.getDataAir(this.x, this.y, this.z);
        if (this.dataAir == 0) {
            this.dataAir = 0x60000C0;
        }
        this.concentration = (byte)(this.dataAir & 0x1F);
        this.pressureGenerator = (short)((this.dataAir & 0xFF00) >> 8);
        this.pressureVoid = (short)((this.dataAir & 0xFF0000) >> 16);
        this.directionGenerator = ForgeDirection.getOrientation((int)((this.dataAir & 0xE0) >> 5));
        this.directionVoid = ForgeDirection.getOrientation((int)((this.dataAir & 0x7000000) >> 24));
        if ((this.dataAir & 0x70000000) == 0) {
            this.updateBlockCache(world);
        }
        this.updateVoidSource();
    }

    public void clearCache() {
        this.chunkData = null;
        this.chunk = null;
    }

    public void updateBlockCache(World world) {
        this.block = this.y >= 0 && this.y < 256 ? this.chunk.func_150810_a(this.x & 0xF, this.y, this.z & 0xF) : Blocks.field_150350_a;
        this.updateBlockType(world);
    }

    private void updateVoidSource() {
        if (!this.isAir()) {
            this.setGenerator((short)0, ForgeDirection.UNKNOWN);
            this.setVoid((short)0, ForgeDirection.UNKNOWN);
        } else if (this.pressureGenerator == 0) {
            this.setVoid((short)0, ForgeDirection.UNKNOWN);
        } else if (this.pressureGenerator == 1) {
            this.setVoid((short)255, this.directionGenerator.getOpposite());
        } else if (this.y == 0) {
            this.setVoid((short)255, ForgeDirection.DOWN);
        } else if (this.y == 255) {
            this.setVoid((short)255, ForgeDirection.UP);
        } else if (this.block != null) {
            boolean isVoid;
            int highestBlock = this.chunk.func_76626_d(this.x & 0xF, this.z & 0xF);
            boolean bl = isVoid = highestBlock < this.y;
            if (isVoid) {
                this.setVoid((short)255, ForgeDirection.UP);
            } else if (this.pressureVoid == 255) {
                this.setVoid((short)0, ForgeDirection.UNKNOWN);
            }
        }
    }

    private void setBlockToNoAir(World world) {
        world.func_147465_d(this.x, this.y, this.z, Blocks.field_150350_a, 0, 2);
        this.block = Blocks.field_150350_a;
        this.updateBlockType(world);
    }

    private void setBlockToAirFlow(World world) {
        world.func_147465_d(this.x, this.y, this.z, WarpDrive.blockAirFlow, 0, 2);
        this.block = WarpDrive.blockAirFlow;
        this.updateBlockType(world);
    }

    public boolean setAirSource(World world, ForgeDirection direction, short pressure) {
        boolean updateRequired;
        assert (this.block != null);
        boolean isPlaceable = (this.dataAir & 0x70000000) == 0x20000000 || (this.dataAir & 0x70000000) == 0x30000000 || (this.dataAir & 0x70000000) == 0x40000000;
        boolean bl = updateRequired = this.block != WarpDrive.blockAirSource || this.pressureGenerator != pressure || this.pressureVoid != 0 || this.concentration != 31;
        if (updateRequired && isPlaceable) {
            world.func_147465_d(this.x, this.y, this.z, WarpDrive.blockAirSource, direction.ordinal(), 2);
            this.block = WarpDrive.blockAirSource;
            this.updateBlockType(world);
            try {
                this.setGeneratorAndUpdateVoid(world, pressure, direction.getOpposite());
            }
            catch (ExceptionChunkNotLoaded exceptionChunkNotLoaded) {
                // empty catch block
            }
            this.setConcentration(world, (byte)31);
        }
        return updateRequired;
    }

    public void removeAirSource(World world) {
        this.setBlockToAirFlow(world);
        this.setConcentration(world, (byte)1);
    }

    private void updateBlockType(World world) {
        int typeBlock;
        assert (this.block != null);
        if (this.block instanceof BlockAirFlow) {
            typeBlock = 0x30000000;
        } else if (this.block == Blocks.field_150350_a) {
            typeBlock = 0x20000000;
        } else if (this.block.func_149688_o() == Material.field_151584_j || this.block.isFoliage((IBlockAccess)world, this.x, this.y, this.z)) {
            typeBlock = 0x70000000;
        } else if (this.block instanceof BlockAirSource) {
            typeBlock = 0x40000000;
        } else if (this.block.func_149721_r()) {
            typeBlock = 0x10000000;
        } else if (this.block instanceof BlockAbstractOmnipanel) {
            typeBlock = 0x10000000;
        } else if (this.block instanceof BlockStairs) {
            typeBlock = 0x10000000;
        } else if (this.block instanceof BlockStaticLiquid || this.block instanceof BlockDynamicLiquid) {
            Block blockAbove = world.func_147439_a(this.x, this.y + 1, this.z);
            typeBlock = blockAbove == this.block || blockAbove instanceof BlockStaticLiquid || blockAbove instanceof BlockDynamicLiquid ? 0x10000000 : 0x60000000;
        } else if (this.block instanceof BlockFluidBase) {
            int density = BlockFluidBase.getDensity((IBlockAccess)world, (int)this.x, (int)this.y, (int)this.z);
            Block blockFlowing = world.func_147439_a(this.x, this.y + (density > 0 ? 1 : -1), this.z);
            typeBlock = blockFlowing == this.block ? 0x10000000 : 0x60000000;
        } else if (this.block.isAir((IBlockAccess)world, this.x, this.y, this.z) || this.block.isReplaceable((IBlockAccess)world, this.x, this.y, this.z)) {
            typeBlock = 0x70000000;
        } else if (this.block instanceof BlockPane) {
            typeBlock = 0x50000000;
        } else {
            AxisAlignedBB axisAlignedBB = this.block.func_149668_a(world, this.x, this.y, this.z);
            if (axisAlignedBB == null) {
                typeBlock = 0x70000000;
            } else {
                boolean fullZ;
                boolean fullX = axisAlignedBB.field_72336_d - axisAlignedBB.field_72340_a > 0.99;
                boolean fullY = axisAlignedBB.field_72337_e - axisAlignedBB.field_72338_b > 0.99;
                boolean bl = fullZ = axisAlignedBB.field_72334_f - axisAlignedBB.field_72339_c > 0.99;
                typeBlock = fullX && fullY && fullZ ? 0x10000000 : (fullX && fullZ ? 0x60000000 : (fullY && (fullX || fullZ) ? 0x50000000 : 0x70000000));
            }
        }
        if ((this.dataAir & 0x70000000) != typeBlock) {
            this.dataAir = this.dataAir & 0x8FFFFFFF | typeBlock;
            this.chunkData.setDataAir(this.x, this.y, this.z, this.dataAir);
        }
    }

    public void setConcentration(World world, byte concentrationNew) {
        assert (concentrationNew >= 0 && concentrationNew <= 31);
        if (concentrationNew == 0) {
            if (this.isAirFlow()) {
                if (this.block == null) {
                    this.updateBlockCache(world);
                }
                if (this.isAirFlow()) {
                    this.setBlockToNoAir(world);
                }
            }
        } else if ((this.dataAir & 0x70000000) == 0x20000000) {
            if (this.block == null) {
                int dataAirLegacy = this.dataAir;
                this.updateBlockCache(world);
                if ((this.dataAir & 0x70000000) != 0x20000000) {
                    if (WarpDrive.isDev) {
                        WarpDrive.logger.info(String.format("Desynchronized air state detected @ %s (%d %d %d): %8x -> %s", world.field_73011_w.func_80007_l(), this.x, this.y, this.z, dataAirLegacy, this));
                    }
                    return;
                }
            }
            this.setBlockToAirFlow(world);
        }
        if (this.concentration != concentrationNew) {
            this.dataAir = this.dataAir & 0xFFFFFFE0 | concentrationNew;
            this.concentration = concentrationNew;
            this.chunkData.setDataAir(this.x, this.y, this.z, this.dataAir);
        }
    }

    protected void setGeneratorAndUpdateVoid(World world, short pressureNew, ForgeDirection directionNew) throws ExceptionChunkNotLoaded {
        if (pressureNew == 0 && this.pressureVoid > 0) {
            this.removeGeneratorAndCascade(world);
        } else {
            this.setGenerator(pressureNew, directionNew);
            this.updateVoidSource();
        }
    }

    private void setGenerator(short pressureNew, ForgeDirection directionNew) {
        boolean isUpdated = false;
        if (pressureNew != this.pressureGenerator) {
            assert (pressureNew >= 0 && pressureNew <= 255);
            this.dataAir = this.dataAir & 0xFFFF00FF | pressureNew << 8;
            this.pressureGenerator = pressureNew;
            isUpdated = true;
        }
        if (directionNew != this.directionGenerator) {
            this.dataAir = this.dataAir & 0xFFFFFF1F | directionNew.ordinal() << 5;
            this.directionGenerator = directionNew;
            isUpdated = true;
        }
        if (isUpdated) {
            this.chunkData.setDataAir(this.x, this.y, this.z, this.dataAir);
        }
        assert (this.pressureGenerator != 0 || this.directionGenerator == ForgeDirection.UNKNOWN);
        assert (this.pressureGenerator == 0 || this.pressureGenerator == 255 || this.directionGenerator != ForgeDirection.UNKNOWN);
        assert (this.pressureGenerator == 0 || this.directionGenerator != ForgeDirection.UNKNOWN);
    }

    protected void removeGeneratorAndCascade(World world) throws ExceptionChunkNotLoaded {
        this.removeGeneratorAndCascade(world, WarpDriveConfig.BREATHING_VOLUME_UPDATE_DEPTH_BLOCKS);
    }

    private void removeGeneratorAndCascade(World world, int depth) throws ExceptionChunkNotLoaded {
        if (this.pressureGenerator != 0) {
            assert (this.directionGenerator != ForgeDirection.UNKNOWN);
            this.dataAir = this.dataAir & 0xFFFF001F | ForgeDirection.UNKNOWN.ordinal() << 5;
            this.pressureGenerator = 0;
            this.directionGenerator = ForgeDirection.UNKNOWN;
            this.chunkData.setDataAir(this.x, this.y, this.z, this.dataAir);
            if (depth > 0) {
                StateAir stateAir = new StateAir(this.chunkData);
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    stateAir.refresh(world, this, direction);
                    if (stateAir.pressureGenerator <= 0 || stateAir.directionGenerator != direction.getOpposite()) continue;
                    stateAir.removeGeneratorAndCascade(world, depth - 1);
                }
            }
        }
    }

    protected void setVoid(short pressureNew, ForgeDirection directionNew) {
        boolean isUpdated = false;
        if (pressureNew != this.pressureVoid) {
            assert (pressureNew >= 0 && pressureNew <= 255);
            this.dataAir = this.dataAir & 0xFF00FFFF | pressureNew << 16;
            this.pressureVoid = pressureNew;
            isUpdated = true;
        }
        if (directionNew != this.directionVoid) {
            this.dataAir = this.dataAir & 0xF8FFFFFF | directionNew.ordinal() << 24;
            this.directionVoid = directionNew;
            isUpdated = true;
        }
        if (isUpdated) {
            this.chunkData.setDataAir(this.x, this.y, this.z, this.dataAir);
        }
        assert (this.pressureVoid != 0 || this.directionVoid == ForgeDirection.UNKNOWN);
        assert (this.pressureVoid == 0 || this.directionVoid != ForgeDirection.UNKNOWN);
        assert (this.pressureVoid == 0 || this.pressureVoid == 255 || this.directionVoid != ForgeDirection.UNKNOWN);
    }

    protected void removeVoidAndCascade(World world) throws ExceptionChunkNotLoaded {
        this.removeVoidAndCascade(world, WarpDriveConfig.BREATHING_VOLUME_UPDATE_DEPTH_BLOCKS);
    }

    private void removeVoidAndCascade(World world, int depth) throws ExceptionChunkNotLoaded {
        if (this.pressureVoid != 0) {
            assert (this.directionVoid != ForgeDirection.UNKNOWN);
            this.dataAir = this.dataAir & 0xF800FFFF | ForgeDirection.UNKNOWN.ordinal() << 24;
            this.pressureVoid = 0;
            this.directionVoid = ForgeDirection.UNKNOWN;
            this.chunkData.setDataAir(this.x, this.y, this.z, this.dataAir);
            if (depth > 0) {
                StateAir stateAir = new StateAir(this.chunkData);
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    stateAir.refresh(world, this, direction);
                    if (stateAir.pressureVoid <= 0 || stateAir.directionVoid != direction.getOpposite()) continue;
                    stateAir.removeVoidAndCascade(world, depth - 1);
                }
            }
        }
    }

    public boolean isAir() {
        return (this.dataAir & 0x70000000) != 0x10000000;
    }

    public boolean isAir(ForgeDirection forgeDirection) {
        switch (this.dataAir & 0x70000000) {
            case 0x10000000: {
                return false;
            }
            case 0x20000000: {
                return true;
            }
            case 0x30000000: {
                return true;
            }
            case 0x40000000: {
                return true;
            }
            case 0x50000000: {
                return forgeDirection.offsetY != 0;
            }
            case 0x60000000: {
                return forgeDirection.offsetY == 0;
            }
            case 0x70000000: {
                return true;
            }
        }
        return false;
    }

    public boolean isAirSource() {
        return (this.dataAir & 0x70000000) == 0x40000000;
    }

    public boolean isAirFlow() {
        return (this.dataAir & 0x70000000) == 0x30000000;
    }

    public boolean isVoidSource() {
        return this.pressureVoid == 255;
    }

    protected boolean isLeakingHorizontally() {
        return (this.dataAir & 0x70000000) == 0x60000000;
    }

    protected boolean isLeakingVertically() {
        return (this.dataAir & 0x70000000) == 0x50000000;
    }

    protected static boolean isEmptyData(int dataAir) {
        return (dataAir & 0xFFFF1F) == 0 && (dataAir & 0x70000000) != 0x30000000;
    }

    private static int rotateDirection(int direction, byte rotationSteps) {
        switch (rotationSteps) {
            case 1: {
                return rotDirection[direction];
            }
            case 2: {
                return rotDirection[rotDirection[direction]];
            }
            case 3: {
                return rotDirection[rotDirection[rotDirection[direction]]];
            }
        }
        return direction;
    }

    public static int rotate(int dataAir, byte rotationSteps) {
        int dataNoDirection = dataAir & 0xF8FFFF1F;
        int directionGenerator = StateAir.rotateDirection((dataAir & 0xE0) >> 5, rotationSteps);
        int directionVoid = StateAir.rotateDirection((dataAir & 0x7000000) >> 24, rotationSteps);
        return dataNoDirection | directionGenerator << 5 | directionVoid << 24;
    }

    public static void dumpAroundEntity(EntityPlayer entityPlayer) {
        try {
            StateAir[][][] stateAirs = new StateAir[3][3][3];
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    for (int dx = -1; dx <= 1; ++dx) {
                        StateAir stateAir = new StateAir(null);
                        stateAir.refresh(entityPlayer.field_70170_p, MathHelper.func_76128_c((double)entityPlayer.field_70165_t) + dx, MathHelper.func_76128_c((double)entityPlayer.field_70163_u) + dy, MathHelper.func_76128_c((double)entityPlayer.field_70161_v) + dz);
                        stateAirs[dx + 1][dy + 1][dz + 1] = stateAir;
                    }
                }
            }
            StringBuilder message = new StringBuilder("------------------------------------------------\n");
            message.append("\u00c2\u00a73Air, \u00c2\u00a7aGenerator \u00c2\u00a77and \u00c2\u00a7dVoid \u00c2\u00a77stats at ").append(entityPlayer.field_70173_aa);
            for (int indexY = 2; indexY >= 0; --indexY) {
                for (int indexZ = 2; indexZ >= 0; --indexZ) {
                    String stringDirection;
                    String stringValue;
                    StateAir stateAir;
                    int indexX;
                    message.append("\n");
                    for (indexX = 0; indexX <= 2; ++indexX) {
                        stateAir = stateAirs[indexX][indexY][indexZ];
                        stringValue = String.format("%2d", 100 + stateAir.concentration).substring(1);
                        message.append(String.format("\u00c2\u00a73%s ", stringValue));
                    }
                    message.append("\u00c2\u00a7f| ");
                    for (indexX = 0; indexX <= 2; ++indexX) {
                        stateAir = stateAirs[indexX][indexY][indexZ];
                        stringValue = String.format("%X", 256 + stateAir.pressureGenerator).substring(1);
                        stringDirection = StateAir.directionToChar(stateAir.directionGenerator);
                        message.append(String.format("\u00c2\u00a7e%s \u00c2\u00a7a%s ", stringValue, stringDirection));
                    }
                    message.append("\u00c2\u00a7f| ");
                    for (indexX = 0; indexX <= 2; ++indexX) {
                        stateAir = stateAirs[indexX][indexY][indexZ];
                        stringValue = String.format("%X", 256 + stateAir.pressureVoid).substring(1);
                        stringDirection = StateAir.directionToChar(stateAir.directionVoid);
                        message.append(String.format("\u00c2\u00a7e%s \u00c2\u00a7d%s ", stringValue, stringDirection));
                    }
                    if (indexZ == 2) {
                        message.append("\u00c2\u00a7f\\");
                        continue;
                    }
                    if (indexZ == 1) {
                        message.append(String.format("\u00c2\u00a7f  > y = %d", stateAirs[1][indexY][indexZ].y));
                        continue;
                    }
                    message.append("\u00c2\u00a7f/");
                }
            }
            Commons.addChatMessage((ICommandSender)entityPlayer, message.toString());
        }
        catch (ExceptionChunkNotLoaded exceptionChunkNotLoaded) {
            // empty catch block
        }
    }

    private static String directionToChar(ForgeDirection direction) {
        switch (direction) {
            case UP: {
                return "U";
            }
            case DOWN: {
                return "D";
            }
            case NORTH: {
                return "N";
            }
            case SOUTH: {
                return "S";
            }
            case EAST: {
                return "E";
            }
            case WEST: {
                return "W";
            }
            case UNKNOWN: {
                return "?";
            }
        }
        return "x";
    }

    public String toString() {
        return String.format("StateAir @ (%6d %3d %6d) data 0x%08x, concentration %d, block %s", this.x, this.y, this.z, this.dataAir, this.concentration, this.block);
    }
}

